/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.window;

import java.util.Iterator;
import java.util.LinkedHashSet;
import net.esper.collection.ViewUpdatedCollection;
import net.esper.core.StatementContext;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.CloneableView;
import net.esper.view.DataWindowView;
import net.esper.view.View;
import net.esper.view.ViewSupport;
import net.esper.view.window.KeepAllViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeepAllView
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final KeepAllViewFactory keepAllViewFactory;
    private LinkedHashSet<EventBean> indexedEvents;
    private final ViewUpdatedCollection viewUpdatedCollection;

    public KeepAllView(KeepAllViewFactory keepAllViewFactory, ViewUpdatedCollection viewUpdatedCollection) {
        this.keepAllViewFactory = keepAllViewFactory;
        this.indexedEvents = new LinkedHashSet();
        this.viewUpdatedCollection = viewUpdatedCollection;
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.keepAllViewFactory.makeView(statementContext);
    }

    public boolean isEmpty() {
        return this.indexedEvents.isEmpty();
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null) {
            for (EventBean aNewData : newData) {
                this.indexedEvents.add(aNewData);
            }
        }
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                this.indexedEvents.remove(anOldData);
            }
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, oldData);
        }
        this.updateChildren(newData, oldData);
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.indexedEvents.iterator();
    }
}

