/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.window;

import java.util.List;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.eql.named.RemoveStreamViewCapability;
import net.esper.event.EventType;
import net.esper.view.DataWindowViewFactory;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapDataWindowAccess;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewParameterException;
import net.esper.view.window.IStreamRandomAccess;
import net.esper.view.window.KeepAllView;
import net.esper.view.window.RandomAccessByIndexGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeepAllViewFactory
implements DataWindowViewFactory {
    protected RandomAccessByIndexGetter randomAccessGetterImpl;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        String errorMessage = "Keep-all data window view requires an empty parameter list";
        if (viewParameters.size() != 0) {
            throw new ViewParameterException(errorMessage);
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof ViewCapDataWindowAccess) {
            return true;
        }
        return viewCapability instanceof RemoveStreamViewCapability;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            return;
        }
        if (this.randomAccessGetterImpl == null) {
            this.randomAccessGetterImpl = new RandomAccessByIndexGetter();
        }
        resourceCallback.setViewResource(this.randomAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamRandomAccess randomAccess = null;
        if (this.randomAccessGetterImpl != null) {
            randomAccess = new IStreamRandomAccess(this.randomAccessGetterImpl);
            this.randomAccessGetterImpl.updated(randomAccess);
        }
        return new KeepAllView(this, randomAccess);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (this.randomAccessGetterImpl != null) {
            return false;
        }
        if (!(view instanceof KeepAllView)) {
            return false;
        }
        KeepAllView myView = (KeepAllView)view;
        return myView.isEmpty();
    }
}

