/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.window;

import java.util.List;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.eql.named.RemoveStreamViewCapability;
import net.esper.event.EventType;
import net.esper.util.JavaClassHelper;
import net.esper.view.DataWindowViewFactory;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapDataWindowAccess;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewParameterException;
import net.esper.view.window.IStreamRelativeAccess;
import net.esper.view.window.LengthBatchView;
import net.esper.view.window.LengthBatchViewRStream;
import net.esper.view.window.RelativeAccessByEventNIndexGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthBatchViewFactory
implements DataWindowViewFactory {
    protected int size;
    protected RelativeAccessByEventNIndexGetter relativeAccessGetterImpl;
    protected boolean isRemoveStreamHandling;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        String errorMessage = "Length window view requires a single integer-type parameter";
        if (viewParameters.size() != 1) {
            throw new ViewParameterException(errorMessage);
        }
        Object parameter = viewParameters.get(0);
        if (!(parameter instanceof Number)) {
            throw new ViewParameterException(errorMessage);
        }
        Number numParam = (Number)parameter;
        if (JavaClassHelper.isFloatingPointNumber(numParam) || numParam instanceof Long) {
            throw new ViewParameterException(errorMessage);
        }
        this.size = numParam.intValue();
        if (this.size <= 0) {
            throw new ViewParameterException("Length window requires a positive number");
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof RemoveStreamViewCapability) {
            return true;
        }
        return viewCapability instanceof ViewCapDataWindowAccess;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            this.isRemoveStreamHandling = true;
            return;
        }
        if (this.relativeAccessGetterImpl == null) {
            this.relativeAccessGetterImpl = new RelativeAccessByEventNIndexGetter();
        }
        resourceCallback.setViewResource(this.relativeAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamRelativeAccess relativeAccessByEvent = null;
        if (this.relativeAccessGetterImpl != null) {
            relativeAccessByEvent = new IStreamRelativeAccess(this.relativeAccessGetterImpl);
            this.relativeAccessGetterImpl.updated(relativeAccessByEvent, null);
        }
        if (this.isRemoveStreamHandling) {
            return new LengthBatchViewRStream(this, this.size);
        }
        return new LengthBatchView(this, this.size, relativeAccessByEvent);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (this.relativeAccessGetterImpl != null) {
            return false;
        }
        if (!(view instanceof LengthBatchView)) {
            return false;
        }
        LengthBatchView myView = (LengthBatchView)view;
        if (myView.getSize() != this.size) {
            return false;
        }
        return myView.isEmpty();
    }
}

