/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.window;

import java.util.Iterator;
import java.util.LinkedHashSet;
import net.esper.core.StatementContext;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.view.CloneableView;
import net.esper.view.DataWindowView;
import net.esper.view.View;
import net.esper.view.ViewSupport;
import net.esper.view.window.LengthBatchViewFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LengthBatchViewRStream
extends ViewSupport
implements CloneableView,
DataWindowView {
    private final LengthBatchViewFactory lengthBatchViewFactory;
    private final int size;
    private LinkedHashSet<EventBean> lastBatch = null;
    private LinkedHashSet<EventBean> currentBatch = new LinkedHashSet();
    private static final Log log = LogFactory.getLog(LengthBatchViewRStream.class);

    public LengthBatchViewRStream(LengthBatchViewFactory lengthBatchViewFactory, int size) {
        this.lengthBatchViewFactory = lengthBatchViewFactory;
        this.size = size;
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid size parameter, size=" + size);
        }
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.lengthBatchViewFactory.makeView(statementContext);
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.currentBatch.remove(oldData[i]);
            }
        }
        if (newData == null || newData.length == 0) {
            return;
        }
        for (i = 0; i < newData.length; ++i) {
            this.currentBatch.add(newData[i]);
        }
        if (this.currentBatch.size() < this.size) {
            return;
        }
        this.sendBatch();
    }

    protected final void sendBatch() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendBatch Update child views");
        }
        if (this.hasViews()) {
            EventBean[] newData = null;
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                newData = this.currentBatch.toArray(new EventBean[0]);
            }
            if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
                oldData = this.lastBatch.toArray(new EventBean[0]);
            }
            if (newData != null || oldData != null) {
                this.updateChildren(newData, oldData);
            }
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendBatch Published updated data, ....newData size=" + this.currentBatch.size());
            for (EventBean object : this.currentBatch) {
                log.debug(".sendBatch object=" + object);
            }
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new LinkedHashSet();
    }

    public boolean isEmpty() {
        if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
            return false;
        }
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " size=" + this.size;
    }
}

