/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.window;

import java.util.Iterator;
import java.util.LinkedList;
import net.esper.collection.ViewUpdatedCollection;
import net.esper.core.StatementContext;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.CloneableView;
import net.esper.view.DataWindowView;
import net.esper.view.View;
import net.esper.view.ViewSupport;
import net.esper.view.window.LengthWindowViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LengthWindowView
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final LengthWindowViewFactory lengthWindowViewFactory;
    private final int size;
    private final ViewUpdatedCollection viewUpdatedCollection;
    private final LinkedList<EventBean> events = new LinkedList();

    public LengthWindowView(LengthWindowViewFactory lengthWindowViewFactory, int size, ViewUpdatedCollection viewUpdatedCollection) {
        if (size < 1) {
            throw new IllegalArgumentException("Illegal argument for size of length window");
        }
        this.lengthWindowViewFactory = lengthWindowViewFactory;
        this.size = size;
        this.viewUpdatedCollection = viewUpdatedCollection;
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.lengthWindowViewFactory.makeView(statementContext);
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public final int getSize() {
        return this.size;
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                this.events.add(newData[i]);
            }
        }
        int expiredCount = this.events.size() - this.size;
        EventBean[] expiredArr = null;
        if (expiredCount > 0) {
            expiredArr = new EventBean[expiredCount];
            for (int i = 0; i < expiredCount; ++i) {
                expiredArr[i] = this.events.removeFirst();
            }
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, expiredArr);
        }
        if (this.hasViews()) {
            this.updateChildren(newData, expiredArr);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.events.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " size=" + this.size;
    }
}

