/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.window;

import java.util.List;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.eql.named.RemoveStreamViewCapability;
import net.esper.event.EventType;
import net.esper.util.JavaClassHelper;
import net.esper.view.DataWindowViewFactory;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapDataWindowAccess;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewParameterException;
import net.esper.view.window.IStreamRandomAccess;
import net.esper.view.window.LengthWindowView;
import net.esper.view.window.LengthWindowViewRStream;
import net.esper.view.window.RandomAccessByIndexGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthWindowViewFactory
implements DataWindowViewFactory {
    protected int size;
    protected RandomAccessByIndexGetter randomAccessGetterImpl;
    protected boolean isRemoveStreamHandling;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        String errorMessage = "Length window view requires a single integer-type parameter";
        if (viewParameters.size() != 1) {
            throw new ViewParameterException(errorMessage);
        }
        Object parameter = viewParameters.get(0);
        if (!(parameter instanceof Number)) {
            throw new ViewParameterException(errorMessage);
        }
        Number numParam = (Number)parameter;
        if (JavaClassHelper.isFloatingPointNumber(numParam) || numParam instanceof Long) {
            throw new ViewParameterException(errorMessage);
        }
        this.size = numParam.intValue();
        if (this.size <= 0) {
            throw new ViewParameterException("Length window requires a positive number");
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof ViewCapDataWindowAccess) {
            return true;
        }
        return viewCapability instanceof RemoveStreamViewCapability;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            this.isRemoveStreamHandling = true;
            return;
        }
        if (this.randomAccessGetterImpl == null) {
            this.randomAccessGetterImpl = new RandomAccessByIndexGetter();
        }
        resourceCallback.setViewResource(this.randomAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamRandomAccess randomAccess = null;
        if (this.randomAccessGetterImpl != null) {
            randomAccess = new IStreamRandomAccess(this.randomAccessGetterImpl);
            this.randomAccessGetterImpl.updated(randomAccess);
        }
        if (this.isRemoveStreamHandling) {
            return new LengthWindowViewRStream(this, this.size);
        }
        return new LengthWindowView(this, this.size, randomAccess);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof LengthWindowView)) {
            return false;
        }
        if (this.randomAccessGetterImpl != null) {
            return false;
        }
        LengthWindowView myView = (LengthWindowView)view;
        if (myView.getSize() != this.size) {
            return false;
        }
        return myView.isEmpty();
    }
}

