/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.window;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import net.esper.core.StatementContext;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.CloneableView;
import net.esper.view.DataWindowView;
import net.esper.view.View;
import net.esper.view.ViewSupport;
import net.esper.view.window.LengthWindowViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LengthWindowViewRStream
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final LengthWindowViewFactory lengthWindowViewFactory;
    private final int size;
    private LinkedHashSet<EventBean> indexedEvents;

    public LengthWindowViewRStream(LengthWindowViewFactory lengthWindowViewFactory, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Illegal argument for size of length window");
        }
        this.lengthWindowViewFactory = lengthWindowViewFactory;
        this.size = size;
        this.indexedEvents = new LinkedHashSet();
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.lengthWindowViewFactory.makeView(statementContext);
    }

    public boolean isEmpty() {
        return this.indexedEvents.isEmpty();
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                this.indexedEvents.add(newData[i]);
            }
        }
        EventBean[] expiredArr = null;
        int expiredCount = this.indexedEvents.size() - this.size;
        if (expiredCount > 0) {
            expiredArr = new EventBean[expiredCount];
            Iterator it = this.indexedEvents.iterator();
            for (int i = 0; i < expiredCount; ++i) {
                expiredArr[i] = (EventBean)it.next();
            }
            for (EventBean anExpired : expiredArr) {
                this.indexedEvents.remove(anExpired);
            }
        }
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                this.indexedEvents.remove(anOldData);
            }
            if (expiredArr == null) {
                expiredArr = oldData;
            } else {
                HashSet<EventBean> oldDataSet = new HashSet<EventBean>();
                for (EventBean old : expiredArr) {
                    oldDataSet.add(old);
                }
                for (EventBean old : oldData) {
                    oldDataSet.add(old);
                }
                expiredArr = oldDataSet.toArray(new EventBean[0]);
            }
        }
        if (this.hasViews()) {
            this.updateChildren(newData, expiredArr);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.indexedEvents.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " size=" + this.size;
    }
}

