/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.window;

import java.io.Serializable;
import java.util.List;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.eql.named.RemoveStreamViewCapability;
import net.esper.event.EventType;
import net.esper.type.TimePeriodParameter;
import net.esper.util.JavaClassHelper;
import net.esper.view.DataWindowViewFactory;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapDataWindowAccess;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewParameterException;
import net.esper.view.window.IStreamRelativeAccess;
import net.esper.view.window.RelativeAccessByEventNIndexGetter;
import net.esper.view.window.TimeBatchView;
import net.esper.view.window.TimeBatchViewRStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBatchViewFactory
implements DataWindowViewFactory {
    private EventType eventType;
    protected long millisecondsBeforeExpiry;
    protected Long optionalReferencePoint;
    protected RelativeAccessByEventNIndexGetter relativeAccessGetterImpl;
    protected boolean isRemoveStreamHandling;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        Serializable param;
        String errorMessage = "Time batch view requires a single numeric or time period parameter, and an optional long-typed reference point in msec";
        if (viewParameters.size() < 1 || viewParameters.size() > 2) {
            throw new ViewParameterException(errorMessage);
        }
        Object parameter = viewParameters.get(0);
        if (parameter instanceof TimePeriodParameter) {
            param = (TimePeriodParameter)parameter;
            this.millisecondsBeforeExpiry = Math.round(1000.0 * ((TimePeriodParameter)param).getNumSeconds());
        } else {
            if (!(parameter instanceof Number)) {
                throw new ViewParameterException(errorMessage);
            }
            param = (Number)parameter;
            this.millisecondsBeforeExpiry = JavaClassHelper.isFloatingPointNumber((Number)param) ? Math.round(1000.0 * ((Number)param).doubleValue()) : 1000L * ((Number)param).longValue();
        }
        if (this.millisecondsBeforeExpiry < 100L) {
            throw new ViewParameterException("Time batch view requires a size of at least 100 msec");
        }
        if (viewParameters.size() == 2) {
            Object paramRef = viewParameters.get(1);
            if (!(paramRef instanceof Number) || JavaClassHelper.isFloatingPointNumber((Number)paramRef)) {
                throw new ViewParameterException("Time batch view requires a Long-typed reference point in msec as a second parameter");
            }
            this.optionalReferencePoint = ((Number)paramRef).longValue();
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof RemoveStreamViewCapability) {
            return true;
        }
        return viewCapability instanceof ViewCapDataWindowAccess;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            this.isRemoveStreamHandling = true;
            return;
        }
        if (this.relativeAccessGetterImpl == null) {
            this.relativeAccessGetterImpl = new RelativeAccessByEventNIndexGetter();
        }
        resourceCallback.setViewResource(this.relativeAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamRelativeAccess relativeAccessByEvent = null;
        if (this.relativeAccessGetterImpl != null) {
            relativeAccessByEvent = new IStreamRelativeAccess(this.relativeAccessGetterImpl);
            this.relativeAccessGetterImpl.updated(relativeAccessByEvent, null);
        }
        if (this.isRemoveStreamHandling) {
            return new TimeBatchViewRStream(this, statementContext, this.millisecondsBeforeExpiry, this.optionalReferencePoint);
        }
        return new TimeBatchView(this, statementContext, this.millisecondsBeforeExpiry, this.optionalReferencePoint, relativeAccessByEvent);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (this.relativeAccessGetterImpl != null) {
            return false;
        }
        if (!(view instanceof TimeBatchView)) {
            return false;
        }
        TimeBatchView myView = (TimeBatchView)view;
        if (myView.getMsecIntervalSize() != this.millisecondsBeforeExpiry) {
            return false;
        }
        if (myView.getInitialReferencePoint() != null && this.optionalReferencePoint != null && !myView.getInitialReferencePoint().equals((long)this.optionalReferencePoint)) {
            return false;
        }
        if (myView.getInitialReferencePoint() == null && this.optionalReferencePoint != null || myView.getInitialReferencePoint() != null && this.optionalReferencePoint == null) {
            return false;
        }
        return myView.isEmpty();
    }
}

