/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.window;

import java.io.Serializable;
import java.util.List;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.eql.named.RemoveStreamViewCapability;
import net.esper.event.EventType;
import net.esper.type.TimePeriodParameter;
import net.esper.util.JavaClassHelper;
import net.esper.view.DataWindowViewFactory;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapDataWindowAccess;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewParameterException;
import net.esper.view.window.IStreamRelativeAccess;
import net.esper.view.window.RelativeAccessByEventNIndexGetter;
import net.esper.view.window.TimeLengthBatchView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLengthBatchViewFactory
implements DataWindowViewFactory {
    private static final String FORCE_UPDATE_KEYWORD = "force_update";
    private static final String START_EAGER_KEYWORD = "start_eager";
    private EventType eventType;
    protected long numberOfEvents;
    protected long millisecondsBeforeExpiry;
    protected boolean isForceUpdate;
    protected boolean isStartEager;
    protected RelativeAccessByEventNIndexGetter relativeAccessGetterImpl;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        Serializable param;
        String errorMessage = "Time-length combination batch view requires a numeric or time period parameter as a time interval size, and an integer parameter as a maximal number-of-events, and an optional list of control keywords as a string parameter (please see the documentation)";
        if (viewParameters.size() != 2 && viewParameters.size() != 3) {
            throw new ViewParameterException(errorMessage);
        }
        Object parameter = viewParameters.get(0);
        if (parameter instanceof TimePeriodParameter) {
            param = (TimePeriodParameter)parameter;
            this.millisecondsBeforeExpiry = Math.round(1000.0 * ((TimePeriodParameter)param).getNumSeconds());
        } else {
            if (!(parameter instanceof Number)) {
                throw new ViewParameterException(errorMessage);
            }
            param = (Number)parameter;
            this.millisecondsBeforeExpiry = JavaClassHelper.isFloatingPointNumber((Number)param) ? Math.round(1000.0 * ((Number)param).doubleValue()) : 1000L * ((Number)param).longValue();
        }
        parameter = viewParameters.get(1);
        if (!(parameter instanceof Number) || JavaClassHelper.isFloatingPointNumber((Number)parameter)) {
            throw new ViewParameterException(errorMessage);
        }
        this.numberOfEvents = ((Number)parameter).longValue();
        if (this.millisecondsBeforeExpiry < 100L) {
            throw new ViewParameterException("Time-length-combination batch view requires a size of at least 100 msec");
        }
        if (viewParameters.size() > 2) {
            Object keywords = viewParameters.get(2);
            if (!(keywords instanceof String)) {
                throw new ViewParameterException(errorMessage);
            }
            String[] keyword = ((String)keywords).split(",");
            for (int i = 0; i < keyword.length; ++i) {
                String keywordText = keyword[i].toLowerCase().trim();
                if (keywordText.length() == 0) continue;
                if (keywordText.equals(FORCE_UPDATE_KEYWORD)) {
                    this.isForceUpdate = true;
                    continue;
                }
                if (keywordText.equals(START_EAGER_KEYWORD)) {
                    this.isForceUpdate = true;
                    this.isStartEager = true;
                    continue;
                }
                String keywordRange = "force_update,start_eager";
                throw new ViewParameterException("Time-length-combination view encountered an invalid keyword '" + keywordText + "', valid control keywords are: " + keywordRange);
            }
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof RemoveStreamViewCapability) {
            return true;
        }
        return viewCapability instanceof ViewCapDataWindowAccess;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            return;
        }
        if (this.relativeAccessGetterImpl == null) {
            this.relativeAccessGetterImpl = new RelativeAccessByEventNIndexGetter();
        }
        resourceCallback.setViewResource(this.relativeAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamRelativeAccess relativeAccessByEvent = null;
        if (this.relativeAccessGetterImpl != null) {
            relativeAccessByEvent = new IStreamRelativeAccess(this.relativeAccessGetterImpl);
            this.relativeAccessGetterImpl.updated(relativeAccessByEvent, null);
        }
        return new TimeLengthBatchView(this, statementContext, this.millisecondsBeforeExpiry, this.numberOfEvents, this.isForceUpdate, this.isStartEager, relativeAccessByEvent);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (this.relativeAccessGetterImpl != null) {
            return false;
        }
        if (!(view instanceof TimeLengthBatchView)) {
            return false;
        }
        TimeLengthBatchView myView = (TimeLengthBatchView)view;
        if (myView.getMsecIntervalSize() != this.millisecondsBeforeExpiry) {
            return false;
        }
        if (myView.getNumberOfEvents() != this.numberOfEvents) {
            return false;
        }
        if (myView.isForceOutput() != this.isForceUpdate) {
            return false;
        }
        if (myView.isStartEager()) {
            return false;
        }
        return myView.isEmpty();
    }
}

