/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.window;

import java.util.List;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.eql.named.RemoveStreamViewCapability;
import net.esper.event.EventType;
import net.esper.type.TimePeriodParameter;
import net.esper.util.JavaClassHelper;
import net.esper.view.DataWindowViewFactory;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapDataWindowAccess;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewParameterException;
import net.esper.view.window.IStreamRandomAccess;
import net.esper.view.window.RandomAccessByIndexGetter;
import net.esper.view.window.TimeWindowView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeWindowViewFactory
implements DataWindowViewFactory {
    protected long millisecondsBeforeExpiry;
    protected RandomAccessByIndexGetter randomAccessGetterImpl;
    protected boolean isRemoveStreamHandling;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        String errorMessage = "Time window view requires a single numeric or time period parameter";
        if (viewParameters.size() != 1) {
            throw new ViewParameterException(errorMessage);
        }
        Object parameter = viewParameters.get(0);
        if (parameter instanceof TimePeriodParameter) {
            TimePeriodParameter param = (TimePeriodParameter)parameter;
            this.millisecondsBeforeExpiry = Math.round(1000.0 * param.getNumSeconds());
        } else {
            if (!(parameter instanceof Number)) {
                throw new ViewParameterException(errorMessage);
            }
            Number param = (Number)parameter;
            this.millisecondsBeforeExpiry = JavaClassHelper.isFloatingPointNumber(param) ? Math.round(1000.0 * param.doubleValue()) : 1000L * param.longValue();
        }
        if (this.millisecondsBeforeExpiry < 100L) {
            throw new ViewParameterException("Time window view requires a size of at least 100 msec");
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof ViewCapDataWindowAccess) {
            return true;
        }
        return viewCapability instanceof RemoveStreamViewCapability;
    }

    public long getMillisecondsBeforeExpiry() {
        return this.millisecondsBeforeExpiry;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            this.isRemoveStreamHandling = true;
            return;
        }
        if (this.randomAccessGetterImpl == null) {
            this.randomAccessGetterImpl = new RandomAccessByIndexGetter();
        }
        resourceCallback.setViewResource(this.randomAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamRandomAccess randomAccess = null;
        if (this.randomAccessGetterImpl != null) {
            randomAccess = new IStreamRandomAccess(this.randomAccessGetterImpl);
            this.randomAccessGetterImpl.updated(randomAccess);
        }
        return new TimeWindowView(statementContext, this, this.millisecondsBeforeExpiry, randomAccess, this.isRemoveStreamHandling);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (this.randomAccessGetterImpl != null) {
            return false;
        }
        if (!(view instanceof TimeWindowView)) {
            return false;
        }
        TimeWindowView myView = (TimeWindowView)view;
        if (myView.getMillisecondsBeforeExpiry() != this.millisecondsBeforeExpiry) {
            return false;
        }
        return myView.isEmpty();
    }
}

