/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import antlr.Token;
import java.io.IOException;
import java.util.List;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.tool.Grammar;

public class Target {
    protected String[] targetCharValueEscape = new String[255];

    public Target() {
        this.targetCharValueEscape[10] = "\\n";
        this.targetCharValueEscape[13] = "\\r";
        this.targetCharValueEscape[9] = "\\t";
        this.targetCharValueEscape[8] = "\\b";
        this.targetCharValueEscape[12] = "\\f";
        this.targetCharValueEscape[92] = "\\\\";
        this.targetCharValueEscape[39] = "\\'";
        this.targetCharValueEscape[34] = "\\\"";
    }

    protected void genRecognizerFile(Tool tool, CodeGenerator codeGenerator, Grammar grammar, StringTemplate stringTemplate) throws IOException {
        String string = codeGenerator.getRecognizerFileName(grammar.name, grammar.type);
        codeGenerator.write(stringTemplate, string);
    }

    protected void genRecognizerHeaderFile(Tool tool, CodeGenerator codeGenerator, Grammar grammar, StringTemplate stringTemplate, String string) throws IOException {
    }

    protected void performGrammarAnalysis(CodeGenerator codeGenerator, Grammar grammar) {
        grammar.createNFAs();
        grammar.createLookaheadDFAs();
    }

    public boolean isValidActionScope(int n, String string) {
        switch (n) {
            case 1: {
                if (!string.equals("lexer")) break;
                return true;
            }
            case 2: {
                if (!string.equals("parser")) break;
                return true;
            }
            case 4: {
                if (string.equals("parser")) {
                    return true;
                }
                if (!string.equals("lexer")) break;
                return true;
            }
            case 3: {
                if (!string.equals("treeparser")) break;
                return true;
            }
        }
        return false;
    }

    public String getTokenTypeAsTargetLabel(CodeGenerator codeGenerator, int n) {
        String string = codeGenerator.grammar.getTokenDisplayName(n);
        if (string.charAt(0) == '\'') {
            return String.valueOf(n);
        }
        return string;
    }

    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator codeGenerator, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\'');
        int n = Grammar.getCharValueFromGrammarCharLiteral(string);
        if (n < 0) {
            return "'\u0000'";
        }
        if (n < this.targetCharValueEscape.length && this.targetCharValueEscape[n] != null) {
            stringBuffer.append(this.targetCharValueEscape[n]);
        } else if (Character.UnicodeBlock.of((char)n) == Character.UnicodeBlock.BASIC_LATIN && !Character.isISOControl((char)n)) {
            stringBuffer.append((char)n);
        } else {
            String string2 = Integer.toHexString(n | 0x10000).toUpperCase().substring(1, 5);
            stringBuffer.append("\\u");
            stringBuffer.append(string2);
        }
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator codeGenerator, String string) {
        string = Utils.replace(string, "\"", "\\\"");
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, '\"');
        stringBuffer.setCharAt(string.length() - 1, '\"');
        return stringBuffer.toString();
    }

    public String getTargetStringLiteralFromString(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append('\"');
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\'' && c < this.targetCharValueEscape.length && this.targetCharValueEscape[c] != null) {
                stringBuffer.append(this.targetCharValueEscape[c]);
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    public String getTargetStringLiteralFromString(String string) {
        return this.getTargetStringLiteralFromString(string, false);
    }

    public String getTarget64BitStringFromValue(long l) {
        int n = 16;
        StringBuffer stringBuffer = new StringBuffer(n + 2);
        stringBuffer.append("0x");
        String string = Long.toHexString(l);
        string = string.toUpperCase();
        int n2 = n - string.length();
        for (int i = 1; i <= n2; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public int getMaxCharValue(CodeGenerator codeGenerator) {
        return 65534;
    }

    public List postProcessAction(List list, Token token2) {
        return list;
    }
}

