/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.RuntimeVariable;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.CurrentTimeNode;
import org.jacorb.notification.filter.etcl.DomainNameShorthandNode;
import org.jacorb.notification.filter.etcl.EventNameShorthandNode;
import org.jacorb.notification.filter.etcl.PropertyShorthandNode;
import org.jacorb.notification.filter.etcl.TypeNameShorthandNode;
import org.jacorb.notification.filter.etcl.VisitorException;

public class RuntimeVariableNode
extends AbstractTCLNode
implements RuntimeVariable {
    private final String value_;
    private final AbstractTCLNode strategy_;

    public RuntimeVariableNode(Token token2) {
        super(token2);
        this.value_ = token2.getText();
        this.strategy_ = this.newStrategy(this.value_);
    }

    public EvaluationResult evaluate(EvaluationContext evaluationContext) throws EvaluationException {
        return this.strategy_.evaluate(evaluationContext);
    }

    private AbstractTCLNode newStrategy(String string) {
        if ("domain_name".equals(string)) {
            return new DomainNameShorthandNode();
        }
        if ("type_name".equals(string)) {
            return new TypeNameShorthandNode();
        }
        if ("event_name".equals(string)) {
            return new EventNameShorthandNode();
        }
        if ("curtime".equals(string)) {
            return new CurrentTimeNode();
        }
        return new PropertyShorthandNode(string);
    }

    public void acceptPostOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        if (this.getFirstChild() != null) {
            ((AbstractTCLNode)this.getFirstChild()).acceptPostOrder(abstractTCLVisitor);
        }
        abstractTCLVisitor.visitRuntimeVariable(this);
    }

    public void acceptPreOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        abstractTCLVisitor.visitRuntimeVariable(this);
        if (this.getFirstChild() != null) {
            ((AbstractTCLNode)this.getFirstChild()).acceptPreOrder(abstractTCLVisitor);
        }
    }

    public void acceptInOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        if (this.getFirstChild() != null) {
            ((AbstractTCLNode)this.getFirstChild()).acceptInOrder(abstractTCLVisitor);
        }
        abstractTCLVisitor.visitRuntimeVariable(this);
    }

    public String toString() {
        return this.value_;
    }

    public String getIdentifier() {
        return this.value_;
    }
}

