/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.TypeCode;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.FixedHolder;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class Any
extends org.omg.CORBA.Any {
    private org.omg.CORBA.TypeCode typeCode;
    private java.lang.Object value;
    private org.omg.CORBA.ORB orb;

    Any(org.omg.CORBA.ORB oRB) {
        this.orb = oRB;
        this.typeCode = oRB.get_primitive_tc(TCKind.tk_null);
    }

    public TCKind kind() {
        return this.typeCode.kind();
    }

    public org.omg.CORBA.TypeCode type() {
        return this.typeCode;
    }

    public org.omg.CORBA.TypeCode originalType() {
        return TypeCode.originalType(this.typeCode);
    }

    public void type(org.omg.CORBA.TypeCode typeCode) {
        this.typeCode = typeCode;
        this.value = null;
    }

    public java.lang.Object value() {
        return this.value;
    }

    public int _get_TCKind() {
        return 11;
    }

    private void tc_error(String string) {
        throw new BAD_OPERATION(string);
    }

    private void checkExtract(int n, String string) {
        if (this.originalType().kind().value() != n) {
            throw new BAD_OPERATION(string);
        }
    }

    public boolean equal(org.omg.CORBA.Any any) {
        if (any == null) {
            throw new BAD_PARAM("Null passed to Any equal operation");
        }
        if (!this.typeCode.equal(any.type())) {
            return false;
        }
        int n = this.originalType().kind().value();
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return this.extract_short() == any.extract_short();
            }
            case 3: {
                return this.extract_long() == any.extract_long();
            }
            case 23: {
                return this.extract_longlong() == any.extract_longlong();
            }
            case 4: {
                return this.extract_ushort() == any.extract_ushort();
            }
            case 5: {
                return this.extract_ulong() == any.extract_ulong();
            }
            case 24: {
                return this.extract_ulonglong() == any.extract_ulonglong();
            }
            case 6: {
                return this.extract_float() == any.extract_float();
            }
            case 7: {
                return this.extract_double() == any.extract_double();
            }
            case 28: {
                return this.extract_fixed().equals(any.extract_fixed());
            }
            case 8: {
                return this.extract_boolean() == any.extract_boolean();
            }
            case 9: {
                return this.extract_char() == any.extract_char();
            }
            case 26: {
                return this.extract_wchar() == any.extract_wchar();
            }
            case 10: {
                return this.extract_octet() == any.extract_octet();
            }
            case 11: {
                return this.extract_any().equals(any.extract_any());
            }
            case 12: {
                return this.extract_TypeCode().equal(any.extract_TypeCode());
            }
            case 13: {
                throw new NO_IMPLEMENT("Principal deprecated");
            }
            case 14: {
                return this.extract_Object().equals(any.extract_Object());
            }
            case 18: {
                return this.extract_string().equals(any.extract_string());
            }
            case 27: {
                return this.extract_wstring().equals(any.extract_wstring());
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: {
                CDROutputStream cDROutputStream;
                CDROutputStream cDROutputStream2;
                if (!(this.orb instanceof ORB)) {
                    cDROutputStream2 = new CDROutputStream();
                    cDROutputStream = new CDROutputStream();
                } else {
                    cDROutputStream2 = new CDROutputStream(this.orb);
                    cDROutputStream = new CDROutputStream(this.orb);
                }
                this.write_value(cDROutputStream2);
                any.write_value(cDROutputStream);
                if (cDROutputStream2.size() != cDROutputStream.size()) {
                    return false;
                }
                return Arrays.equals(cDROutputStream2.getBufferCopy(), cDROutputStream.getBufferCopy());
            }
        }
        throw new BAD_TYPECODE("Cannot compare anys with TypeCode kind " + n);
    }

    public boolean equals(java.lang.Object object) {
        if (object instanceof org.omg.CORBA.Any) {
            return this.equal((org.omg.CORBA.Any)object);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "null";
    }

    public void insert_short(short s) {
        this.value = new Short(s);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_short);
    }

    public short extract_short() throws BAD_OPERATION {
        this.checkExtract(2, "Cannot extract short");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_short();
        }
        return (Short)this.value;
    }

    public void insert_ushort(short s) {
        this.value = new Short(s);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_ushort);
    }

    public short extract_ushort() {
        this.checkExtract(4, "Cannot extract ushort");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_ushort();
        }
        return (Short)this.value;
    }

    public void insert_long(int n) {
        this.value = new Integer(n);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_long);
    }

    public int extract_long() {
        this.checkExtract(3, "Cannot extract long");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_long();
        }
        return (Integer)this.value;
    }

    public void insert_ulong(int n) {
        this.value = new Integer(n);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_ulong);
    }

    public int extract_ulong() {
        this.checkExtract(5, "Cannot extract ulong");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_ulong();
        }
        return (Integer)this.value;
    }

    public void insert_longlong(long l) {
        this.value = new Long(l);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_longlong);
    }

    public long extract_longlong() {
        this.checkExtract(23, "Cannot extract longlong");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_longlong();
        }
        return (Long)this.value;
    }

    public void insert_ulonglong(long l) {
        this.value = new Long(l);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_ulonglong);
    }

    public long extract_ulonglong() {
        this.checkExtract(24, "Cannot extract ulonglong");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_ulonglong();
        }
        return (Long)this.value;
    }

    public void insert_float(float f) {
        this.value = new Float(f);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_float);
    }

    public float extract_float() {
        this.checkExtract(6, "Cannot extract float");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_float();
        }
        return ((Float)this.value).floatValue();
    }

    public void insert_double(double d) {
        this.value = new Double(d);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_double);
    }

    public double extract_double() {
        this.checkExtract(7, "Cannot extract double");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_double();
        }
        return (Double)this.value;
    }

    public void insert_boolean(boolean bl) {
        this.value = bl ? Boolean.TRUE : Boolean.FALSE;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_boolean);
    }

    public boolean extract_boolean() {
        this.checkExtract(8, "Cannot extract boolean");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_boolean();
        }
        return (Boolean)this.value;
    }

    public void insert_char(char c) {
        this.value = new Character(c);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_char);
    }

    public char extract_char() {
        this.checkExtract(9, "Cannot extract char");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_char();
        }
        return ((Character)this.value).charValue();
    }

    public void insert_wchar(char c) {
        this.value = new Character(c);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_wchar);
    }

    public char extract_wchar() {
        this.checkExtract(26, "Cannot extract wchar");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_wchar();
        }
        return ((Character)this.value).charValue();
    }

    public void insert_octet(byte by) {
        this.value = new Byte(by);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_octet);
    }

    public byte extract_octet() {
        this.checkExtract(10, "Cannot extract octet");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_octet();
        }
        return (Byte)this.value;
    }

    public void insert_any(org.omg.CORBA.Any any) {
        this.value = any;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_any);
    }

    public org.omg.CORBA.Any extract_any() {
        this.checkExtract(11, "Cannot extract any");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_any();
        }
        return (org.omg.CORBA.Any)this.value;
    }

    public void insert_TypeCode(org.omg.CORBA.TypeCode typeCode) {
        this.value = typeCode;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_TypeCode);
    }

    public org.omg.CORBA.TypeCode extract_TypeCode() {
        this.checkExtract(12, "Cannot extract TypeCode");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_TypeCode();
        }
        return (org.omg.CORBA.TypeCode)this.value;
    }

    public void insert_string(String string) {
        this.value = string;
        this.typeCode = this.orb.create_string_tc(0);
    }

    public String extract_string() {
        this.checkExtract(18, "Cannot extract string");
        return this.value.toString();
    }

    public void insert_wstring(String string) {
        this.value = string;
        this.typeCode = this.orb.create_wstring_tc(0);
    }

    public String extract_wstring() {
        this.checkExtract(27, "Cannot extract wstring");
        return this.value.toString();
    }

    public void insert_fixed(BigDecimal bigDecimal) {
        this.value = bigDecimal;
        this.typeCode = new FixedHolder(bigDecimal)._type();
    }

    public void insert_fixed(BigDecimal bigDecimal, org.omg.CORBA.TypeCode typeCode) {
        try {
            java.lang.Object object;
            String string = bigDecimal.toString();
            int n = bigDecimal.scale() - typeCode.fixed_scale();
            if (n > 0) {
                string = string.substring(0, string.length() - n);
            } else if (n < 0) {
                object = new StringBuffer(string);
                if (string.indexOf(46) == -1) {
                    ((StringBuffer)object).append(".");
                }
                for (int i = n; i < 0; ++i) {
                    ((StringBuffer)object).append("0");
                }
                string = ((StringBuffer)object).toString();
            }
            bigDecimal = new BigDecimal(string);
            object = new FixedHolder(bigDecimal);
            org.omg.CORBA.TypeCode typeCode2 = ((FixedHolder)object)._type();
            if (typeCode2.fixed_digits() > typeCode.fixed_digits()) {
                throw new BAD_TYPECODE();
            }
        }
        catch (BadKind badKind) {
            throw new BAD_TYPECODE();
        }
        this.value = bigDecimal;
        this.typeCode = typeCode;
    }

    public BigDecimal extract_fixed() {
        this.checkExtract(28, "Cannot extract fixed");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_fixed();
        }
        return (BigDecimal)this.value;
    }

    public void insert_Object(Object object) {
        this.value = object;
        org.omg.CORBA.ORB oRB = null;
        String string = null;
        String string2 = "";
        if (this.value == null) {
            oRB = org.omg.CORBA.ORB.init();
            string = "IDL:omg.org/CORBA/Object:1.0";
            string2 = "Object";
        } else {
            oRB = ((ObjectImpl)object)._orb();
            string = ((ObjectImpl)object)._ids()[0];
            if (string.startsWith("IDL:")) {
                string2 = string.substring(4, string.lastIndexOf(58));
                string2 = string2.substring(string2.lastIndexOf(47) + 1);
            } else if (string.startsWith("RMI:")) {
                string2 = string.substring(4, string.lastIndexOf(58));
                string2 = string2.substring(string2.lastIndexOf(46) + 1);
            } else {
                throw new BAD_PARAM("Unknown repository id format");
            }
        }
        this.typeCode = oRB.create_interface_tc(string, string2);
    }

    public void insert_Object(Object object, org.omg.CORBA.TypeCode typeCode) {
        if (typeCode.kind().value() != 14) {
            this.tc_error("Illegal, non-object TypeCode!");
        }
        this.orb = this.value == null ? org.omg.CORBA.ORB.init() : ((ObjectImpl)object)._orb();
        this.value = object;
        this.typeCode = typeCode;
    }

    public Object extract_Object() {
        this.checkExtract(14, "Cannot extract object");
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_Object();
        }
        return (Object)this.value;
    }

    public java.lang.Object extract_objref() {
        this.checkExtract(14, "Cannot extract object");
        return this.value;
    }

    public void insert_Principal(Principal principal) {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    public Principal extract_Principal() {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    public void insert_Streamable(Streamable streamable) {
        this.value = streamable;
        this.typeCode = streamable._type();
    }

    public Streamable extract_Streamable() throws BAD_INV_ORDER {
        try {
            return (Streamable)this.value;
        }
        catch (ClassCastException classCastException) {
            throw new BAD_INV_ORDER();
        }
    }

    public Serializable extract_Value() throws BAD_OPERATION {
        int n = this.typeCode.kind().value();
        if (n != 29 && n != 30 && n != 32 && n != 0) {
            this.tc_error("Cannot extract value!");
        }
        return (Serializable)this.value;
    }

    public void insert_Value(Serializable serializable) {
        if (serializable != null) {
            this.value = serializable;
            this.typeCode = TypeCode.create_tc(serializable.getClass());
        } else {
            this.value = null;
            this.typeCode = new TypeCode(0);
        }
    }

    public void insert_Value(Serializable serializable, org.omg.CORBA.TypeCode typeCode) throws MARSHAL {
        this.value = serializable;
        this.typeCode = typeCode;
    }

    public org.omg.CORBA.portable.OutputStream create_output_stream() {
        this.value = !(this.orb instanceof ORB) ? new CDROutputStream() : new CDROutputStream(this.orb);
        return (CDROutputStream)this.value;
    }

    public org.omg.CORBA.portable.InputStream create_input_stream() {
        if (this.value instanceof CDROutputStream) {
            return new CDRInputStream(this.orb, ((CDROutputStream)this.value).getBufferCopy());
        }
        CDROutputStream cDROutputStream = !(this.orb instanceof ORB) ? new CDROutputStream() : new CDROutputStream(this.orb);
        this.write_value(cDROutputStream);
        return new CDRInputStream(this.orb, cDROutputStream.getBufferCopy());
    }

    public void read_value(org.omg.CORBA.portable.InputStream inputStream, org.omg.CORBA.TypeCode typeCode) throws MARSHAL {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        this.typeCode = typeCode;
        int n = typeCode.kind().value();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.insert_short(inputStream.read_short());
                break;
            }
            case 3: {
                this.insert_long(inputStream.read_long());
                break;
            }
            case 23: {
                this.insert_longlong(inputStream.read_longlong());
                break;
            }
            case 4: {
                this.insert_ushort(inputStream.read_ushort());
                break;
            }
            case 5: {
                this.insert_ulong(inputStream.read_ulong());
                break;
            }
            case 24: {
                this.insert_ulonglong(inputStream.read_ulonglong());
                break;
            }
            case 6: {
                this.insert_float(inputStream.read_float());
                break;
            }
            case 7: {
                this.insert_double(inputStream.read_double());
                break;
            }
            case 28: {
                try {
                    BigDecimal bigDecimal = inputStream.read_fixed();
                    short s = typeCode.fixed_scale();
                    this.insert_fixed(bigDecimal.movePointLeft(s), typeCode);
                }
                catch (BadKind badKind) {}
                break;
            }
            case 8: {
                this.insert_boolean(inputStream.read_boolean());
                break;
            }
            case 9: {
                this.insert_char(inputStream.read_char());
                break;
            }
            case 26: {
                this.insert_wchar(inputStream.read_wchar());
                break;
            }
            case 10: {
                this.insert_octet(inputStream.read_octet());
                break;
            }
            case 11: {
                this.insert_any(inputStream.read_any());
                break;
            }
            case 12: {
                this.insert_TypeCode(inputStream.read_TypeCode());
                break;
            }
            case 13: {
                throw new NO_IMPLEMENT("Principal deprecated");
            }
            case 14: {
                this.insert_Object(inputStream.read_Object());
                break;
            }
            case 18: {
                this.insert_string(inputStream.read_string());
                break;
            }
            case 27: {
                this.insert_wstring(inputStream.read_wstring());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                this.value = !(this.orb instanceof ORB) ? new CDROutputStream() : new CDROutputStream(this.orb);
                ((CDROutputStream)this.value).write_value(typeCode, inputStream);
                break;
            }
            case 29: 
            case 30: {
                this.insert_Value(((InputStream)inputStream).read_value(), typeCode);
                break;
            }
            case 32: {
                java.lang.Object object = ((InputStream)inputStream).read_abstract_interface();
                if (object instanceof Object) {
                    this.insert_Object((Object)object);
                    break;
                }
                this.insert_Value((Serializable)object);
                break;
            }
            default: {
                throw new BAD_TYPECODE("Cannot handle TypeCode with kind " + n);
            }
        }
    }

    public void write_value(org.omg.CORBA.portable.OutputStream outputStream) {
        int n = this.typeCode.kind().value();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                outputStream.write_short(this.extract_short());
                break;
            }
            case 3: {
                outputStream.write_long(this.extract_long());
                break;
            }
            case 23: {
                outputStream.write_longlong(this.extract_longlong());
                break;
            }
            case 4: {
                outputStream.write_ushort(this.extract_ushort());
                break;
            }
            case 5: {
                outputStream.write_ulong(this.extract_ulong());
                break;
            }
            case 24: {
                outputStream.write_ulonglong(this.extract_ulonglong());
                break;
            }
            case 6: {
                outputStream.write_float(this.extract_float());
                break;
            }
            case 7: {
                outputStream.write_double(this.extract_double());
                break;
            }
            case 28: {
                outputStream.write_fixed(this.extract_fixed());
                break;
            }
            case 8: {
                outputStream.write_boolean(this.extract_boolean());
                break;
            }
            case 9: {
                outputStream.write_char(this.extract_char());
                break;
            }
            case 26: {
                outputStream.write_wchar(this.extract_wchar());
                break;
            }
            case 10: {
                outputStream.write_octet(this.extract_octet());
                break;
            }
            case 11: {
                outputStream.write_any(this.extract_any());
                break;
            }
            case 12: {
                outputStream.write_TypeCode(this.extract_TypeCode());
                break;
            }
            case 13: {
                throw new NO_IMPLEMENT("Principal deprecated");
            }
            case 14: {
                outputStream.write_Object(this.extract_Object());
                break;
            }
            case 18: {
                outputStream.write_string(this.extract_string());
                break;
            }
            case 27: {
                outputStream.write_wstring(this.extract_wstring());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                try {
                    if (this.value instanceof Streamable) {
                        Streamable streamable = (Streamable)this.value;
                        streamable._write(outputStream);
                        break;
                    }
                    if (!(this.value instanceof org.omg.CORBA.portable.OutputStream)) break;
                    org.omg.CORBA.ORB oRB = this.orb;
                    if (!(oRB instanceof ORB)) {
                        oRB = ((CDROutputStream)outputStream).orb();
                    }
                    CDROutputStream cDROutputStream = (CDROutputStream)this.value;
                    CDRInputStream cDRInputStream = new CDRInputStream(oRB, cDROutputStream.getBufferCopy());
                    cDRInputStream.read_value(this.typeCode, outputStream);
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new INTERNAL(exception.getMessage());
                }
            }
            case 29: 
            case 30: {
                ((OutputStream)outputStream).write_value((Serializable)this.value);
                break;
            }
            case 32: {
                ((OutputStream)outputStream).write_abstract_interface(this.value);
                break;
            }
            default: {
                throw new BAD_TYPECODE("Cannot handle TypeCode with kind " + n);
            }
        }
    }

    public void insert_void() {
        this.value = null;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_void);
    }

    public void insert_object(org.omg.CORBA.TypeCode typeCode, java.lang.Object object) {
        this.insert_object(typeCode, null, object);
    }

    public void insert_object(org.omg.CORBA.TypeCode typeCode, org.omg.CORBA.ORB oRB, java.lang.Object object) {
        this.typeCode = typeCode;
        if (oRB != null) {
            this.orb = oRB;
        }
        this.value = object;
    }
}

