/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.jgroups.Message;
import org.jgroups.auth.AuthToken;
import org.jgroups.util.Util;

public class MD5Token
extends AuthToken {
    public static final String TOKEN_ATTR = "auth_value";
    public static final String TOKEN_TYPE = "token_hash";
    private String token = null;
    private String hash_type = "MD5";

    public MD5Token() {
    }

    public MD5Token(String token2) {
        this.token = this.hash(token2);
    }

    public MD5Token(String token2, String hash_type) {
        this.token = this.hash(token2);
        this.hash_type = hash_type;
    }

    public void setValue(Properties properties) {
        this.token = this.hash((String)properties.get(TOKEN_ATTR));
        properties.remove(TOKEN_ATTR);
        if (properties.containsKey(TOKEN_TYPE)) {
            this.hash_type = (String)properties.get(TOKEN_TYPE);
            properties.remove(TOKEN_TYPE);
        }
    }

    public String getName() {
        return "org.jgroups.auth.MD5Token";
    }

    private String hash(String token2) {
        String hashedToken = null;
        hashedToken = this.hash_type.equalsIgnoreCase("SHA") ? Util.sha(token2) : Util.md5(token2);
        if (hashedToken == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("Failed to hash token - sending in clear text");
            }
            return token2;
        }
        return hashedToken;
    }

    public boolean authenticate(AuthToken token2, Message msg) {
        if (token2 != null && token2 instanceof MD5Token) {
            MD5Token serverToken = (MD5Token)token2;
            if (this.token != null && serverToken.token != null && this.token.equalsIgnoreCase(serverToken.token)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("MD5Token match");
                }
                return true;
            }
            if (this.log.isWarnEnabled()) {
                this.log.warn("Authentication failed on MD5Token");
            }
            return false;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn("Invalid AuthToken instance - wrong type or null");
        }
        return false;
    }

    public void writeTo(DataOutputStream out) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("MD5Token writeTo()");
        }
        Util.writeString(this.token, out);
    }

    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("MD5Token readFrom()");
        }
        this.token = Util.readString(in);
    }
}

