/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspCollector;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.Scheduler;
import org.jgroups.util.SchedulerListener;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestCorrelator {
    protected Object transport = null;
    protected final ConcurrentMap<Long, RspCollector> requests = new ConcurrentHashMap<Long, RspCollector>();
    protected RequestHandler request_handler = null;
    protected RpcDispatcher.Marshaller2 marshaller = null;
    protected String name = null;
    protected Scheduler scheduler = null;
    protected Address local_addr = null;
    protected Stack<Address> call_stack = null;
    protected boolean deadlock_detection = false;
    private CallStackSetter call_stack_setter = null;
    protected boolean concurrent_processing = false;
    protected boolean started = false;
    private final MyProbeHandler probe_handler = new MyProbeHandler(this.requests);
    protected static final Log log = LogFactory.getLog(RequestCorrelator.class);

    public RequestCorrelator(String name, Object transport, RequestHandler handler) {
        this.name = name;
        this.transport = transport;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, Address local_addr) {
        this.name = name;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection) {
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection, boolean concurrent_processing) {
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.request_handler = handler;
        this.concurrent_processing = concurrent_processing;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection, Address local_addr) {
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection, Address local_addr, boolean concurrent_processing) {
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.concurrent_processing = concurrent_processing;
        this.start();
    }

    public void setDeadlockDetection(boolean flag) {
        if (this.deadlock_detection != flag) {
            this.deadlock_detection = flag;
            if (this.started) {
                if (this.deadlock_detection) {
                    this.startScheduler();
                } else {
                    this.stopScheduler();
                }
            }
        }
    }

    public void setRequestHandler(RequestHandler handler) {
        this.request_handler = handler;
        this.start();
    }

    public void setConcurrentProcessing(boolean concurrent_processing) {
        this.concurrent_processing = concurrent_processing;
    }

    public void sendRequest(long id, Message msg, RspCollector coll) throws Exception {
        this.sendRequest(id, null, msg, coll);
    }

    public RpcDispatcher.Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(RpcDispatcher.Marshaller marshaller) {
        this.marshaller = marshaller == null ? null : (marshaller instanceof RpcDispatcher.Marshaller2 ? (RpcDispatcher.Marshaller2)marshaller : new RpcDispatcher.MarshallerAdapter(marshaller));
    }

    public void sendRequest(long id, List<Address> dest_mbrs, Message msg, RspCollector coll) throws Exception {
        this.sendRequest(id, dest_mbrs, msg, coll, false);
    }

    public void sendRequest(long id, List<Address> dest_mbrs, Message msg, RspCollector coll, boolean use_anycasting) throws Exception {
        Message copy;
        if (this.transport == null) {
            if (log.isWarnEnabled()) {
                log.warn("transport is not available !");
            }
            return;
        }
        Header hdr = new Header(0, id, coll != null, this.name);
        hdr.dest_mbrs = dest_mbrs;
        if (coll != null) {
            if (this.deadlock_detection) {
                if (this.local_addr == null) {
                    if (log.isErrorEnabled()) {
                        log.error("local address is null !");
                    }
                    return;
                }
                Stack new_call_stack = this.call_stack != null ? (Stack)this.call_stack.clone() : new Stack();
                new_call_stack.push(this.local_addr);
                hdr.callStack = new_call_stack;
            }
            this.addEntry(hdr.id, coll);
        }
        msg.putHeader(this.name, hdr);
        if (this.transport instanceof Protocol) {
            if (use_anycasting) {
                for (Address mbr : dest_mbrs) {
                    copy = msg.copy(true);
                    copy.setDest(mbr);
                    ((Protocol)this.transport).down(new Event(1, copy));
                }
            } else {
                ((Protocol)this.transport).down(new Event(1, msg));
            }
        } else if (this.transport instanceof Transport) {
            if (use_anycasting) {
                for (Address mbr : dest_mbrs) {
                    copy = msg.copy(true);
                    copy.setDest(mbr);
                    ((Transport)this.transport).send(copy);
                }
            } else {
                ((Transport)this.transport).send(msg);
            }
        } else {
            throw new IllegalStateException("transport has to be either a Transport or a Protocol, however it is a " + this.transport.getClass());
        }
    }

    public void done(long id) {
        this.removeEntry(id);
    }

    public boolean receive(Event evt) {
        switch (evt.getType()) {
            case 9: {
                this.receiveSuspect((Address)evt.getArg());
                break;
            }
            case 6: {
                this.receiveView((View)evt.getArg());
                break;
            }
            case 8: {
                this.setLocalAddress((Address)evt.getArg());
                break;
            }
            case 1: {
                if (!this.receiveMessage((Message)evt.getArg())) break;
                return true;
            }
        }
        return false;
    }

    public final void start() {
        if (this.deadlock_detection) {
            this.startScheduler();
        }
        this.started = true;
    }

    public void stop() {
        this.stopScheduler();
        this.started = false;
    }

    void startScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new Scheduler();
            if (this.deadlock_detection && this.call_stack_setter == null) {
                this.call_stack_setter = new CallStackSetter();
                this.scheduler.setListener(this.call_stack_setter);
            }
            if (this.concurrent_processing) {
                this.scheduler.setConcurrentProcessing(this.concurrent_processing);
            }
            this.scheduler.start();
        }
    }

    void stopScheduler() {
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
    }

    public void registerProbeHandler(TP transport) {
        if (transport != null) {
            transport.registerProbeHandler(this.probe_handler);
        }
    }

    public void unregisterProbeHandler(TP transport) {
        if (transport != null) {
            transport.unregisterProbeHandler(this.probe_handler);
        }
    }

    public void receiveSuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("suspect=" + mbr);
        }
        for (RspCollector coll : this.requests.values()) {
            if (coll == null) continue;
            coll.suspect(mbr);
        }
    }

    public void receiveView(View new_view) {
        for (RspCollector coll : this.requests.values()) {
            if (coll == null) continue;
            coll.viewChange(new_view);
        }
    }

    public boolean receiveMessage(Message msg) {
        Header hdr = (Header)msg.getHeader(this.name);
        if (hdr == null) {
            return false;
        }
        if (hdr.corrName == null || !hdr.corrName.equals(this.name)) {
            if (log.isTraceEnabled()) {
                log.trace(new StringBuilder("name of request correlator header (").append(hdr.corrName).append(") is different from ours (").append(this.name).append("). Msg not accepted, passed up"));
            }
            return false;
        }
        List<Address> dests = hdr.dest_mbrs;
        if (dests != null && this.local_addr != null && !dests.contains(this.local_addr)) {
            if (log.isTraceEnabled()) {
                log.trace(new StringBuilder("discarded request from ").append(msg.getSrc()).append(" as we are not part of destination list (local_addr=").append(this.local_addr).append(", hdr=").append(hdr).append(')'));
            }
            return true;
        }
        switch (hdr.type) {
            case 0: {
                if (this.request_handler == null) {
                    if (log.isWarnEnabled()) {
                        log.warn("there is no request handler installed to deliver request !");
                    }
                    return true;
                }
                if (this.deadlock_detection) {
                    if (this.scheduler == null) {
                        log.error("deadlock_detection is true, but scheduler is null: this is not supposed to happen (discarding request)");
                        break;
                    }
                    Request req = new Request(msg, hdr);
                    Stack<Address> stack = hdr.callStack;
                    if (hdr.rsp_expected && stack != null && this.local_addr != null && stack.contains(this.local_addr)) {
                        if (log.isTraceEnabled()) {
                            log.trace("call stack=" + hdr.callStack + " contains " + this.local_addr + ": adding request to priority queue");
                        }
                        this.scheduler.addPrio(req);
                        break;
                    }
                    this.scheduler.add(req);
                    break;
                }
                this.handleRequest(msg, hdr);
                break;
            }
            case 1: {
                msg.getHeader(this.name);
                RspCollector coll = (RspCollector)this.requests.get(hdr.id);
                if (coll == null) break;
                Address sender = msg.getSrc();
                Object retval = null;
                byte[] buf = msg.getBuffer();
                int offset = msg.getOffset();
                int length = msg.getLength();
                try {
                    retval = this.marshaller != null ? this.marshaller.objectFromByteBuffer(buf, offset, length) : Util.objectFromByteBuffer(buf, offset, length);
                }
                catch (Exception e) {
                    log.error("failed unmarshalling buffer into return value", e);
                    retval = e;
                }
                coll.receiveResponse(retval, sender);
                break;
            }
            default: {
                msg.getHeader(this.name);
                if (!log.isErrorEnabled()) break;
                log.error("header's type is neither REQ nor RSP !");
            }
        }
        return true;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public void setLocalAddress(Address local_addr) {
        this.local_addr = local_addr;
    }

    private void addEntry(long id, RspCollector coll) {
        this.requests.putIfAbsent(id, coll);
    }

    private void removeEntry(long id) {
        Long id_obj = new Long(id);
        this.requests.remove(id_obj);
    }

    protected void handleRequest(Message req, Header hdr) {
        block23: {
            byte[] rsp_buf;
            Object retval;
            if (log.isTraceEnabled()) {
                log.trace(new StringBuilder("calling (").append(this.request_handler != null ? this.request_handler.getClass().getName() : "null").append(") with request ").append(hdr.id));
            }
            try {
                retval = this.request_handler.handle(req);
            }
            catch (Throwable t) {
                if (log.isErrorEnabled()) {
                    log.error("error invoking method", t);
                }
                retval = t;
            }
            if (!hdr.rsp_expected) {
                return;
            }
            if (this.transport == null) {
                if (log.isErrorEnabled()) {
                    log.error("failure sending response; no transport available");
                }
                return;
            }
            try {
                rsp_buf = this.marshaller != null ? (Object)this.marshaller.objectToBuffer(retval) : Util.objectToByteBuffer(retval);
            }
            catch (Throwable t) {
                try {
                    rsp_buf = this.marshaller != null ? (Object)this.marshaller.objectToBuffer(t) : Util.objectToByteBuffer(t);
                }
                catch (Throwable tt) {
                    if (log.isErrorEnabled()) {
                        log.error("failed sending rsp: return value (" + retval + ") is not serializable");
                    }
                    return;
                }
            }
            Message rsp = req.makeReply();
            if (rsp_buf instanceof Buffer) {
                rsp.setBuffer((Buffer)rsp_buf);
            } else if (rsp_buf instanceof byte[]) {
                rsp.setBuffer(rsp_buf);
            }
            Header rsp_hdr = new Header(1, hdr.id, false, this.name);
            rsp.putHeader(this.name, rsp_hdr);
            if (log.isTraceEnabled()) {
                log.trace(new StringBuilder("sending rsp for ").append(rsp_hdr.id).append(" to ").append(rsp.getDest()));
            }
            try {
                if (this.transport instanceof Protocol) {
                    ((Protocol)this.transport).down(new Event(1, rsp));
                } else if (this.transport instanceof Transport) {
                    ((Transport)this.transport).send(rsp);
                } else if (log.isErrorEnabled()) {
                    log.error("transport object has to be either a Transport or a Protocol, however it is a " + this.transport.getClass());
                }
            }
            catch (Throwable e) {
                if (!log.isErrorEnabled()) break block23;
                log.error("failed sending the response", e);
            }
        }
    }

    private class Request
    implements Runnable {
        final Message req;
        final Header hdr;

        public Request(Message req, Header hdr) {
            this.req = req;
            this.hdr = hdr;
        }

        public void run() {
            RequestCorrelator.this.handleRequest(this.req, this.hdr);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.req != null) {
                sb.append("req=" + this.req + ", headers=" + this.req.printObjectHeaders());
            }
            return sb.toString();
        }
    }

    private class CallStackSetter
    implements SchedulerListener {
        private CallStackSetter() {
        }

        public void started(Runnable r) {
            this.setCallStack(r);
        }

        public void stopped(Runnable r) {
            this.setCallStack(null);
        }

        public void suspended(Runnable r) {
            this.setCallStack(null);
        }

        public void resumed(Runnable r) {
            this.setCallStack(r);
        }

        void setCallStack(Runnable r) {
            if (r == null) {
                RequestCorrelator.this.call_stack = null;
                return;
            }
            Message req = ((Request)r).req;
            if (req == null) {
                return;
            }
            org.jgroups.Header obj = req.getHeader(RequestCorrelator.this.name);
            if (obj == null || !(obj instanceof Header)) {
                return;
            }
            Header hdr = (Header)obj;
            if (!hdr.rsp_expected) {
                return;
            }
            Stack<Address> new_stack = hdr.callStack;
            if (new_stack != null) {
                RequestCorrelator.this.call_stack = (Stack)new_stack.clone();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyProbeHandler
    implements TP.ProbeHandler {
        private final ConcurrentMap<Long, RspCollector> requests;

        public MyProbeHandler(ConcurrentMap<Long, RspCollector> requests) {
            this.requests = requests;
        }

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            if (this.requests == null) {
                return null;
            }
            HashMap<String, String> retval = new HashMap<String, String>();
            for (String key : keys) {
                if (!key.equals("requests")) continue;
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : this.requests.entrySet()) {
                    sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                }
                retval.put("requests", sb.toString());
                break;
            }
            return retval;
        }

        @Override
        public String[] supportedKeys() {
            return new String[]{"requests"};
        }
    }

    public static final class Header
    extends org.jgroups.Header
    implements Streamable {
        public static final byte REQ = 0;
        public static final byte RSP = 1;
        public byte type = 0;
        public long id = 0L;
        public boolean rsp_expected = true;
        public String corrName = null;
        public Stack<Address> callStack = null;
        public List<Address> dest_mbrs = null;

        public Header() {
        }

        public Header(byte type, long id, boolean rsp_expected, String name) {
            this.type = type;
            this.id = id;
            this.rsp_expected = rsp_expected;
            this.corrName = name;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append("[Header: name=" + this.corrName + ", type=");
            ret.append(this.type == 0 ? "REQ" : (this.type == 1 ? "RSP" : "<unknown>"));
            ret.append(", id=" + this.id);
            ret.append(", rsp_expected=" + this.rsp_expected + ']');
            if (this.callStack != null) {
                ret.append(", call stack=" + this.callStack);
            }
            if (this.dest_mbrs != null) {
                ret.append(", dest_mbrs=").append(this.dest_mbrs);
            }
            return ret.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            out.writeBoolean(this.rsp_expected);
            if (this.corrName != null) {
                out.writeBoolean(true);
                out.writeUTF(this.corrName);
            } else {
                out.writeBoolean(false);
            }
            out.writeObject(this.callStack);
            out.writeObject(this.dest_mbrs);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.rsp_expected = in.readBoolean();
            if (in.readBoolean()) {
                this.corrName = in.readUTF();
            }
            this.callStack = (Stack)in.readObject();
            this.dest_mbrs = (List)in.readObject();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            out.writeBoolean(this.rsp_expected);
            if (this.corrName != null) {
                out.writeBoolean(true);
                out.writeUTF(this.corrName);
            } else {
                out.writeBoolean(false);
            }
            if (this.callStack != null) {
                out.writeBoolean(true);
                out.writeShort(this.callStack.size());
                for (int i = 0; i < this.callStack.size(); ++i) {
                    Address mbr = (Address)this.callStack.elementAt(i);
                    Util.writeAddress(mbr, out);
                }
            } else {
                out.writeBoolean(false);
            }
            Util.writeAddresses(this.dest_mbrs, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.rsp_expected = in.readBoolean();
            boolean present = in.readBoolean();
            if (present) {
                this.corrName = in.readUTF();
            }
            if (present = in.readBoolean()) {
                this.callStack = new Stack();
                short len = in.readShort();
                for (short i = 0; i < len; i = (short)(i + 1)) {
                    Address tmp = Util.readAddress(in);
                    this.callStack.add(tmp);
                }
            }
            this.dest_mbrs = (List)Util.readAddresses(in, LinkedList.class);
        }

        public int size() {
            int retval = 10;
            ++retval;
            if (this.corrName != null) {
                retval += this.corrName.length() + 2;
            }
            ++retval;
            if (this.callStack != null) {
                retval += 2;
                if (!this.callStack.isEmpty()) {
                    Address mbr = (Address)this.callStack.firstElement();
                    retval += this.callStack.size() * Util.size(mbr);
                }
            }
            retval = (int)((long)retval + Util.size(this.dest_mbrs));
            return retval;
        }
    }
}

