/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.mux;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelListenerAdapter;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.Global;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.mux.MuxChannel;
import org.jgroups.mux.MuxHeader;
import org.jgroups.mux.ServiceInfo;
import org.jgroups.protocols.pbcast.FLUSH;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.AckCollector;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.FIFOMessageQueue;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multiplexer
implements UpHandler {
    private static final Log log = LogFactory.getLog(Multiplexer.class);
    private static final String SEPARATOR = "::";
    private static final short SEPARATOR_LEN = (short)"::".length();
    private static final String NAME = "MUX";
    private final ConcurrentMap<String, MuxChannel> services = new ConcurrentHashMap<String, MuxChannel>();
    private final JChannel channel;
    private final ExecutorService thread_pool;
    private final FIFOMessageQueue<String, Runnable> fifo_queue = new FIFOMessageQueue();
    private final AckCollector service_ack_collector = new AckCollector();
    protected long service_ack_timeout = 2000L;
    private volatile View view = null;
    private final Map<String, Boolean> state_transfer_listeners = new HashMap<String, Boolean>();
    private final Map<String, List<Address>> service_state = new HashMap<String, List<Address>>();
    private final Map<Address, Set<String>> service_responses = new HashMap<Address, Set<String>>();
    private final List<Address> services_merged_collector = new ArrayList<Address>();
    private AtomicBoolean services_merged = new AtomicBoolean(false);
    private long service_response_timeout = 3000L;

    public Multiplexer(JChannel channel) {
        if (channel == null || !channel.isOpen()) {
            throw new IllegalArgumentException("Channel " + channel + " cannot be used for Multiplexer");
        }
        this.channel = channel;
        this.channel.addChannelListener(new MultiplexerChannelListener());
        this.channel.setUpHandler(this);
        this.channel.setOpt(0, Boolean.TRUE);
        boolean use_thread_pool = Global.getPropertyAsBoolean("jgroups.mux.enabled", true);
        this.thread_pool = use_thread_pool ? this.createThreadPool() : null;
    }

    JChannel getChannel() {
        return this.channel;
    }

    public Set getApplicationIds() {
        return this.getServiceIds();
    }

    public Set<String> getServiceIds() {
        return Collections.unmodifiableSet(this.services.keySet());
    }

    public long getServicesResponseTimeout() {
        return this.service_response_timeout;
    }

    public void setServicesResponseTimeout(long services_rsp_timeout) {
        this.service_response_timeout = services_rsp_timeout;
    }

    public long getServiceAckTimeout() {
        return this.service_ack_timeout;
    }

    public void setServiceAckTimeout(long service_ack_timeout) {
        this.service_ack_timeout = service_ack_timeout;
    }

    View getServiceView(String service_id) {
        List<Address> hosts = this.service_state.get(service_id);
        if (hosts == null) {
            return null;
        }
        return this.generateServiceView(hosts);
    }

    boolean stateTransferListenersPresent() {
        return !this.state_transfer_listeners.isEmpty();
    }

    public synchronized void registerForStateTransfer(String appl_id, String substate_id) {
        String key = appl_id;
        if (substate_id != null && substate_id.length() > 0) {
            key = key + SEPARATOR + substate_id;
        }
        this.state_transfer_listeners.put(key, Boolean.FALSE);
    }

    synchronized boolean getState(Address target, String id, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        Collection<Boolean> values;
        boolean all_true;
        if (this.state_transfer_listeners.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Boolean> entry : this.state_transfer_listeners.entrySet()) {
            boolean match;
            String key = entry.getKey();
            int index = key.indexOf(SEPARATOR);
            if (index > -1) {
                String tmp = key.substring(0, index);
                match = id.equals(tmp);
            } else {
                match = id.equals(key);
            }
            if (!match) continue;
            entry.setValue(Boolean.TRUE);
            break;
        }
        if (!(all_true = Util.all(values = this.state_transfer_listeners.values(), Boolean.TRUE))) {
            return true;
        }
        boolean rc = false;
        HashSet<String> keys = new HashSet<String>(this.state_transfer_listeners.keySet());
        rc = this.fetchServiceStates(target, keys, timeout);
        this.state_transfer_listeners.clear();
        return rc;
    }

    protected ThreadPoolExecutor createThreadPool() {
        int min_threads = 1;
        int max_threads = 4;
        long keep_alive = 30000L;
        Map<String, Object> m = this.channel.getInfo();
        min_threads = Global.getPropertyAsInteger("jgroups.mux.min_threads", min_threads);
        max_threads = Global.getPropertyAsInteger("jgroups.mux.max_threads", max_threads);
        keep_alive = Global.getPropertyAsLong("jgroups.mux.keepalive_time", keep_alive);
        DefaultThreadFactory factory = new DefaultThreadFactory(Util.getGlobalThreadGroup(), "Multiplexer", false, true);
        return new ThreadPoolExecutor(min_threads, max_threads, keep_alive, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), factory, new ShutdownRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy()));
    }

    protected void shutdownThreadPool() {
        if (this.thread_pool != null && !this.thread_pool.isShutdown()) {
            this.thread_pool.shutdownNow();
            try {
                this.thread_pool.awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchServiceStates(Address target, Set<String> keys, long timeout) throws ChannelClosedException, ChannelNotConnectedException {
        boolean all_tranfers_ok = false;
        boolean flushStarted = this.channel.startFlush(false);
        if (flushStarted) {
            try {
                for (String stateId : keys) {
                    boolean rc = this.channel.getState(target, stateId, timeout, false);
                    if (rc) continue;
                    throw new Exception("Failed transfer for state id " + stateId + ", state provider was " + target);
                }
                all_tranfers_ok = true;
            }
            catch (Exception e) {
                log.warn("Failed multiple state transfer under one flush phase ", e);
            }
            finally {
                this.channel.stopFlush();
            }
        }
        return flushStarted && all_tranfers_ok;
    }

    void sendServiceUpMessage(String service) throws Exception {
        this.sendServiceMessage(true, (byte)3, service, null, false);
    }

    void sendServiceDownMessage(String service) throws Exception {
        this.sendServiceMessage(true, (byte)4, service, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                msg = (Message)evt.getArg();
                hdr = (MuxHeader)msg.getHeader("MUX");
                if (hdr == null) {
                    Multiplexer.log.error("MuxHeader not present - discarding message " + msg);
                    return null;
                }
                sender = msg.getSrc();
                v0 = isServiceMessage = hdr.info != null;
                if (!isServiceMessage) ** GOTO lbl18
                try {
                    this.handleServiceMessage(hdr.info, sender);
                }
                catch (Exception e) {
                    if (!Multiplexer.log.isErrorEnabled()) ** GOTO lbl17
                    Multiplexer.log.error("failure in handling service message " + hdr.info + " from sender " + sender, e);
                }
lbl17:
                // 3 sources

                return null;
lbl18:
                // 1 sources

                mux_ch = (MuxChannel)this.services.get(hdr.id);
                return mux_ch == null ? null : this.passToMuxChannel(mux_ch, evt, this.fifo_queue, sender, hdr.id, false, msg.isFlagSet((byte)1));
            }
            case 6: {
                old_members = this.view != null ? this.view.getMembers() : null;
                this.view = (View)evt.getArg();
                new_members = this.view != null ? this.view.getMembers() : null;
                left_members = Util.determineLeftMembers(old_members, new_members);
                if (this.view instanceof MergeView) {
                    temp_merge_view = (MergeView)this.view.clone();
                    if (Multiplexer.log.isTraceEnabled()) {
                        Multiplexer.log.trace("received a MergeView: " + temp_merge_view + ", adjusting the service view");
                    }
                    try {
                        this.handleMergeView(temp_merge_view);
                    }
                    catch (Exception e) {
                        if (!Multiplexer.log.isErrorEnabled()) ** GOTO lbl62
                        Multiplexer.log.error("failed handling merge view", e);
                    }
                    finally {
                        e = this.service_responses;
                        synchronized (e) {
                            this.service_responses.clear();
                        }
                        e = this.services_merged_collector;
                        synchronized (e) {
                            this.services_merged_collector.clear();
                        }
                        this.services_merged.set(false);
                    }
                } else {
                    payload = (HashMap)this.view.getPayload("service_state");
                    if (payload != null) {
                        e = this.service_state;
                        synchronized (e) {
                            this.service_state.putAll(payload);
                        }
                    }
                }
lbl62:
                // 6 sources

                this.service_ack_collector.handleView(this.view);
                for (Address member : left_members) {
                    try {
                        this.adjustServiceView(member);
                    }
                    catch (Throwable t) {
                        if (!Multiplexer.log.isErrorEnabled()) continue;
                        Multiplexer.log.error("failed adjusting service views", t);
                    }
                }
                break;
            }
            case 86: {
                prepare_view = (View)evt.getArg();
                old_members = this.view != null ? this.view.getMembers() : new Vector<Address>();
                added_members = new Vector<Address>(prepare_view.getMembers());
                added_members.removeAll(old_members);
                if (added_members.isEmpty()) break;
                t = this.service_state;
                synchronized (t) {
                    prepare_view.addPayload("service_state", this.service_state);
                    break;
                }
            }
            case 9: {
                suspected_mbr = (Address)evt.getArg();
                this.service_ack_collector.suspect(suspected_mbr);
                this.passToAllMuxChannels(evt);
                break;
            }
            case 17: {
                return this.handleStateRequest(evt, true);
            }
            case 72: {
                this.handleStateRequest(evt, true);
                break;
            }
            case 20: 
            case 71: {
                this.handleStateResponse(evt, true);
                break;
            }
            case 8: {
                this.passToAllMuxChannels(evt);
                break;
            }
            case 10: {
                this.passToAllMuxChannels(evt, true, true);
                return null;
            }
            case 75: {
                this.passToAllMuxChannels(evt);
                break;
            }
            case 46: {
                this.closeAll();
                break;
            }
            default: {
                this.passToAllMuxChannels(evt);
            }
        }
        return null;
    }

    public Channel createMuxChannel(String id, String stack_name) throws Exception {
        if (this.services.containsKey(id)) {
            throw new Exception("service ID \"" + id + "\" is already registered at channel" + this.getLocalAddress() + ", cannot register service with duplicate ID at the same channel");
        }
        MuxChannel ch = new MuxChannel(id, stack_name, this);
        this.services.put(id, ch);
        return ch;
    }

    private void passToAllMuxChannels(Event evt) {
        this.passToAllMuxChannels(evt, false, true);
    }

    private void passToAllMuxChannels(Event evt, boolean block, boolean bypass_thread_pool) {
        for (Map.Entry entry : this.services.entrySet()) {
            String service_name = (String)entry.getKey();
            MuxChannel ch = (MuxChannel)entry.getValue();
            this.passToMuxChannel(ch, evt, this.fifo_queue, null, service_name, block, bypass_thread_pool);
        }
    }

    void addServiceIfNotPresent(String id, MuxChannel ch) {
        this.services.putIfAbsent(id, ch);
    }

    protected MuxChannel removeService(String id) {
        MuxChannel ch = (MuxChannel)this.services.remove(id);
        if (ch != null) {
            ch.up(new Event(75));
        }
        return ch;
    }

    void disconnect() {
        boolean all_disconnected = true;
        for (MuxChannel mux_ch : this.services.values()) {
            if (!mux_ch.isConnected()) continue;
            all_disconnected = false;
            break;
        }
        if (all_disconnected) {
            if (log.isTraceEnabled()) {
                log.trace("disconnecting underlying JChannel as all MuxChannels are disconnected");
            }
            this.channel.disconnect();
        }
    }

    public boolean close() {
        boolean all_closed = true;
        for (MuxChannel mux_ch : this.services.values()) {
            if (!mux_ch.isOpen()) continue;
            all_closed = false;
            break;
        }
        if (all_closed) {
            if (log.isTraceEnabled()) {
                log.trace("closing underlying JChannel as all MuxChannels are closed");
            }
            this.channel.close();
            this.services.clear();
            this.shutdownThreadPool();
        }
        return all_closed;
    }

    public void closeAll() {
        for (MuxChannel mux_ch : this.services.values()) {
            mux_ch.setConnected(false);
            mux_ch.setClosed(true);
            mux_ch.closeMessageQueue(true);
        }
    }

    boolean shutdown() {
        boolean all_closed = true;
        for (MuxChannel mux_ch : this.services.values()) {
            if (!mux_ch.isOpen()) continue;
            all_closed = false;
            break;
        }
        if (all_closed) {
            if (log.isTraceEnabled()) {
                log.trace("shutting down underlying JChannel as all MuxChannels are closed");
            }
            this.channel.shutdown();
            this.services.clear();
            this.shutdownThreadPool();
        }
        return all_closed;
    }

    Address getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    boolean flushSupported() {
        return this.channel.flushSupported();
    }

    boolean startFlush(boolean automatic_resume) {
        return this.channel.startFlush(automatic_resume);
    }

    void stopFlush() {
        this.channel.stopFlush();
    }

    boolean isConnected() {
        return this.channel.isConnected();
    }

    void connect(String cluster_name) throws ChannelException {
        this.channel.connect(cluster_name);
    }

    boolean isOpen() {
        return this.channel.isOpen();
    }

    void open() throws ChannelException {
        this.channel.open();
    }

    Address getStateProvider(Address preferredTarget, String service_id) {
        Address result = null;
        List<Address> hosts = this.service_state.get(service_id);
        if (hosts != null && !hosts.isEmpty()) {
            result = hosts.contains(preferredTarget) ? preferredTarget : hosts.get(0);
        }
        return result;
    }

    private void sendServiceMessage(boolean synchronous, byte type, String service, byte[] payload, boolean oob) throws Exception {
        Address host = this.getLocalAddress();
        if (host == null) {
            if (log.isWarnEnabled()) {
                log.warn("local_addr is null, cannot send ServiceInfo." + ServiceInfo.typeToString(type) + " message");
            }
            return;
        }
        if (!this.channel.isOpen() || !this.channel.isConnected()) {
            if (log.isWarnEnabled()) {
                log.warn("Underlying multiplexer channel " + this.channel.getLocalAddress() + " is not connected, cannot send ServiceInfo." + ServiceInfo.typeToString(type) + " message");
            }
            return;
        }
        Message service_msg = new Message();
        service_msg.putHeader(NAME, new MuxHeader(new ServiceInfo(type, service, host, payload)));
        if (oob) {
            service_msg.setFlag((byte)1);
        }
        if (this.channel.flushSupported()) {
            service_msg.putHeader("FLUSH", new FLUSH.FlushHeader(6));
        }
        if (synchronous) {
            CopyOnWriteArrayList<Address> muxChannels = new CopyOnWriteArrayList<Address>();
            muxChannels.add(host);
            List<Address> list = this.service_state.get(service);
            if (list != null && !list.isEmpty()) {
                muxChannels.addAllAbsent(list);
            }
            this.service_ack_collector.reset(null, muxChannels);
            int size = this.service_ack_collector.size();
            this.channel.send(service_msg);
            long start = System.currentTimeMillis();
            try {
                this.service_ack_collector.waitForAllAcks(this.service_ack_timeout);
                if (log.isTraceEnabled()) {
                    log.trace("received all service ACKs (" + size + ")  in " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            catch (TimeoutException e) {
                log.warn("failed to collect all service ACKs (" + size + ") for " + service_msg + " after " + this.service_ack_timeout + "ms, missing ACKs from " + this.service_ack_collector.printMissing() + " (received=" + this.service_ack_collector.printReceived() + "), local_addr=" + this.getLocalAddress());
            }
        } else {
            this.channel.send(service_msg);
        }
    }

    private Object handleStateRequest(Event evt, boolean hasReturnValue) {
        String id;
        StateTransferInfo info = (StateTransferInfo)evt.getArg();
        String original_id = id = info.state_id;
        Address requester = info.target;
        if (id == null) {
            if (log.isWarnEnabled()) {
                log.warn("Invalid state request " + info + " arrived at Multiplexer, dropping it");
            }
            return new StateTransferInfo(null, original_id, 0L, null);
        }
        try {
            int index = id.indexOf(SEPARATOR);
            if (index > -1) {
                info.state_id = id.substring(index + SEPARATOR_LEN);
                id = id.substring(0, index);
            } else {
                info.state_id = null;
            }
            MuxChannel mux_ch = (MuxChannel)this.services.get(id);
            if (mux_ch == null) {
                if (log.isWarnEnabled()) {
                    log.warn("State provider " + this.channel.getLocalAddress() + " does not have service with id " + id + ", returning null state");
                }
                return new StateTransferInfo(null, original_id, 0L, null);
            }
            StateTransferInfo ret = (StateTransferInfo)this.passToMuxChannel(mux_ch, evt, this.fifo_queue, requester, id, hasReturnValue);
            if (ret == null) {
                return new StateTransferInfo(null, original_id, 0L, null);
            }
            ret.state_id = original_id;
            return ret;
        }
        catch (Throwable ex) {
            if (log.isErrorEnabled()) {
                log.error("failed returning the application state, will return null", ex);
            }
            return new StateTransferInfo(null, original_id, 0L, null);
        }
    }

    private void handleStateResponse(Event evt, boolean block) {
        String substate_id;
        String appl_id;
        StateTransferInfo info = (StateTransferInfo)evt.getArg();
        Address state_sender = info.target;
        String tmp = info.state_id;
        if (tmp == null) {
            if (log.isTraceEnabled()) {
                log.trace("state is null, not passing up: " + info);
            }
            return;
        }
        int index = tmp.indexOf(SEPARATOR);
        if (index > -1) {
            appl_id = tmp.substring(0, index);
            substate_id = tmp.substring(index + SEPARATOR_LEN);
        } else {
            appl_id = tmp;
            substate_id = null;
        }
        MuxChannel mux_ch = (MuxChannel)this.services.get(appl_id);
        if (mux_ch == null) {
            log.error("State receiver " + this.channel.getLocalAddress() + " does not have service with id " + appl_id);
        } else {
            StateTransferInfo tmp_info = info.copy();
            tmp_info.state_id = substate_id;
            Event tmpEvt = new Event(evt.getType(), tmp_info);
            this.passToMuxChannel(mux_ch, tmpEvt, this.fifo_queue, state_sender, appl_id, block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceMessage(ServiceInfo info, Address sender) throws Exception {
        switch (info.type) {
            case 3: {
                this.handleServiceUp(info.service, info.host);
                this.ackServiceMessage(info, sender);
                break;
            }
            case 4: {
                this.handleServiceDown(info.service, info.host);
                this.ackServiceMessage(info, sender);
                break;
            }
            case 5: {
                this.handleServicesRsp(sender, info.state);
                break;
            }
            case 6: {
                this.service_ack_collector.ack(sender);
                break;
            }
            case 7: {
                List<Address> list = this.services_merged_collector;
                synchronized (list) {
                    if (!this.services_merged_collector.contains(sender)) {
                        this.services_merged_collector.add(sender);
                    }
                    boolean mergeOk = this.view != null && this.services_merged_collector.containsAll(this.view.getMembers());
                    this.services_merged.set(mergeOk);
                    if (log.isDebugEnabled()) {
                        log.debug(this.getLocalAddress() + " got service merged from " + sender + " merged so far " + this.services_merged_collector + " view is " + this.view.size());
                    }
                    break;
                }
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error("service request type " + info.type + " not known");
            }
        }
    }

    private void ackServiceMessage(ServiceInfo info, Address ackTarget) throws ChannelNotConnectedException, ChannelClosedException {
        Message ack = new Message(ackTarget, null, null);
        ack.setFlag((byte)1);
        ServiceInfo si = new ServiceInfo(6, info.service, info.host, null);
        MuxHeader hdr = new MuxHeader(si);
        ack.putHeader(NAME, hdr);
        if (this.channel.isConnected()) {
            this.channel.send(ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServicesRsp(Address sender, byte[] state) throws Exception {
        Set s = (Set)Util.objectFromByteBuffer(state);
        boolean all_merged = false;
        Map<Address, Set<String>> map = this.service_responses;
        synchronized (map) {
            Set<String> tmp = this.service_responses.get(sender);
            if (tmp == null) {
                tmp = new HashSet<String>();
            }
            tmp.addAll(s);
            this.service_responses.put(sender, tmp);
            if (log.isDebugEnabled()) {
                log.debug(this.getLocalAddress() + " received service response: " + sender + "(" + s.toString() + ")");
            }
            all_merged = this.view != null && this.service_responses.keySet().containsAll(this.view.getMembers());
        }
        if (all_merged) {
            if (log.isDebugEnabled()) {
                log.debug(this.getLocalAddress() + " sent service merged " + this.service_responses.keySet() + " view is " + this.view.getMembers());
            }
            this.sendServiceMessage(false, (byte)7, null, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceDown(String service, Address host) {
        Address local_address;
        boolean isMyService;
        ArrayList<Address> hosts_copy;
        boolean removed = false;
        Map<String, List<Address>> map = this.service_state;
        synchronized (map) {
            List<Address> hosts = this.service_state.get(service);
            if (hosts == null) {
                return;
            }
            removed = hosts.remove(host);
            hosts_copy = new ArrayList<Address>(hosts);
        }
        if (removed) {
            View service_view = this.generateServiceView(hosts_copy);
            MuxChannel ch = (MuxChannel)this.services.get(service);
            if (ch != null && ch.isConnected()) {
                Event view_evt = new Event(6, service_view);
                this.passToMuxChannel(ch, view_evt, this.fifo_queue, null, service, false, true);
            } else if (log.isTraceEnabled()) {
                log.trace("service " + service + " not found, cannot dispatch service view " + service_view);
            }
        }
        boolean bl = isMyService = (local_address = this.getLocalAddress()) != null && local_address.equals(host);
        if (isMyService) {
            this.removeService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceUp(String service, Address host) {
        ArrayList<Address> hosts_copy;
        boolean added = false;
        Map<String, List<Address>> map = this.service_state;
        synchronized (map) {
            List<Address> hosts = this.service_state.get(service);
            if (hosts == null) {
                hosts = new CopyOnWriteArrayList<Address>();
                this.service_state.put(service, hosts);
            }
            if (!hosts.contains(host)) {
                hosts.add(host);
                added = true;
            }
            hosts_copy = new ArrayList<Address>(hosts);
        }
        if (added) {
            View service_view = this.generateServiceView(hosts_copy);
            MuxChannel ch = (MuxChannel)this.services.get(service);
            if (ch != null) {
                Event view_evt = new Event(6, service_view);
                this.passToMuxChannel(ch, view_evt, this.fifo_queue, null, service, false, true);
            } else if (log.isTraceEnabled()) {
                log.trace("service " + service + " not found, cannot dispatch service view " + service_view);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMergeView(MergeView view) throws Exception {
        long time_to_wait = this.service_response_timeout;
        long start_time = System.currentTimeMillis();
        HashMap<Address, Set<String>> copy = null;
        byte[] data = Util.objectToByteBuffer(new HashSet(this.services.keySet()));
        while (time_to_wait > 0L && !this.services_merged.get()) {
            this.sendServiceMessage(false, (byte)5, null, data, true);
            Util.sleep(500L);
            time_to_wait = this.service_response_timeout - (System.currentTimeMillis() - start_time);
        }
        if (time_to_wait <= 0L && !this.services_merged.get()) {
            log.warn("Services not merged at " + this.getLocalAddress() + " received merge from " + this.services_merged_collector);
        }
        Map<Address, Set<String>> map = this.service_responses;
        synchronized (map) {
            copy = new HashMap<Address, Set<String>>(this.service_responses);
        }
        if (log.isDebugEnabled()) {
            log.debug("At " + this.getLocalAddress() + " emitting views to MuxChannels " + copy);
        }
        this.mergeServiceState(view, copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeServiceState(MergeView view, Map<Address, Set<String>> copy) {
        HashSet<String> modified_services = new HashSet<String>();
        Map<String, List<Address>> map = this.service_state;
        synchronized (map) {
            for (Map.Entry<Address, Set<String>> entry : copy.entrySet()) {
                Address host = entry.getKey();
                Set<String> service_list = entry.getValue();
                if (service_list == null) continue;
                for (String service : service_list) {
                    boolean was_modified;
                    List<Address> my_services = this.service_state.get(service);
                    if (my_services == null) {
                        my_services = new CopyOnWriteArrayList<Address>();
                        this.service_state.put(service, my_services);
                    }
                    if (!(was_modified = my_services.add(host))) continue;
                    modified_services.add(service);
                }
            }
        }
        for (String service : modified_services) {
            MuxChannel ch = (MuxChannel)this.services.get(service);
            if (ch == null) continue;
            List<Address> hosts = this.service_state.get(service);
            Vector<Address> membersCopy = new Vector<Address>(view.getMembers());
            membersCopy.retainAll(hosts);
            MergeView v = new MergeView(view.getVid(), membersCopy, view.getSubgroups());
            this.passToMuxChannel(ch, new Event(6, v), this.fifo_queue, null, service, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustServiceView(Address host) {
        Address local_address = this.getLocalAddress();
        Map<String, List<Address>> map = this.service_state;
        synchronized (map) {
            for (Map.Entry<String, List<Address>> entry : this.service_state.entrySet()) {
                boolean isMyService;
                String service = entry.getKey();
                List<Address> hosts = entry.getValue();
                if (hosts == null) continue;
                if (hosts.remove(host)) {
                    View service_view = this.generateServiceView(new ArrayList<Address>(hosts));
                    MuxChannel ch = (MuxChannel)this.services.get(service);
                    if (ch != null && ch.isConnected()) {
                        Event view_evt = new Event(6, service_view);
                        this.passToMuxChannel(ch, view_evt, this.fifo_queue, null, service, false, true);
                    } else if (log.isTraceEnabled()) {
                        log.trace("service " + service + " not found, cannot dispatch service view " + service_view);
                    }
                }
                if (!(isMyService = local_address != null && local_address.equals(host))) continue;
                this.removeService(service);
            }
        }
    }

    private View generateServiceView(List<Address> hosts) {
        if (this.view == null) {
            Vector<Address> tmp = new Vector<Address>();
            tmp.add(this.getLocalAddress());
            this.view = new View(new ViewId(this.getLocalAddress()), tmp);
        }
        Vector<Address> members = new Vector<Address>(this.view.getMembers());
        members.retainAll(hosts);
        return new View(this.view.getVid(), members);
    }

    private Object passToMuxChannel(MuxChannel ch, Event evt, FIFOMessageQueue<String, Runnable> queue, Address sender, String dest, boolean block) {
        return this.passToMuxChannel(ch, evt, queue, sender, dest, block, false);
    }

    private Object passToMuxChannel(MuxChannel ch, Event evt, FIFOMessageQueue<String, Runnable> queue, Address sender, String dest, boolean block, boolean bypass_thread_pool) {
        if (this.thread_pool == null || bypass_thread_pool) {
            return ch.up(evt);
        }
        Task task = new Task(ch, evt, queue, sender, dest, block);
        ExecuteTask execute_task = new ExecuteTask(this.fifo_queue);
        try {
            this.fifo_queue.put(sender, dest, task);
            this.thread_pool.execute(execute_task);
            if (block) {
                try {
                    return task.exchanger.exchange(null);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecuteTask
    implements Runnable {
        FIFOMessageQueue<String, Runnable> queue;

        public ExecuteTask(FIFOMessageQueue<String, Runnable> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                Runnable task = this.queue.take();
                task.run();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Task
    implements Runnable {
        Exchanger<Object> exchanger;
        MuxChannel channel;
        Event evt;
        FIFOMessageQueue<String, Runnable> queue;
        Address sender;
        String dest;

        Task(MuxChannel channel, Event evt, FIFOMessageQueue<String, Runnable> queue, Address sender, String dest, boolean result_expected) {
            this.channel = channel;
            this.evt = evt;
            this.queue = queue;
            this.sender = sender;
            this.dest = dest;
            if (result_expected) {
                this.exchanger = new Exchanger();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object retval = this.channel.up(this.evt);
                if (this.exchanger != null) {
                    this.exchanger.exchange(retval);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.queue.done(this.sender, this.dest);
            }
        }
    }

    private class MultiplexerChannelListener
    extends ChannelListenerAdapter {
        private MultiplexerChannelListener() {
        }

        public void channelReconnected(Address addr) {
            if (log.isDebugEnabled()) {
                log.debug("Reconnecting services " + Multiplexer.this.services.keySet());
            }
            for (MuxChannel mux_ch : Multiplexer.this.services.values()) {
                try {
                    boolean fetchAndGetState;
                    if (log.isDebugEnabled()) {
                        log.debug("Reconnecting service " + mux_ch.getId());
                    }
                    mux_ch.open();
                    boolean reconnect = (Boolean)mux_ch.getOpt(5);
                    boolean getState = (Boolean)mux_ch.getOpt(6);
                    boolean bl = fetchAndGetState = reconnect && getState;
                    if (fetchAndGetState) {
                        mux_ch.connect(mux_ch.getClusterName(), null, null, 10000L);
                        mux_ch.fireChannelReconnected(mux_ch.getLocalAddress());
                        continue;
                    }
                    if (reconnect) {
                        mux_ch.connect(mux_ch.getClusterName());
                        mux_ch.fireChannelReconnected(mux_ch.getLocalAddress());
                    }
                    if (!getState) continue;
                    mux_ch.getState(null, 5000L);
                }
                catch (ChannelException e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error("MuxChannel reconnect failed " + e);
                }
            }
        }

        public void channelShunned() {
            for (MuxChannel mux_ch : Multiplexer.this.services.values()) {
                mux_ch.fireChannelShunned();
            }
        }
    }
}

