/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class BSH
extends Protocol {
    static final String name = "BSH";
    Interpreter interpreter = null;

    public String getName() {
        return name;
    }

    public void init() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
        if (this.interpreter != null) {
            this.destroyInterpreter();
        }
    }

    public void destroy() {
    }

    public Object up(Event evt) {
        Message msg;
        Header h;
        if (evt.getType() == 1 && (h = (msg = (Message)evt.getArg()).getHeader(name)) instanceof BshHeader) {
            int type = ((BshHeader)h).type;
            switch (type) {
                case 1: {
                    this.handleRequest(msg.getSrc(), msg.getBuffer());
                    return null;
                }
                case 2: {
                    msg.putHeader(name, h);
                    this.up_prot.up(evt);
                    return null;
                }
                case 3: {
                    this.destroyInterpreter();
                    return null;
                }
            }
            if (this.log.isErrorEnabled()) {
                this.log.error("header type was not REQ as expected (was " + type + ')');
            }
            return null;
        }
        return this.up_prot.up(evt);
    }

    void handleRequest(Address sender, byte[] buf) {
        Object retval;
        String code;
        block16: {
            if (buf == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("buffer was null");
                }
                return;
            }
            code = new String(buf);
            if (this.interpreter == null) {
                this.interpreter = new Interpreter();
                if (this.log.isInfoEnabled()) {
                    this.log.info("beanshell interpreter was created");
                }
                try {
                    this.interpreter.set("bsh_prot", (Object)this);
                    if (this.log.isInfoEnabled()) {
                        this.log.info("set \"bsh_prot\" to " + this);
                    }
                }
                catch (EvalError err) {
                    if (!this.log.isErrorEnabled()) break block16;
                    this.log.error("failed setting \"bsh_prot\": " + (Object)((Object)err));
                }
            }
        }
        try {
            retval = this.interpreter.eval(code);
            if (this.log.isInfoEnabled()) {
                this.log.info("eval: \"" + code + "\", retval=" + retval);
            }
        }
        catch (EvalError ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("error is " + Util.getStackTrace(ex));
            }
            retval = ex;
        }
        if (sender != null) {
            Message rsp = new Message(sender, null, null);
            if (retval != null) {
                if (retval instanceof Serializable) {
                    rsp.setObject((Serializable)retval);
                } else {
                    rsp.setObject((Serializable)((Object)retval.toString()));
                }
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("sending back response " + retval + " to " + rsp.getDest());
            }
            rsp.putHeader(name, new BshHeader(2));
            this.down_prot.down(new Event(1, rsp));
        }
    }

    public void destroyInterpreter() {
        this.interpreter = null;
        if (this.log.isInfoEnabled()) {
            this.log.info("beanshell interpreter was destroyed");
        }
    }

    public static class BshHeader
    extends Header {
        public static final int REQ = 1;
        public static final int RSP = 2;
        public static final int DESTROY_INTERPRETER = 3;
        int type = 1;

        public BshHeader() {
        }

        public BshHeader(int type) {
            this.type = type;
        }

        public int size() {
            return 10;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.type == 1) {
                sb.append("REQ");
            } else if (this.type == 2) {
                sb.append("RSP");
            } else if (this.type == 3) {
                sb.append("DESTROY_INTERPRETER");
            } else {
                sb.append("<unknown type>");
            }
            return sb.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }
    }
}

