/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DISCARD
extends Protocol {
    double up = 0.0;
    double down = 0.0;
    boolean excludeItself = true;
    Address localAddress;
    int num_down = 0;
    int num_up = 0;
    final Set<Address> ignoredMembers = new HashSet<Address>();
    boolean discard_all = false;
    int drop_down_unicasts = 0;
    int drop_down_multicasts = 0;

    @Override
    public String getName() {
        return "DISCARD";
    }

    public boolean isDiscardAll() {
        return this.discard_all;
    }

    public void setDiscardAll(boolean discard_all) {
        this.discard_all = discard_all;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("up");
        if (str != null) {
            this.up = Double.parseDouble(str);
            props.remove("up");
        }
        if ((str = props.getProperty("down")) != null) {
            this.down = Double.parseDouble(str);
            props.remove("down");
        }
        if ((str = props.getProperty("excludeitself")) != null) {
            this.excludeItself = Boolean.valueOf(str);
            props.remove("excludeitself");
        }
        if (!props.isEmpty()) {
            this.log.error("DISCARD.setProperties(): these properties are not recognized: " + props);
            return false;
        }
        return true;
    }

    public int getDropDownUnicasts() {
        return this.drop_down_unicasts;
    }

    public void setDropDownUnicasts(int drop_down_unicasts) {
        this.drop_down_unicasts = drop_down_unicasts;
    }

    public int getDropDownMulticasts() {
        return this.drop_down_multicasts;
    }

    public void setDropDownMulticasts(int drop_down_multicasts) {
        this.drop_down_multicasts = drop_down_multicasts;
    }

    public void addIgnoreMember(Address sender) {
        this.ignoredMembers.add(sender);
    }

    public void resetIgnoredMembers() {
        this.ignoredMembers.clear();
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    @Override
    public Object up(Event evt) {
        if (evt.getType() == 8) {
            this.localAddress = (Address)evt.getArg();
        }
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            Address sender = msg.getSrc();
            if (this.discard_all && !sender.equals(this.localAddress)) {
                return null;
            }
            DiscardHeader dh = (DiscardHeader)msg.getHeader(this.getName());
            if (dh != null) {
                this.ignoredMembers.clear();
                this.ignoredMembers.addAll(dh.dropMessages);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("will potentially drop messages from " + this.ignoredMembers);
                }
            } else {
                double r;
                boolean dropMessage = this.ignoredMembers.contains(sender);
                if (dropMessage) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("dropping message from " + sender);
                    }
                    ++this.num_up;
                    return null;
                }
                if (this.up > 0.0 && (r = Math.random()) < this.up) {
                    if (this.excludeItself && sender.equals(this.localAddress)) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("excluding itself");
                        }
                    } else {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("dropping message from " + sender);
                        }
                        ++this.num_up;
                        return null;
                    }
                }
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        if (evt.getType() == 1) {
            double r;
            Message msg = (Message)evt.getArg();
            Address dest = msg.getDest();
            if (msg.getSrc() == null) {
                msg.setSrc(this.localAddress);
            }
            if (this.discard_all) {
                if (dest == null || dest.isMulticastAddress() || dest.equals(this.localAddress)) {
                    this.loopback(msg);
                }
                return null;
            }
            if (this.down > 0.0 && (r = Math.random()) < this.down) {
                if (this.excludeItself && msg.getSrc().equals(this.localAddress)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("excluding itself");
                    }
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("dropping message");
                    }
                    ++this.num_down;
                    return null;
                }
            }
        }
        return this.down_prot.down(evt);
    }

    private void loopback(Message msg) {
        final Message rsp = msg.copy(true);
        if (rsp.getSrc() == null) {
            rsp.setSrc(this.localAddress);
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                DISCARD.this.up_prot.up(new Event(1, rsp));
            }
        });
        thread.start();
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_up = 0;
        this.num_down = 0;
    }

    @Override
    public Map<String, Object> dumpStats() {
        HashMap<String, Object> m = new HashMap<String, Object>(2);
        m.put("num_dropped_down", new Integer(this.num_down));
        m.put("num_dropped_up", new Integer(this.num_up));
        return m;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DiscardHeader
    extends Header
    implements Streamable {
        private final Set<Address> dropMessages;
        private static final long serialVersionUID = -2149735838082082084L;

        public DiscardHeader() {
            this.dropMessages = new HashSet<Address>();
        }

        public DiscardHeader(Set<Address> ignoredAddresses) {
            this.dropMessages = ignoredAddresses;
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            int size = in.readShort();
            if (size > 0) {
                this.dropMessages.clear();
                for (int i = 0; i < size; ++i) {
                    this.dropMessages.add(Util.readAddress(in));
                }
            }
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            if (this.dropMessages != null && !this.dropMessages.isEmpty()) {
                out.writeShort(this.dropMessages.size());
                for (Address addr : this.dropMessages) {
                    Util.writeAddress(addr, out);
                }
            } else {
                out.writeShort(0);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            Set tmp = (Set)in.readObject();
            this.dropMessages.clear();
            this.dropMessages.addAll(tmp);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.dropMessages);
        }
    }
}

