/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;

public class FD_SIMPLE
extends Protocol {
    Address local_addr = null;
    TimeScheduler timer = null;
    final Lock heartbeat_lock = new ReentrantLock();
    Future heartbeat_future = null;
    HeartbeatTask task;
    long interval = 3000L;
    long timeout = 3000L;
    final Vector members = new Vector();
    final HashMap counters = new HashMap();
    int max_missed_hbs = 5;
    static final String name = "FD_SIMPLE";

    public String getName() {
        return name;
    }

    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("interval")) != null) {
            this.interval = Long.parseLong(str);
            props.remove("interval");
        }
        if ((str = props.getProperty("max_missed_hbs")) != null) {
            this.max_missed_hbs = Integer.parseInt(str);
            props.remove("max_missed_hbs");
        }
        if (!props.isEmpty()) {
            this.log.error("the following properties are not recognized: " + props);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.heartbeat_lock.lock();
        try {
            if (this.heartbeat_future != null) {
                this.heartbeat_future.cancel(true);
                this.heartbeat_future = null;
                this.task = null;
            }
        }
        finally {
            this.heartbeat_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object up(Event evt) {
        FdHeader hdr = null;
        boolean counter_reset = false;
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Address sender = msg.getSrc();
                this.resetCounter(sender);
                counter_reset = true;
                hdr = (FdHeader)msg.getHeader(name);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        Message rsp = new Message(sender);
                        rsp.putHeader(name, new FdHeader(2));
                        this.down_prot.down(new Event(1, rsp));
                        return null;
                    }
                    case 2: {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("received I_AM_ALIVE response from " + sender);
                        }
                        this.heartbeat_lock.lock();
                        try {
                            if (this.task != null) {
                                this.task.receivedHeartbeatResponse(sender);
                            }
                        }
                        finally {
                            this.heartbeat_lock.unlock();
                        }
                        if (!counter_reset) {
                            this.resetCounter(sender);
                        }
                        return null;
                    }
                }
                if (this.log.isWarnEnabled()) {
                    this.log.warn("FdHeader type " + hdr.type + " not known");
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                new_view = (View)evt.getArg();
                this.members.clear();
                this.members.addAll(new_view.getMembers());
                if (new_view.size() <= 1) ** GOTO lbl19
                this.heartbeat_lock.lock();
                try {
                    if (this.heartbeat_future != null && !this.heartbeat_future.isDone()) ** GOTO lbl32
                    this.task = new HeartbeatTask();
                    if (this.log.isInfoEnabled()) {
                        this.log.info("starting heartbeat task");
                    }
                    this.heartbeat_future = this.timer.scheduleWithFixedDelay(this.task, this.interval, this.interval, TimeUnit.MILLISECONDS);
                }
                finally {
                    this.heartbeat_lock.unlock();
                }
lbl19:
                // 1 sources

                this.heartbeat_lock.lock();
                try {
                    if (this.heartbeat_future != null) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("stopping heartbeat task");
                        }
                        this.heartbeat_future.cancel(true);
                        this.heartbeat_future = null;
                        this.task = null;
                    }
                }
                finally {
                    this.heartbeat_lock.unlock();
                }
lbl32:
                // 3 sources

                it = this.counters.keySet().iterator();
                while (it.hasNext()) {
                    key = (Address)it.next();
                    if (this.members.contains(key)) continue;
                    if (this.log.isInfoEnabled()) {
                        this.log.info("removing " + key + " from counters");
                    }
                    it.remove();
                }
                break;
            }
        }
        return this.down_prot.down(evt);
    }

    Address getHeartbeatDest() {
        Address retval = null;
        if (this.members == null || this.members.size() < 2 || this.local_addr == null) {
            return null;
        }
        Vector members_copy = (Vector)this.members.clone();
        members_copy.removeElement(this.local_addr);
        int size = members_copy.size();
        int r = (int)(Math.random() * (double)(size + 1)) % size;
        retval = (Address)members_copy.elementAt(r);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int incrementCounter(Address mbr) {
        int ret = 0;
        if (mbr == null) {
            return ret;
        }
        HashMap hashMap = this.counters;
        synchronized (hashMap) {
            Integer cnt = (Integer)this.counters.get(mbr);
            if (cnt == null) {
                cnt = new Integer(0);
                this.counters.put(mbr, cnt);
            } else {
                ret = cnt + 1;
                this.counters.put(mbr, new Integer(ret));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetCounter(Address mbr) {
        if (mbr == null) {
            return;
        }
        HashMap hashMap = this.counters;
        synchronized (hashMap) {
            this.counters.put(mbr, new Integer(0));
        }
    }

    String printCounters() {
        StringBuilder sb = new StringBuilder();
        for (Address key : this.counters.keySet()) {
            sb.append(key).append(": ").append(this.counters.get(key)).append('\n');
        }
        return sb.toString();
    }

    class HeartbeatTask
    implements Runnable {
        final Promise<Address> promise = new Promise();
        Address dest = null;

        HeartbeatTask() {
        }

        public void receivedHeartbeatResponse(Address from) {
            if (from != null && this.dest != null && from.equals(this.dest)) {
                this.promise.setResult(from);
            }
        }

        public void run() {
            int num_missed_hbs = 0;
            this.dest = FD_SIMPLE.this.getHeartbeatDest();
            if (this.dest == null) {
                if (FD_SIMPLE.this.log.isWarnEnabled()) {
                    FD_SIMPLE.this.log.warn("heartbeat destination was null, will not send ARE_YOU_ALIVE message");
                }
                return;
            }
            if (FD_SIMPLE.this.log.isInfoEnabled()) {
                FD_SIMPLE.this.log.info("sending ARE_YOU_ALIVE message to " + this.dest + ", counters are\n" + FD_SIMPLE.this.printCounters());
            }
            this.promise.reset();
            Message msg = new Message(this.dest);
            msg.putHeader(FD_SIMPLE.name, new FdHeader(1));
            FD_SIMPLE.this.down_prot.down(new Event(1, msg));
            this.promise.getResult(FD_SIMPLE.this.timeout);
            num_missed_hbs = FD_SIMPLE.this.incrementCounter(this.dest);
            if (num_missed_hbs >= FD_SIMPLE.this.max_missed_hbs) {
                if (FD_SIMPLE.this.log.isInfoEnabled()) {
                    FD_SIMPLE.this.log.info("missed " + num_missed_hbs + " from " + this.dest + ", suspecting member");
                }
                FD_SIMPLE.this.up_prot.up(new Event(9, this.dest));
            }
        }
    }

    public static class FdHeader
    extends Header
    implements Streamable {
        static final byte ARE_YOU_ALIVE = 1;
        static final byte I_AM_ALIVE = 2;
        byte type = 1;
        private static final long serialVersionUID = 4021056597004641352L;

        public FdHeader() {
        }

        FdHeader(byte type) {
            this.type = type;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[FD_SIMPLE: ARE_YOU_ALIVE]";
                }
                case 2: {
                    return "[FD_SIMPLE: I_AM_ALIVE]";
                }
            }
            return "[FD_SIMPLE: unknown type (" + this.type + ")]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
        }

        public int size() {
            return 1;
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
        }
    }
}

