/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Message;

public class AckReceiverWindow {
    long next_to_remove = 0L;
    final Map<Long, Message> msgs = new HashMap<Long, Message>();
    static final Log log = LogFactory.getLog(AckReceiverWindow.class);
    final ReentrantLock lock = new ReentrantLock();

    public AckReceiverWindow(long initial_seqno) {
        this.next_to_remove = initial_seqno;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(long seqno, Message msg) {
        if (msg == null) {
            throw new IllegalArgumentException("msg must be non-null");
        }
        Map<Long, Message> map = this.msgs;
        synchronized (map) {
            if (seqno < this.next_to_remove) {
                if (log.isTraceEnabled()) {
                    log.trace("discarded msg with seqno=" + seqno + " (next msg to receive is " + this.next_to_remove + ')');
                }
                return false;
            }
            if (!this.msgs.containsKey(seqno)) {
                this.msgs.put(seqno, msg);
                return true;
            }
            if (log.isTraceEnabled()) {
                log.trace("seqno " + seqno + " already received - dropping it");
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message remove() {
        Message retval;
        Map<Long, Message> map = this.msgs;
        synchronized (map) {
            retval = this.msgs.remove(this.next_to_remove);
            if (retval != null) {
                if (log.isTraceEnabled()) {
                    log.trace("removed seqno=" + this.next_to_remove);
                }
                ++this.next_to_remove;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message removeOOBMessage() {
        Message retval;
        Map<Long, Message> map = this.msgs;
        synchronized (map) {
            retval = this.msgs.get(this.next_to_remove);
            if (retval != null) {
                if (!retval.isFlagSet((byte)1)) {
                    return null;
                }
                retval = this.msgs.remove(this.next_to_remove);
                if (log.isTraceEnabled()) {
                    log.trace("removed OOB message with seqno=" + this.next_to_remove);
                }
                ++this.next_to_remove;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessagesToRemove() {
        Map<Long, Message> map = this.msgs;
        synchronized (map) {
            return this.msgs.containsKey(this.next_to_remove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<Long, Message> map = this.msgs;
        synchronized (map) {
            this.msgs.clear();
        }
    }

    public int size() {
        return this.msgs.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.msgs.size()).append(" msgs (").append("next=").append(this.next_to_remove).append(")");
        TreeSet<Long> s = new TreeSet<Long>(this.msgs.keySet());
        if (!s.isEmpty()) {
            sb.append(" [").append(s.first()).append(" - ").append(s.last()).append("]");
            sb.append(": ").append(s);
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.msgs.size()).append(" msgs (").append("next=").append(this.next_to_remove).append(")").append(", msgs=").append(new TreeSet<Long>(this.msgs.keySet()));
        return sb.toString();
    }
}

