/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ExtendedReceiver;
import org.jgroups.GetStateEvent;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SetStateEvent;
import org.jgroups.UnblockEvent;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.stack.GossipRouter;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelTestBase
extends TestCase {
    protected static final Random RANDOM = new Random();
    private static final int LETTER_A = 64;
    protected static final String DEFAULT_MUX_FACTORY_COUNT = "4";
    protected static String CHANNEL_CONFIG = "udp.xml";
    protected int active_threads = 0;
    protected String thread_dump = null;
    protected int currentChannelGeneratedName = 64;
    private static final int ROUTER_PORT = 12001;
    private static final String BIND_ADDR = "127.0.0.1";
    GossipRouter router = null;
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public ChannelTestBase() {
    }

    public ChannelTestBase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        CHANNEL_CONFIG = System.getProperty("channel.conf", CHANNEL_CONFIG);
        this.currentChannelGeneratedName = 64;
        if (ChannelTestBase.isTunnelUsed()) {
            this.router = new GossipRouter(12001, BIND_ADDR);
            this.router.start();
        }
        if (ChannelTestBase.shouldCompareThreadCount()) {
            this.active_threads = Thread.activeCount();
            this.thread_dump = "active threads before (" + this.active_threads + "):\n" + Util.activeThreads();
        }
    }

    protected static boolean isTunnelUsed() {
        String channelConf = System.getProperty("channel.conf", "");
        String channelFlushConf = System.getProperty("channel.conf.flush", "");
        return channelConf.contains("tunnel") || channelFlushConf.contains("tunnel");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.router != null) {
            this.router.stop();
            Util.sleep(100L);
        }
        if (ChannelTestBase.shouldCompareThreadCount()) {
            Util.sleep(20L);
            int current_active_threads = Thread.activeCount();
            String msg = "";
            if (this.active_threads != current_active_threads) {
                System.out.println(this.thread_dump);
                System.out.println("active threads after (" + current_active_threads + "):\n" + Util.activeThreads());
                msg = "active threads:\n" + Util.dumpThreads();
            }
            ChannelTestBase.assertEquals((String)msg, (int)this.active_threads, (int)current_active_threads);
        }
    }

    protected String getNextChannelName() {
        return Character.toString((char)(++this.currentChannelGeneratedName));
    }

    protected String[] createApplicationNames(int applicationCount) {
        String[] names = new String[applicationCount];
        for (int i = 0; i < applicationCount; ++i) {
            names[i] = this.getNextChannelName();
        }
        return names;
    }

    protected JChannel createChannel(Object id) throws Exception {
        return (JChannel)new DefaultChannelTestFactory().createChannel(id);
    }

    protected JChannel createChannel() throws Exception {
        return this.createChannel("A");
    }

    public static String translateEventTrace(List<Object> et) throws Exception {
        String eventString = "";
        for (Object obj : et) {
            if (obj instanceof BlockEvent) {
                eventString = eventString + "b";
                continue;
            }
            if (obj instanceof UnblockEvent) {
                eventString = eventString + "u";
                continue;
            }
            if (obj instanceof SetStateEvent) {
                eventString = eventString + "s";
                continue;
            }
            if (obj instanceof GetStateEvent) {
                eventString = eventString + "g";
                continue;
            }
            if (obj instanceof View) {
                eventString = eventString + "v";
                continue;
            }
            throw new Exception("Unrecognized event type in event trace");
        }
        return eventString;
    }

    protected static boolean validateEventString(String eventString, String spec) {
        Pattern pattern = null;
        Matcher matcher = null;
        pattern = Pattern.compile(spec);
        matcher = pattern.matcher(eventString);
        if (matcher.find()) {
            if (matcher.start() != 0 || matcher.end() != eventString.length()) {
                System.err.println("event string invalid (proper substring matched): event string = " + eventString + ", specification = " + spec + "matcher.start() " + matcher.start() + " matcher.end() " + matcher.end());
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean validateEventTrace(List<Object> eventTrace) {
        String validSequence = "([b][vgs]*[u])+";
        String eventString = null;
        boolean result = false;
        try {
            eventString = ChannelTestBase.translateEventTrace(eventTrace);
            result = ChannelTestBase.validateEventString(eventString, "([b][vgs]*[u])+");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected static void checkEventStateTransferSequence(EventSequence receiver) {
        List<Object> events = receiver.getEvents();
        ChannelTestBase.assertNotNull(events);
        String validSequence = "([b][vgs]*[u])+";
        try {
            ChannelTestBase.assertTrue((String)("Invalid event sequence " + events), (boolean)ChannelTestBase.validateEventString(ChannelTestBase.translateEventTrace(events), "([b][vgs]*[u])+"));
        }
        catch (Exception e) {
            ChannelTestBase.fail((String)("Invalid event sequence " + events));
        }
    }

    protected static boolean shouldCompareThreadCount() {
        return Boolean.valueOf(System.getProperty("threadcount", "false"));
    }

    protected boolean useBlocking() {
        return Boolean.valueOf(System.getProperty("useBlocking", "false"));
    }

    public static boolean areViewsComplete(Channel[] channels, int memberCount) {
        for (int i = 0; i < memberCount; ++i) {
            if (ChannelTestBase.isViewComplete(channels[i], memberCount)) continue;
            return false;
        }
        return true;
    }

    public static void blockUntilViewsReceived(Channel[] channels, long timeout) {
        ChannelTestBase.blockUntilViewsReceived(channels, channels.length, timeout);
    }

    public static void blockUntilViewsReceived(List<? extends ChannelRetrievable> channels, int count, long timeout) {
        Channel[] cs = new Channel[channels.size()];
        int i = 0;
        for (ChannelRetrievable channelRetrievable : channels) {
            cs[i++] = channelRetrievable.getChannel();
        }
        ChannelTestBase.blockUntilViewsReceived(cs, count, timeout);
    }

    public static void blockUntilViewsReceived(List<? extends ChannelRetrievable> channels, long timeout) {
        Channel[] cs = new Channel[channels.size()];
        int i = 0;
        for (ChannelRetrievable channelRetrievable : channels) {
            cs[i++] = channelRetrievable.getChannel();
        }
        ChannelTestBase.blockUntilViewsReceived(cs, cs.length, timeout);
    }

    public static void blockUntilViewsReceived(Channel[] channels, int count, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            Util.sleep(100L);
            if (!ChannelTestBase.areViewsComplete(channels, count)) continue;
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Channel c : channels) {
            sb.append(c.getLocalAddress() + ",view=" + c.getView().getMembers() + "|");
        }
        throw new RuntimeException("timed out before caches had complete views. Views are " + sb.toString());
    }

    public static void blockUntilViewsReceived(Channel channel, int count, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        boolean timeouted = false;
        while (!ChannelTestBase.isViewComplete(channel, count) && !timeouted) {
            timeouted = System.currentTimeMillis() > failTime;
            Util.sleep(100L);
        }
        if (timeouted) {
            StringBuilder sb = new StringBuilder();
            sb.append(channel.getLocalAddress() + ",view=" + channel.getView().getMembers() + "|");
            throw new RuntimeException("timed out before caches had complete views. Views are " + sb.toString());
        }
    }

    public static void blockUntilViewsReceived(ChannelRetrievable[] channels, int count, long timeout) {
        List<ChannelRetrievable> list = Arrays.asList(channels);
        ChannelTestBase.blockUntilViewsReceived(list, count, timeout);
    }

    public static void blockUntilViewsReceived(ChannelRetrievable[] channels, long timeout) {
        List<ChannelRetrievable> list = Arrays.asList(channels);
        ChannelTestBase.blockUntilViewsReceived(list, list.size(), timeout);
    }

    public static void blockUntilViewsReceived(Collection<Channel> channels, int count, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            Util.sleep(100L);
            if (!ChannelTestBase.areViewsComplete(channels.toArray(new Channel[0]), count)) continue;
            return;
        }
        throw new RuntimeException("timed out before caches had complete views");
    }

    public static boolean isViewComplete(Channel channel, int memberCount) {
        Vector<Address> members;
        View view = channel.getView();
        Vector<Address> vector = members = view != null ? view.getMembers() : null;
        if (members == null || memberCount > members.size()) {
            return false;
        }
        if (memberCount < members.size()) {
            StringBuilder sb = new StringBuilder("Channel at address ");
            sb.append(channel.getLocalAddress());
            sb.append(" had ");
            sb.append(members.size());
            sb.append(" members; expecting ");
            sb.append(memberCount);
            sb.append(". Members were (");
            for (int j = 0; j < members.size(); ++j) {
                if (j > 0) {
                    sb.append(", ");
                }
                sb.append(members.get(j));
            }
            sb.append(')');
            throw new IllegalStateException(sb.toString());
        }
        return true;
    }

    public static void sleepRandom(int minTime, int maxTime) {
        int nextInt = RANDOM.nextInt(maxTime);
        if (nextInt < minTime) {
            nextInt = minTime;
        }
        Util.sleep(nextInt);
    }

    public static interface ChannelRetrievable {
        public Channel getChannel();
    }

    protected abstract class PushChannelApplicationWithSemaphore
    extends PushChannelApplication {
        protected Semaphore semaphore;

        public PushChannelApplicationWithSemaphore(String name, ChannelTestFactory factory, Semaphore semaphore, boolean useDispatcher) throws Exception {
            super(name, factory, useDispatcher);
            this.semaphore = semaphore;
        }

        protected PushChannelApplicationWithSemaphore(String name, Semaphore semaphore) throws Exception {
            this(name, semaphore, false);
        }

        protected PushChannelApplicationWithSemaphore(String name, Semaphore semaphore, boolean useDispatcher) throws Exception {
            this(name, channelTestBase.new DefaultChannelTestFactory(), semaphore, useDispatcher);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean acquired = false;
            try {
                acquired = this.semaphore.tryAcquire(60000L, TimeUnit.MILLISECONDS);
                if (!acquired) {
                    throw new Exception(this.name + " cannot acquire semaphore");
                }
                this.useChannel();
            }
            catch (Exception e) {
                ChannelTestBase.this.log.error(this.name + ": " + e.getLocalizedMessage(), e);
                this.exception = e;
            }
            finally {
                if (acquired) {
                    this.semaphore.release();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class PushChannelApplication
    extends ChannelApplication
    implements ExtendedReceiver {
        RpcDispatcher dispatcher;
        List<Object> events;

        public PushChannelApplication(String name) throws Exception {
            this(name, false);
        }

        public PushChannelApplication(String name, boolean useDispatcher) throws Exception {
            this(name, channelTestBase.new DefaultChannelTestFactory(), useDispatcher);
        }

        public PushChannelApplication(String name, ChannelTestFactory factory, boolean useDispatcher) throws Exception {
            super(name, factory);
            this.events = Collections.synchronizedList(new LinkedList());
            if (useDispatcher) {
                this.dispatcher = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
            } else {
                this.channel.setReceiver(this);
            }
        }

        @Override
        public List<Object> getEvents() {
            return this.events;
        }

        public RpcDispatcher getDispatcher() {
            return this.dispatcher;
        }

        public boolean hasDispatcher() {
            return this.dispatcher != null;
        }

        @Override
        public void block() {
            this.events.add(new BlockEvent());
            ChannelTestBase.this.log.debug("Channel " + this.getLocalAddress() + "[" + this.getName() + "] in blocking");
        }

        @Override
        public byte[] getState() {
            this.events.add(new GetStateEvent(null, null));
            ChannelTestBase.this.log.debug("Channel getState " + this.getLocalAddress() + "[" + this.getName() + "] ");
            return null;
        }

        @Override
        public void getState(OutputStream ostream) {
            this.events.add(new GetStateEvent(null, null));
            ChannelTestBase.this.log.debug("Channel getState " + this.getLocalAddress() + "[" + this.getName() + "]");
        }

        @Override
        public byte[] getState(String state_id) {
            this.events.add(new GetStateEvent(null, state_id));
            ChannelTestBase.this.log.debug("Channel getState " + this.getLocalAddress() + "[" + this.getName() + " state id =" + state_id);
            return null;
        }

        @Override
        public void getState(String state_id, OutputStream ostream) {
            this.events.add(new GetStateEvent(null, state_id));
            ChannelTestBase.this.log.debug("Channel getState " + this.getLocalAddress() + "[" + this.getName() + "] state id =" + state_id);
        }

        @Override
        public void receive(Message msg) {
        }

        @Override
        public void setState(byte[] state) {
            this.events.add(new SetStateEvent(null, null));
            ChannelTestBase.this.log.debug("Channel setState " + this.getLocalAddress() + "[" + this.getName() + "] ");
        }

        @Override
        public void setState(InputStream istream) {
            this.events.add(new SetStateEvent(null, null));
            ChannelTestBase.this.log.debug("Channel setState " + this.getLocalAddress() + "[" + this.getName() + "]");
        }

        @Override
        public void setState(String state_id, byte[] state) {
            this.events.add(new SetStateEvent(null, null));
            ChannelTestBase.this.log.debug("Channel setState " + this.getLocalAddress() + "[" + this.getName() + "] state id =" + state_id + ", state size is " + state.length);
        }

        @Override
        public void setState(String state_id, InputStream istream) {
            this.events.add(new SetStateEvent(null, null));
            ChannelTestBase.this.log.debug("Channel setState " + this.getLocalAddress() + "[" + this.getName() + "] state id " + state_id);
        }

        @Override
        public void suspect(Address suspected_mbr) {
            ChannelTestBase.this.log.debug("Channel " + this.getLocalAddress() + "[" + this.getName() + "] suspecting " + suspected_mbr);
        }

        @Override
        public void unblock() {
            this.events.add(new UnblockEvent());
            ChannelTestBase.this.log.debug("Channel " + this.getLocalAddress() + "[" + this.getName() + "] unblocking");
        }

        @Override
        public void viewAccepted(View new_view) {
            this.events.add(new_view);
            ChannelTestBase.this.log.info("Channel " + this.getLocalAddress() + "[" + this.getName() + "] accepted view " + new_view);
        }
    }

    protected abstract class ChannelApplication
    implements EventSequence,
    Runnable,
    ChannelRetrievable {
        protected Channel channel;
        protected Thread thread;
        protected Throwable exception;
        protected String name;

        public ChannelApplication(String name) throws Exception {
            ChannelTestBase.this.createChannel(name);
        }

        public ChannelApplication(String name, ChannelTestFactory factory) throws Exception {
            this.name = name;
            this.channel = factory.createChannel(name);
        }

        protected abstract void useChannel() throws Exception;

        public void run() {
            try {
                this.useChannel();
            }
            catch (Exception e) {
                ChannelTestBase.this.log.error(this.name + ": " + e.getLocalizedMessage(), e);
                this.exception = e;
            }
        }

        public Address getLocalAddress() {
            return this.channel.getLocalAddress();
        }

        public void start() {
            boolean connected;
            this.thread = new Thread((Runnable)this, this.getName());
            this.thread.start();
            Address a = this.getLocalAddress();
            boolean bl = connected = a != null;
            if (connected) {
                ChannelTestBase.this.log.info("Thread for channel " + a + "[" + this.getName() + "] started");
            } else {
                ChannelTestBase.this.log.info("Thread for channel [" + this.getName() + "] started");
            }
        }

        public void setChannel(Channel ch) {
            this.channel = ch;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public String getName() {
            return this.name;
        }

        public void cleanup() {
            Address a;
            boolean connected;
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
            boolean bl = connected = (a = this.getLocalAddress()) != null;
            if (connected) {
                ChannelTestBase.this.log.info("Closing channel " + a + "[" + this.getName() + "]");
            } else {
                ChannelTestBase.this.log.info("Closing channel [" + this.getName() + "]");
            }
            try {
                this.channel.close();
                ChannelTestBase.this.log.info("Closed channel " + a + "[" + this.getName() + "]");
            }
            catch (Throwable t) {
                ChannelTestBase.this.log.warn("Got exception while closing channel " + a + "[" + this.getName() + "]");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface EventSequence {
        public List<Object> getEvents();

        public String getName();
    }

    protected static interface ChannelTestFactory {
        public Channel createChannel(Object var1) throws Exception;
    }

    public class NextAvailableMuxChannelTestFactory
    implements ChannelTestFactory {
        public Channel createChannel(Object id) throws Exception {
            return ChannelTestBase.this.createChannel(id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultChannelTestFactory
    implements ChannelTestFactory {
        protected DefaultChannelTestFactory() {
        }

        protected JChannel createChannel(String configFile, boolean useBlocking) throws Exception {
            HashMap<Integer, Object> channelOptions = new HashMap<Integer, Object>();
            channelOptions.put(0, useBlocking);
            return this.createChannel(configFile, channelOptions);
        }

        protected JChannel createChannel(String configFile, Map<Integer, Object> channelOptions) throws Exception {
            JChannel ch = null;
            ChannelTestBase.this.log.info("Using configuration file " + configFile);
            ch = new JChannel(configFile);
            for (Map.Entry<Integer, Object> entry : channelOptions.entrySet()) {
                Integer key = entry.getKey();
                Object value = entry.getValue();
                ch.setOpt(key, value);
            }
            return ch;
        }

        @Override
        public Channel createChannel(Object id) throws Exception {
            return this.createChannel(CHANNEL_CONFIG, ChannelTestBase.this.useBlocking());
        }
    }
}

