/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class ConcurrentStartupTest
extends ChannelTestBase {
    private AtomicInteger mod = new AtomicInteger(1);

    public void setUp() throws Exception {
        super.setUp();
        this.mod.set(1);
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "flush-udp.xml");
    }

    public boolean useBlocking() {
        return true;
    }

    public void testConcurrentStartupState() {
        this.concurrentStartupHelper(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void concurrentStartupHelper(boolean useDispatcher) {
        String[] names = new String[]{"A", "B", "C", "D"};
        int count = names.length;
        ChannelTestBase.ChannelRetrievable[] channels = new ConcurrentStartupChannel[count];
        try {
            Semaphore semaphore = new Semaphore(count);
            semaphore.acquire(count);
            for (int i = 0; i < count; ++i) {
                channels[i] = new ConcurrentStartupChannel(names[i], semaphore, useDispatcher);
                ((ChannelTestBase.ChannelApplication)channels[i]).start();
                semaphore.release(1);
            }
            ConcurrentStartupTest.blockUntilViewsReceived(channels, 60000L);
            for (ChannelTestBase.ChannelRetrievable c : channels) {
                View view = ((ChannelTestBase.ChannelApplication)c).getChannel().getView();
                System.out.println("view = " + view);
            }
            Util.sleep(1000L);
            boolean acquired = semaphore.tryAcquire(count, 20L, TimeUnit.SECONDS);
            if (!acquired) {
                this.log.warn("Most likely a bug, analyse the stack below:");
                this.log.warn(Util.dumpThreads());
            }
            Util.sleep(1000L);
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                this.log.info(((ChannelTestBase.ChannelApplication)channel).getName() + "=" + ((ConcurrentStartupChannel)channel).getList());
            }
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                this.log.info(((ChannelTestBase.ChannelApplication)channel).getName() + "=" + ((ConcurrentStartupChannel)channel).getModifications());
            }
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                ConcurrentStartupTest.assertEquals((String)(((ChannelTestBase.ChannelApplication)channel).getName() + " should have " + count + " elements"), (int)count, (int)((ConcurrentStartupChannel)channel).getList().size());
            }
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                ConcurrentStartupTest.checkEventStateTransferSequence((ChannelTestBase.EventSequence)((Object)channel));
            }
        }
        catch (Exception ex) {
            this.log.warn("Exception encountered during test", ex);
            ConcurrentStartupTest.fail((String)ex.getLocalizedMessage());
        }
        finally {
            for (int i = count - 1; i >= 0; --i) {
                ((ChannelTestBase.ChannelApplication)channels[i]).cleanup();
                Util.sleep(250L);
            }
        }
    }

    protected int getMod() {
        return this.mod.incrementAndGet();
    }

    public static Test suite() {
        return new TestSuite(ConcurrentStartupTest.class);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ConcurrentStartupTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConcurrentStartupChannel
    extends ChannelTestBase.PushChannelApplicationWithSemaphore {
        private final List<Address> l;
        private final Map<Integer, Object> mods;

        public ConcurrentStartupChannel(String name, Semaphore semaphore, boolean useDispatcher) throws Exception {
            super(name, semaphore, useDispatcher);
            this.l = new LinkedList<Address>();
            this.mods = new TreeMap<Integer, Object>();
        }

        @Override
        public void useChannel() throws Exception {
            this.channel.connect("test", null, null, 25000L);
            LinkedList<Address> l = new LinkedList<Address>();
            l.add(this.channel.getLocalAddress());
            this.channel.send(null, null, l);
        }

        List<Address> getList() {
            return this.l;
        }

        Map<Integer, Object> getModifications() {
            return this.mods;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Message msg) {
            if (msg.getBuffer() == null) {
                return;
            }
            List obj = (List)msg.getObject();
            ConcurrentStartupTest.this.log.info("-- [#" + this.getName() + " (" + this.channel.getLocalAddress() + ")]: received " + obj);
            ConcurrentStartupChannel concurrentStartupChannel = this;
            synchronized (concurrentStartupChannel) {
                this.l.addAll(obj);
                Integer key = new Integer(ConcurrentStartupTest.this.getMod());
                this.mods.put(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void viewAccepted(View new_view) {
            super.viewAccepted(new_view);
            ConcurrentStartupChannel concurrentStartupChannel = this;
            synchronized (concurrentStartupChannel) {
                Integer key = new Integer(ConcurrentStartupTest.this.getMod());
                this.mods.put(key, new_view.getVid());
                if (new_view instanceof MergeView) {
                    MergeView mv = (MergeView)new_view;
                    Vector<View> subgroups = mv.getSubgroups();
                    boolean amISubgroupLeader = false;
                    for (View view : subgroups) {
                        Address subCoord = view.getMembers().firstElement();
                        amISubgroupLeader = this.getLocalAddress().equals(subCoord);
                        if (!amISubgroupLeader) continue;
                        for (View view2 : subgroups) {
                            if (this.getLocalAddress().equals(view2.getMembers().firstElement())) continue;
                            for (Address member : view2.getMembers()) {
                                Message m = new Message(member, null, (Serializable)((Object)this.l));
                                try {
                                    this.channel.send(m);
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setState(byte[] state) {
            super.setState(state);
            try {
                List tmp = (List)Util.objectFromByteBuffer(state);
                ConcurrentStartupChannel concurrentStartupChannel = this;
                synchronized (concurrentStartupChannel) {
                    this.l.clear();
                    this.l.addAll(tmp);
                    ConcurrentStartupTest.this.log.info("-- [#" + this.getName() + " (" + this.channel.getLocalAddress() + ")]: state is " + this.l);
                    Integer key = new Integer(ConcurrentStartupTest.this.getMod());
                    this.mods.put(key, tmp);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getState() {
            super.getState();
            LinkedList<Address> tmp = null;
            ConcurrentStartupChannel concurrentStartupChannel = this;
            synchronized (concurrentStartupChannel) {
                tmp = new LinkedList<Address>(this.l);
                try {
                    return Util.objectToByteBuffer(tmp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getState(OutputStream ostream) {
            super.getState(ostream);
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(ostream);
                LinkedList<Address> tmp = null;
                ConcurrentStartupChannel concurrentStartupChannel = this;
                synchronized (concurrentStartupChannel) {
                    tmp = new LinkedList<Address>(this.l);
                }
                oos.writeObject(tmp);
                oos.flush();
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Util.close(oos);
                    throw throwable;
                }
                Util.close(oos);
            }
            Util.close(oos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setState(InputStream istream) {
            super.setState(istream);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(istream);
                List tmp = (List)ois.readObject();
                ConcurrentStartupChannel concurrentStartupChannel = this;
                synchronized (concurrentStartupChannel) {
                    this.l.clear();
                    this.l.addAll(tmp);
                    ConcurrentStartupTest.this.log.info("-- [#" + this.getName() + " (" + this.channel.getLocalAddress() + ")]: state is " + this.l);
                    Integer key = new Integer(ConcurrentStartupTest.this.getMod());
                    this.mods.put(key, tmp);
                }
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Util.close(ois);
                    throw throwable;
                }
                Util.close(ois);
            }
            Util.close(ois);
        }
    }
}

