/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.ChannelException;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.util.ContextObjectInputStream;

public class MagicObjectInputStream
extends ContextObjectInputStream {
    static volatile ClassConfigurator conf = null;
    static final Log log = LogFactory.getLog(MagicObjectInputStream.class);

    public MagicObjectInputStream(InputStream is) throws IOException {
        super(is);
        if (conf == null) {
            try {
                conf = ClassConfigurator.getInstance(false);
            }
            catch (ChannelException e) {
                log.error("ClassConfigurator could not be instantiated", e);
            }
        }
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        short magic_num = super.readShort();
        if (conf == null || magic_num == -1) {
            return super.readClassDescriptor();
        }
        ObjectStreamClass retval = conf.getObjectStreamClassFromMagicNumber(magic_num);
        if (retval == null) {
            throw new ClassNotFoundException("failed fetching class descriptor for magic number " + magic_num);
        }
        return retval;
    }
}

