/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies;

import fr.dyade.aaa.agent.AgentId;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.objectweb.joram.mom.proxies.ProxyAgentItf;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.XACnxPrepare;
import org.objectweb.util.monolog.api.BasicLevel;

class ClientContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AgentId proxyId;
    private int id;
    private Vector tempDestinations;
    private Hashtable deliveringQueues;
    private Hashtable transactionsTable;
    private transient boolean started;
    private transient int cancelledRequestId;
    private transient Vector activeSubs;
    private transient Vector repliesBuffer;
    private transient Hashtable commitTable;
    private transient ProxyAgentItf proxy;

    ClientContext(AgentId proxyId, int id) {
        this.proxyId = proxyId;
        this.id = id;
        this.tempDestinations = new Vector();
        this.deliveringQueues = new Hashtable();
        this.started = false;
        this.cancelledRequestId = -1;
        this.activeSubs = new Vector();
        this.repliesBuffer = new Vector();
    }

    void setProxyAgent(ProxyAgentItf px) {
        this.proxy = px;
    }

    int getId() {
        return this.id;
    }

    void setActivated(boolean started) {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("ClientContext[" + this.proxyId + ',' + this.id + "].setActivated(" + started + ')'));
        }
        this.started = started;
    }

    boolean getActivated() {
        return this.started;
    }

    void addTemporaryDestination(AgentId destId) {
        this.tempDestinations.add(destId);
        this.proxy.setSave();
    }

    Enumeration getTempDestinations() {
        Vector tempDests = new Vector();
        Enumeration dests = this.tempDestinations.elements();
        while (dests.hasMoreElements()) {
            tempDests.addElement(dests.nextElement());
        }
        return tempDests.elements();
    }

    void removeTemporaryDestination(AgentId destId) {
        this.deliveringQueues.remove(destId);
        this.tempDestinations.remove(destId);
        this.proxy.setSave();
    }

    void addPendingDelivery(AbstractJmsReply reply) {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("ClientContext[" + this.proxyId + ',' + this.id + "].addPendingDelivery(" + reply + ')'));
        }
        this.repliesBuffer.add(reply);
    }

    Enumeration getPendingDeliveries() {
        return this.repliesBuffer.elements();
    }

    void clearPendingDeliveries() {
        this.repliesBuffer.clear();
    }

    void addSubName(String subName) {
        this.activeSubs.add(subName);
    }

    Enumeration getActiveSubs() {
        return this.activeSubs.elements();
    }

    void removeSubName(String subName) {
        this.activeSubs.remove(subName);
    }

    void cancelReceive(int cancelledRequestId) {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("ClientContext[" + this.proxyId + ':' + this.id + "].cancelReceive(" + cancelledRequestId + ')'));
        }
        this.cancelledRequestId = cancelledRequestId;
    }

    int getCancelledReceive() {
        return this.cancelledRequestId;
    }

    void addDeliveringQueue(AgentId queueId) {
        this.deliveringQueues.put(queueId, queueId);
        this.proxy.setSave();
    }

    Enumeration getDeliveringQueues() {
        return this.deliveringQueues.keys();
    }

    void addMultiReplyContext(int requestId, int asyncReplyCount) {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("ClientContext[" + this.proxyId + ':' + this.id + "].addMultiReplyContext(" + requestId + ',' + asyncReplyCount + ')'));
        }
        if (this.commitTable == null) {
            this.commitTable = new Hashtable();
        }
        this.commitTable.put(new Integer(requestId), new MultiReplyContext(asyncReplyCount));
        this.proxy.setSave();
    }

    int setReply(int requestId) {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("ClientContext[" + this.proxyId + ':' + this.id + "].setReply(" + requestId + ')'));
        }
        if (this.commitTable == null) {
            return 0;
        }
        Integer ctxKey = new Integer(requestId);
        MultiReplyContext ctx = (MultiReplyContext)this.commitTable.get(ctxKey);
        if (ctx == null) {
            return 0;
        }
        --ctx.counter;
        if (ctx.counter == 0) {
            this.commitTable.remove(ctxKey);
            this.proxy.setSave();
        }
        return ctx.counter;
    }

    void registerTxPrepare(Object key, XACnxPrepare prepare) throws Exception {
        if (this.transactionsTable == null) {
            this.transactionsTable = new Hashtable();
        }
        if (this.transactionsTable.containsKey(key)) {
            throw new Exception("Prepare request already received by TM for this transaction.");
        }
        this.transactionsTable.put(key, prepare);
        this.proxy.setSave();
    }

    XACnxPrepare getTxPrepare(Object key) {
        XACnxPrepare prepare = null;
        if (this.transactionsTable != null) {
            prepare = (XACnxPrepare)this.transactionsTable.remove(key);
            this.proxy.setSave();
        }
        return prepare;
    }

    public boolean isPrepared(Object key) {
        return this.transactionsTable.containsKey(key);
    }

    Enumeration getTxIds() {
        if (this.transactionsTable == null) {
            return new Hashtable().keys();
        }
        return this.transactionsTable.keys();
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.started = in.readBoolean();
        this.cancelledRequestId = in.readInt();
        this.activeSubs = (Vector)in.readObject();
        this.repliesBuffer = (Vector)in.readObject();
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.started);
        out.writeInt(this.cancelledRequestId);
        out.writeObject(this.activeSubs);
        out.writeObject(this.repliesBuffer);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("ClientContext (proxyId=");
        buff.append(this.proxyId);
        buff.append(",id=");
        buff.append(this.id);
        buff.append(",tempDestinations=");
        buff.append(this.tempDestinations);
        buff.append(",deliveringQueues=");
        buff.append(this.deliveringQueues);
        buff.append(",transactionsTable=");
        buff.append(this.transactionsTable);
        buff.append(",started=");
        buff.append(this.started);
        buff.append(",cancelledRequestId=");
        buff.append(this.cancelledRequestId);
        buff.append(",activeSubs=");
        buff.append(this.activeSubs);
        buff.append(",repliesBuffer=");
        buff.append(this.repliesBuffer);
        buff.append(')');
        return buff.toString();
    }

    static class MultiReplyContext {
        public int counter;

        MultiReplyContext(int c) {
            this.counter = c;
        }
    }
}

