/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.javaLog;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.objectweb.util.monolog.wrapper.common.AbstractFactory;

public class MonologFormatter
extends Formatter {
    public static final String WRAPPERS_PROPERTY = "monolog.wrappers";
    private static final int STACK_TRACE_ITEMS = 8;
    private static String[] LOGWRAPPER = new String[]{"org.objectweb.util.monolog.wrapper", "org.apache.commons.logging", "java.util.logging.Logger"};
    private static final int PATTERN_ID_LEVEL = -100;
    private static final int PATTERN_ID_TOPIC = -200;
    private static final int PATTERN_ID_DATE = -300;
    private static final int PATTERN_ID_THREAD = -400;
    private static final int PATTERN_ID_MESSAGE = -500;
    private static final int PATTERN_ID_METHOD = -600;
    private static final int PATTERN_ID_OBJECT = -700;
    private static final int PATTERN_ID_LINE_NUMBER = -800;
    private static final int PATTERN_ID_NEW_LINE = -900;
    private static final int PATTERN_ID_INTERVAL = 100;
    private static final String TOKENS = "{}ltdhmMOL%n";
    Calendar calendar;
    private static long previousTime;
    private static char[] previousTimeWithoutMillis;
    private static boolean debug;
    String strPattern;
    int[] pattern;
    String[] strings;
    SimpleFormatter simpleFormatter = new SimpleFormatter();

    private static final String patternIdToString(int id) {
        switch (id) {
            case -100: {
                return "l";
            }
            case -200: {
                return "t";
            }
            case -300: {
                return "d";
            }
            case -400: {
                return "h";
            }
            case -500: {
                return "m";
            }
            case -600: {
                return "M";
            }
            case -700: {
                return "O";
            }
            case -800: {
                return "L";
            }
            case -900: {
                return "n";
            }
        }
        return null;
    }

    public MonologFormatter() {
        this.calendar = Calendar.getInstance();
    }

    public MonologFormatter(String strPattern) {
        this();
        this.setPattern(strPattern);
    }

    public String getPattern() {
        return this.strPattern;
    }

    public void setPattern(String p) {
        if (debug) {
            AbstractFactory.debug("Pattern=" + p);
        }
        this.strPattern = p;
        if (this.strPattern == null) {
            this.pattern = new int[0];
        } else {
            StringTokenizer st = new StringTokenizer(p, TOKENS, true);
            ArrayList<Object> sections = new ArrayList<Object>();
            boolean isPrefix = false;
            boolean isObject = false;
            boolean isInSubObject = false;
            int subObjectNumber = 1;
            block14: while (st.hasMoreElements()) {
                String token2 = st.nextToken();
                if (debug) {
                    AbstractFactory.debug("token=<" + token2 + ">");
                }
                if (isObject && token2.equals("{")) {
                    isInSubObject = true;
                    isObject = false;
                }
                if (token2.length() == 1) {
                    char c = token2.charAt(0);
                    switch (c) {
                        case '{': {
                            if (isInSubObject) continue block14;
                            this.addSection(sections, token2);
                            break;
                        }
                        case '}': {
                            if (isInSubObject) {
                                int old = (Integer)sections.get(sections.size() - 1);
                                sections.set(sections.size() - 1, new Integer(old - subObjectNumber));
                                isInSubObject = false;
                                break;
                            }
                            this.addSection(sections, token2);
                            break;
                        }
                        case '%': {
                            if (isPrefix) {
                                sections.add(String.valueOf('%'));
                            }
                            isPrefix = !isPrefix;
                            break;
                        }
                        case 'l': {
                            isPrefix = this.treatPattern(sections, token2, -100, isPrefix);
                            break;
                        }
                        case 't': {
                            isPrefix = this.treatPattern(sections, token2, -200, isPrefix);
                            break;
                        }
                        case 'd': {
                            isPrefix = this.treatPattern(sections, token2, -300, isPrefix);
                            break;
                        }
                        case 'h': {
                            isPrefix = this.treatPattern(sections, token2, -400, isPrefix);
                            break;
                        }
                        case 'm': {
                            isPrefix = this.treatPattern(sections, token2, -500, isPrefix);
                            break;
                        }
                        case 'M': {
                            isPrefix = this.treatPattern(sections, token2, -600, isPrefix);
                            break;
                        }
                        case 'O': {
                            isPrefix = this.treatPattern(sections, token2, -700, isPrefix);
                            isObject = true;
                            break;
                        }
                        case 'L': {
                            isPrefix = this.treatPattern(sections, token2, -800, isPrefix);
                            break;
                        }
                        case 'n': {
                            isPrefix = this.treatPattern(sections, token2, -900, isPrefix);
                            break;
                        }
                        default: {
                            if (isInSubObject) {
                                subObjectNumber = Integer.parseInt(token2);
                                break;
                            }
                            this.addSection(sections, token2);
                            break;
                        }
                    }
                    continue;
                }
                if (isObject) continue;
                if (isInSubObject) {
                    subObjectNumber = Integer.parseInt(token2);
                    continue;
                }
                this.addSection(sections, token2);
            }
            this.pattern = new int[sections.size()];
            if (debug) {
                AbstractFactory.debug("building pattern array...");
                AbstractFactory.debug("nb of pattern:" + this.pattern.length);
            }
            ArrayList stringList = new ArrayList(sections.size());
            int cpt = 0;
            for (int i = 0; i < this.pattern.length; ++i) {
                Object o = sections.get(i);
                if (o instanceof String) {
                    if (debug) {
                        AbstractFactory.debug("add current pattern into strings: [" + cpt + ", " + o + "]");
                    }
                    stringList.add(o);
                    this.pattern[i] = cpt++;
                    continue;
                }
                if (!(o instanceof Integer)) continue;
                if (debug) {
                    AbstractFactory.debug("add current pattern as negative number:" + o);
                }
                this.pattern[i] = (Integer)o;
            }
            this.strings = stringList.toArray(new String[cpt]);
            if (debug) {
                AbstractFactory.debug("nb of string:" + this.strings.length);
            }
        }
    }

    private boolean treatPattern(List sections, String token2, int tokenId, boolean isPrefix) {
        if (debug) {
            AbstractFactory.debug("treatPttern(" + tokenId + "):" + " isPrefix=" + isPrefix + " token=" + token2 + " sections=" + sections);
        }
        if (isPrefix) {
            sections.add(new Integer(tokenId));
            return false;
        }
        this.addSection(sections, token2);
        return isPrefix;
    }

    private void addSection(List sections, String s) {
        int size = sections.size();
        if (size == 0) {
            if (debug) {
                AbstractFactory.debug("addSection(" + s + ", " + sections + "): first elem");
            }
            sections.add(s);
        } else {
            Object last = sections.get(size - 1);
            if (last instanceof String) {
                sections.set(size - 1, last + s);
                if (debug) {
                    AbstractFactory.debug("addSection(" + s + ", " + sections + "): concat: " + sections.get(size - 1));
                }
            } else {
                if (debug) {
                    AbstractFactory.debug("addSection(" + s + ", " + sections + "): new elem");
                }
                sections.add(s);
            }
        }
    }

    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        String[] ctx = null;
        block11: for (int i = 0; i < this.pattern.length; ++i) {
            int p = this.pattern[i];
            if (debug) {
                AbstractFactory.debug("format: pattern=" + p + "=" + MonologFormatter.patternIdToString(p));
            }
            switch (p) {
                case -100: {
                    sb.append(record.getLevel().getName());
                    continue block11;
                }
                case -200: {
                    sb.append(record.getLoggerName());
                    continue block11;
                }
                case -300: {
                    this.format(new Date(record.getMillis()), sb);
                    continue block11;
                }
                case -400: {
                    sb.append(Thread.currentThread().getName());
                    continue block11;
                }
                case -500: {
                    sb.append(this.simpleFormatter.formatMessage(record));
                    continue block11;
                }
                case -600: {
                    if (ctx == null) {
                        ctx = MonologFormatter.getContext();
                    }
                    sb.append(ctx[1]);
                    continue block11;
                }
                case -700: {
                    if (ctx == null) {
                        ctx = MonologFormatter.getContext();
                    }
                    sb.append(ctx[0]);
                    continue block11;
                }
                case -800: {
                    if (ctx == null) {
                        ctx = MonologFormatter.getContext();
                    }
                    sb.append(ctx[2]);
                    continue block11;
                }
                case -900: {
                    sb.append("\n");
                    continue block11;
                }
                default: {
                    if (p < 0) {
                        int idx;
                        if (ctx == null) {
                            ctx = MonologFormatter.getContext();
                        }
                        if (p <= -800 || p >= -700) continue block11;
                        String res = ctx[0];
                        if (p == 1) {
                            idx = res.lastIndexOf(46);
                            if (idx != -1) {
                                res = res.substring(idx + 1);
                            }
                        } else if (p != 0) {
                            idx = res.lastIndexOf(46);
                            for (p = -700 - p; p > 1 && idx != -1; --p) {
                                if (idx == -1) continue;
                                idx = res.lastIndexOf(46, idx - 1);
                            }
                            if (idx != -1) {
                                res = res.substring(idx + 1);
                            }
                        }
                        sb.append(res);
                        continue block11;
                    }
                    if (p >= this.strings.length) {
                        System.err.println("ERROR: String identifier unknown: " + p);
                        continue block11;
                    }
                    sb.append(this.strings[p]);
                }
            }
        }
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(sw));
            sb.append(sw.getBuffer());
        }
        return sb.toString();
    }

    public static String[] getContext() {
        Throwable t = new Throwable().fillInStackTrace();
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String m = sw.getBuffer().toString();
        int fin = 0;
        int deb = 0;
        for (int i = 0; i < 8; ++i) {
            deb = m.indexOf("\n", deb) + 1;
        }
        boolean isWrapper = true;
        deb = m.indexOf("at ", deb) + 3;
        while (isWrapper) {
            isWrapper = false;
            for (int i = 0; i < LOGWRAPPER.length && !isWrapper; isWrapper |= m.startsWith(LOGWRAPPER[i], deb), ++i) {
            }
            if (!isWrapper) continue;
            deb = m.indexOf("at ", deb) + 3;
        }
        fin = m.indexOf("\n", deb);
        m = m.substring(deb, fin);
        deb = m.indexOf("(");
        fin = m.indexOf(":");
        if (deb == -1) {
            AbstractFactory.warn("Bad stack trace. '(' and ':' expected in the string '" + m + "'. The full stack trace is the following:\n" + sw.getBuffer().toString());
            return new String[]{"", "", ""};
        }
        String[] res = new String[3];
        res[2] = fin == -1 ? "unknown" : m.substring(fin + 1, m.length() - 1);
        m = m.substring(0, deb);
        fin = m.lastIndexOf(46);
        res[0] = m.substring(0, fin);
        res[1] = m.substring(fin + 1);
        return res;
    }

    public void format(Date date, StringBuffer sbuf) {
        int millis;
        long now = date.getTime();
        if (now - (long)(millis = (int)(now % 1000L)) != previousTime) {
            this.calendar.setTime(date);
            int start = sbuf.length();
            int year = this.calendar.get(1);
            sbuf.append(year);
            sbuf.append('-');
            int month = this.calendar.get(2);
            if (++month < 10) {
                sbuf.append('0');
            }
            sbuf.append(month);
            sbuf.append('-');
            int day = this.calendar.get(5);
            if (day < 10) {
                sbuf.append('0');
            }
            sbuf.append(day);
            sbuf.append(' ');
            int hour = this.calendar.get(11);
            if (hour < 10) {
                sbuf.append('0');
            }
            sbuf.append(hour);
            sbuf.append(':');
            int mins = this.calendar.get(12);
            if (mins < 10) {
                sbuf.append('0');
            }
            sbuf.append(mins);
            sbuf.append(':');
            int secs = this.calendar.get(13);
            if (secs < 10) {
                sbuf.append('0');
            }
            sbuf.append(secs);
            sbuf.append(',');
            sbuf.getChars(start, sbuf.length(), previousTimeWithoutMillis, 0);
            previousTime = now - (long)millis;
        } else {
            sbuf.append(previousTimeWithoutMillis);
        }
        if (millis < 100) {
            sbuf.append('0');
        }
        if (millis < 10) {
            sbuf.append('0');
        }
        sbuf.append(millis);
    }

    public String format(String msg, String levelName, String topic, long time) {
        StringBuffer sb = new StringBuffer();
        String[] ctx = null;
        block11: for (int i = 0; i < this.pattern.length; ++i) {
            int p = this.pattern[i];
            if (debug) {
                AbstractFactory.debug("format: pattern=" + p + "=" + MonologFormatter.patternIdToString(p));
            }
            switch (p) {
                case -100: {
                    sb.append(levelName);
                    continue block11;
                }
                case -200: {
                    sb.append(topic);
                    continue block11;
                }
                case -300: {
                    this.format(new Date(time), sb);
                    continue block11;
                }
                case -400: {
                    sb.append(Thread.currentThread().getName());
                    continue block11;
                }
                case -500: {
                    sb.append(msg);
                    continue block11;
                }
                case -600: {
                    if (ctx == null) {
                        ctx = MonologFormatter.getContext();
                    }
                    sb.append(ctx[1]);
                    continue block11;
                }
                case -700: {
                    if (ctx == null) {
                        ctx = MonologFormatter.getContext();
                    }
                    sb.append(ctx[0]);
                    continue block11;
                }
                case -800: {
                    if (ctx == null) {
                        ctx = MonologFormatter.getContext();
                    }
                    sb.append(ctx[2]);
                    continue block11;
                }
                case -900: {
                    sb.append("\n");
                    continue block11;
                }
                default: {
                    if (p < 0) {
                        int idx;
                        if (ctx == null) {
                            ctx = MonologFormatter.getContext();
                        }
                        if (p <= -800 || p >= -700) continue block11;
                        String res = ctx[0];
                        if (p == 1) {
                            idx = res.lastIndexOf(46);
                            if (idx != -1) {
                                res = res.substring(idx + 1);
                            }
                        } else if (p != 0) {
                            idx = res.lastIndexOf(46);
                            for (p = -700 - p; p > 1 && idx != -1; --p) {
                                if (idx == -1) continue;
                                idx = res.lastIndexOf(46, idx - 1);
                            }
                            if (idx != -1) {
                                res = res.substring(idx + 1);
                            }
                        }
                        sb.append(res);
                        continue block11;
                    }
                    if (p >= this.strings.length) {
                        System.err.println("ERROR: String identifier unknown: " + p);
                        continue block11;
                    }
                    sb.append(this.strings[p]);
                }
            }
        }
        return sb.toString();
    }

    static {
        String wrap = System.getProperty(WRAPPERS_PROPERTY);
        if (wrap != null) {
            ArrayList<String> ws = new ArrayList<String>(5);
            StringTokenizer st = new StringTokenizer(wrap, ",;: /", false);
            while (st.hasMoreTokens()) {
                ws.add(st.nextToken());
            }
            String[] wsa = new String[LOGWRAPPER.length + ws.size()];
            System.arraycopy(LOGWRAPPER, 0, wsa, 0, LOGWRAPPER.length);
            for (int i = 0; i < ws.size(); ++i) {
                wsa[MonologFormatter.LOGWRAPPER.length + i] = (String)ws.get(i);
            }
            LOGWRAPPER = wsa;
        }
        previousTimeWithoutMillis = new char[20];
        debug = Boolean.getBoolean("monolog.pattern.debug");
    }
}

