/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.ha.interceptor.iiop;

import java.io.IOException;
import java.util.Stack;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.ow2.cmi.ha.RequestId;
import org.ow2.cmi.ha.interceptor.HAContext;
import org.ow2.cmi.ha.interceptor.HACurrent;
import org.ow2.cmi.ha.interceptor.iiop.HAInterceptor;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class HAServerInterceptor
extends HAInterceptor
implements ServerRequestInterceptor {
    private static final long serialVersionUID = 686400419582706917L;
    private String interceptorName = "HAServerInterceptor";
    private static Log logger = LogFactory.getLog(HAServerInterceptor.class);
    private HAContext receivedCtx;

    public String name() {
        return this.interceptorName;
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        try {
            ServiceContext serviceContext = ri.get_request_service_context(HA_CTX_ID);
            this.receivedCtx = this.unmarshallHAContext(serviceContext.context_data);
            logger.debug(this.receivedCtx.toString(), new Object[0]);
        }
        catch (BAD_PARAM e) {
        }
        catch (IOException e) {
            logger.error("Error while unmarshalling", e);
        }
        catch (ClassNotFoundException e) {
            logger.error("Error while unmarshalling", e);
        }
    }

    public void receive_request(ServerRequestInfo jri) throws ForwardRequest {
        if (this.receivedCtx != null) {
            HACurrent current = HACurrent.getHACurrent();
            Stack<RequestId> requests = this.receivedCtx.getRequests();
            current.setRequests(requests);
            boolean onFailover = this.receivedCtx.isOnFailover();
            current.setOnFailover(onFailover);
            logger.debug("HACtx associated to Thread", new Object[0]);
        }
    }

    public void send_reply(ServerRequestInfo jri) {
        this.putHAContext(jri);
    }

    public void destroy() {
    }

    public void send_exception(ServerRequestInfo jri) throws ForwardRequest {
        this.putHAContext(jri);
    }

    public void send_other(ServerRequestInfo jri) throws ForwardRequest {
        this.putHAContext(jri);
    }

    private void putHAContext(ServerRequestInfo serverRequestInfo) {
        HACurrent current = HACurrent.getHACurrent();
        HAContext haContext = new HAContext();
        Stack<RequestId> requests = current.getRequests();
        haContext.setRequests(requests);
        logger.debug("newHACtx: " + haContext, new Object[0]);
        try {
            ServiceContext serviceContext = new ServiceContext(HA_CTX_ID, this.marshallHAContext(haContext));
            serverRequestInfo.add_reply_service_context(serviceContext, true);
        }
        catch (IOException e) {
            logger.error("Error while marshalling " + haContext, e);
        }
    }
}

