/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.cluster.jgroups;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManager
implements ChannelListener,
InvocationHandler {
    private static Log logger = LogFactory.getLog(ConnectionManager.class);
    private volatile long timeout;
    private final Object handled;
    private final Class<?> itfHandled;
    private boolean connected = true;
    private Set<Method> alreadyHandledMethods = new HashSet<Method>();

    public ConnectionManager(long timeout, Object handled, Class<?> itfHandled) {
        this.timeout = timeout;
        this.handled = handled;
        this.itfHandled = itfHandled;
    }

    public ConnectionManager(long timeout, Object handled) {
        this.timeout = timeout;
        this.handled = handled;
        this.itfHandled = null;
    }

    @Override
    public synchronized void channelClosed(Channel arg0) {
        this.connected = false;
    }

    @Override
    public synchronized void channelConnected(Channel arg0) {
        this.connected = true;
        this.notifyAll();
    }

    @Override
    public synchronized void channelDisconnected(Channel arg0) {
        this.connected = false;
    }

    @Override
    public synchronized void channelReconnected(Address arg0) {
        this.connected = true;
        this.notifyAll();
    }

    @Override
    public void channelShunned() {
    }

    public Object getJgroupsObject() {
        return this.handled;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        if (this.handleThisMethod(method)) {
            long startTime = System.currentTimeMillis();
            while (!this.connected && System.currentTimeMillis() - startTime < this.timeout) {
                this.wait(this.timeout);
            }
            if (this.connected) {
                return method.invoke(this.handled, args);
            }
            logger.error("Reconnection timeout of '" + this.timeout + " ms' exceeded: unable to invoke " + method.getName() + " with args " + Arrays.asList(args), new Object[0]);
            throw new Exception("Reconnection timeout of '" + this.timeout + " ms' exceeded: unable to invoke " + method.getName() + " with args " + Arrays.asList(args));
        }
        try {
            ret = method.invoke(this.handled, args);
        }
        catch (IllegalAccessException e) {
            logger.error("Cannot invoke the method {0}", method.getName(), e);
        }
        catch (IllegalArgumentException e) {
            logger.error("Cannot invoke the method {0}", method.getName(), e);
        }
        catch (InvocationTargetException e) {
            logger.error("Cannot invoke the method {0}", method.getName(), e);
        }
        return ret;
    }

    private boolean handleThisMethod(Method method) {
        if (this.alreadyHandledMethods.contains(method)) {
            return true;
        }
        if (this.itfHandled == null) {
            return method.getDeclaringClass() != Object.class;
        }
        Method[] handledMethods = this.itfHandled.getDeclaredMethods();
        boolean found = true;
        for (Method handledMethod : handledMethods) {
            Class<?>[] expectedParamTypes;
            Class<?>[] paramTypes;
            if (method.equals(handledMethod)) {
                this.alreadyHandledMethods.add(method);
                return true;
            }
            if (!method.getName().equals(handledMethod.getName()) || (paramTypes = method.getParameterTypes()).length != (expectedParamTypes = handledMethod.getParameterTypes()).length) continue;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i].equals(expectedParamTypes[i])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            this.alreadyHandledMethods.add(method);
            return true;
        }
        return false;
    }
}

