/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.event.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.ow2.util.event.api.EventPriority;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventToken;

public class EventDispatcher
implements IEventDispatcher {
    private static final int DEFAULT_SIZE = 1;
    private final HashMap<EventPriority, CopyOnWriteArrayList<IEventListener>> listeners;
    private final EventQueue queue;
    private final EventToken kill = new EventToken();
    private AtomicBoolean available;
    private AtomicInteger size;

    public EventDispatcher() {
        this.queue = new EventQueue();
        this.available = new AtomicBoolean(false);
        this.size = new AtomicInteger(1);
        this.listeners = new HashMap();
        for (EventPriority priority : EventPriority.values()) {
            this.listeners.put(priority, new CopyOnWriteArrayList());
        }
    }

    public void start() {
        boolean old = this.available.getAndSet(true);
        if (!old) {
            this.createWorkers(this.size.get());
        }
    }

    public void stop() {
        boolean old = this.available.getAndSet(false);
        if (old) {
            this.destroyWorkers(this.size.get());
        }
    }

    public boolean isAvailable() {
        return this.available.get();
    }

    public int getNbWorkers() {
        return this.size.get();
    }

    public void setNbWorkers(int nbWorkers) {
        int diff = this.size.getAndSet(nbWorkers) - nbWorkers;
        if (this.available.get()) {
            if (diff > 0) {
                this.destroyWorkers(diff);
            } else {
                this.createWorkers(-diff);
            }
        }
    }

    public void addListener(IEventListener listener) {
        this.listeners.get((Object)listener.getPriority()).add(listener);
    }

    public void removeListener(IEventListener listener) {
        this.listeners.get((Object)listener.getPriority()).remove(listener);
    }

    public IEventToken dispatch(IEvent event) {
        return this.dispatch(event, EventPriority.NONE, Long.MAX_VALUE, 1);
    }

    public IEventToken dispatch(IEvent event, EventPriority priority) {
        return this.dispatch(event, priority, Long.MAX_VALUE, 1);
    }

    public IEventToken dispatch(IEvent event, long timeout) {
        return this.dispatch(event, EventPriority.NONE, timeout, 1);
    }

    public IEventToken dispatch(IEvent event, int nbWorker) {
        return this.dispatch(event, EventPriority.NONE, Long.MAX_VALUE, nbWorker);
    }

    public IEventToken dispatch(IEvent event, EventPriority priority, long timeout) {
        return this.dispatch(event, priority, timeout, 1);
    }

    public IEventToken dispatch(IEvent event, EventPriority priority, int nbWorker) {
        return this.dispatch(event, priority, Long.MAX_VALUE, nbWorker);
    }

    public IEventToken dispatch(IEvent event, long timeout, int nbWorker) {
        return this.dispatch(event, EventPriority.NONE, timeout, nbWorker);
    }

    public IEventToken dispatch(IEvent event, EventPriority priority, long timeout, int nbWorker) {
        if (!this.available.get()) {
            return null;
        }
        long end = System.currentTimeMillis() + timeout;
        if (end < 0L) {
            end = Long.MAX_VALUE;
        }
        EventToken token2 = new EventToken(event);
        for (int i = 0; i < nbWorker; ++i) {
            token2.allocate();
        }
        if (priority != null) {
            while (System.currentTimeMillis() < end) {
                try {
                    token2.join(priority, end - System.currentTimeMillis());
                    break;
                }
                catch (InterruptedException e) {
                }
            }
        }
        return token2;
    }

    private void createWorkers(int nb) {
        for (int i = 0; i < nb; ++i) {
            new EventWorker().start();
        }
    }

    private void destroyWorkers(int nb) {
        EventToken kill = this.kill;
        EventQueue queue = this.queue;
        for (int i = 0; i < nb; ++i) {
            queue.put(kill);
        }
    }

    private final class EventToken
    implements IEventToken {
        private IEvent event;
        private boolean killed = false;
        private Semaphore lock = new Semaphore(1, true);
        private LinkedList<EventWorker> workers = new LinkedList();
        private ConcurrentLinkedQueue<IEventListener> listeners = new ConcurrentLinkedQueue();
        private Map<EventPriority, Semaphore> semaphores = new HashMap<EventPriority, Semaphore>();
        private Map<EventPriority, AtomicInteger> counts = new HashMap<EventPriority, AtomicInteger>();

        private EventToken() {
        }

        private EventToken(IEvent event) {
            this.event = event;
            int permit = 1;
            for (EventPriority priority : EventPriority.values()) {
                int count = 0;
                this.semaphores.put(priority, new Semaphore(permit, true));
                for (IEventListener listener : (CopyOnWriteArrayList)EventDispatcher.this.listeners.get((Object)priority)) {
                    if (!event.checkPermission(listener) || !listener.accept(event)) continue;
                    this.listeners.add(listener);
                    permit = 0;
                    ++count;
                }
                this.counts.put(priority, new AtomicInteger(count));
            }
            this.semaphores.put(null, new Semaphore(permit, true));
            this.counts.put(null, new AtomicInteger(0));
        }

        public void terminate() {
            this.lock.acquireUninterruptibly();
            this.killed = true;
            for (EventWorker worker : this.workers) {
                worker.stop();
            }
            EventDispatcher.this.createWorkers(this.workers.size());
            this.lock.release();
        }

        public void allocate() {
            EventDispatcher.this.queue.put(this);
        }

        public boolean join(long timeout) throws InterruptedException {
            return this.join(EventPriority.values()[EventPriority.values().length - 1], timeout, false);
        }

        public boolean join(long timeout, boolean kill) throws InterruptedException {
            return this.join(EventPriority.values()[EventPriority.values().length - 1], timeout, kill);
        }

        public boolean join(EventPriority priority, long timeout) throws InterruptedException {
            return this.join(priority, timeout, false);
        }

        public boolean join(EventPriority priority, long timeout, boolean kill) throws InterruptedException {
            int nextOrdinal = priority.ordinal() + 1;
            EventPriority nextPriority = nextOrdinal < EventPriority.values().length ? EventPriority.values()[nextOrdinal] : null;
            Semaphore semaphore = this.semaphores.get((Object)nextPriority);
            boolean ok = semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            if (ok) {
                semaphore.release();
            } else if (kill) {
                this.terminate();
            }
            return ok;
        }
    }

    private final class EventWorker
    extends Thread {
        private EventWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EventQueue queue = EventDispatcher.this.queue;
            EventToken kill = EventDispatcher.this.kill;
            EventToken token2;
            while ((token2 = queue.take()) != kill) {
                token2.lock.acquireUninterruptibly();
                if (token2.killed) {
                    token2.lock.release();
                    continue;
                }
                token2.workers.add(this);
                token2.lock.release();
                IEventListener listener = (IEventListener)token2.listeners.poll();
                if (listener != null) {
                    EventPriority priority = listener.getPriority();
                    Semaphore semaphore = (Semaphore)token2.semaphores.get((Object)priority);
                    semaphore.acquireUninterruptibly();
                    semaphore.release();
                    try {
                        listener.handle(token2.event);
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        int count = ((AtomicInteger)token2.counts.get((Object)priority)).decrementAndGet();
                        while (count == 0 && priority != null) {
                            int nextOrdinal = priority.ordinal() + 1;
                            priority = nextOrdinal < EventPriority.values().length ? EventPriority.values()[nextOrdinal] : null;
                            semaphore = (Semaphore)token2.semaphores.get((Object)priority);
                            count = ((AtomicInteger)token2.counts.get((Object)priority)).get();
                            semaphore.release();
                        }
                        throw throwable;
                    }
                }
                token2.lock.acquireUninterruptibly();
                token2.workers.remove(this);
                token2.lock.release();
            }
            return;
        }
    }

    static final class EventQueue {
        private final SynchronousQueue<EventToken> synchronousQueue = new SynchronousQueue(true);
        private final ConcurrentLinkedQueue<EventToken> concurrentLinkedQueue = new ConcurrentLinkedQueue();

        EventQueue() {
        }

        public void put(EventToken token2) {
            if (!this.synchronousQueue.offer(token2)) {
                this.concurrentLinkedQueue.offer(token2);
            }
        }

        public EventToken take() {
            while (true) {
                try {
                    EventToken token2 = this.concurrentLinkedQueue.poll();
                    if (token2 != null) {
                        return token2;
                    }
                    return this.synchronousQueue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
    }
}

