/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.hierarchy;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import net.esper.client.Configuration;
import net.esper.client.EPException;
import net.esper.client.EPServiceProvider;
import net.esper.client.EPServiceProviderManager;
import net.esper.client.EPStatement;
import net.esper.client.UpdateListener;
import net.esper.event.EventBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.cmi.jndi.ClusteredObject;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextException;
import org.ow2.wildcat.ContextFactory;
import org.ow2.wildcat.ContextFactoryException;
import org.ow2.wildcat.Query;
import org.ow2.wildcat.event.WAttributeEvent;
import org.ow2.wildcat.event.WEvent;
import org.ow2.wildcat.hierarchy.MalformedPathException;
import org.ow2.wildcat.hierarchy.Path;
import org.ow2.wildcat.hierarchy.attribute.Attribute;
import org.ow2.wildcat.hierarchy.attribute.POJOAttribute;
import org.ow2.wildcat.hierarchy.attribute.RunnableAttribute;
import org.ow2.wildcat.hierarchy.resource.LocalResource;
import org.ow2.wildcat.hierarchy.resource.Resource;
import org.ow2.wildcat.hierarchy.resource.ResourceException;
import org.ow2.wildcat.hierarchy.resource.Symlink;
import org.ow2.wildcat.remote.RemoteContext;
import org.ow2.wildcat.remote.dispatcher.rmi.RMIDispatcher;
import org.ow2.wildcat.remote.dispatcher.rmi.RMIRemoteContext;
import org.ow2.wildcat.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicContext
implements Context,
ClusteredObject,
RMIRemoteContext {
    private static Log logger = LogFactory.getLog(BasicContext.class);
    private String name;
    private ContextFactory factory;
    private final Resource root;
    private final EPServiceProvider esperServiceProvider;
    private final Map<Query, EPStatement> queries;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final ScheduledThreadPoolExecutor runnableExecutor = new ScheduledThreadPoolExecutor(10);
    private final Map<String, Future<?>> tasks = new HashMap();
    private boolean exported;
    private Query forwarderQuery;
    private EventForwarder eventForwarder;
    private final Map<Path, AttributePoller> attributePollers;

    protected BasicContext(ContextFactory factory) {
        this.factory = factory;
        this.exported = false;
        this.attributePollers = new HashMap<Path, AttributePoller>();
        this.root = new LocalResource();
        this.root.mount(this, Path.ROOT);
        Configuration esperConfiguration = new Configuration();
        esperConfiguration.addEventTypeAlias("WEvent", "org.ow2.wildcat.event.WEvent");
        esperConfiguration.addEventTypeAlias("WHierarchyEvent", "org.ow2.wildcat.event.WHierarchyEvent");
        esperConfiguration.addEventTypeAlias("WAttributeEvent", "org.ow2.wildcat.event.WAttributeEvent");
        this.esperServiceProvider = EPServiceProviderManager.getProvider("wildcat", esperConfiguration);
        this.queries = new HashMap<Query, EPStatement>();
    }

    public BasicContext(ContextFactory factory, String name) {
        this(factory);
        logger.debug(Messages.message(BasicContext.class.getName() + ".create", name));
        this.name = name;
    }

    public BasicContext(String name) {
        this(null, name);
    }

    public BasicContext() {
        this("anonymous");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void attachAttribute(String attribute, Attribute a) throws ContextException {
        block6: {
            logger.debug(Messages.message(BasicContext.class.getName() + ".attachAttribute", attribute));
            Path attr = null;
            RemoteContext ctx = null;
            try {
                attr = new Path(attribute).canonicalize();
                attr.expectAbsolute();
                attr.expectAttribute();
                attr.expectFinite();
                ctx = this.resolve(attr.getHostname());
                if (ctx == this) {
                    RunnableAttribute runnableAttribute;
                    this.attachAttribute(attr, a);
                    if (a instanceof RunnableAttribute && (runnableAttribute = (RunnableAttribute)a).getDelay() >= 0L) {
                        this.addRunnable(this.name, runnableAttribute);
                    }
                    break block6;
                }
                try {
                    ctx.attachAttribute(attribute, a);
                }
                catch (RemoteException e) {
                    logger.error("Communication error.", e);
                    throw new ContextException("Communication error.", e);
                }
            }
            catch (MalformedPathException e) {
                logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
            }
        }
    }

    @Override
    public Attribute getAttribute(String attribute) throws ContextException {
        Path attr = null;
        RemoteContext ctx = null;
        try {
            attr = new Path(attribute).canonicalize();
            attr.expectAbsolute();
            attr.expectAttribute();
            attr.expectFinite();
            ctx = this.resolve(attr.getHostname());
            if (ctx == this) {
                return this.getAttribute(attr);
            }
            try {
                return ctx.getAttribute(attribute);
            }
            catch (RemoteException e) {
                logger.error("Communication error.", e);
                throw new ContextException("Communication error.", e);
            }
        }
        catch (MalformedPathException e) {
            logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
            return null;
        }
    }

    private Attribute getAttribute(Path attr) throws ContextException {
        try {
            return this.root.getAttribute(attr);
        }
        catch (ResourceException e) {
            logger.error("Unable to get an attribute at path " + attr, e);
            throw new ContextException("Unable to get an attribute at path " + attr, e);
        }
    }

    private void attachAttribute(Path attribute, Attribute a) throws ContextException {
        try {
            this.root.attachAttribute(attribute.getRelativePart(), a);
        }
        catch (ResourceException e) {
            logger.error("Unable to attach an attribute at path " + attribute, e);
            throw new ContextException("Unable to attach an attribute at path " + attribute, e);
        }
    }

    @Override
    public void createAttribute(String attribute, Object value) throws ContextException {
        block5: {
            logger.debug(Messages.message(BasicContext.class.getName() + ".createAttribute", attribute));
            Path attr = null;
            RemoteContext ctx = null;
            try {
                attr = new Path(attribute).canonicalize();
                attr.expectAbsolute();
                attr.expectAttribute();
                attr.expectFinite();
                ctx = this.resolve(attr.getHostname());
                if (ctx == this) {
                    this.createAttribute(attr, value);
                    break block5;
                }
                try {
                    ctx.createAttribute(attribute, value);
                }
                catch (RemoteException e) {
                    logger.error("Communication error.", e);
                    throw new ContextException("Communication error.", e);
                }
            }
            catch (MalformedPathException e) {
                logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
            }
        }
    }

    public void createAttribute(Path attribute, Object value) throws ContextException {
        try {
            this.root.createAttribute(attribute.getRelativePart(), value);
        }
        catch (ResourceException e) {
            logger.error("Unable to create an attribute at path " + attribute, e);
            throw new ContextException("Unable to create an attribute at path " + attribute, e);
        }
    }

    public Attribute createAttribute(Object value) {
        return new POJOAttribute(value);
    }

    @Override
    public void detachAttribute(String attribute) throws ContextException {
        block6: {
            Path res = null;
            try {
                res = new Path(attribute).canonicalize();
                res.expectAbsolute();
                res.expectAttribute();
                res.expectFinite();
                RemoteContext ctx = this.resolve(res.getHostname());
                if (ctx == this) {
                    Attribute att = this.getAttribute(res);
                    if (att instanceof RunnableAttribute) {
                        this.removeRunnable(attribute);
                    }
                    this.detachAttribute(res);
                    break block6;
                }
                try {
                    ctx.detachAttribute(attribute);
                }
                catch (RemoteException e) {
                    logger.error("Communication error.", e);
                    throw new ContextException("Communication error.", e);
                }
            }
            catch (MalformedPathException e) {
                logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
            }
        }
    }

    @Override
    public void attachResource(String resource, Resource res) throws ContextException {
        block5: {
            logger.debug(Messages.message(BasicContext.class.getName() + ".attachResource", resource));
            Path r = null;
            RemoteContext ctx = null;
            try {
                r = new Path(resource).canonicalize();
                r.expectAbsolute();
                r.expectResource();
                r.expectFinite();
                ctx = this.resolve(r.getHostname());
                if (ctx == this) {
                    this.attachResource(r, res);
                    break block5;
                }
                try {
                    ctx.attachResource(resource, res);
                }
                catch (RemoteException e) {
                    logger.error("Communication error.", e);
                    throw new ContextException("Communication error.", e);
                }
            }
            catch (MalformedPathException e) {
                logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
            }
        }
    }

    @Override
    public void createResource(String resource) throws ContextException {
        block5: {
            logger.debug(Messages.message(BasicContext.class.getName() + ".createResource", resource));
            Path res = null;
            try {
                res = new Path(resource).canonicalize();
                res.expectAbsolute();
                res.expectResource();
                res.expectFinite();
                RemoteContext ctx = this.resolve(res.getHostname());
                if (ctx == this) {
                    this.createResource(res);
                    break block5;
                }
                try {
                    ctx.createResource(resource);
                }
                catch (RemoteException e) {
                    logger.error("Communication error.", e);
                    throw new ContextException("Communication error.", e);
                }
            }
            catch (MalformedPathException e) {
                logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
            }
        }
    }

    @Override
    public Resource getResource(String resource) throws ContextException {
        Path res = null;
        try {
            res = new Path(resource).canonicalize();
            res.expectAbsolute();
            res.expectResource();
            res.expectFinite();
            RemoteContext ctx = this.resolve(res.getHostname());
            if (ctx == this) {
                return this.getResource(res);
            }
            try {
                return ctx.getResource(resource);
            }
            catch (RemoteException e) {
                logger.error("Communication error.", e);
                throw new ContextException("Communication error.", e);
            }
        }
        catch (MalformedPathException e) {
            logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
            return null;
        }
    }

    @Override
    public void detachResource(String resource) throws ContextException {
        block8: {
            Path r = null;
            RemoteContext ctx = null;
            try {
                r = new Path(resource).canonicalize();
                r.expectAbsolute();
                r.expectResource();
                r.expectFinite();
                ctx = this.resolve(r.getHostname());
                if (ctx == this) {
                    Resource symlink = this.getResource(r);
                    if (symlink != null && symlink instanceof Symlink) {
                        try {
                            this.factory.doNotListen(this, ((Symlink)symlink).getTarget().getHostname());
                        }
                        catch (ContextFactoryException e) {
                            logger.warn("Unable to not any more listen the context with name " + ((Symlink)symlink).getTarget().getHostname(), e);
                        }
                    }
                    this.detachResource(r);
                    break block8;
                }
                try {
                    ctx.detachResource(resource);
                }
                catch (RemoteException e) {
                    logger.error("Communication error.", e);
                    throw new ContextException("Communication error.", e);
                }
            }
            catch (MalformedPathException e) {
                logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
            }
        }
    }

    private void attachResource(Path resource, Resource res) throws ContextException {
        try {
            this.root.attachResource(resource.getRelativePart(), res);
        }
        catch (ResourceException e) {
            logger.error("Unable to attach a resource at path " + resource, e);
            throw new ContextException("Unable to attach a resource at path " + resource, e);
        }
    }

    private void detachResource(Path r) throws ContextException {
        try {
            this.root.detachResource(r.getRelativePart());
        }
        catch (ResourceException e) {
            logger.error("Unable to detach a resource at path " + r, e);
            throw new ContextException("Unable to detach a resource at path " + r, e);
        }
    }

    private void createResource(Path resource) throws ContextException {
        try {
            this.root.createResource(resource.getRelativePart());
        }
        catch (ResourceException e) {
            logger.error("Unable to create a resource at path " + resource, e);
            throw new ContextException("Unable to create a resource at path " + resource, e);
        }
    }

    @Override
    public void createSymlink(String link, String target) throws ContextException {
        block6: {
            logger.debug(Messages.message(BasicContext.class.getName() + ".createSymlink", link, target));
            Path l = null;
            Path t = null;
            RemoteContext ctx = null;
            try {
                l = new Path(link).canonicalize();
                t = new Path(target).canonicalize();
                l.expectAbsolute();
                l.expectResource();
                l.expectFinite();
                t.expectAbsolute();
                t.expectResource();
                t.expectFinite();
                ctx = this.resolve(l.getHostname());
                if (ctx == this) {
                    if (!this.isLocalHost(t.getHostname()) && this.factory != null && !this.factory.listen(this, t.getHostname())) {
                        logger.error("Unable to listen the context with name " + t.getHostname());
                        throw new ContextException("Unable to listen the context with name " + t.getHostname());
                    }
                    Symlink sl = new Symlink(t);
                    this.attachResource(l, (Resource)sl);
                    break block6;
                }
                try {
                    ctx.createSymlink(link, target);
                }
                catch (RemoteException e) {
                    logger.error("Communication error.", e);
                    throw new ContextException("Communication error.", e);
                }
            }
            catch (MalformedPathException e) {
                logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
            }
        }
    }

    @Override
    public Object getValue(String attribute) throws ContextException {
        logger.debug(Messages.message(BasicContext.class.getName() + ".pull", attribute));
        Path attr = null;
        RemoteContext ctx = null;
        try {
            attr = new Path(attribute).canonicalize();
            attr.expectAbsolute();
            attr.expectAttribute();
            attr.expectFinite();
            ctx = this.resolve(attr.getHostname());
            if (ctx == this) {
                return this.getValue(attr);
            }
            try {
                return ctx.getValue(attribute);
            }
            catch (RemoteException e) {
                logger.error("Communication error.", e);
                throw new ContextException("Communication error.", e);
            }
        }
        catch (MalformedPathException e) {
            logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
            return null;
        }
    }

    private Object getValue(Path attribute) throws ContextException {
        try {
            return this.root.getValue(attribute.getRelativePart());
        }
        catch (ResourceException e) {
            logger.error("Unable to get a value at path " + attribute, e);
            throw new ContextException("Unable to get a value at path " + attribute, e);
        }
    }

    @Override
    public Object setValue(String attribute, Object value) throws ContextException {
        logger.debug(Messages.message(BasicContext.class.getName() + ".set", attribute, value));
        Path attr = null;
        RemoteContext ctx = null;
        try {
            attr = new Path(attribute).canonicalize();
            attr.expectAbsolute();
            attr.expectAttribute();
            attr.expectFinite();
            ctx = this.resolve(attr.getHostname());
            if (ctx == this) {
                return this.setValue(attr, value);
            }
            try {
                return ctx.setValue(attribute, value);
            }
            catch (RemoteException e) {
                logger.error("Communication error.", e);
                throw new ContextException("Communication error.", e);
            }
        }
        catch (MalformedPathException e) {
            logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
            return null;
        }
    }

    private Object setValue(Path attribute, Object value) throws ContextException {
        try {
            return this.root.setValue(attribute.getRelativePart(), value);
        }
        catch (ResourceException e) {
            logger.error("Unable to set a value at path " + attribute, e);
            throw new ContextException("Unable to set a value at path " + attribute, e);
        }
    }

    @Override
    public Set<String> list(String resource) throws ContextException {
        logger.debug(Messages.message(BasicContext.class.getName() + ".list", new Object[0]));
        Path res = null;
        RemoteContext ctx = null;
        try {
            res = new Path(resource).canonicalize();
            res.expectAbsolute();
            res.expectResource();
            res.expectFinite();
            ctx = this.resolve(res.getHostname());
            if (ctx == this) {
                return this.list(res);
            }
            try {
                return ctx.list(resource);
            }
            catch (RemoteException e) {
                logger.error("Communication error.", e);
                throw new ContextException("Communication error.", e);
            }
        }
        catch (MalformedPathException e) {
            logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
            return null;
        }
    }

    private Set<String> list(Path resource) throws ContextException {
        try {
            return this.root.list(resource.getRelativePart());
        }
        catch (ResourceException e) {
            logger.error("Unable to list a resource at path " + resource, e);
            throw new ContextException("Unable to list a resource at path " + resource, e);
        }
    }

    private Resource getResource(Path res) throws ContextException {
        try {
            return this.root.getResource(res);
        }
        catch (ResourceException e) {
            logger.error("Unable to get a resource at path " + res, e);
            throw new ContextException("Unable to get a resource at path " + res, e);
        }
    }

    private void detachAttribute(Path path) throws ContextException {
        try {
            this.root.detachAttribute(path);
        }
        catch (ResourceException e) {
            logger.error("Unable to detach an attribute at path " + path, e);
            throw new ContextException("Unable to detach an attribute at path " + path, e);
        }
    }

    @Override
    public void emitEvent(WEvent ... events) {
        for (WEvent event : events) {
            this.esperServiceProvider.getEPRuntime().sendEvent(event);
        }
    }

    @Override
    public void createPeriodicAttributePoller(String attribute, long duration, TimeUnit unit) throws ContextException {
        block5: {
            logger.debug(Messages.message(BasicContext.class.getName() + ".periodicPoll", new Object[]{attribute, duration, unit}));
            Path attr = null;
            RemoteContext ctx = null;
            try {
                attr = new Path(attribute).canonicalize();
                attr.expectAbsolute();
                attr.expectAttribute();
                attr.expectFinite();
                ctx = this.resolve(attr.getHostname());
                if (ctx == this) {
                    this.createPeriodicAttributePoller(attr, duration, unit);
                    break block5;
                }
                try {
                    ctx.createPeriodicAttributePoller(attribute, duration, unit);
                }
                catch (RemoteException e) {
                    logger.error("Communication error.", e);
                    throw new ContextException("Communication error.", e);
                }
            }
            catch (MalformedPathException e) {
                logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
                return;
            }
        }
    }

    @Override
    public void removePeriodicAttributePoller(String attribute) throws ContextException {
        block5: {
            Path attr = null;
            RemoteContext ctx = null;
            try {
                attr = new Path(attribute).canonicalize();
                attr.expectAbsolute();
                attr.expectAttribute();
                attr.expectFinite();
                ctx = this.resolve(attr.getHostname());
                if (ctx == this) {
                    this.removePeriodicAttributePoller(attr);
                    break block5;
                }
                try {
                    ctx.removePeriodicAttributePoller(attribute);
                }
                catch (RemoteException e) {
                    logger.error("Communication error.", e);
                    throw new ContextException("Communication error.", e);
                }
            }
            catch (MalformedPathException e) {
                logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]), e);
                return;
            }
        }
    }

    private void createPeriodicAttributePoller(Path attribute, long duration, TimeUnit period) {
        AttributePoller attributePoller = new AttributePoller(this, attribute, duration, period);
        attributePoller.start();
        this.attributePollers.put(attribute, attributePoller);
    }

    private void removePeriodicAttributePoller(Path attr) {
        AttributePoller attributePoller = this.attributePollers.remove(attr);
        attributePoller.stop();
    }

    @Override
    public Query createQuery(String query) {
        logger.debug(Messages.message(BasicContext.class.getName() + ".createQuery", query));
        EPStatement statement = null;
        Query q = null;
        try {
            statement = this.esperServiceProvider.getEPAdministrator().createEQL(query);
            q = new Query(query);
            this.queries.put(q, statement);
        }
        catch (EPException e) {
            logger.warn(Messages.message(BasicContext.class.getName() + ".errorQuery", query), e);
            logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]));
        }
        return q;
    }

    @Override
    public void pauseQuery(Query query) {
        EPStatement statement = this.queries.get(query);
        if (statement != null) {
            statement.stop();
        }
    }

    @Override
    public void resumeQuery(Query query) {
        EPStatement statement = this.queries.get(query);
        if (statement != null) {
            statement.start();
        }
    }

    @Override
    public void destroyQuery(Query query) {
        logger.debug(Messages.message(BasicContext.class.getName() + ".destroyQuery", query));
        if (!this.queries.containsKey(query)) {
            logger.warn(Messages.message(BasicContext.class.getName() + ".noSuchQuery", query));
            logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]));
        } else {
            EPStatement statement = this.queries.remove(query);
            statement.destroy();
        }
    }

    @Override
    public Query registerListeners(String query, UpdateListener ... listeners) {
        logger.debug(Messages.message(BasicContext.class.getName() + ".createQuery", query));
        Query q = this.createQuery(query);
        if (q != null && listeners != null) {
            this.registerListeners(q, listeners);
        }
        return q;
    }

    @Override
    public void registerListeners(Query query, UpdateListener ... listeners) {
        logger.debug(Messages.message(BasicContext.class.getName() + ".registerListener", query));
        if (!this.queries.containsKey(query)) {
            logger.warn(Messages.message(BasicContext.class.getName() + ".noSuchQuery", query));
            logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]));
        } else {
            EPStatement statement = this.queries.get(query);
            if (listeners != null) {
                for (UpdateListener l : listeners) {
                    statement.addListener(l);
                }
            }
        }
    }

    @Override
    public void removeListeners(Query query, UpdateListener ... listeners) {
        logger.debug(Messages.message(BasicContext.class.getName() + ".removeListener", query, listeners));
        if (!this.queries.containsKey(query)) {
            logger.warn(Messages.message(BasicContext.class.getName() + ".noSuchQuery", query));
            logger.warn(Messages.message(BasicContext.class.getName() + ".ignore", new Object[0]));
        } else {
            EPStatement statement = this.queries.get(query);
            if (listeners != null) {
                for (UpdateListener l : listeners) {
                    statement.removeListener(l);
                }
            }
        }
    }

    private boolean isLocalHost(String hostname) {
        return hostname == null || "self".equals(hostname) || hostname.equals(this.name);
    }

    private RemoteContext resolve(String hostname) throws ContextException {
        try {
            return this.isLocalHost(hostname) ? this : this.factory.lookup(hostname);
        }
        catch (ContextFactoryException e) {
            logger.error("Unable to resolve the context with name " + this.name, e);
            throw new ContextException("Unable to resolve the context with name " + this.name, e);
        }
    }

    @Override
    public void export() throws ContextException {
        logger.debug(Messages.message(BasicContext.class.getName() + ".export", this.getName()));
        if (!this.exported) {
            if (this.factory == null) {
                this.factory = ContextFactory.getDefaultFactory();
            }
            try {
                this.factory.export(this);
            }
            catch (ContextFactoryException e) {
                logger.error("Unable to export the context with name " + this.name, e);
                throw new ContextException("Unable to export the context with name " + this.name, e);
            }
            this.eventForwarder = new EventForwarder(this);
            this.forwarderQuery = this.registerListeners("select * from WEvent", this.eventForwarder);
            this.exported = true;
        }
    }

    @Override
    public void unexport() throws ContextException {
        if (this.exported) {
            this.exported = false;
            if (this.factory == null) {
                this.factory = ContextFactory.getDefaultFactory();
            }
            try {
                this.factory.unexport(this);
            }
            catch (ContextFactoryException e) {
                logger.error("Unable to unexport the context with name " + this.name, e);
                throw new ContextException("Unable to unexport the context with name " + this.name, e);
            }
            this.removeListeners(this.forwarderQuery, this.eventForwarder);
        }
    }

    @Override
    public ClusteredObjectInfo getClusteredObjectInfo() {
        return new ClusteredObjectInfo(RMIRemoteContext.class, "wild_cluster");
    }

    @Override
    public TopicConnectionFactory getTopicConnectionFactoryToSpy() throws RemoteException, ContextException {
        try {
            return ((RMIDispatcher)this.factory.getDispatcher()).getRemoteTopicConnectionFactory();
        }
        catch (Exception e) {
            logger.error("Unable to get the topic connection factory of the context with name " + this.name, e);
            throw new ContextException("Unable to get the topic connection factory of the context with name " + this.name, e);
        }
    }

    @Override
    public Topic getTopicToSpy() throws RemoteException, ContextException {
        try {
            return ((RMIDispatcher)this.factory.getDispatcher()).getExportedTopic(this.name);
        }
        catch (Exception e) {
            logger.error("Unable to get the topic of the context with name " + this.name, e);
            throw new ContextException("Unable to get the topic of the context with name " + this.name, e);
        }
    }

    private void addRunnable(String name, RunnableAttribute runnableAttribute) {
        this.tasks.put(name, this.runnableExecutor.schedule(runnableAttribute, runnableAttribute.getDelay(), TimeUnit.MILLISECONDS));
    }

    private void removeRunnable(String name) {
        Future<?> task = this.tasks.get(name);
        if (!task.isDone() && !task.cancel(true)) {
            logger.warn("Cannot cancel the task for the RunnableAttribute with name " + name);
        } else {
            this.runnableExecutor.purge();
        }
    }

    @Override
    public void destroy() throws ContextException {
        this.unexport();
        this.esperServiceProvider.destroy();
    }

    @Override
    public boolean listen(String source) {
        return this.factory.listen(this, source);
    }

    private class EventForwarder
    implements UpdateListener {
        private BasicContext context;

        public EventForwarder(BasicContext context) {
            this.context = context;
        }

        public void update(EventBean[] arg0, EventBean[] arg1) {
            for (EventBean bean : arg0) {
                WEvent wevent = (WEvent)bean.getUnderlying();
                Path p = null;
                try {
                    p = new Path(wevent.getSource());
                    if (!this.context.isLocalHost(p.getHostname())) continue;
                    p.setHostName(this.context.getName());
                    WEvent evt = (WEvent)wevent.clone();
                    evt.setSource(p);
                    this.context.factory.notifyEvent(this.context, evt);
                }
                catch (Exception e) {
                    logger.warn("Unable to forward the event " + wevent, e);
                }
            }
        }
    }

    private class AttributePoller
    implements Runnable {
        BasicContext ctx;
        Path attribute;
        long period;
        TimeUnit unit;
        ScheduledFuture<?> future;

        private AttributePoller(BasicContext ctx, Path attribute, long period, TimeUnit unit) {
            this.ctx = ctx;
            this.attribute = attribute;
            this.period = period;
            this.unit = unit;
        }

        public void run() {
            try {
                Object value = this.ctx.getValue(this.attribute.toString());
                this.ctx.emitEvent(new WAttributeEvent(this.attribute, value));
            }
            catch (ContextException e) {
                logger.warn("Enable to emit a new event for the attribute at path " + this.attribute, e);
            }
        }

        public synchronized void start() {
            if (this.future == null) {
                this.future = this.ctx.scheduler.scheduleAtFixedRate(this, 0L, this.period, this.unit);
            }
        }

        public synchronized void stop() {
            if (this.future != null) {
                this.future.cancel(false);
                this.future = null;
            }
        }
    }
}

