/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.remote.provider;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.wildcat.ContextFactory;
import org.ow2.wildcat.remote.provider.JMSProvider;
import org.ow2.wildcat.remote.provider.JMSProviderException;

public final class JNDIProvider
implements JMSProvider {
    private static Log logger = LogFactory.getLog(JNDIProvider.class);
    private Context context = null;
    private final boolean local;
    private ContextFactory contextFactory;
    private final JMSProvider delegate;
    private final Set<String> boundDestinations = new HashSet<String>();

    public JNDIProvider(JMSProvider delegate, boolean local) {
        this.local = local;
        this.delegate = delegate;
    }

    public void init(ContextFactory contextFactory) throws JMSProviderException {
        this.contextFactory = contextFactory;
        Hashtable<String, String> env = new Hashtable<String, String>();
        String providerURL = contextFactory.getProperty("org.ow2.wildcat.remote.jms_provider_url");
        if (providerURL != null) {
            env.put("java.naming.provider.url", providerURL);
        }
        env.put("cmi.disabled", "true");
        try {
            this.context = new InitialContext(env);
        }
        catch (NamingException e) {
            logger.error("Cannot create an initial context", e);
            throw new JMSProviderException("Cannot create an initial context", e);
        }
    }

    public TopicConnectionFactory getTopicConnectionFactory() throws JMSProviderException {
        if (this.delegate != null && this.contextFactory.isEmbedded()) {
            return this.delegate.getTopicConnectionFactory();
        }
        return this.getRemoteTopicConnectionFactory();
    }

    public Topic getTopic(String topicName) throws JMSProviderException {
        Object topic;
        block5: {
            try {
                topic = this.context.lookup(topicName);
            }
            catch (NamingException ne) {
                if (this.delegate != null) {
                    logger.info("Cannot retrieve the topic with name {0}.\nTrying to create it with the delegate...", topicName);
                    logger.debug("Cause:", ne);
                    topic = this.delegate.getTopic(topicName);
                    if (!this.local) break block5;
                    try {
                        this.context.rebind(topicName, topic);
                    }
                    catch (NamingException e) {
                        logger.error("Cannot rebind the topic with name {0}", topicName, e);
                        throw new JMSProviderException("Cannot rebind the topic with name " + topicName, e);
                    }
                    this.boundDestinations.add(topicName);
                }
                logger.error("Cannot retrieve the topic with name {0}", topicName, ne);
                throw new JMSProviderException("Cannot retrieve the topic with name " + topicName, ne);
            }
        }
        return (Topic)topic;
    }

    public TopicConnectionFactory getRemoteTopicConnectionFactory() throws JMSProviderException {
        String topicConnectionFactoryName = this.contextFactory.getProperty("org.ow2.wildcat.remote.topic_connection_factory");
        try {
            return (TopicConnectionFactory)this.context.lookup(topicConnectionFactoryName);
        }
        catch (NamingException e) {
            logger.error("Cannot retrieve the topic connection factory with name {0}", topicConnectionFactoryName, e);
            throw new JMSProviderException("Cannot retrieve the topic connection factory with name " + topicConnectionFactoryName, e);
        }
    }

    public Queue getQueue(String queueName) throws JMSProviderException {
        Object queue;
        block5: {
            try {
                queue = this.context.lookup(queueName);
            }
            catch (NamingException ne) {
                if (this.delegate != null) {
                    logger.info("Cannot retrieve the queue with name {0}.\nTrying to create it with the delegate...", queueName);
                    logger.debug("Cause:", ne);
                    queue = this.delegate.getQueue(queueName);
                    if (!this.local) break block5;
                    try {
                        this.context.rebind(queueName, queue);
                    }
                    catch (NamingException e) {
                        logger.error("Cannot rebind the queue with name {0}", queueName, e);
                        throw new JMSProviderException("Cannot rebind the queue with name " + queueName, e);
                    }
                    this.boundDestinations.add(queueName);
                }
                logger.error("Cannot retrieve the queue with name {0}", queueName, ne);
                throw new JMSProviderException("Cannot queue the queue with name " + queueName, ne);
            }
        }
        return (Queue)queue;
    }

    public QueueConnectionFactory getQueueConnectionFactory() throws JMSProviderException {
        if (this.delegate != null && this.contextFactory.isEmbedded()) {
            return this.delegate.getQueueConnectionFactory();
        }
        return this.getRemoteQueueConnectionFactory();
    }

    public QueueConnectionFactory getRemoteQueueConnectionFactory() throws JMSProviderException {
        String queueConnectionFactoryName = this.contextFactory.getProperty("org.ow2.wildcat.remote.queue_connection_factory");
        try {
            return (QueueConnectionFactory)this.context.lookup(queueConnectionFactoryName);
        }
        catch (NamingException e) {
            logger.error("Cannot retrieve the queue connection factory with name {0}", queueConnectionFactoryName, e);
            throw new JMSProviderException("Cannot retrieve the queue connection factory with name " + queueConnectionFactoryName, e);
        }
    }

    public void deleteQueue(String queueName) throws JMSProviderException {
        if (this.boundDestinations.remove(queueName)) {
            try {
                this.context.unbind(queueName);
            }
            catch (NamingException e) {
                logger.warn("Cannot unbind the queue with name " + queueName, e);
            }
        }
        if (this.delegate != null) {
            this.delegate.deleteQueue(queueName);
        }
    }

    public void deleteTopic(String topicName) throws JMSProviderException {
        if (this.boundDestinations.remove(topicName)) {
            try {
                this.context.unbind(topicName);
            }
            catch (NamingException e) {
                logger.warn("Cannot unbind the topic with name " + topicName, e);
            }
        }
        if (this.delegate != null) {
            this.delegate.deleteTopic(topicName);
        }
    }

    public void destroy() throws JMSProviderException {
        for (String destName : this.boundDestinations) {
            try {
                this.context.unbind(destName);
            }
            catch (NamingException e) {
                logger.warn("Cannot unbind the destination with name " + destName, e);
            }
        }
        this.boundDestinations.clear();
        try {
            this.context.close();
        }
        catch (NamingException e) {
            logger.warn("Cannot close the context", e);
        }
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }
}

