/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Messages {
    private static Log logger = LogFactory.getLog(Messages.class);
    private static Messages WILDCAT;
    private Properties properties = new Properties();

    public static void init(String resource) {
        if (WILDCAT == null) {
            WILDCAT = new Messages(resource);
        }
    }

    private Messages(String resource) {
        try {
            this.properties.load(this.getClass().getResourceAsStream(resource));
        }
        catch (IOException e) {
            logger.warn("Could not fetch messages file '" + resource + "'");
            this.properties = null;
        }
    }

    private static String getMessage(String key) {
        if (WILDCAT == null || Messages.WILDCAT.properties == null) {
            return "! " + key + " !";
        }
        return Messages.WILDCAT.properties.getProperty(key, "! " + key + " !");
    }

    public static String message(String key, Object ... args) {
        return MessageFormat.format(Messages.getMessage(key), args);
    }
}

