/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.adapter;

import com.espertech.esper.adapter.AdapterState;
import com.espertech.esper.adapter.IllegalStateTransitionException;

public class AdapterStateManager {
    private AdapterState state = AdapterState.OPENED;
    private boolean stateTransitionsAllowed = true;

    public AdapterState getState() {
        return this.state;
    }

    public void start() throws IllegalStateTransitionException {
        this.assertStateTransitionsAllowed();
        if (this.state != AdapterState.OPENED) {
            throw new IllegalStateTransitionException("Cannot start from the " + (Object)((Object)this.state) + " state");
        }
        this.state = AdapterState.STARTED;
    }

    public void stop() throws IllegalStateTransitionException {
        this.assertStateTransitionsAllowed();
        if (this.state != AdapterState.STARTED && this.state != AdapterState.PAUSED) {
            throw new IllegalStateTransitionException("Cannot stop from the " + (Object)((Object)this.state) + " state");
        }
        this.state = AdapterState.OPENED;
    }

    public void pause() throws IllegalStateTransitionException {
        this.assertStateTransitionsAllowed();
        if (this.state != AdapterState.STARTED) {
            throw new IllegalStateTransitionException("Cannot pause from the " + (Object)((Object)this.state) + " state");
        }
        this.state = AdapterState.PAUSED;
    }

    public void resume() throws IllegalStateTransitionException {
        this.assertStateTransitionsAllowed();
        if (this.state != AdapterState.PAUSED) {
            throw new IllegalStateTransitionException("Cannot resume from the " + (Object)((Object)this.state) + " state");
        }
        this.state = AdapterState.STARTED;
    }

    public void destroy() throws IllegalStateTransitionException {
        if (this.state == AdapterState.DESTROYED) {
            throw new IllegalStateTransitionException("Cannot destroy from the " + (Object)((Object)this.state) + " state");
        }
        this.state = AdapterState.DESTROYED;
    }

    public void disallowStateTransitions() {
        this.stateTransitionsAllowed = false;
    }

    private void assertStateTransitionsAllowed() {
        if (!this.stateTransitionsAllowed) {
            throw new IllegalStateTransitionException("State transitions have been disallowed");
        }
    }
}

