/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPPreparedStatement;
import com.espertech.esper.client.soda.EPStatementObjectModel;
import com.espertech.esper.epl.spec.SubstitutionParameterExpression;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPPreparedStatementImpl
implements EPPreparedStatement {
    private EPStatementObjectModel model;
    private Map<Integer, SubstitutionParameterExpression> subParams;

    public EPPreparedStatementImpl(EPStatementObjectModel model, Map<Integer, SubstitutionParameterExpression> subParams) {
        this.model = model;
        this.subParams = subParams;
    }

    @Override
    public void setObject(int parameterIndex, Object value) throws EPException {
        if (parameterIndex < 1) {
            throw new IllegalArgumentException("Substitution parameter index starts at 1");
        }
        if (this.subParams.size() == 0) {
            throw new IllegalArgumentException("Statement does not have substitution parameters indicated by the '?' character");
        }
        if (parameterIndex > this.subParams.size()) {
            throw new IllegalArgumentException("Invalid substitution parameter index of " + parameterIndex + " supplied, the maximum for this statement is " + this.subParams.size());
        }
        SubstitutionParameterExpression subs = this.subParams.get(parameterIndex);
        subs.setConstant(value);
    }

    public EPStatementObjectModel getModel() {
        return this.model;
    }

    public Map<Integer, SubstitutionParameterExpression> getSubParams() {
        return this.subParams;
    }
}

