/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.annotation;

import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.epl.annotation.AnnotationException;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HintEnum {
    ITERATE_ONLY("ITERATE_ONLY", false, false),
    DISABLE_RECLAIM_GROUP("DISABLE_RECLAIM_GROUP", false, false),
    RECLAIM_GROUP_AGED("RECLAIM_GROUP_AGED", true, true),
    RECLAIM_GROUP_FREQ("RECLAIM_GROUP_FREQ", true, true);

    private final String value;
    private final boolean acceptsParameters;
    private final boolean requiresParameters;

    private HintEnum(String value, boolean acceptsParameters, boolean requiresParameters) {
        this.value = value.toUpperCase();
        this.acceptsParameters = acceptsParameters;
        this.requiresParameters = acceptsParameters ? true : requiresParameters;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isAcceptsParameters() {
        return this.acceptsParameters;
    }

    public boolean isRequiresParameters() {
        return this.requiresParameters;
    }

    public Hint getHint(Annotation[] annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            String[] hints;
            String hintName;
            Hint hintAnnotation;
            String hintVal;
            if (!(annotation instanceof Hint) || (hintVal = (hintAnnotation = (Hint)annotation).value()) == null) continue;
            if ((hintVal = hintVal.trim().toUpperCase()).equals(this.value)) {
                return hintAnnotation;
            }
            if (hintVal.indexOf(61) != -1 && (hintName = hintVal.substring(0, hintVal.indexOf(61))).trim().toUpperCase().equals(this.value)) {
                return hintAnnotation;
            }
            for (String hint : hints = hintVal.split(",")) {
                String hintName2;
                hintVal = hint.trim().toUpperCase();
                if (hintVal.equals(this.value)) {
                    return hintAnnotation;
                }
                if (hintVal.indexOf(61) == -1 || !(hintName2 = hintVal.substring(0, hintVal.indexOf(61))).trim().toUpperCase().equals(this.value)) continue;
                return hintAnnotation;
            }
        }
        return null;
    }

    public String getHintAssignedValue(Hint hintAnnotation) {
        String[] hints;
        if (!this.acceptsParameters) {
            return null;
        }
        String hintValMixed = hintAnnotation.value().trim();
        String hintVal = hintValMixed.toUpperCase();
        if (hintVal.indexOf(",") == -1) {
            if (hintVal.indexOf(61) == -1) {
                return null;
            }
            String hintName = hintVal.substring(0, hintVal.indexOf(61));
            if (!hintName.equals(this.value)) {
                return null;
            }
            return hintValMixed.substring(hintVal.indexOf(61) + 1, hintVal.length());
        }
        for (String hint : hints = hintValMixed.split(",")) {
            int indexOfEquals = hint.indexOf(61);
            if (indexOfEquals == -1 || !(hintVal = hint.substring(0, indexOfEquals).trim().toUpperCase()).equals(this.value)) continue;
            String value = hint.substring(indexOfEquals + 1).trim();
            if (value.length() == 0) {
                return null;
            }
            return value;
        }
        return null;
    }

    public static void validate(Annotation annotation) throws AnnotationException {
        if (!(annotation instanceof Hint)) {
            return;
        }
        Hint hint = (Hint)annotation;
        for (HintEnum val : HintEnum.values()) {
            if (!val.getValue().equals(hint.value().trim().toUpperCase())) continue;
            HintEnum.validateParameters(val, hint.value().trim());
            return;
        }
        String[] hints = hint.value().split(",");
        for (int i = 0; i < hints.length; ++i) {
            String hintVal = hints[i].trim().toUpperCase();
            HintEnum found = null;
            for (HintEnum val : HintEnum.values()) {
                if (val.getValue().equals(hintVal)) {
                    found = val;
                    break;
                }
                if (hintVal.indexOf(61) == -1) continue;
                String hintName = hintVal.substring(0, hintVal.indexOf(61));
                if (!val.getValue().equals(hintName.trim().toUpperCase())) continue;
                found = val;
                break;
            }
            if (found == null) {
                String hintName = hints[i].trim();
                if (hintName.indexOf(61) != -1) {
                    hintName = hintName.substring(0, hintName.indexOf(61));
                }
                throw new AnnotationException("Hint annotation value '" + hintName.trim() + "' is not one of the known values");
            }
            HintEnum.validateParameters(found, hintVal);
        }
    }

    private static void validateParameters(HintEnum val, String hintVal) throws AnnotationException {
        if (val.isRequiresParameters() && hintVal.indexOf(61) == -1) {
            throw new AnnotationException("Hint '" + (Object)((Object)val) + "' requires a parameter value");
        }
        if (!val.isAcceptsParameters() && hintVal.indexOf(61) != -1) {
            throw new AnnotationException("Hint '" + (Object)((Object)val) + "' does not accept a parameter value");
        }
    }
}

