/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.EPStatementObjectModel;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class SubqueryInExpression
extends ExpressionBase {
    private boolean notIn;
    private EPStatementObjectModel model;
    private static final long serialVersionUID = 8013096666658967181L;

    public SubqueryInExpression() {
    }

    public SubqueryInExpression(EPStatementObjectModel model, boolean isNotIn) {
        this.model = model;
        this.notIn = isNotIn;
    }

    public SubqueryInExpression(Expression expression, EPStatementObjectModel model, boolean isNotIn) {
        this.getChildren().add(expression);
        this.model = model;
        this.notIn = isNotIn;
    }

    public boolean isNotIn() {
        return this.notIn;
    }

    public void setNotIn(boolean notIn) {
        this.notIn = notIn;
    }

    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildren().get(0).toEPL(writer, this.getPrecedence());
        if (this.notIn) {
            writer.write(" not in (");
        } else {
            writer.write(" in (");
        }
        writer.write(this.model.toEPL());
        writer.write(41);
    }

    public EPStatementObjectModel getModel() {
        return this.model;
    }

    public void setModel(EPStatementObjectModel model) {
        this.model = model;
    }
}

