/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.collection;

import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.util.ManagedLock;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeIteratorImpl<E>
implements SafeIterator<E> {
    private final ManagedLock iteratorLock;
    private final Iterator<E> underlying;
    private boolean lockTaken;

    public SafeIteratorImpl(ManagedLock iteratorLock, Iterator<E> underlying) {
        this.iteratorLock = iteratorLock;
        this.underlying = underlying;
        this.lockTaken = true;
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public E next() {
        return this.underlying.next();
    }

    @Override
    public void close() {
        if (this.lockTaken) {
            this.iteratorLock.releaseLock(null);
            this.lockTaken = false;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operation not supported");
    }
}

