/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.ConfigurationOperations;
import com.espertech.esper.client.ConfigurationRevisionEventType;
import com.espertech.esper.client.ConfigurationVariantStream;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementEventTypeRef;
import com.espertech.esper.core.StatementVariableRef;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.EngineSettingsService;
import com.espertech.esper.epl.metric.MetricReportingService;
import com.espertech.esper.epl.variable.VariableExistsException;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.epl.variable.VariableTypeException;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.event.vaevent.ValueAddEventService;
import com.espertech.esper.event.vaevent.VariantEventType;
import com.espertech.esper.event.xml.SchemaModel;
import com.espertech.esper.event.xml.XSDSchemaMapper;
import com.espertech.esper.util.JavaClassHelper;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationOperationsImpl
implements ConfigurationOperations {
    private final EventAdapterService eventAdapterService;
    private final EngineImportService engineImportService;
    private final VariableService variableService;
    private final EngineSettingsService engineSettingsService;
    private final ValueAddEventService valueAddEventService;
    private final MetricReportingService metricReportingService;
    private final StatementEventTypeRef statementEventTypeRef;
    private final StatementVariableRef statementVariableRef;

    public ConfigurationOperationsImpl(EventAdapterService eventAdapterService, EngineImportService engineImportService, VariableService variableService, EngineSettingsService engineSettingsService, ValueAddEventService valueAddEventService, MetricReportingService metricReportingService, StatementEventTypeRef statementEventTypeRef, StatementVariableRef statementVariableRef) {
        this.eventAdapterService = eventAdapterService;
        this.engineImportService = engineImportService;
        this.variableService = variableService;
        this.engineSettingsService = engineSettingsService;
        this.valueAddEventService = valueAddEventService;
        this.metricReportingService = metricReportingService;
        this.statementEventTypeRef = statementEventTypeRef;
        this.statementVariableRef = statementVariableRef;
    }

    @Override
    public void addEventTypeAutoName(String javaPackageName) {
        this.eventAdapterService.addAutoNamePackage(javaPackageName);
    }

    @Override
    public void addPlugInAggregationFunction(String functionName, String aggregationClassName) {
        try {
            this.engineImportService.addAggregation(functionName, aggregationClassName);
        }
        catch (EngineImportException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public void addImport(String importName) {
        try {
            this.engineImportService.addImport(importName);
        }
        catch (EngineImportException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public void addImport(Class importClass) {
        this.addImport(importClass.getName());
    }

    @Override
    public boolean isEventTypeExists(String eventTypeName) {
        return this.eventAdapterService.getExistsTypeByName(eventTypeName) != null;
    }

    @Override
    public void addEventType(String eventTypeName, String javaEventClassName) {
        try {
            this.eventAdapterService.addBeanType(eventTypeName, javaEventClassName, false);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(String eventTypeName, Class javaEventClass) {
        try {
            this.eventAdapterService.addBeanType(eventTypeName, javaEventClass, true);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(Class javaEventClass) {
        try {
            this.eventAdapterService.addBeanType(javaEventClass.getSimpleName(), javaEventClass, true);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(String eventTypeName, Properties typeMap) {
        Map<String, Object> types = ConfigurationOperationsImpl.createPropertyTypes(typeMap);
        try {
            this.eventAdapterService.addNestableMapType(eventTypeName, types, null, true, false, false);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(String eventTypeName, Map<String, Object> typeMap) {
        try {
            this.eventAdapterService.addNestableMapType(eventTypeName, typeMap, null, true, false, false);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(String eventTypeName, Map<String, Object> typeMap, String[] superTypes) throws ConfigurationException {
        HashSet<String> superTypeNames = null;
        if (superTypes != null && superTypes.length > 0) {
            superTypeNames = new HashSet<String>(Arrays.asList(superTypes));
        }
        try {
            this.eventAdapterService.addNestableMapType(eventTypeName, typeMap, superTypeNames, true, false, false);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    @Override
    public void addEventType(String eventTypeName, ConfigurationEventTypeXMLDOM xmlDOMEventTypeDesc) {
        SchemaModel schemaModel = null;
        if (xmlDOMEventTypeDesc.getSchemaResource() != null) {
            try {
                schemaModel = XSDSchemaMapper.loadAndMap(xmlDOMEventTypeDesc.getSchemaResource(), 2);
            }
            catch (Exception ex) {
                throw new ConfigurationException(ex.getMessage(), ex);
            }
        }
        try {
            this.eventAdapterService.addXMLDOMType(eventTypeName, xmlDOMEventTypeDesc, schemaModel);
        }
        catch (EventAdapterException t) {
            throw new ConfigurationException(t.getMessage(), t);
        }
    }

    private static Map<String, Object> createPropertyTypes(Properties properties) {
        HashMap<String, Object> propertyTypes = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Class<?> clazz;
            String className = (String)entry.getValue();
            if ("string".equals(className)) {
                className = String.class.getName();
            }
            String boxedClassName = JavaClassHelper.getBoxedClassName(className);
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                clazz = Class.forName(boxedClassName, true, cl);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("Unable to load class '" + boxedClassName + "', class not found", ex);
            }
            propertyTypes.put((String)entry.getKey(), clazz);
        }
        return propertyTypes;
    }

    @Override
    public void addVariable(String variableName, Class type, Object initializationValue) throws ConfigurationException {
        try {
            this.variableService.createNewVariable(variableName, type.getName(), initializationValue, null);
            this.statementVariableRef.addConfiguredVariable(variableName);
        }
        catch (VariableExistsException e) {
            throw new ConfigurationException("Error creating variable: " + e.getMessage(), e);
        }
        catch (VariableTypeException e) {
            throw new ConfigurationException("Error creating variable: " + e.getMessage(), e);
        }
    }

    @Override
    public void addVariable(String variableName, String eventTypeName, Object initializationValue) throws ConfigurationException {
        try {
            this.variableService.createNewVariable(variableName, eventTypeName, initializationValue, null);
            this.statementVariableRef.addConfiguredVariable(variableName);
        }
        catch (VariableExistsException e) {
            throw new ConfigurationException("Error creating variable: " + e.getMessage(), e);
        }
        catch (VariableTypeException e) {
            throw new ConfigurationException("Error creating variable: " + e.getMessage(), e);
        }
    }

    @Override
    public void addPlugInEventType(String eventTypeName, URI[] resolutionURIs, Serializable initializer) {
        try {
            this.eventAdapterService.addPlugInEventType(eventTypeName, resolutionURIs, initializer);
        }
        catch (EventAdapterException e) {
            throw new ConfigurationException("Error adding plug-in event type: " + e.getMessage(), e);
        }
    }

    @Override
    public void setPlugInEventTypeResolutionURIs(URI[] urisToResolveName) {
        this.engineSettingsService.setPlugInEventTypeResolutionURIs(urisToResolveName);
    }

    @Override
    public void addRevisionEventType(String revisioneventTypeName, ConfigurationRevisionEventType revisionEventTypeConfig) {
        this.valueAddEventService.addRevisionEventType(revisioneventTypeName, revisionEventTypeConfig, this.eventAdapterService);
    }

    @Override
    public void addVariantStream(String varianteventTypeName, ConfigurationVariantStream variantStreamConfig) {
        this.valueAddEventService.addVariantStream(varianteventTypeName, variantStreamConfig, this.eventAdapterService);
    }

    @Override
    public void updateMapEventType(String mapeventTypeName, Map<String, Object> typeMap) throws ConfigurationException {
        try {
            this.eventAdapterService.updateMapEventType(mapeventTypeName, typeMap);
        }
        catch (EventAdapterException e) {
            throw new ConfigurationException("Error updating Map event type: " + e.getMessage(), e);
        }
    }

    @Override
    public void setMetricsReportingInterval(String stmtGroupName, long newInterval) {
        try {
            this.metricReportingService.setMetricsReportingInterval(stmtGroupName, newInterval);
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Error updating interval for metric reporting: " + e.getMessage(), e);
        }
    }

    @Override
    public void setMetricsReportingStmtEnabled(String statementName) {
        try {
            this.metricReportingService.setMetricsReportingStmtEnabled(statementName);
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Error enabling metric reporting for statement: " + e.getMessage(), e);
        }
    }

    @Override
    public void setMetricsReportingStmtDisabled(String statementName) {
        try {
            this.metricReportingService.setMetricsReportingStmtDisabled(statementName);
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Error enabling metric reporting for statement: " + e.getMessage(), e);
        }
    }

    @Override
    public void setMetricsReportingEnabled() {
        try {
            this.metricReportingService.setMetricsReportingEnabled();
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Error enabling metric reporting: " + e.getMessage(), e);
        }
    }

    @Override
    public void setMetricsReportingDisabled() {
        try {
            this.metricReportingService.setMetricsReportingDisabled();
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Error enabling metric reporting: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isVariantStreamExists(String name) {
        ValueAddEventProcessor processor = this.valueAddEventService.getValueAddProcessor(name);
        if (processor == null) {
            return false;
        }
        return processor.getValueAddEventType() instanceof VariantEventType;
    }

    @Override
    public boolean removeEventType(String name, boolean force) throws ConfigurationException {
        Set<String> statements;
        if (!force && (statements = this.statementEventTypeRef.getStatementNamesForType(name)) != null && !statements.isEmpty()) {
            throw new ConfigurationException("Event type '" + name + "' is in use by one or more statements");
        }
        EventType type = this.eventAdapterService.getExistsTypeByName(name);
        if (type == null) {
            return false;
        }
        this.eventAdapterService.removeType(name);
        this.statementEventTypeRef.removeReferencesType(name);
        return true;
    }

    @Override
    public boolean removeVariable(String name, boolean force) throws ConfigurationException {
        Set<String> statements;
        if (!force && (statements = this.statementVariableRef.getStatementNamesForVar(name)) != null && !statements.isEmpty()) {
            throw new ConfigurationException("Variable '" + name + "' is in use by one or more statements");
        }
        VariableReader reader = this.variableService.getReader(name);
        if (reader == null) {
            return false;
        }
        this.variableService.removeVariable(name);
        this.statementVariableRef.removeReferencesVariable(name);
        this.statementVariableRef.removeConfiguredVariable(name);
        return true;
    }

    @Override
    public Set<String> getEventTypeNameUsedBy(String name) {
        Set<String> statements = this.statementEventTypeRef.getStatementNamesForType(name);
        if (statements == null || statements.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(statements);
    }

    @Override
    public Set<String> getVariableNameUsedBy(String variableName) {
        Set<String> statements = this.statementVariableRef.getStatementNamesForVar(variableName);
        if (statements == null || statements.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(statements);
    }
}

