/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.antlr.ASTUtil;
import com.espertech.esper.client.ConfigurationOperations;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPPreparedStatement;
import com.espertech.esper.client.EPPreparedStatementImpl;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EPStatementException;
import com.espertech.esper.client.EPStatementSyntaxException;
import com.espertech.esper.client.soda.AnnotationPart;
import com.espertech.esper.client.soda.EPStatementObjectModel;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.MatchRecognizeRegEx;
import com.espertech.esper.client.soda.PatternExpr;
import com.espertech.esper.core.EPAdministratorSPI;
import com.espertech.esper.core.EPServicesContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.parse.EPLTreeWalker;
import com.espertech.esper.epl.parse.ParseHelper;
import com.espertech.esper.epl.parse.ParseResult;
import com.espertech.esper.epl.parse.ParseRuleSelector;
import com.espertech.esper.epl.parse.WalkRuleSelector;
import com.espertech.esper.epl.spec.PatternStreamSpecRaw;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecMapper;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.spec.StatementSpecUnMapResult;
import com.espertech.esper.pattern.EvalNode;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPAdministratorImpl
implements EPAdministratorSPI {
    private static ParseRuleSelector patternParseRule = new ParseRuleSelector(){

        public Tree invokeParseRule(EsperEPL2GrammarParser parser2) throws RecognitionException {
            EsperEPL2GrammarParser.startPatternExpressionRule_return r = parser2.startPatternExpressionRule();
            return (Tree)r.getTree();
        }
    };
    private static ParseRuleSelector eplParseRule;
    private static WalkRuleSelector patternWalkRule;
    private static WalkRuleSelector eplWalkRule;
    private EPServicesContext services;
    private ConfigurationOperations configurationOperations;
    private SelectClauseStreamSelectorEnum defaultStreamSelector;
    private static Log log;

    public EPAdministratorImpl(EPServicesContext services, ConfigurationOperations configurationOperations, SelectClauseStreamSelectorEnum defaultStreamSelector) {
        this.services = services;
        this.configurationOperations = configurationOperations;
        this.defaultStreamSelector = defaultStreamSelector;
    }

    public EPStatement createPattern(String onExpression) throws EPException {
        return this.createPatternStmt(onExpression, null, null);
    }

    public EPStatement createEPL(String eplStatement) throws EPException {
        return this.createEPLStmt(eplStatement, null, null);
    }

    public EPStatement createPattern(String expression, String statementName) throws EPException {
        return this.createPatternStmt(expression, statementName, null);
    }

    public EPStatement createPattern(String expression, String statementName, Object userObject) throws EPException {
        return this.createPatternStmt(expression, statementName, userObject);
    }

    public EPStatement createEPL(String eplStatement, String statementName) throws EPException {
        return this.createEPLStmt(eplStatement, statementName, null);
    }

    public EPStatement createEPL(String eplStatement, String statementName, Object userObject) throws EPException {
        return this.createEPLStmt(eplStatement, statementName, userObject);
    }

    public EPStatement createPattern(String expression, Object userObject) throws EPException {
        return this.createPatternStmt(expression, null, userObject);
    }

    public EPStatement createEPL(String eplStatement, Object userObject) throws EPException {
        return this.createEPLStmt(eplStatement, null, userObject);
    }

    private EPStatement createPatternStmt(String expression, String statementName, Object userObject) throws EPException {
        StatementSpecRaw rawPattern = this.compilePattern(expression, expression, true);
        return this.services.getStatementLifecycleSvc().createAndStart(rawPattern, expression, true, statementName, userObject, null);
    }

    private EPStatement createEPLStmt(String eplStatement, String statementName, Object userObject) throws EPException {
        StatementSpecRaw statementSpec = EPAdministratorImpl.compileEPL(eplStatement, eplStatement, true, statementName, this.services, this.defaultStreamSelector);
        EPStatement statement = this.services.getStatementLifecycleSvc().createAndStart(statementSpec, eplStatement, false, statementName, userObject, null);
        log.debug(".createEPLStmt Statement created and started");
        return statement;
    }

    public EPStatement create(EPStatementObjectModel sodaStatement) throws EPException {
        return this.create(sodaStatement, null);
    }

    public EPStatement create(EPStatementObjectModel sodaStatement, String statementName, Object userObject) throws EPException {
        StatementSpecRaw statementSpec = StatementSpecMapper.map(sodaStatement, this.services.getEngineImportService(), this.services.getVariableService(), this.services.getConfigSnapshot());
        String eplStatement = sodaStatement.toEPL();
        EPStatement statement = this.services.getStatementLifecycleSvc().createAndStart(statementSpec, eplStatement, false, statementName, userObject, null);
        log.debug(".createEPLStmt Statement created and started");
        return statement;
    }

    public EPStatement create(EPStatementObjectModel sodaStatement, String statementName) throws EPException {
        StatementSpecRaw statementSpec = StatementSpecMapper.map(sodaStatement, this.services.getEngineImportService(), this.services.getVariableService(), this.services.getConfigSnapshot());
        String eplStatement = sodaStatement.toEPL();
        EPStatement statement = this.services.getStatementLifecycleSvc().createAndStart(statementSpec, eplStatement, false, statementName, null, null);
        log.debug(".createEPLStmt Statement created and started");
        return statement;
    }

    public EPPreparedStatement prepareEPL(String eplExpression) throws EPException {
        StatementSpecRaw statementSpec = EPAdministratorImpl.compileEPL(eplExpression, eplExpression, true, null, this.services, this.defaultStreamSelector);
        StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(statementSpec);
        return new EPPreparedStatementImpl(unmapped.getObjectModel(), unmapped.getIndexedParams());
    }

    public EPPreparedStatement preparePattern(String patternExpression) throws EPException {
        StatementSpecRaw rawPattern = this.compilePattern(patternExpression, patternExpression, true);
        StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(rawPattern);
        return new EPPreparedStatementImpl(unmapped.getObjectModel(), unmapped.getIndexedParams());
    }

    public EPStatement create(EPPreparedStatement prepared, String statementName, Object userObject) throws EPException {
        EPPreparedStatementImpl impl = (EPPreparedStatementImpl)prepared;
        StatementSpecRaw statementSpec = StatementSpecMapper.map(impl.getModel(), this.services.getEngineImportService(), this.services.getVariableService(), this.services.getConfigSnapshot());
        String eplStatement = impl.getModel().toEPL();
        return this.services.getStatementLifecycleSvc().createAndStart(statementSpec, eplStatement, false, statementName, userObject, null);
    }

    public EPStatement create(EPPreparedStatement prepared, String statementName) throws EPException {
        EPPreparedStatementImpl impl = (EPPreparedStatementImpl)prepared;
        StatementSpecRaw statementSpec = StatementSpecMapper.map(impl.getModel(), this.services.getEngineImportService(), this.services.getVariableService(), this.services.getConfigSnapshot());
        String eplStatement = impl.getModel().toEPL();
        return this.services.getStatementLifecycleSvc().createAndStart(statementSpec, eplStatement, false, statementName, null, null);
    }

    public EPStatement create(EPPreparedStatement prepared) throws EPException {
        return this.create(prepared, null);
    }

    public EPStatementObjectModel compileEPL(String eplStatement) throws EPException {
        StatementSpecRaw statementSpec = EPAdministratorImpl.compileEPL(eplStatement, eplStatement, true, null, this.services, this.defaultStreamSelector);
        StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(statementSpec);
        if (unmapped.getIndexedParams().size() != 0) {
            throw new EPException("Invalid use of substitution parameters marked by '?' in statement, use the prepare method to prepare statements with substitution parameters");
        }
        return unmapped.getObjectModel();
    }

    public EPStatement getStatement(String name) {
        return this.services.getStatementLifecycleSvc().getStatementByName(name);
    }

    public String[] getStatementNames() {
        return this.services.getStatementLifecycleSvc().getStatementNames();
    }

    public void startAllStatements() throws EPException {
        this.services.getStatementLifecycleSvc().startAllStatements();
    }

    public void stopAllStatements() throws EPException {
        this.services.getStatementLifecycleSvc().stopAllStatements();
    }

    public void destroyAllStatements() throws EPException {
        this.services.getStatementLifecycleSvc().destroyAllStatements();
    }

    public ConfigurationOperations getConfiguration() {
        return this.configurationOperations;
    }

    public void destroy() {
        this.services = null;
        this.configurationOperations = null;
    }

    protected static StatementSpecRaw compileEPL(String eplStatement, String eplStatementForErrorMsg, boolean addPleaseCheck, String statementName, EPServicesContext services, SelectClauseStreamSelectorEnum defaultStreamSelector) {
        if (log.isDebugEnabled()) {
            log.debug(".createEPLStmt statementName=" + statementName + " eplStatement=" + eplStatement);
        }
        ParseResult parseResult = ParseHelper.parse(eplStatement, eplStatementForErrorMsg, addPleaseCheck, eplParseRule);
        Tree ast = parseResult.getTree();
        CommonTreeNodeStream nodes = new CommonTreeNodeStream(ast);
        EPLTreeWalker walker = new EPLTreeWalker(nodes, services.getEngineImportService(), services.getVariableService(), services.getSchedulingService(), defaultStreamSelector, services.getEngineURI(), services.getConfigSnapshot());
        try {
            ParseHelper.walk(ast, walker, eplWalkRule, eplStatement, eplStatementForErrorMsg);
        }
        catch (ASTWalkException ex) {
            log.error(".createEPL Error validating expression", ex);
            throw new EPStatementException(ex.getMessage(), eplStatementForErrorMsg);
        }
        catch (EPStatementSyntaxException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            String message = "Error in expression";
            log.debug(message, ex);
            throw new EPStatementException(EPAdministratorImpl.getNullableErrortext(message, ex.getMessage()), eplStatementForErrorMsg);
        }
        if (log.isDebugEnabled()) {
            ASTUtil.dumpAST(ast);
        }
        StatementSpecRaw raw = walker.getStatementSpec();
        raw.setExpressionNoAnnotations(parseResult.getExpressionWithoutAnnotations());
        return raw;
    }

    private StatementSpecRaw compilePattern(String expression, String expressionForErrorMessage, boolean addPleaseCheck) {
        ParseResult parseResult = ParseHelper.parse(expression, expressionForErrorMessage, addPleaseCheck, patternParseRule);
        Tree ast = parseResult.getTree();
        CommonTreeNodeStream nodes = new CommonTreeNodeStream(ast);
        EPLTreeWalker walker = new EPLTreeWalker(nodes, this.services.getEngineImportService(), this.services.getVariableService(), this.services.getSchedulingService(), this.defaultStreamSelector, this.services.getEngineURI(), this.services.getConfigSnapshot());
        try {
            ParseHelper.walk(ast, walker, patternWalkRule, expression, expressionForErrorMessage);
        }
        catch (ASTWalkException ex) {
            log.debug(".createPattern Error validating expression", ex);
            throw new EPStatementException(ex.getMessage(), expression);
        }
        catch (EPStatementSyntaxException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            String message = "Error in expression";
            log.debug(message, ex);
            throw new EPStatementException(EPAdministratorImpl.getNullableErrortext(message, ex.getMessage()), expression);
        }
        if (log.isDebugEnabled()) {
            ASTUtil.dumpAST(ast);
        }
        if (walker.getStatementSpec().getStreamSpecs().size() > 1) {
            throw new IllegalStateException("Unexpected multiple stream specifications encountered");
        }
        PatternStreamSpecRaw patternStreamSpec = (PatternStreamSpecRaw)walker.getStatementSpec().getStreamSpecs().get(0);
        StatementSpecRaw statementSpec = new StatementSpecRaw(SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        statementSpec.getStreamSpecs().add(patternStreamSpec);
        statementSpec.getSelectClauseSpec().getSelectExprList().clear();
        statementSpec.getSelectClauseSpec().getSelectExprList().add(new SelectClauseElementWildcard());
        statementSpec.setAnnotations(walker.getStatementSpec().getAnnotations());
        statementSpec.setExpressionNoAnnotations(parseResult.getExpressionWithoutAnnotations());
        return statementSpec;
    }

    public EvalNode compilePatternToNode(String pattern) throws EPException {
        StatementSpecRaw raw = this.compilePattern(pattern, pattern, false);
        return ((PatternStreamSpecRaw)raw.getStreamSpecs().get(0)).getEvalNode();
    }

    public ExprNode compileExpression(String expression) throws EPException {
        String toCompile = "select * from java.lang.Object.win:time(" + expression + ")";
        StatementSpecRaw raw = EPAdministratorImpl.compileEPL(toCompile, expression, false, null, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        return raw.getStreamSpecs().get(0).getViewSpecs().get(0).getObjectParameters().get(0);
    }

    private static String getNullableErrortext(String msg, String cause) {
        if (cause == null) {
            return msg;
        }
        return msg + ": " + cause;
    }

    public Expression compileExpressionToSODA(String expression) throws EPException {
        ExprNode node = this.compileExpression(expression);
        return StatementSpecMapper.unmap(node);
    }

    public PatternExpr compilePatternToSODA(String expression) throws EPException {
        EvalNode node = this.compilePatternToNode(expression);
        return StatementSpecMapper.unmap(node);
    }

    public AnnotationPart compileAnnotationToSODA(String annotationExpression) {
        String toCompile = annotationExpression + " select * from java.lang.Object";
        StatementSpecRaw raw = EPAdministratorImpl.compileEPL(toCompile, annotationExpression, false, null, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        return StatementSpecMapper.unmap(raw.getAnnotations().get(0));
    }

    public MatchRecognizeRegEx compileMatchRecognizePatternToSODA(String matchRecogPatternExpression) {
        String toCompile = "select * from java.lang.Object match_recognize(measures a.b as c pattern (" + matchRecogPatternExpression + ") define A as true)";
        StatementSpecRaw raw = EPAdministratorImpl.compileEPL(toCompile, matchRecogPatternExpression, false, null, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        return StatementSpecMapper.unmap(raw.getMatchRecognizeSpec().getPattern());
    }

    static {
        patternWalkRule = new WalkRuleSelector(){

            public void invokeWalkRule(EPLTreeWalker walker) throws RecognitionException {
                walker.startPatternExpressionRule();
            }
        };
        eplParseRule = new ParseRuleSelector(){

            public Tree invokeParseRule(EsperEPL2GrammarParser parser2) throws RecognitionException {
                EsperEPL2GrammarParser.startEPLExpressionRule_return r = parser2.startEPLExpressionRule();
                return (Tree)r.getTree();
            }
        };
        eplWalkRule = new WalkRuleSelector(){

            public void invokeWalkRule(EPLTreeWalker walker) throws RecognitionException {
                walker.startEPLExpressionRule();
            }
        };
        log = LogFactory.getLog(EPAdministratorImpl.class);
    }
}

