/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.EPPreparedQueryResult;
import com.espertech.esper.core.EPServicesContext;
import com.espertech.esper.core.EPStatementStartMethod;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.core.StreamJoinAnalysisResult;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactory;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.join.JoinSetComposer;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanReaderDefaultImpl;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecCompiler;
import com.espertech.esper.view.Viewable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPPreparedExecuteMethod {
    private static final Log log = LogFactory.getLog(EPPreparedExecuteMethod.class);
    private final StatementSpecCompiled statementSpec;
    private final ResultSetProcessor resultSetProcessor;
    private final NamedWindowProcessor[] processors;
    private final JoinSetComposer joinComposer;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private EventBeanReader eventBeanReader;
    private final FilterSpecCompiled[] filters;

    public EPPreparedExecuteMethod(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) throws ExprValidationException {
        this.statementSpec = statementSpec;
        this.exprEvaluatorContext = statementContext;
        this.validateExecuteQuery();
        int numStreams = statementSpec.getStreamSpecs().size();
        EventType[] typesPerStream = new EventType[numStreams];
        String[] namesPerStream = new String[numStreams];
        this.processors = new NamedWindowProcessor[numStreams];
        StreamJoinAnalysisResult streamJoinAnalysisResult = new StreamJoinAnalysisResult(numStreams);
        Arrays.fill(streamJoinAnalysisResult.getNamedWindow(), true);
        for (int i = 0; i < numStreams; ++i) {
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs().get(i);
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            String streamName = namedSpec.getWindowName();
            if (namedSpec.getOptionalStreamName() != null) {
                streamName = namedSpec.getOptionalStreamName();
            }
            namesPerStream[i] = streamName;
            this.processors[i] = services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
            typesPerStream[i] = this.processors[i].getTailView().getEventType();
        }
        this.filters = new FilterSpecCompiled[numStreams];
        if (statementSpec.getFilterRootNode() != null) {
            LinkedHashMap<String, Pair<EventType, String>> tagged = new LinkedHashMap<String, Pair<EventType, String>>();
            for (int i = 0; i < numStreams; ++i) {
                try {
                    StreamTypeServiceImpl types = new StreamTypeServiceImpl(typesPerStream, namesPerStream, new boolean[numStreams], services.getEngineURI());
                    this.filters[i] = FilterSpecCompiler.makeFilterSpec(typesPerStream[i], namesPerStream[i], Collections.singletonList(statementSpec.getFilterRootNode()), null, tagged, tagged, types, statementContext.getMethodResolutionService(), statementContext.getTimeProvider(), statementContext.getVariableService(), statementContext.getEventAdapterService(), services.getEngineURI(), null, statementContext);
                    continue;
                }
                catch (Exception ex) {
                    log.warn("Unexpected exception analyzing filter paths: " + ex.getMessage(), ex);
                }
            }
        }
        boolean[] isIStreamOnly = new boolean[namesPerStream.length];
        Arrays.fill(isIStreamOnly, true);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(typesPerStream, namesPerStream, isIStreamOnly, services.getEngineURI());
        EPStatementStartMethod.validateNodes(statementSpec, statementContext, typeService, null);
        this.resultSetProcessor = ResultSetProcessorFactory.getProcessor(statementSpec, statementContext, typeService, null, new boolean[0], true);
        if (statementSpec.getSelectClauseSpec().isDistinct()) {
            if (this.resultSetProcessor.getResultEventType() instanceof EventTypeSPI) {
                this.eventBeanReader = ((EventTypeSPI)this.resultSetProcessor.getResultEventType()).getReader();
            }
            if (this.eventBeanReader == null) {
                this.eventBeanReader = new EventBeanReaderDefaultImpl(this.resultSetProcessor.getResultEventType());
            }
        }
        if (numStreams > 1) {
            Viewable[] viewablePerStream = new Viewable[numStreams];
            for (int i = 0; i < numStreams; ++i) {
                viewablePerStream[i] = this.processors[i].getTailView();
            }
            this.joinComposer = statementContext.getJoinSetComposerFactory().makeComposer(statementSpec.getOuterJoinDescList(), statementSpec.getFilterRootNode(), typesPerStream, namesPerStream, viewablePerStream, SelectClauseStreamSelectorEnum.ISTREAM_ONLY, streamJoinAnalysisResult, statementContext);
        } else {
            this.joinComposer = null;
        }
    }

    public EventType getEventType() {
        return this.resultSetProcessor.getResultEventType();
    }

    public EPPreparedQueryResult execute() {
        UniformPair<EventBean[]> results;
        int numStreams = this.processors.length;
        Collection[] snapshots = new Collection[numStreams];
        for (int i = 0; i < numStreams; ++i) {
            StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs().get(i);
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            snapshots[i] = this.processors[i].getTailView().snapshot(this.filters[i]);
            if (namedSpec.getFilterExpressions().size() == 0) continue;
            snapshots[i] = this.getFiltered(snapshots[i], namedSpec.getFilterExpressions());
        }
        this.resultSetProcessor.clear();
        if (numStreams == 1) {
            if (this.statementSpec.getFilterRootNode() != null) {
                snapshots[0] = this.getFiltered(snapshots[0], Arrays.asList(this.statementSpec.getFilterRootNode()));
            }
            EventBean[] rows = snapshots[0].toArray(new EventBean[snapshots[0].size()]);
            results = this.resultSetProcessor.processViewResult(rows, null, true);
        } else {
            EventBean[][] oldDataPerStream = new EventBean[numStreams][];
            EventBean[][] newDataPerStream = new EventBean[numStreams][];
            for (int i = 0; i < numStreams; ++i) {
                newDataPerStream[i] = snapshots[i].toArray(new EventBean[snapshots[i].size()]);
            }
            UniformPair<Set<MultiKey<EventBean>>> result = this.joinComposer.join(newDataPerStream, oldDataPerStream, this.exprEvaluatorContext);
            results = this.resultSetProcessor.processJoinResult(result.getFirst(), null, true);
        }
        if (this.statementSpec.getSelectClauseSpec().isDistinct()) {
            results.setFirst(EventBeanUtility.getDistinctByProp(results.getFirst(), this.eventBeanReader));
        }
        return new EPPreparedQueryResult(this.resultSetProcessor.getResultEventType(), results.getFirst());
    }

    private void validateExecuteQuery() throws ExprValidationException {
        if (this.statementSpec.getSubSelectExpressions().size() > 0) {
            throw new ExprValidationException("Subqueries are not a supported feature of on-demand queries");
        }
        for (int i = 0; i < this.statementSpec.getStreamSpecs().size(); ++i) {
            if (!(this.statementSpec.getStreamSpecs().get(i) instanceof NamedWindowConsumerStreamSpec)) {
                throw new ExprValidationException("On-demand queries require named windows and do not allow event streams or patterns");
            }
            if (this.statementSpec.getStreamSpecs().get(i).getViewSpecs().size() == 0) continue;
            throw new ExprValidationException("Views are not a supported feature of on-demand queries");
        }
        if (this.statementSpec.getOutputLimitSpec() != null) {
            throw new ExprValidationException("Output rate limiting is not a supported feature of on-demand queries");
        }
        if (this.statementSpec.getInsertIntoDesc() != null) {
            throw new ExprValidationException("Insert-into is not a supported feature of on-demand queries");
        }
    }

    private List<EventBean> getFiltered(Collection<EventBean> snapshot, List<ExprNode> filterExpressions) {
        EventBean[] eventsPerStream = new EventBean[1];
        ArrayList<EventBean> filteredSnapshot = new ArrayList<EventBean>();
        for (EventBean row : snapshot) {
            boolean pass = true;
            eventsPerStream[0] = row;
            for (ExprNode filter : filterExpressions) {
                Boolean result = (Boolean)filter.evaluate(eventsPerStream, true, this.exprEvaluatorContext);
                if (result == null || result.booleanValue()) continue;
                pass = false;
                break;
            }
            if (!pass) continue;
            filteredSnapshot.add(row);
        }
        return filteredSnapshot;
    }
}

