/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPOnDemandPreparedQuery;
import com.espertech.esper.client.EPOnDemandQueryResult;
import com.espertech.esper.client.EPStatementException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.client.EventTypeException;
import com.espertech.esper.client.UnmatchedListener;
import com.espertech.esper.client.VariableNotFoundException;
import com.espertech.esper.client.time.CurrentTimeEvent;
import com.espertech.esper.client.time.TimerControlEvent;
import com.espertech.esper.client.time.TimerEvent;
import com.espertech.esper.client.util.EventRenderer;
import com.espertech.esper.collection.ArrayBackedCollection;
import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.collection.ThreadWorkQueue;
import com.espertech.esper.core.EPAdministratorImpl;
import com.espertech.esper.core.EPPreparedExecuteMethod;
import com.espertech.esper.core.EPPreparedQueryImpl;
import com.espertech.esper.core.EPPreparedQueryResult;
import com.espertech.esper.core.EPQueryResultImpl;
import com.espertech.esper.core.EPRuntimeEventSender;
import com.espertech.esper.core.EPRuntimeSPI;
import com.espertech.esper.core.EPServicesContext;
import com.espertech.esper.core.EPStatementHandle;
import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.core.InsertIntoLatchFactory;
import com.espertech.esper.core.InsertIntoLatchSpin;
import com.espertech.esper.core.InsertIntoLatchWait;
import com.espertech.esper.core.InternalEventRouteDest;
import com.espertech.esper.core.InternalEventRouterImpl;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.core.StatementLifecycleSvcImpl;
import com.espertech.esper.core.thread.InboundUnitSendDOM;
import com.espertech.esper.core.thread.InboundUnitSendEvent;
import com.espertech.esper.core.thread.InboundUnitSendMap;
import com.espertech.esper.core.thread.RouteUnitMultiple;
import com.espertech.esper.core.thread.RouteUnitSingle;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.TimerUnitMultiple;
import com.espertech.esper.core.thread.TimerUnitSingle;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.metric.MetricReportingPath;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.event.util.EventRendererImpl;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.timer.TimerCallback;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.ManagedLock;
import com.espertech.esper.util.MetricUtil;
import com.espertech.esper.util.ThreadLogUtil;
import com.espertech.esper.util.UuidGenerator;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPRuntimeImpl
implements EPRuntimeSPI,
EPRuntimeEventSender,
TimerCallback,
InternalEventRouteDest {
    private EPServicesContext services;
    private boolean isLatchStatementInsertStream;
    private boolean isUsingExternalClocking;
    private boolean isSubselectPreeval;
    private boolean isPrioritized;
    private volatile UnmatchedListener unmatchedListener;
    private AtomicLong routedInternal;
    private AtomicLong routedExternal;
    private EventRenderer eventRenderer;
    private ThreadLocal<Map<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>>> matchesPerStmtThreadLocal;
    private ThreadLocal<Map<EPStatementHandle, Object>> schedulePerStmtThreadLocal;
    private InternalEventRouterImpl internalEventRouterImpl;
    private ExprEvaluatorContext engineFilterAndDispatchTimeContext;
    private ThreadLocal<ArrayBackedCollection<FilterHandle>> matchesArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<FilterHandle>>(){

        @Override
        protected synchronized ArrayBackedCollection<FilterHandle> initialValue() {
            return new ArrayBackedCollection<FilterHandle>(100);
        }
    };
    private ThreadLocal<ArrayBackedCollection<ScheduleHandle>> scheduleArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<ScheduleHandle>>(){

        @Override
        protected synchronized ArrayBackedCollection<ScheduleHandle> initialValue() {
            return new ArrayBackedCollection<ScheduleHandle>(100);
        }
    };
    private static final Log log = LogFactory.getLog(EPRuntimeImpl.class);

    public EPRuntimeImpl(final EPServicesContext services) {
        this.services = services;
        this.isLatchStatementInsertStream = this.services.getEngineSettingsService().getEngineSettings().getThreading().isInsertIntoDispatchPreserveOrder();
        this.isUsingExternalClocking = !this.services.getEngineSettingsService().getEngineSettings().getThreading().isInternalTimerEnabled();
        this.isSubselectPreeval = services.getEngineSettingsService().getEngineSettings().getExpression().isSelfSubselectPreeval();
        this.isPrioritized = services.getEngineSettingsService().getEngineSettings().getExecution().isPrioritized();
        this.routedInternal = new AtomicLong();
        this.routedExternal = new AtomicLong();
        this.engineFilterAndDispatchTimeContext = new ExprEvaluatorContext(){

            public TimeProvider getTimeProvider() {
                return services.getSchedulingService();
            }
        };
        this.matchesPerStmtThreadLocal = new ThreadLocal<Map<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>>>(){

            @Override
            protected synchronized Map<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>> initialValue() {
                if (EPRuntimeImpl.this.isPrioritized) {
                    return new TreeMap<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>>(new Comparator<EPStatementHandle>(){

                        @Override
                        public int compare(EPStatementHandle o1, EPStatementHandle o2) {
                            if (o1.getPriority() == o2.getPriority()) {
                                return 0;
                            }
                            return o1.getPriority() > o2.getPriority() ? -1 : 1;
                        }
                    });
                }
                return new HashMap<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>>(10000);
            }
        };
        this.schedulePerStmtThreadLocal = new ThreadLocal<Map<EPStatementHandle, Object>>(){

            @Override
            protected synchronized Map<EPStatementHandle, Object> initialValue() {
                if (EPRuntimeImpl.this.isPrioritized) {
                    return new TreeMap<EPStatementHandle, Object>(new Comparator<EPStatementHandle>(){

                        @Override
                        public int compare(EPStatementHandle o1, EPStatementHandle o2) {
                            if (o1.getPriority() == o2.getPriority()) {
                                return 0;
                            }
                            return o1.getPriority() > o2.getPriority() ? -1 : 1;
                        }
                    });
                }
                return new HashMap<EPStatementHandle, Object>(10000);
            }
        };
        services.getThreadingService().initThreading(services, this);
    }

    public void setInternalEventRouterImpl(InternalEventRouterImpl internalEventRouterImpl) {
        this.internalEventRouterImpl = internalEventRouterImpl;
    }

    @Override
    public long getRoutedInternal() {
        return this.routedInternal.get();
    }

    @Override
    public long getRoutedExternal() {
        return this.routedExternal.get();
    }

    @Override
    public void timerCallback() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
            log.debug(".timerCallback Evaluating scheduled callbacks");
        }
        long msec = this.services.getTimeSource().getTimeMillis();
        CurrentTimeEvent currentTimeEvent = new CurrentTimeEvent(msec);
        this.sendEvent(currentTimeEvent);
    }

    @Override
    public void sendEvent(Object event) throws EPException {
        if (event == null) {
            log.fatal(".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && (!(event instanceof CurrentTimeEvent) || ExecutionPathDebugLog.isTimerDebugEnabled)) {
            log.debug(".sendEvent Processing event " + event);
        }
        if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isInboundThreading()) {
            this.services.getThreadingService().submitInbound(new InboundUnitSendEvent(event, this));
        } else {
            this.processEvent(event);
        }
    }

    @Override
    public void sendEvent(Node document) throws EPException {
        if (document == null) {
            log.fatal(".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendEvent Processing DOM node event " + document);
        }
        if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isInboundThreading()) {
            this.services.getThreadingService().submitInbound(new InboundUnitSendDOM(document, this.services, this));
        } else {
            EventBean eventBean = this.services.getEventAdapterService().adapterForDOM(document);
            this.processEvent(eventBean);
        }
    }

    @Override
    public void route(Node document) throws EPException {
        if (document == null) {
            log.fatal(".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendEvent Processing DOM node event " + document);
        }
        EventBean eventBean = this.services.getEventAdapterService().adapterForDOM(document);
        ThreadWorkQueue.add(eventBean);
    }

    @Override
    public void sendEvent(Map map, String eventTypeName) throws EPException {
        if (map == null) {
            throw new IllegalArgumentException("Invalid null event object");
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendMap Processing event " + map);
        }
        if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isInboundThreading()) {
            this.services.getThreadingService().submitInbound(new InboundUnitSendMap(map, eventTypeName, this.services, this));
        } else {
            EventBean eventBean = this.services.getEventAdapterService().adapterForMap(map, eventTypeName);
            this.processWrappedEvent(eventBean);
        }
    }

    @Override
    public void route(Map map, String eventTypeName) throws EPException {
        if (map == null) {
            throw new IllegalArgumentException("Invalid null event object");
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".route Processing event " + map);
        }
        EventBean event = this.services.getEventAdapterService().adapterForMap(map, eventTypeName);
        if (this.internalEventRouterImpl.isHasPreprocessing() && (event = this.internalEventRouterImpl.preprocess(event, this.engineFilterAndDispatchTimeContext)) == null) {
            return;
        }
        ThreadWorkQueue.add(event);
    }

    @Override
    public long getNumEventsEvaluated() {
        return this.services.getFilterService().getNumEventsEvaluated();
    }

    @Override
    public void resetStats() {
        this.services.getFilterService().resetStats();
        this.routedInternal.set(0L);
        this.routedExternal.set(0L);
    }

    @Override
    public void routeEventBean(EventBean event) {
        ThreadWorkQueue.add(event);
    }

    @Override
    public void route(Object event) {
        EventBean eventBean;
        this.routedExternal.incrementAndGet();
        if (this.internalEventRouterImpl.isHasPreprocessing() && (event = this.internalEventRouterImpl.preprocess(eventBean = this.services.getEventAdapterService().adapterForBean(event), this.engineFilterAndDispatchTimeContext)) == null) {
            return;
        }
        ThreadWorkQueue.add(event);
    }

    @Override
    public void route(EventBean event, EPStatementHandle epStatementHandle) {
        this.routedInternal.incrementAndGet();
        if (this.isLatchStatementInsertStream) {
            InsertIntoLatchFactory insertIntoLatchFactory = epStatementHandle.getInsertIntoLatchFactory();
            Object latch = insertIntoLatchFactory.newLatch(event);
            ThreadWorkQueue.add(latch);
        } else {
            ThreadWorkQueue.add(event);
        }
    }

    public void processEvent(Object event) {
        if (event instanceof TimerEvent) {
            this.processTimeEvent((TimerEvent)event);
            return;
        }
        EventBean eventBean = event instanceof EventBean ? (EventBean)event : this.services.getEventAdapterService().adapterForBean(event);
        this.processWrappedEvent(eventBean);
    }

    @Override
    public void processWrappedEvent(EventBean eventBean) {
        if (this.internalEventRouterImpl.isHasPreprocessing() && (eventBean = this.internalEventRouterImpl.preprocess(eventBean, this.engineFilterAndDispatchTimeContext)) == null) {
            return;
        }
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            throw new EPException(ex);
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
        this.processThreadWorkQueue();
    }

    private void processTimeEvent(TimerEvent event) {
        if (event instanceof TimerControlEvent) {
            TimerControlEvent timerControlEvent = (TimerControlEvent)event;
            if (timerControlEvent.getClockType() == TimerControlEvent.ClockType.CLOCK_INTERNAL) {
                this.services.getTimerService().startInternalClock();
                this.isUsingExternalClocking = false;
            } else {
                this.services.getTimerService().stopInternalClock(true);
                this.isUsingExternalClocking = true;
            }
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
            log.debug(".processTimeEvent Setting time and evaluating schedules");
        }
        CurrentTimeEvent current = (CurrentTimeEvent)event;
        long currentTime = current.getTimeInMillis();
        if (this.isUsingExternalClocking && currentTime == this.services.getSchedulingService().getTime() && log.isWarnEnabled()) {
            log.warn("Duplicate time event received for currentTime " + currentTime);
        }
        this.services.getSchedulingService().setTime(currentTime);
        if (MetricReportingPath.isMetricsEnabled) {
            this.services.getMetricsReportingService().processTimeEvent(currentTime);
        }
        this.processSchedule();
        this.dispatch();
        this.processThreadWorkQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSchedule() {
        ArrayBackedCollection<ScheduleHandle> handles = this.scheduleArrayThreadLocal.get();
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.services.getSchedulingService().evaluate(handles);
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processScheduleHandles(handles);
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
    }

    private void processScheduleHandles(ArrayBackedCollection<ScheduleHandle> handles) {
        EPStatementHandle handle;
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.trace("Found schedules for", handles.size());
        }
        if (handles.size() == 0) {
            return;
        }
        if (handles.size() == 1) {
            Object[] handleArray = handles.getArray();
            EPStatementHandleCallback handle2 = (EPStatementHandleCallback)handleArray[0];
            if (MetricReportingPath.isMetricsEnabled && handle2.getEpStatementHandle().getMetricsHandle().isEnabled()) {
                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                long wallTimeBefore = MetricUtil.getWall();
                EPRuntimeImpl.processStatementScheduleSingle(handle2, this.services, this.engineFilterAndDispatchTimeContext);
                long wallTimeAfter = MetricUtil.getWall();
                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                long deltaWall = wallTimeAfter - wallTimeBefore;
                this.services.getMetricsReportingService().accountTime(handle2.getEpStatementHandle().getMetricsHandle(), deltaCPU, deltaWall);
            } else if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isTimerThreading()) {
                this.services.getThreadingService().submitTimerWork(new TimerUnitSingle(this.services, this, handle2, this.engineFilterAndDispatchTimeContext));
            } else {
                EPRuntimeImpl.processStatementScheduleSingle(handle2, this.services, this.engineFilterAndDispatchTimeContext);
            }
            handles.clear();
            return;
        }
        Object[] matchArray = handles.getArray();
        int entryCount = handles.size();
        Map<EPStatementHandle, Object> stmtCallbacks = this.schedulePerStmtThreadLocal.get();
        stmtCallbacks.clear();
        for (int i = 0; i < entryCount; ++i) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)matchArray[i];
            handle = handleCallback.getEpStatementHandle();
            ScheduleHandleCallback callback = handleCallback.getScheduleCallback();
            Object entry = stmtCallbacks.get(handle);
            if (entry == null) {
                stmtCallbacks.put(handle, callback);
                continue;
            }
            if (entry instanceof ScheduleHandleCallback) {
                ScheduleHandleCallback existingCallback = (ScheduleHandleCallback)entry;
                ArrayDequeJDK6Backport<ScheduleHandleCallback> entries = new ArrayDequeJDK6Backport<ScheduleHandleCallback>();
                entries.add(existingCallback);
                entries.add(callback);
                stmtCallbacks.put(handle, entries);
                continue;
            }
            ArrayDequeJDK6Backport entries = (ArrayDequeJDK6Backport)entry;
            entries.add(callback);
        }
        handles.clear();
        for (Map.Entry<EPStatementHandle, Object> entry : stmtCallbacks.entrySet()) {
            handle = entry.getKey();
            Object callbackObject = entry.getValue();
            if (MetricReportingPath.isMetricsEnabled && handle.getMetricsHandle().isEnabled()) {
                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                long wallTimeBefore = MetricUtil.getWall();
                EPRuntimeImpl.processStatementScheduleMultiple(handle, callbackObject, this.services, this.engineFilterAndDispatchTimeContext);
                long wallTimeAfter = MetricUtil.getWall();
                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                long deltaWall = wallTimeAfter - wallTimeBefore;
                this.services.getMetricsReportingService().accountTime(handle.getMetricsHandle(), deltaCPU, deltaWall);
            } else if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isTimerThreading()) {
                this.services.getThreadingService().submitTimerWork(new TimerUnitMultiple(this.services, this, handle, callbackObject, this.engineFilterAndDispatchTimeContext));
            } else {
                EPRuntimeImpl.processStatementScheduleMultiple(handle, callbackObject, this.services, this.engineFilterAndDispatchTimeContext);
            }
            if (!this.isPrioritized || !handle.isPreemptive()) continue;
            break;
        }
    }

    public void processThreadWorkQueue() {
        Object item;
        while ((item = ThreadWorkQueue.next()) != null) {
            if (item instanceof InsertIntoLatchSpin) {
                this.processThreadWorkQueueLatchedSpin((InsertIntoLatchSpin)item);
                continue;
            }
            if (item instanceof InsertIntoLatchWait) {
                this.processThreadWorkQueueLatchedWait((InsertIntoLatchWait)item);
                continue;
            }
            this.processThreadWorkQueueUnlatched(item);
        }
        boolean haveDispatched = this.services.getNamedWindowService().dispatch(this.engineFilterAndDispatchTimeContext);
        if (haveDispatched) {
            this.dispatch();
        }
        if (!ThreadWorkQueue.isEmpty()) {
            this.processThreadWorkQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processThreadWorkQueueLatchedWait(InsertIntoLatchWait insertIntoLatch) {
        Object item = insertIntoLatch.await();
        EventBean eventBean = item instanceof EventBean ? (EventBean)item : this.services.getEventAdapterService().adapterForBean(item);
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        finally {
            insertIntoLatch.done();
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processThreadWorkQueueLatchedSpin(InsertIntoLatchSpin insertIntoLatch) {
        Object item = insertIntoLatch.await();
        EventBean eventBean = item instanceof EventBean ? (EventBean)item : this.services.getEventAdapterService().adapterForBean(item);
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        finally {
            insertIntoLatch.done();
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processThreadWorkQueueUnlatched(Object item) {
        EventBean eventBean = item instanceof EventBean ? (EventBean)item : this.services.getEventAdapterService().adapterForBean(item);
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processMatches(EventBean event) {
        EPStatementHandle handle;
        ArrayBackedCollection<FilterHandle> matches = this.matchesArrayThreadLocal.get();
        long version2 = this.services.getFilterService().evaluate(event, matches, this.engineFilterAndDispatchTimeContext);
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.trace("Found matches for underlying ", matches.size(), event.getUnderlying());
        }
        if (matches.size() == 0) {
            if (this.unmatchedListener != null) {
                this.unmatchedListener.update(event);
            }
            return;
        }
        Map<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>> stmtCallbacks = this.matchesPerStmtThreadLocal.get();
        Object[] matchArray = matches.getArray();
        int entryCount = matches.size();
        for (int i = 0; i < entryCount; ++i) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)matchArray[i];
            handle = handleCallback.getEpStatementHandle();
            if (handle.isCanSelfJoin() || this.isPrioritized) {
                ArrayDequeJDK6Backport<FilterHandleCallback> callbacks = stmtCallbacks.get(handle);
                if (callbacks == null) {
                    callbacks = new ArrayDequeJDK6Backport();
                    stmtCallbacks.put(handle, callbacks);
                }
                callbacks.add(handleCallback.getFilterCallback());
                continue;
            }
            if (MetricReportingPath.isMetricsEnabled && handle.getMetricsHandle().isEnabled()) {
                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                long wallTimeBefore = MetricUtil.getWall();
                this.processStatementFilterSingle(handle, handleCallback, event, version2);
                long wallTimeAfter = MetricUtil.getWall();
                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                long deltaWall = wallTimeAfter - wallTimeBefore;
                this.services.getMetricsReportingService().accountTime(handle.getMetricsHandle(), deltaCPU, deltaWall);
                continue;
            }
            if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isRouteThreading()) {
                this.services.getThreadingService().submitRoute(new RouteUnitSingle(this, handleCallback, event, version2));
                continue;
            }
            this.processStatementFilterSingle(handle, handleCallback, event, version2);
        }
        matches.clear();
        if (stmtCallbacks.isEmpty()) {
            return;
        }
        for (Map.Entry<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>> entry : stmtCallbacks.entrySet()) {
            handle = entry.getKey();
            ArrayDequeJDK6Backport<FilterHandleCallback> callbackList = entry.getValue();
            if (MetricReportingPath.isMetricsEnabled && handle.getMetricsHandle().isEnabled()) {
                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                long wallTimeBefore = MetricUtil.getWall();
                this.processStatementFilterMultiple(handle, callbackList, event, version2);
                long wallTimeAfter = MetricUtil.getWall();
                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                long deltaWall = wallTimeAfter - wallTimeBefore;
                this.services.getMetricsReportingService().accountTime(handle.getMetricsHandle(), deltaCPU, deltaWall);
                continue;
            }
            if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isRouteThreading()) {
                this.services.getThreadingService().submitRoute(new RouteUnitMultiple(this, callbackList, event, handle, version2));
            } else {
                this.processStatementFilterMultiple(handle, callbackList, event, version2);
            }
            if (!this.isPrioritized || !handle.isPreemptive()) continue;
            break;
        }
        stmtCallbacks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processStatementScheduleMultiple(EPStatementHandle handle, Object callbackObject, EPServicesContext services, ExprEvaluatorContext exprEvaluatorContext) {
        handle.getStatementLock().acquireLock(services.getStatementLockFactory());
        try {
            if (handle.isHasVariables()) {
                services.getVariableService().setLocalVersion();
            }
            if (callbackObject instanceof ArrayDequeJDK6Backport) {
                ArrayDequeJDK6Backport callbackList = (ArrayDequeJDK6Backport)callbackObject;
                for (ScheduleHandleCallback callback : callbackList) {
                    callback.scheduledTrigger(services.getExtensionServicesContext());
                }
            } else {
                ScheduleHandleCallback callback = (ScheduleHandleCallback)callbackObject;
                callback.scheduledTrigger(services.getExtensionServicesContext());
            }
            handle.internalDispatch(exprEvaluatorContext);
        }
        finally {
            handle.getStatementLock().releaseLock(services.getStatementLockFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processStatementScheduleSingle(EPStatementHandleCallback handle, EPServicesContext services, ExprEvaluatorContext exprEvaluatorContext) {
        ManagedLock statementLock = handle.getEpStatementHandle().getStatementLock();
        statementLock.acquireLock(services.getStatementLockFactory());
        try {
            if (handle.getEpStatementHandle().isHasVariables()) {
                services.getVariableService().setLocalVersion();
            }
            handle.getScheduleCallback().scheduledTrigger(services.getExtensionServicesContext());
            handle.getEpStatementHandle().internalDispatch(exprEvaluatorContext);
        }
        finally {
            handle.getEpStatementHandle().getStatementLock().releaseLock(services.getStatementLockFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStatementFilterMultiple(EPStatementHandle handle, ArrayDequeJDK6Backport<FilterHandleCallback> callbackList, EventBean event, long version2) {
        handle.getStatementLock().acquireLock(this.services.getStatementLockFactory());
        try {
            if (handle.isHasVariables()) {
                this.services.getVariableService().setLocalVersion();
            }
            if (!handle.isCurrentFilter(version2)) {
                callbackList.clear();
                ArrayDequeJDK6Backport<FilterHandle> callbackListNew = this.getCallbackList(event, handle.getStatementId());
                for (FilterHandle callback : callbackListNew) {
                    EPStatementHandleCallback handleCallbackFilter = (EPStatementHandleCallback)callback;
                    callbackList.add(handleCallbackFilter.getFilterCallback());
                }
            }
            if (this.isSubselectPreeval) {
                for (FilterHandleCallback callback : callbackList) {
                    if (!callback.isSubSelect()) continue;
                    callback.matchFound(event);
                }
                for (FilterHandleCallback callback : callbackList) {
                    if (callback.isSubSelect()) continue;
                    callback.matchFound(event);
                }
            } else {
                for (FilterHandleCallback callback : callbackList) {
                    if (callback.isSubSelect()) continue;
                    callback.matchFound(event);
                }
                for (FilterHandleCallback callback : callbackList) {
                    if (!callback.isSubSelect()) continue;
                    callback.matchFound(event);
                }
            }
            handle.internalDispatch(this.engineFilterAndDispatchTimeContext);
        }
        finally {
            handle.getStatementLock().releaseLock(this.services.getStatementLockFactory());
        }
    }

    private ArrayDequeJDK6Backport<FilterHandle> getCallbackList(EventBean event, String statementId) {
        ArrayDequeJDK6Backport<FilterHandle> callbacks = new ArrayDequeJDK6Backport<FilterHandle>();
        this.services.getFilterService().evaluate(event, callbacks, this.engineFilterAndDispatchTimeContext, statementId);
        return callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStatementFilterSingle(EPStatementHandle handle, EPStatementHandleCallback handleCallback, EventBean event, long version2) {
        handle.getStatementLock().acquireLock(this.services.getStatementLockFactory());
        try {
            if (handle.isHasVariables()) {
                this.services.getVariableService().setLocalVersion();
            }
            if (!handle.isCurrentFilter(version2)) {
                ArrayDequeJDK6Backport<FilterHandle> callbackList = this.getCallbackList(event, handle.getStatementId());
                for (FilterHandle callback : callbackList) {
                    EPStatementHandleCallback handleCallbackFilter = (EPStatementHandleCallback)callback;
                    handleCallbackFilter.getFilterCallback().matchFound(event);
                }
            } else {
                handleCallback.getFilterCallback().matchFound(event);
            }
            handle.internalDispatch(this.engineFilterAndDispatchTimeContext);
        }
        finally {
            handleCallback.getEpStatementHandle().getStatementLock().releaseLock(this.services.getStatementLockFactory());
        }
    }

    public void dispatch() {
        try {
            this.services.getDispatchService().dispatch();
        }
        catch (RuntimeException ex) {
            throw new EPException(ex);
        }
    }

    public void destroy() {
        this.services = null;
        this.matchesArrayThreadLocal.remove();
        this.matchesPerStmtThreadLocal.remove();
        this.scheduleArrayThreadLocal.remove();
        this.schedulePerStmtThreadLocal.remove();
        this.matchesArrayThreadLocal = null;
        this.matchesPerStmtThreadLocal = null;
        this.scheduleArrayThreadLocal = null;
        this.schedulePerStmtThreadLocal = null;
    }

    @Override
    public void setUnmatchedListener(UnmatchedListener listener) {
        this.unmatchedListener = listener;
    }

    @Override
    public void setVariableValue(String variableName, Object variableValue) throws EPException {
        VariableReader reader = this.services.getVariableService().getReader(variableName);
        if (reader == null) {
            throw new VariableNotFoundException("Variable by name '" + variableName + "' has not been declared");
        }
        this.services.getVariableService().checkAndWrite(reader.getVariableNumber(), variableValue);
        this.services.getVariableService().commit();
    }

    @Override
    public void setVariableValue(Map<String, Object> variableValues) throws EPException {
        for (Map.Entry<String, Object> entry : variableValues.entrySet()) {
            String variableName = entry.getKey();
            VariableReader reader = this.services.getVariableService().getReader(variableName);
            if (reader == null) {
                this.services.getVariableService().rollback();
                throw new VariableNotFoundException("Variable by name '" + variableName + "' has not been declared");
            }
            try {
                this.services.getVariableService().checkAndWrite(reader.getVariableNumber(), entry.getValue());
            }
            catch (RuntimeException ex) {
                this.services.getVariableService().rollback();
                throw ex;
            }
        }
        this.services.getVariableService().commit();
    }

    @Override
    public Object getVariableValue(String variableName) throws EPException {
        this.services.getVariableService().setLocalVersion();
        VariableReader reader = this.services.getVariableService().getReader(variableName);
        if (reader == null) {
            throw new VariableNotFoundException("Variable by name '" + variableName + "' has not been declared");
        }
        Object value = reader.getValue();
        if (value == null || reader.getEventType() == null) {
            return value;
        }
        return ((EventBean)value).getUnderlying();
    }

    @Override
    public Map<String, Object> getVariableValue(Set<String> variableNames) throws EPException {
        this.services.getVariableService().setLocalVersion();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String variableName : variableNames) {
            VariableReader reader = this.services.getVariableService().getReader(variableName);
            if (reader == null) {
                throw new VariableNotFoundException("Variable by name '" + variableName + "' has not been declared");
            }
            Object value = reader.getValue();
            if (value != null && reader.getEventType() != null) {
                value = ((EventBean)value).getUnderlying();
            }
            values.put(variableName, value);
        }
        return values;
    }

    @Override
    public Map<String, Object> getVariableValueAll() throws EPException {
        this.services.getVariableService().setLocalVersion();
        Map<String, VariableReader> variables = this.services.getVariableService().getVariables();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, VariableReader> entry : variables.entrySet()) {
            Object value = entry.getValue().getValue();
            values.put(entry.getValue().getVariableName(), value);
        }
        return values;
    }

    @Override
    public Map<String, Class> getVariableTypeAll() {
        Map<String, VariableReader> variables = this.services.getVariableService().getVariables();
        HashMap<String, Class> values = new HashMap<String, Class>();
        for (Map.Entry<String, VariableReader> entry : variables.entrySet()) {
            Class type = entry.getValue().getType();
            values.put(entry.getValue().getVariableName(), type);
        }
        return values;
    }

    @Override
    public Class getVariableType(String variableName) {
        VariableReader reader = this.services.getVariableService().getReader(variableName);
        if (reader == null) {
            return null;
        }
        return reader.getType();
    }

    @Override
    public EPOnDemandQueryResult executeQuery(String epl) {
        try {
            EPPreparedExecuteMethod executeMethod = this.getExecuteMethod(epl);
            EPPreparedQueryResult result = executeMethod.execute();
            return new EPQueryResultImpl(result);
        }
        catch (EPStatementException ex) {
            throw ex;
        }
        catch (Throwable t) {
            String message = "Error executing statement: " + t.getMessage();
            log.info(message, t);
            throw new EPStatementException(message, epl);
        }
    }

    @Override
    public EPOnDemandPreparedQuery prepareQuery(String epl) {
        try {
            EPPreparedExecuteMethod startMethod = this.getExecuteMethod(epl);
            return new EPPreparedQueryImpl(startMethod, epl);
        }
        catch (EPStatementException ex) {
            throw ex;
        }
        catch (Throwable t) {
            String message = "Error executing statement: " + t.getMessage();
            log.debug(message, t);
            throw new EPStatementException(message, epl);
        }
    }

    private EPPreparedExecuteMethod getExecuteMethod(String epl) {
        String stmtName = UuidGenerator.generate();
        String stmtId = UuidGenerator.generate();
        try {
            StatementSpecRaw spec = EPAdministratorImpl.compileEPL(epl, epl, true, stmtName, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
            Annotation[] annotations = AnnotationUtil.compileAnnotations(spec.getAnnotations(), this.services.getEngineImportService(), epl);
            StatementContext statementContext = this.services.getStatementContextFactory().makeContext(stmtId, stmtName, epl, false, this.services, null, null, null, true, annotations, null);
            StatementSpecCompiled compiledSpec = StatementLifecycleSvcImpl.compile(spec, epl, statementContext, true, annotations);
            return new EPPreparedExecuteMethod(compiledSpec, this.services, statementContext);
        }
        catch (EPStatementException ex) {
            throw ex;
        }
        catch (Throwable t) {
            String message = "Error executing statement: " + t.getMessage();
            log.debug(message, t);
            throw new EPStatementException(message, epl);
        }
    }

    @Override
    public EventSender getEventSender(String eventTypeName) {
        return this.services.getEventAdapterService().getStaticTypeEventSender(this, eventTypeName, this.services.getThreadingService());
    }

    @Override
    public EventSender getEventSender(URI[] uri) throws EventTypeException {
        return this.services.getEventAdapterService().getDynamicTypeEventSender(this, uri, this.services.getThreadingService());
    }

    @Override
    public EventRenderer getEventRenderer() {
        if (this.eventRenderer == null) {
            this.eventRenderer = new EventRendererImpl();
        }
        return this.eventRenderer;
    }

    @Override
    public long getCurrentTime() {
        return this.services.getSchedulingService().getTime();
    }
}

