/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPRuntimeIsolated;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.time.CurrentTimeEvent;
import com.espertech.esper.client.time.TimerEvent;
import com.espertech.esper.collection.ArrayBackedCollection;
import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.collection.ThreadWorkQueue;
import com.espertech.esper.core.EPIsolationUnitServices;
import com.espertech.esper.core.EPRuntimeImpl;
import com.espertech.esper.core.EPServicesContext;
import com.espertech.esper.core.EPStatementHandle;
import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.core.InsertIntoLatchFactory;
import com.espertech.esper.core.InsertIntoLatchSpin;
import com.espertech.esper.core.InsertIntoLatchWait;
import com.espertech.esper.core.InternalEventRouteDest;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.ThreadLogUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPRuntimeIsolatedImpl
implements EPRuntimeIsolated,
InternalEventRouteDest {
    private EPServicesContext unisolatedServices;
    private EPIsolationUnitServices services;
    private boolean isSubselectPreeval;
    private boolean isPrioritized;
    private boolean isLatchStatementInsertStream;
    private ExprEvaluatorContext isolatedTimeEvalContext;
    private ThreadLocal<Map<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>>> matchesPerStmtThreadLocal;
    private ThreadLocal<Map<EPStatementHandle, Object>> schedulePerStmtThreadLocal;
    private ThreadLocal<ArrayBackedCollection<FilterHandle>> matchesArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<FilterHandle>>(){

        @Override
        protected synchronized ArrayBackedCollection<FilterHandle> initialValue() {
            return new ArrayBackedCollection<FilterHandle>(100);
        }
    };
    private ThreadLocal<ArrayBackedCollection<ScheduleHandle>> scheduleArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<ScheduleHandle>>(){

        @Override
        protected synchronized ArrayBackedCollection<ScheduleHandle> initialValue() {
            return new ArrayBackedCollection<ScheduleHandle>(100);
        }
    };
    private static final Log log = LogFactory.getLog(EPRuntimeImpl.class);

    public EPRuntimeIsolatedImpl(EPIsolationUnitServices svc, EPServicesContext unisolatedSvc) {
        this.services = svc;
        this.unisolatedServices = unisolatedSvc;
        this.isSubselectPreeval = unisolatedSvc.getEngineSettingsService().getEngineSettings().getExpression().isSelfSubselectPreeval();
        this.isPrioritized = unisolatedSvc.getEngineSettingsService().getEngineSettings().getExecution().isPrioritized();
        this.isLatchStatementInsertStream = unisolatedSvc.getEngineSettingsService().getEngineSettings().getThreading().isInsertIntoDispatchPreserveOrder();
        this.isolatedTimeEvalContext = new ExprEvaluatorContext(){

            public TimeProvider getTimeProvider() {
                return EPRuntimeIsolatedImpl.this.services.getSchedulingService();
            }
        };
        this.matchesPerStmtThreadLocal = new ThreadLocal<Map<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>>>(){

            @Override
            protected synchronized Map<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>> initialValue() {
                if (EPRuntimeIsolatedImpl.this.isPrioritized) {
                    return new TreeMap<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>>(new Comparator<EPStatementHandle>(){

                        @Override
                        public int compare(EPStatementHandle o1, EPStatementHandle o2) {
                            if (o1.getPriority() == o2.getPriority()) {
                                return 0;
                            }
                            return o1.getPriority() > o2.getPriority() ? -1 : 1;
                        }
                    });
                }
                return new HashMap<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>>(10000);
            }
        };
        this.schedulePerStmtThreadLocal = new ThreadLocal<Map<EPStatementHandle, Object>>(){

            @Override
            protected synchronized Map<EPStatementHandle, Object> initialValue() {
                if (EPRuntimeIsolatedImpl.this.isPrioritized) {
                    return new TreeMap<EPStatementHandle, Object>(new Comparator<EPStatementHandle>(){

                        @Override
                        public int compare(EPStatementHandle o1, EPStatementHandle o2) {
                            if (o1.getPriority() == o2.getPriority()) {
                                return 0;
                            }
                            return o1.getPriority() > o2.getPriority() ? -1 : 1;
                        }
                    });
                }
                return new HashMap<EPStatementHandle, Object>(10000);
            }
        };
    }

    @Override
    public void sendEvent(Object event) throws EPException {
        if (event == null) {
            log.fatal(".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && (!(event instanceof CurrentTimeEvent) || ExecutionPathDebugLog.isTimerDebugEnabled)) {
            log.debug(".sendEvent Processing event " + event);
        }
        this.processEvent(event);
    }

    @Override
    public void sendEvent(Node document) throws EPException {
        if (document == null) {
            log.fatal(".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendEvent Processing DOM node event " + document);
        }
        EventBean eventBean = this.unisolatedServices.getEventAdapterService().adapterForDOM(document);
        this.processEvent(eventBean);
    }

    public void route(Node document) throws EPException {
        if (document == null) {
            log.fatal(".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendEvent Processing DOM node event " + document);
        }
        EventBean eventBean = this.unisolatedServices.getEventAdapterService().adapterForDOM(document);
        ThreadWorkQueue.add(eventBean);
    }

    @Override
    public void sendEvent(Map map, String eventTypeName) throws EPException {
        if (map == null) {
            throw new IllegalArgumentException("Invalid null event object");
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendMap Processing event " + map);
        }
        EventBean eventBean = this.unisolatedServices.getEventAdapterService().adapterForMap(map, eventTypeName);
        this.processWrappedEvent(eventBean);
    }

    public void processEvent(Object event) {
        if (event instanceof TimerEvent) {
            this.processTimeEvent((TimerEvent)event);
            return;
        }
        EventBean eventBean = event instanceof EventBean ? (EventBean)event : this.unisolatedServices.getEventAdapterService().adapterForBean(event);
        this.processWrappedEvent(eventBean);
    }

    public void processWrappedEvent(EventBean eventBean) {
        this.unisolatedServices.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            throw new EPException(ex);
        }
        finally {
            this.unisolatedServices.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
        this.processThreadWorkQueue();
    }

    private void processTimeEvent(TimerEvent event) {
        CurrentTimeEvent current;
        long currentTime;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
            log.debug(".processTimeEvent Setting time and evaluating schedules");
        }
        if ((currentTime = (current = (CurrentTimeEvent)event).getTimeInMillis()) == this.services.getSchedulingService().getTime() && log.isWarnEnabled()) {
            log.warn("Duplicate time event received for currentTime " + currentTime);
        }
        this.services.getSchedulingService().setTime(currentTime);
        this.processSchedule();
        this.dispatch();
        this.processThreadWorkQueue();
    }

    private void processSchedule() {
        ArrayBackedCollection<ScheduleHandle> handles = this.scheduleArrayThreadLocal.get();
        this.unisolatedServices.getEventProcessingRWLock().acquireReadLock();
        try {
            this.services.getSchedulingService().evaluate(handles);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.unisolatedServices.getEventProcessingRWLock().releaseReadLock();
        }
        this.unisolatedServices.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processScheduleHandles(handles);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.unisolatedServices.getEventProcessingRWLock().releaseReadLock();
        }
    }

    private void processScheduleHandles(ArrayBackedCollection<ScheduleHandle> handles) {
        EPStatementHandle handle;
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.trace("Found schedules for", handles.size());
        }
        if (handles.size() == 0) {
            return;
        }
        if (handles.size() == 1) {
            Object[] handleArray = handles.getArray();
            EPStatementHandleCallback handle2 = (EPStatementHandleCallback)handleArray[0];
            EPRuntimeImpl.processStatementScheduleSingle(handle2, this.unisolatedServices, this.isolatedTimeEvalContext);
            handles.clear();
            return;
        }
        Object[] matchArray = handles.getArray();
        int entryCount = handles.size();
        Map<EPStatementHandle, Object> stmtCallbacks = this.schedulePerStmtThreadLocal.get();
        stmtCallbacks.clear();
        for (int i = 0; i < entryCount; ++i) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)matchArray[i];
            handle = handleCallback.getEpStatementHandle();
            ScheduleHandleCallback callback = handleCallback.getScheduleCallback();
            Object entry = stmtCallbacks.get(handle);
            if (entry == null) {
                stmtCallbacks.put(handle, callback);
                continue;
            }
            if (entry instanceof ScheduleHandleCallback) {
                ScheduleHandleCallback existingCallback = (ScheduleHandleCallback)entry;
                ArrayDequeJDK6Backport<ScheduleHandleCallback> entries = new ArrayDequeJDK6Backport<ScheduleHandleCallback>();
                entries.add(existingCallback);
                entries.add(callback);
                stmtCallbacks.put(handle, entries);
                continue;
            }
            ArrayDequeJDK6Backport entries = (ArrayDequeJDK6Backport)entry;
            entries.add(callback);
        }
        handles.clear();
        for (Map.Entry<EPStatementHandle, Object> entry : stmtCallbacks.entrySet()) {
            handle = entry.getKey();
            Object callbackObject = entry.getValue();
            EPRuntimeImpl.processStatementScheduleMultiple(handle, callbackObject, this.unisolatedServices, this.isolatedTimeEvalContext);
            if (!this.isPrioritized || !handle.isPreemptive()) continue;
            break;
        }
    }

    public void processThreadWorkQueue() {
        Object item;
        while ((item = ThreadWorkQueue.next()) != null) {
            if (item instanceof InsertIntoLatchSpin) {
                this.processThreadWorkQueueLatchedSpin((InsertIntoLatchSpin)item);
                continue;
            }
            if (item instanceof InsertIntoLatchWait) {
                this.processThreadWorkQueueLatchedWait((InsertIntoLatchWait)item);
                continue;
            }
            this.processThreadWorkQueueUnlatched(item);
        }
        boolean haveDispatched = this.unisolatedServices.getNamedWindowService().dispatch(this.isolatedTimeEvalContext);
        if (haveDispatched) {
            this.dispatch();
        }
        if (!ThreadWorkQueue.isEmpty()) {
            this.processThreadWorkQueue();
        }
    }

    private void processThreadWorkQueueLatchedWait(InsertIntoLatchWait insertIntoLatch) {
        Object item = insertIntoLatch.await();
        EventBean eventBean = item instanceof EventBean ? (EventBean)item : this.unisolatedServices.getEventAdapterService().adapterForBean(item);
        this.unisolatedServices.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            insertIntoLatch.done();
            this.unisolatedServices.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processThreadWorkQueueLatchedSpin(InsertIntoLatchSpin insertIntoLatch) {
        Object item = insertIntoLatch.await();
        EventBean eventBean = item instanceof EventBean ? (EventBean)item : this.unisolatedServices.getEventAdapterService().adapterForBean(item);
        this.unisolatedServices.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            insertIntoLatch.done();
            this.unisolatedServices.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processThreadWorkQueueUnlatched(Object item) {
        EventBean eventBean = item instanceof EventBean ? (EventBean)item : this.unisolatedServices.getEventAdapterService().adapterForBean(item);
        this.unisolatedServices.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.unisolatedServices.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processMatches(EventBean event) {
        EPStatementHandle handle;
        ArrayBackedCollection<FilterHandle> matches = this.matchesArrayThreadLocal.get();
        this.services.getFilterService().evaluate(event, matches, this.isolatedTimeEvalContext);
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.trace("Found matches for underlying ", matches.size(), event.getUnderlying());
        }
        if (matches.size() == 0) {
            return;
        }
        Map<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>> stmtCallbacks = this.matchesPerStmtThreadLocal.get();
        Object[] matchArray = matches.getArray();
        int entryCount = matches.size();
        for (int i = 0; i < entryCount; ++i) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)matchArray[i];
            handle = handleCallback.getEpStatementHandle();
            if (handle.isCanSelfJoin() || this.isPrioritized) {
                ArrayDequeJDK6Backport<FilterHandleCallback> callbacks = stmtCallbacks.get(handle);
                if (callbacks == null) {
                    callbacks = new ArrayDequeJDK6Backport();
                    stmtCallbacks.put(handle, callbacks);
                }
                callbacks.add(handleCallback.getFilterCallback());
                continue;
            }
            this.processStatementFilterSingle(handle, handleCallback, event);
        }
        matches.clear();
        if (stmtCallbacks.isEmpty()) {
            return;
        }
        for (Map.Entry<EPStatementHandle, ArrayDequeJDK6Backport<FilterHandleCallback>> entry : stmtCallbacks.entrySet()) {
            handle = entry.getKey();
            ArrayDequeJDK6Backport<FilterHandleCallback> callbackList = entry.getValue();
            this.processStatementFilterMultiple(handle, callbackList, event);
            if (!this.isPrioritized || !handle.isPreemptive()) continue;
            break;
        }
        stmtCallbacks.clear();
    }

    public void processStatementFilterMultiple(EPStatementHandle handle, ArrayDequeJDK6Backport<FilterHandleCallback> callbackList, EventBean event) {
        handle.getStatementLock().acquireLock(this.unisolatedServices.getStatementLockFactory());
        try {
            if (handle.isHasVariables()) {
                this.unisolatedServices.getVariableService().setLocalVersion();
            }
            if (this.isSubselectPreeval) {
                for (FilterHandleCallback callback : callbackList) {
                    if (!callback.isSubSelect()) continue;
                    callback.matchFound(event);
                }
                for (FilterHandleCallback callback : callbackList) {
                    if (callback.isSubSelect()) continue;
                    callback.matchFound(event);
                }
            } else {
                for (FilterHandleCallback callback : callbackList) {
                    if (callback.isSubSelect()) continue;
                    callback.matchFound(event);
                }
                for (FilterHandleCallback callback : callbackList) {
                    if (!callback.isSubSelect()) continue;
                    callback.matchFound(event);
                }
            }
            handle.internalDispatch(this.isolatedTimeEvalContext);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            handle.getStatementLock().releaseLock(this.unisolatedServices.getStatementLockFactory());
        }
    }

    public void processStatementFilterSingle(EPStatementHandle handle, EPStatementHandleCallback handleCallback, EventBean event) {
        handle.getStatementLock().acquireLock(this.unisolatedServices.getStatementLockFactory());
        try {
            if (handle.isHasVariables()) {
                this.unisolatedServices.getVariableService().setLocalVersion();
            }
            handleCallback.getFilterCallback().matchFound(event);
            handle.internalDispatch(this.isolatedTimeEvalContext);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            handleCallback.getEpStatementHandle().getStatementLock().releaseLock(this.unisolatedServices.getStatementLockFactory());
        }
    }

    public void dispatch() {
        try {
            this.unisolatedServices.getDispatchService().dispatch();
        }
        catch (RuntimeException ex) {
            throw new EPException(ex);
        }
    }

    public void destroy() {
        this.services = null;
        this.matchesArrayThreadLocal.remove();
        this.matchesPerStmtThreadLocal.remove();
        this.scheduleArrayThreadLocal.remove();
        this.schedulePerStmtThreadLocal.remove();
        this.matchesArrayThreadLocal = null;
        this.matchesPerStmtThreadLocal = null;
        this.scheduleArrayThreadLocal = null;
        this.schedulePerStmtThreadLocal = null;
    }

    @Override
    public long getCurrentTime() {
        return this.services.getSchedulingService().getTime();
    }

    @Override
    public void route(EventBean event, EPStatementHandle epStatementHandle) {
        if (this.isLatchStatementInsertStream) {
            InsertIntoLatchFactory insertIntoLatchFactory = epStatementHandle.getInsertIntoLatchFactory();
            Object latch = insertIntoLatchFactory.newLatch(event);
            ThreadWorkQueue.add(latch);
        } else {
            ThreadWorkQueue.add(event);
        }
    }
}

