/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.ConfigurationPluginLoader;
import com.espertech.esper.client.EPAdministrator;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPRuntime;
import com.espertech.esper.client.EPServiceProviderIsolated;
import com.espertech.esper.client.EPServiceStateListener;
import com.espertech.esper.client.EPStatementStateListener;
import com.espertech.esper.core.ConfigurationOperationsImpl;
import com.espertech.esper.core.EPAdministratorImpl;
import com.espertech.esper.core.EPRuntimeImpl;
import com.espertech.esper.core.EPServiceProviderSPI;
import com.espertech.esper.core.EPServicesContext;
import com.espertech.esper.core.EPServicesContextFactory;
import com.espertech.esper.core.EPServicesContextFactoryDefault;
import com.espertech.esper.core.EngineEnvContext;
import com.espertech.esper.core.ExtensionServicesContext;
import com.espertech.esper.core.StatementContextFactory;
import com.espertech.esper.core.StatementEventDispatcherUnthreaded;
import com.espertech.esper.core.StatementEventTypeRef;
import com.espertech.esper.core.StatementLifecycleSvc;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.metric.MetricReportingPath;
import com.espertech.esper.epl.metric.MetricReportingService;
import com.espertech.esper.epl.named.NamedWindowService;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.vaevent.ValueAddEventService;
import com.espertech.esper.filter.FilterService;
import com.espertech.esper.plugin.PluginLoader;
import com.espertech.esper.plugin.PluginLoaderInitContext;
import com.espertech.esper.schedule.SchedulingMgmtService;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.timer.TimerService;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.SerializableObjectCopier;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPServiceProviderImpl
implements EPServiceProviderSPI {
    private static final Log log = LogFactory.getLog(EPServiceProviderImpl.class);
    private volatile EPServiceEngine engine;
    private ConfigurationInformation configSnapshot;
    private String engineURI;
    private Set<EPServiceStateListener> serviceListeners;
    private Set<EPStatementStateListener> statementListeners;
    private StatementEventDispatcherUnthreaded stmtEventDispatcher;

    public EPServiceProviderImpl(Configuration configuration, String engineURI) throws ConfigurationException {
        if (configuration == null) {
            throw new NullPointerException("Unexpected null value received for configuration");
        }
        if (engineURI == null) {
            throw new NullPointerException("Engine URI should not be null at this stage");
        }
        this.engineURI = engineURI;
        this.verifyConfiguration(configuration);
        this.configSnapshot = this.takeSnapshot(configuration);
        this.serviceListeners = new CopyOnWriteArraySet<EPServiceStateListener>();
        this.statementListeners = new CopyOnWriteArraySet<EPStatementStateListener>();
        this.doInitialize();
    }

    public synchronized EPServiceProviderIsolated getEPServiceIsolated(String name) {
        if (this.engine.getServices().getConfigSnapshot().getEngineDefaults().getViewResources().isShareViews()) {
            throw new EPException("Isolated runtime requires view sharing disabled, set engine defaults under view resources and share views to false");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name parameter does not have a value provided");
        }
        return this.engine.getServices().getStatementIsolationService().getIsolationUnit(name, null);
    }

    public void postInitialize() {
        List<ConfigurationPluginLoader> pluginLoaders = this.engine.getServices().getConfigSnapshot().getPluginLoaders();
        for (ConfigurationPluginLoader config : pluginLoaders) {
            try {
                PluginLoader plugin = (PluginLoader)this.engine.getServices().getEngineEnvContext().lookup("plugin-loader/" + config.getLoaderName());
                plugin.postInitialize();
            }
            catch (Throwable t) {
                String message = "Error post-initializing plugin class " + config.getClassName() + ": " + t.getMessage();
                log.error(message, t);
                throw new EPException(message, t);
            }
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.verifyConfiguration(configuration);
        this.configSnapshot = this.takeSnapshot(configuration);
    }

    private void verifyConfiguration(Configuration configuration) {
        if (configuration.getEngineDefaults().getExecution().isPrioritized()) {
            if (!configuration.getEngineDefaults().getViewResources().isShareViews()) {
                log.info("Setting engine setting for share-views to false as execution is prioritized");
            }
            configuration.getEngineDefaults().getViewResources().setShareViews(false);
        }
    }

    public String getURI() {
        return this.engineURI;
    }

    public EPRuntime getEPRuntime() {
        return this.engine.getRuntime();
    }

    public EPAdministrator getEPAdministrator() {
        return this.engine.getAdmin();
    }

    public EPServicesContext getServicesContext() {
        return this.engine.getServices();
    }

    public ThreadingService getThreadingService() {
        return this.engine.getServices().getThreadingService();
    }

    public EventAdapterService getEventAdapterService() {
        return this.engine.getServices().getEventAdapterService();
    }

    public SchedulingService getSchedulingService() {
        return this.engine.getServices().getSchedulingService();
    }

    public FilterService getFilterService() {
        return this.engine.getServices().getFilterService();
    }

    public TimerService getTimerService() {
        return this.engine.getServices().getTimerService();
    }

    public ConfigurationInformation getConfigurationInformation() {
        return this.configSnapshot;
    }

    public NamedWindowService getNamedWindowService() {
        return this.engine.getServices().getNamedWindowService();
    }

    public ExtensionServicesContext getExtensionServicesContext() {
        return this.engine.getServices().getExtensionServicesContext();
    }

    public StatementLifecycleSvc getStatementLifecycleSvc() {
        return this.engine.getServices().getStatementLifecycleSvc();
    }

    public MetricReportingService getMetricReportingService() {
        return this.engine.getServices().getMetricsReportingService();
    }

    public ValueAddEventService getValueAddEventService() {
        return this.engine.getServices().getValueAddEventService();
    }

    public StatementEventTypeRef getStatementEventTypeRef() {
        return this.engine.getServices().getStatementEventTypeRefService();
    }

    public EngineEnvContext getEngineEnvContext() {
        return this.engine.getServices().getEngineEnvContext();
    }

    public Context getContext() {
        return this.engine.getServices().getEngineEnvContext();
    }

    public StatementContextFactory getStatementContextFactory() {
        return this.engine.getServices().getStatementContextFactory();
    }

    public void destroy() {
        if (this.engine != null) {
            for (EPServiceStateListener listener : this.serviceListeners) {
                try {
                    listener.onEPServiceDestroyRequested(this);
                }
                catch (RuntimeException ex) {
                    log.error("Runtime exception caught during an onEPServiceDestroyRequested callback:" + ex.getMessage(), ex);
                }
            }
            this.engine.getServices().getTimerService().stopInternalClock(false);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            List<ConfigurationPluginLoader> pluginLoaders = this.engine.getServices().getConfigSnapshot().getPluginLoaders();
            for (ConfigurationPluginLoader config : pluginLoaders) {
                try {
                    PluginLoader plugin = (PluginLoader)this.engine.getServices().getEngineEnvContext().lookup("plugin-loader/" + config.getLoaderName());
                    plugin.destroy();
                }
                catch (NamingException e) {}
            }
            this.engine.getRuntime().destroy();
            this.engine.getAdmin().destroy();
            this.engine.getServices().destroy();
            this.engine.getServices().initialize();
        }
        this.engine = null;
    }

    public boolean isDestroyed() {
        return this.engine == null;
    }

    public void initialize() {
        this.doInitialize();
        this.postInitialize();
    }

    protected void doInitialize() {
        EPServicesContextFactory epServicesContextFactory;
        String epServicesContextFactoryClassName;
        ExecutionPathDebugLog.setDebugEnabled(this.configSnapshot.getEngineDefaults().getLogging().isEnableExecutionDebug());
        ExecutionPathDebugLog.setTimerDebugEnabled(this.configSnapshot.getEngineDefaults().getLogging().isEnableTimerDebug());
        MetricReportingPath.setMetricsEnabled(this.configSnapshot.getEngineDefaults().getMetricsReporting().isEnableMetricsReporting());
        ThreadingOption.setThreadingEnabled(ThreadingOption.isThreadingEnabled() || this.configSnapshot.getEngineDefaults().getThreading().isThreadPoolTimerExec() || this.configSnapshot.getEngineDefaults().getThreading().isThreadPoolInbound() || this.configSnapshot.getEngineDefaults().getThreading().isThreadPoolRouteExec() || this.configSnapshot.getEngineDefaults().getThreading().isThreadPoolOutbound());
        if (this.engine != null) {
            this.engine.getServices().getTimerService().stopInternalClock(false);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.engine.getServices().destroy();
        }
        if ((epServicesContextFactoryClassName = this.configSnapshot.getEPServicesContextFactoryClassName()) == null) {
            epServicesContextFactoryClassName = System.getProperty("ESPER_EPSERVICE_CONTEXT_FACTORY_CLASS");
        }
        if (epServicesContextFactoryClassName == null) {
            epServicesContextFactory = new EPServicesContextFactoryDefault();
        } else {
            Object obj;
            Class<?> clazz;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                clazz = Class.forName(epServicesContextFactoryClassName, true, cl);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Class '" + epServicesContextFactoryClassName + "' cannot be loaded");
            }
            try {
                obj = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new ConfigurationException("Class '" + clazz + "' cannot be instantiated");
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Illegal access instantiating class '" + clazz);
            }
            epServicesContextFactory = (EPServicesContextFactory)obj;
        }
        EPServicesContext services = epServicesContextFactory.createServicesContext(this, this.configSnapshot);
        EPRuntimeImpl runtime = new EPRuntimeImpl(services);
        runtime.setInternalEventRouterImpl(services.getInternalEventRouter());
        services.setInternalEventEngineRouteDest(runtime);
        services.getTimerService().setCallback(runtime);
        services.getStatementLifecycleSvc().init();
        ConfigurationOperationsImpl configOps = new ConfigurationOperationsImpl(services.getEventAdapterService(), services.getEngineImportService(), services.getVariableService(), services.getEngineSettingsService(), services.getValueAddEventService(), services.getMetricsReportingService(), services.getStatementEventTypeRefService(), services.getStatementVariableRefService());
        SelectClauseStreamSelectorEnum defaultStreamSelector = SelectClauseStreamSelectorEnum.mapFromSODA(this.configSnapshot.getEngineDefaults().getStreamSelection().getDefaultStreamSelector());
        EPAdministratorImpl admin = new EPAdministratorImpl(services, configOps, defaultStreamSelector);
        if (this.configSnapshot.getEngineDefaults().getThreading().isInternalTimerEnabled()) {
            services.getTimerService().startInternalClock();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.engine = new EPServiceEngine(services, runtime, admin);
        this.loadAdapters(services);
        if (services.getExtensionServicesContext() != null) {
            services.getExtensionServicesContext().init();
        }
        if (this.configSnapshot.getEngineDefaults().getMetricsReporting().isEnableMetricsReporting()) {
            services.getMetricsReportingService().setContext(runtime, services);
        }
        for (EPServiceStateListener listener : this.serviceListeners) {
            try {
                listener.onEPServiceInitialized(this);
            }
            catch (RuntimeException ex) {
                log.error("Runtime exception caught during an onEPServiceInitialized callback:" + ex.getMessage(), ex);
            }
        }
    }

    private void loadAdapters(EPServicesContext services) {
        List<ConfigurationPluginLoader> pluginLoaders = this.configSnapshot.getPluginLoaders();
        if (pluginLoaders == null || pluginLoaders.size() == 0) {
            return;
        }
        for (ConfigurationPluginLoader config : pluginLoaders) {
            Object pluginLoaderObj;
            Class<?> pluginLoaderClass;
            String className = config.getClassName();
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                pluginLoaderClass = Class.forName(className, true, cl);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("Failed to load adapter loader class '" + className + "'", ex);
            }
            try {
                pluginLoaderObj = pluginLoaderClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new ConfigurationException("Failed to instantiate adapter loader class '" + className + "' via default constructor", ex);
            }
            catch (IllegalAccessException ex) {
                throw new ConfigurationException("Illegal access to instantiate adapter loader class '" + className + "' via default constructor", ex);
            }
            if (!(pluginLoaderObj instanceof PluginLoader)) {
                throw new ConfigurationException("Failed to cast adapter loader class '" + className + "' to " + PluginLoader.class.getName());
            }
            PluginLoader pluginLoader = (PluginLoader)pluginLoaderObj;
            PluginLoaderInitContext context = new PluginLoaderInitContext(config.getLoaderName(), config.getConfigProperties(), config.getConfigurationXML(), this);
            pluginLoader.init(context);
            try {
                services.getEngineEnvContext().bind("plugin-loader/" + config.getLoaderName(), (Object)pluginLoader);
            }
            catch (NamingException e) {
                throw new EPException("Failed to use context to bind adapter loader", e);
            }
        }
    }

    private ConfigurationInformation takeSnapshot(Configuration configuration) {
        try {
            return (ConfigurationInformation)SerializableObjectCopier.copy(configuration);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to snapshot configuration instance through serialization : " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Failed to snapshot configuration instance through serialization : " + e.getMessage(), e);
        }
    }

    public void addServiceStateListener(EPServiceStateListener listener) {
        this.serviceListeners.add(listener);
    }

    public boolean removeServiceStateListener(EPServiceStateListener listener) {
        return this.serviceListeners.remove(listener);
    }

    public void removeAllServiceStateListeners() {
        this.serviceListeners.clear();
    }

    public synchronized void addStatementStateListener(EPStatementStateListener listener) {
        if (this.statementListeners.isEmpty()) {
            this.stmtEventDispatcher = new StatementEventDispatcherUnthreaded(this, this.statementListeners);
            this.getStatementLifecycleSvc().addObserver(this.stmtEventDispatcher);
        }
        this.statementListeners.add(listener);
    }

    public synchronized boolean removeStatementStateListener(EPStatementStateListener listener) {
        boolean result = this.statementListeners.remove(listener);
        if (this.statementListeners.isEmpty()) {
            this.getStatementLifecycleSvc().removeObserver(this.stmtEventDispatcher);
            this.stmtEventDispatcher = null;
        }
        return result;
    }

    public synchronized void removeAllStatementStateListeners() {
        this.statementListeners.clear();
        if (this.statementListeners.isEmpty()) {
            this.getStatementLifecycleSvc().removeObserver(this.stmtEventDispatcher);
            this.stmtEventDispatcher = null;
        }
    }

    public String[] getEPServiceIsolatedNames() {
        return this.engine.getServices().getStatementIsolationService().getIsolationUnitNames();
    }

    public SchedulingMgmtService getSchedulingMgmtService() {
        return this.engine.getServices().getSchedulingMgmtService();
    }

    public EngineImportService getEngineImportService() {
        return this.engine.getServices().getEngineImportService();
    }

    public TimeProvider getTimeProvider() {
        return this.engine.getServices().getSchedulingService();
    }

    private static class EPServiceEngine {
        private EPServicesContext services;
        private EPRuntimeImpl runtime;
        private EPAdministratorImpl admin;

        public EPServiceEngine(EPServicesContext services, EPRuntimeImpl runtime, EPAdministratorImpl admin) {
            this.services = services;
            this.runtime = runtime;
            this.admin = admin;
        }

        public EPServicesContext getServices() {
            return this.services;
        }

        public EPRuntimeImpl getRuntime() {
            return this.runtime;
        }

        public EPAdministratorImpl getAdmin() {
            return this.admin;
        }
    }
}

