/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.core.EPStatementDispatch;
import com.espertech.esper.core.InsertIntoLatchFactory;
import com.espertech.esper.core.StatementFilterVersion;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.metric.StatementMetricHandle;
import com.espertech.esper.util.ManagedLock;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;

public class EPStatementHandle
implements MetaDefItem,
Serializable {
    private static final long serialVersionUID = 0L;
    private final String statementId;
    private transient ManagedLock statementLock;
    private final int hashCode;
    private transient EPStatementDispatch optionalDispatchable;
    private boolean canSelfJoin;
    private boolean hasVariables;
    private final int priority;
    private final boolean preemptive;
    private transient InsertIntoLatchFactory insertIntoLatchFactory;
    private transient StatementMetricHandle metricsHandle;
    private final StatementFilterVersion statementFilterVersion;

    public EPStatementHandle(String statementId, ManagedLock statementLock, String expressionText, boolean hasVariables, StatementMetricHandle metricsHandle, int priority, boolean preemptive, StatementFilterVersion statementFilterVersion) {
        this.statementId = statementId;
        this.statementLock = statementLock;
        this.hasVariables = hasVariables;
        this.metricsHandle = metricsHandle;
        this.priority = priority;
        this.preemptive = preemptive;
        this.statementFilterVersion = statementFilterVersion;
        this.hashCode = expressionText.hashCode() ^ statementLock.hashCode();
    }

    public boolean isCurrentFilter(long filterVersion) {
        return this.statementFilterVersion.isCurrentFilter(filterVersion);
    }

    public void setCanSelfJoin(boolean canSelfJoin) {
        this.canSelfJoin = canSelfJoin;
    }

    public String getStatementId() {
        return this.statementId;
    }

    public void setInsertIntoLatchFactory(InsertIntoLatchFactory insertIntoLatchFactory) {
        this.insertIntoLatchFactory = insertIntoLatchFactory;
    }

    public InsertIntoLatchFactory getInsertIntoLatchFactory() {
        return this.insertIntoLatchFactory;
    }

    public ManagedLock getStatementLock() {
        return this.statementLock;
    }

    public boolean isHasVariables() {
        return this.hasVariables;
    }

    public void setStatementLock(ManagedLock statementLock) {
        this.statementLock = statementLock;
    }

    public void setOptionalDispatchable(EPStatementDispatch optionalDispatchable) {
        this.optionalDispatchable = optionalDispatchable;
    }

    public void internalDispatch(ExprEvaluatorContext exprEvaluatorContext) {
        if (this.optionalDispatchable != null) {
            this.optionalDispatchable.execute(exprEvaluatorContext);
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isPreemptive() {
        return this.preemptive;
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof EPStatementHandle)) {
            return false;
        }
        EPStatementHandle other = (EPStatementHandle)otherObj;
        return other.statementId.equals(this.statementId);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isCanSelfJoin() {
        return this.canSelfJoin;
    }

    public StatementMetricHandle getMetricsHandle() {
        return this.metricsHandle;
    }

    public EPStatementDispatch getOptionalDispatchable() {
        return this.optionalDispatchable;
    }
}

