/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EPStatementState;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.client.StatementAwareUpdateListener;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.collection.SafeIteratorImpl;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.EPStatementListenerSet;
import com.espertech.esper.core.EPStatementSPI;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.core.StatementLifecycleEvent;
import com.espertech.esper.core.StatementLifecycleSvc;
import com.espertech.esper.core.StatementMetadata;
import com.espertech.esper.core.UpdateDispatchViewBase;
import com.espertech.esper.core.UpdateDispatchViewBlockingSpin;
import com.espertech.esper.core.UpdateDispatchViewBlockingWait;
import com.espertech.esper.core.UpdateDispatchViewNonBlocking;
import com.espertech.esper.dispatch.DispatchService;
import com.espertech.esper.timer.TimeSourceService;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPStatementImpl
implements EPStatementSPI {
    private static Log log = LogFactory.getLog(EPStatementImpl.class);
    private final EPStatementListenerSet statementListenerSet;
    private final String statementId;
    private final String statementName;
    private final String expressionText;
    private final String expressionNoAnnotations;
    private final boolean nameProvided;
    private boolean isPattern;
    private UpdateDispatchViewBase dispatchChildView;
    private StatementLifecycleSvc statementLifecycleSvc;
    private long timeLastStateChange;
    private Viewable parentView;
    private EPStatementState currentState;
    private EventType eventType;
    private StatementMetadata statementMetadata;
    private Object userObject;
    private Annotation[] annotations;
    private StatementContext statementContext;
    private String serviceIsolated;

    public EPStatementImpl(String statementId, String statementName, String expressionText, String expressionNoAnnotations, boolean isPattern, DispatchService dispatchService, StatementLifecycleSvc statementLifecycleSvc, long timeLastStateChange, boolean isBlockingDispatch, boolean isSpinBlockingDispatch, long msecBlockingTimeout, TimeSourceService timeSourceService, StatementMetadata statementMetadata, Object userObject, Annotation[] annotations, StatementContext statementContext, boolean isFailed, boolean nameProvided) {
        this.isPattern = isPattern;
        this.statementId = statementId;
        this.statementName = statementName;
        this.expressionText = expressionText;
        this.expressionNoAnnotations = expressionNoAnnotations;
        this.statementLifecycleSvc = statementLifecycleSvc;
        this.statementContext = statementContext;
        this.nameProvided = nameProvided;
        this.statementListenerSet = new EPStatementListenerSet();
        this.dispatchChildView = isBlockingDispatch ? (isSpinBlockingDispatch ? new UpdateDispatchViewBlockingSpin(statementContext.getStatementResultService(), dispatchService, msecBlockingTimeout, timeSourceService) : new UpdateDispatchViewBlockingWait(statementContext.getStatementResultService(), dispatchService, msecBlockingTimeout)) : new UpdateDispatchViewNonBlocking(statementContext.getStatementResultService(), dispatchService);
        this.currentState = !isFailed ? EPStatementState.STOPPED : EPStatementState.FAILED;
        this.timeLastStateChange = timeLastStateChange;
        this.statementMetadata = statementMetadata;
        this.userObject = userObject;
        this.annotations = annotations;
        statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet);
    }

    @Override
    public String getStatementId() {
        return this.statementId;
    }

    @Override
    public void start() {
        if (this.statementLifecycleSvc == null) {
            throw new IllegalStateException("Cannot start statement, statement is in destroyed state");
        }
        this.statementLifecycleSvc.start(this.statementId);
    }

    @Override
    public void stop() {
        if (this.statementLifecycleSvc == null) {
            throw new IllegalStateException("Cannot stop statement, statement is in destroyed state");
        }
        this.statementLifecycleSvc.stop(this.statementId);
        this.statementContext.getStatementResultService().dispatchOnStop();
        this.dispatchChildView.clear();
    }

    @Override
    public void destroy() {
        if (this.currentState == EPStatementState.DESTROYED) {
            throw new IllegalStateException("Statement already destroyed");
        }
        this.statementLifecycleSvc.destroy(this.statementId);
        this.parentView = null;
        this.eventType = null;
        this.dispatchChildView = null;
        this.statementLifecycleSvc = null;
    }

    @Override
    public EPStatementState getState() {
        return this.currentState;
    }

    @Override
    public void setCurrentState(EPStatementState currentState, long timeLastStateChange) {
        this.currentState = currentState;
        this.timeLastStateChange = timeLastStateChange;
    }

    @Override
    public void setParentView(Viewable viewable) {
        if (viewable == null) {
            if (this.parentView != null) {
                this.parentView.removeView(this.dispatchChildView);
            }
            this.parentView = null;
        } else {
            this.parentView = viewable;
            this.parentView.addView(this.dispatchChildView);
            this.eventType = this.parentView.getEventType();
        }
    }

    @Override
    public String getText() {
        return this.expressionText;
    }

    @Override
    public String getName() {
        return this.statementName;
    }

    @Override
    public Iterator<EventBean> iterator() {
        this.statementContext.getVariableService().setLocalVersion();
        if (this.parentView == null) {
            return null;
        }
        if (this.isPattern) {
            return new SingleEventIterator(this.statementContext.getStatementResultService().getLastIterableEvent());
        }
        return this.parentView.iterator();
    }

    @Override
    public SafeIterator<EventBean> safeIterator() {
        if (this.parentView == null) {
            return null;
        }
        this.statementContext.getEpStatementHandle().getStatementLock().acquireLock(null);
        try {
            this.statementContext.getVariableService().setLocalVersion();
            if (this.isPattern) {
                return new SafeIteratorImpl<EventBean>(this.statementContext.getEpStatementHandle().getStatementLock(), this.dispatchChildView.iterator());
            }
            return new SafeIteratorImpl<EventBean>(this.statementContext.getEpStatementHandle().getStatementLock(), this.parentView.iterator());
        }
        catch (RuntimeException ex) {
            this.statementContext.getEpStatementHandle().getStatementLock().releaseLock(null);
            throw ex;
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public EPStatementListenerSet getListenerSet() {
        return this.statementListenerSet;
    }

    @Override
    public void setListeners(EPStatementListenerSet listenerSet) {
        this.statementListenerSet.setListeners(listenerSet);
        this.statementContext.getStatementResultService().setUpdateListeners(listenerSet);
    }

    @Override
    public void addListener(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        if (this.isDestroyed()) {
            throw new IllegalStateException("Statement is in destroyed state");
        }
        this.statementListenerSet.addListener(listener);
        this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet);
        this.statementLifecycleSvc.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(this, StatementLifecycleEvent.LifecycleEventType.LISTENER_ADD, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListenerWithReplay(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        if (this.isDestroyed()) {
            throw new IllegalStateException("Statement is in destroyed state");
        }
        this.statementContext.getEpStatementHandle().getStatementLock().acquireLock(null);
        try {
            this.statementListenerSet.addListener(listener);
            this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet);
            this.statementLifecycleSvc.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(this, StatementLifecycleEvent.LifecycleEventType.LISTENER_ADD, listener));
            Iterator<EventBean> it = this.iterator();
            if (it == null) {
                try {
                    listener.update(null, null);
                }
                catch (Throwable t) {
                    String message = "Unexpected exception invoking listener update method for replay on listener class '" + listener.getClass().getSimpleName() + "' : " + t.getClass().getSimpleName() + " : " + t.getMessage();
                    log.error(message, t);
                }
                return;
            }
            ArrayList<EventBean> events = new ArrayList<EventBean>();
            while (it.hasNext()) {
                events.add(it.next());
            }
            if (events.isEmpty()) {
                try {
                    listener.update(null, null);
                }
                catch (Throwable t) {
                    String message = "Unexpected exception invoking listener update method for replay on listener class '" + listener.getClass().getSimpleName() + "' : " + t.getClass().getSimpleName() + " : " + t.getMessage();
                    log.error(message, t);
                }
            } else {
                EventBean[] iteratorResult = events.toArray(new EventBean[events.size()]);
                try {
                    listener.update(iteratorResult, null);
                }
                catch (Throwable t) {
                    String message = "Unexpected exception invoking listener update method for replay on listener class '" + listener.getClass().getSimpleName() + "' : " + t.getClass().getSimpleName() + " : " + t.getMessage();
                    log.error(message, t);
                }
            }
        }
        finally {
            this.statementContext.getEpStatementHandle().getStatementLock().releaseLock(null);
        }
    }

    @Override
    public void removeListener(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        this.statementListenerSet.removeListener(listener);
        this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet);
        if (this.statementLifecycleSvc != null) {
            this.statementLifecycleSvc.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(this, StatementLifecycleEvent.LifecycleEventType.LISTENER_REMOVE, listener));
        }
    }

    @Override
    public void removeAllListeners() {
        this.statementListenerSet.removeAllListeners();
        this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet);
        if (this.statementLifecycleSvc != null) {
            this.statementLifecycleSvc.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(this, StatementLifecycleEvent.LifecycleEventType.LISTENER_REMOVE_ALL, new Object[0]));
        }
    }

    @Override
    public void addListener(StatementAwareUpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        if (this.isDestroyed()) {
            throw new IllegalStateException("Statement is in destroyed state");
        }
        this.statementListenerSet.addListener(listener);
        this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet);
        this.statementLifecycleSvc.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(this, StatementLifecycleEvent.LifecycleEventType.LISTENER_ADD, listener));
    }

    @Override
    public void removeListener(StatementAwareUpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        this.statementListenerSet.removeListener(listener);
        this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet);
        if (this.statementLifecycleSvc != null) {
            this.statementLifecycleSvc.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(this, StatementLifecycleEvent.LifecycleEventType.LISTENER_REMOVE, listener));
        }
    }

    @Override
    public Iterator<StatementAwareUpdateListener> getStatementAwareListeners() {
        return this.statementListenerSet.getStmtAwareListeners().iterator();
    }

    @Override
    public Iterator<UpdateListener> getUpdateListeners() {
        return this.statementListenerSet.getListeners().iterator();
    }

    @Override
    public long getTimeLastStateChange() {
        return this.timeLastStateChange;
    }

    @Override
    public boolean isStarted() {
        return this.currentState == EPStatementState.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.currentState == EPStatementState.STOPPED;
    }

    @Override
    public boolean isDestroyed() {
        return this.currentState == EPStatementState.DESTROYED;
    }

    @Override
    public void setSubscriber(Object subscriber) {
        this.statementListenerSet.setSubscriber(subscriber);
        this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet);
    }

    @Override
    public Object getSubscriber() {
        return this.statementListenerSet.getSubscriber();
    }

    @Override
    public boolean isPattern() {
        return this.isPattern;
    }

    @Override
    public StatementMetadata getStatementMetadata() {
        return this.statementMetadata;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public StatementContext getStatementContext() {
        return this.statementContext;
    }

    @Override
    public String getExpressionNoAnnotations() {
        return this.expressionNoAnnotations;
    }

    @Override
    public String getServiceIsolated() {
        return this.serviceIsolated;
    }

    @Override
    public void setServiceIsolated(String serviceIsolated) {
        this.serviceIsolated = serviceIsolated;
    }

    @Override
    public boolean isNameProvided() {
        return this.nameProvided;
    }
}

