/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EPStatementException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.VariableValueException;
import com.espertech.esper.client.annotation.HookType;
import com.espertech.esper.client.hook.SQLColumnTypeConversion;
import com.espertech.esper.client.hook.SQLOutputRowConversion;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.EPServicesContext;
import com.espertech.esper.core.EPStatementDestroyMethod;
import com.espertech.esper.core.EPStatementStartResult;
import com.espertech.esper.core.EPStatementStopMethod;
import com.espertech.esper.core.InternalEventRouterImpl;
import com.espertech.esper.core.InternalRoutePreprocessView;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.core.StatementLifecycleSvcImpl;
import com.espertech.esper.core.StreamJoinAnalysisResult;
import com.espertech.esper.core.SubSelectStreamCollection;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.agg.AggregationServiceFactory;
import com.espertech.esper.epl.core.MethodPollingViewableFactory;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactory;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.core.ViewResourceDelegateImpl;
import com.espertech.esper.epl.db.DatabasePollingViewableFactory;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprEqualsNode;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeIdentifierVisitor;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.join.JoinExecStrategyDispatchable;
import com.espertech.esper.epl.join.JoinExecutionStrategyImpl;
import com.espertech.esper.epl.join.JoinPreloadMethod;
import com.espertech.esper.epl.join.JoinPreloadMethodImpl;
import com.espertech.esper.epl.join.JoinPreloadMethodNull;
import com.espertech.esper.epl.join.JoinSetComposer;
import com.espertech.esper.epl.join.JoinSetFilter;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzer;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndTableCoerceAdd;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.join.table.UnindexedEventTable;
import com.espertech.esper.epl.lookup.FullTableScanLookupStrategy;
import com.espertech.esper.epl.lookup.IndexedTableLookupStrategy;
import com.espertech.esper.epl.lookup.IndexedTableLookupStrategyCoercing;
import com.espertech.esper.epl.lookup.JoinedPropDesc;
import com.espertech.esper.epl.lookup.TableLookupStrategy;
import com.espertech.esper.epl.lookup.TableLookupStrategyNullRow;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowRootView;
import com.espertech.esper.epl.named.NamedWindowTailView;
import com.espertech.esper.epl.named.NotADataWindowViewCapability;
import com.espertech.esper.epl.named.RemoveStreamViewCapability;
import com.espertech.esper.epl.spec.CreateIndexDesc;
import com.espertech.esper.epl.spec.CreateVariableDesc;
import com.espertech.esper.epl.spec.DBStatementStreamSpec;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.OnTriggerDesc;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.OnTriggerSetDesc;
import com.espertech.esper.epl.spec.OnTriggerSplitStream;
import com.espertech.esper.epl.spec.OnTriggerSplitStreamDesc;
import com.espertech.esper.epl.spec.OnTriggerType;
import com.espertech.esper.epl.spec.OnTriggerWindowDesc;
import com.espertech.esper.epl.spec.OnTriggerWindowUpdateDesc;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.epl.spec.PatternStreamSpecCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecCompiled;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.UpdateDesc;
import com.espertech.esper.epl.subquery.SubqueryStopCallback;
import com.espertech.esper.epl.subquery.SubselectAggregatorView;
import com.espertech.esper.epl.subquery.SubselectBufferObserver;
import com.espertech.esper.epl.variable.CreateVariableView;
import com.espertech.esper.epl.variable.OnSetVariableView;
import com.espertech.esper.epl.variable.VariableDeclarationException;
import com.espertech.esper.epl.variable.VariableExistsException;
import com.espertech.esper.epl.view.FilterExprView;
import com.espertech.esper.epl.view.OutputConditionExpression;
import com.espertech.esper.epl.view.OutputProcessView;
import com.espertech.esper.epl.view.OutputProcessViewFactory;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.pattern.EvalRootNode;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.pattern.PatternMatchCallback;
import com.espertech.esper.pattern.PatternStopCallback;
import com.espertech.esper.rowregex.EventRowRegexNFAViewFactory;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.ManagedLock;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.BatchingDataWindowView;
import com.espertech.esper.view.EventStream;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.StatementStopCallback;
import com.espertech.esper.view.ValidatedView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryChain;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.Viewable;
import com.espertech.esper.view.ZeroDepthStream;
import com.espertech.esper.view.internal.BufferView;
import com.espertech.esper.view.internal.RouteResultView;
import com.espertech.esper.view.internal.SingleStreamDispatchView;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPStatementStartMethod {
    private static final Log log = LogFactory.getLog(EPStatementStartMethod.class);
    private final StatementSpecCompiled statementSpec;
    private final EPServicesContext services;
    private final StatementContext statementContext;

    public EPStatementStartMethod(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) {
        this.statementSpec = statementSpec;
        this.services = services;
        this.statementContext = statementContext;
    }

    public EPStatementStartResult start(boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        this.statementContext.getVariableService().setLocalVersion();
        if (this.statementSpec.getUpdateSpec() != null) {
            return this.startUpdate();
        }
        if (this.statementSpec.getOnTriggerDesc() != null) {
            return this.startOnTrigger();
        }
        if (this.statementSpec.getCreateWindowDesc() != null) {
            return this.startCreateWindow(isNewStatement, isRecoveringStatement);
        }
        if (this.statementSpec.getCreateIndexDesc() != null) {
            return this.startCreateIndex();
        }
        if (this.statementSpec.getCreateVariableDesc() != null) {
            return this.startCreateVariable(isNewStatement);
        }
        return this.startSelect(isRecoveringResilient);
    }

    private EPStatementStartResult startCreateIndex() throws ExprValidationException, ViewProcessingException {
        final CreateIndexDesc spec = this.statementSpec.getCreateIndexDesc();
        final NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(spec.getWindowName());
        processor.getRootView().addExplicitIndex(spec.getWindowName(), spec.getIndexName(), spec.getColumns());
        Viewable viewable = new Viewable(){

            @Override
            public View addView(View view) {
                return null;
            }

            @Override
            public List<View> getViews() {
                return null;
            }

            @Override
            public boolean removeView(View view) {
                return false;
            }

            @Override
            public void removeAllViews() {
            }

            @Override
            public boolean hasViews() {
                return false;
            }

            @Override
            public EventType getEventType() {
                return processor.getNamedWindowType();
            }

            @Override
            public Iterator<EventBean> iterator() {
                return new ArrayEventIterator(null);
            }
        };
        EPStatementStopMethod stopMethod = new EPStatementStopMethod(){

            public void stop() {
                processor.getRootView().removeExplicitIndex(spec.getIndexName());
            }
        };
        EPStatementStartResult result = new EPStatementStartResult(viewable, stopMethod, null);
        return result;
    }

    private EPStatementStartResult startOnTrigger() throws ExprValidationException, ViewProcessingException {
        OnTriggerDesc desc;
        View onExprView;
        Viewable eventStreamParentViewable;
        final LinkedList<StopCallback> stopCallbacks = new LinkedList<StopCallback>();
        SubSelectStreamCollection subSelectStreamDesc = this.createSubSelectStreams(true);
        final StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs().get(0);
        String triggereventTypeName = null;
        if (streamSpec instanceof FilterStreamSpecCompiled) {
            FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
            triggereventTypeName = filterStreamSpec.getFilterSpec().getFilterForEventTypeName();
            Pair<EventStream, ManagedLock> streamLockPair = this.services.getStreamService().createStream(this.statementContext.getStatementId(), filterStreamSpec.getFilterSpec(), this.statementContext.getFilterService(), this.statementContext.getEpStatementHandle(), false, false, this.statementContext, true);
            eventStreamParentViewable = streamLockPair.getFirst();
            if (streamLockPair.getSecond() != null) {
                this.statementContext.getEpStatementHandle().setStatementLock(streamLockPair.getSecond());
            }
        } else if (streamSpec instanceof PatternStreamSpecCompiled) {
            PatternStreamSpecCompiled patternStreamSpec = (PatternStreamSpecCompiled)streamSpec;
            boolean usedByChildViews = !streamSpec.getViewSpecs().isEmpty() || this.statementSpec.getInsertIntoDesc() != null;
            final EventType eventType = this.services.getEventAdapterService().createSemiAnonymousMapType(patternStreamSpec.getTaggedEventTypes(), patternStreamSpec.getArrayEventTypes(), usedByChildViews);
            final ZeroDepthStream sourceEventStream = new ZeroDepthStream(eventType);
            eventStreamParentViewable = sourceEventStream;
            EvalRootNode rootNode = new EvalRootNode();
            rootNode.addChildNode(patternStreamSpec.getEvalNode());
            PatternMatchCallback callback = new PatternMatchCallback(){

                @Override
                public void matchFound(Map<String, Object> matchEvent) {
                    EventBean compositeEvent = EPStatementStartMethod.this.statementContext.getEventAdapterService().adaptorForTypedMap(matchEvent, eventType);
                    sourceEventStream.insert(compositeEvent);
                }
            };
            PatternContext patternContext = this.statementContext.getPatternContextFactory().createContext(this.statementContext, 0, rootNode, !patternStreamSpec.getArrayEventTypes().isEmpty());
            PatternStopCallback patternStopCallback = rootNode.start(callback, patternContext);
            stopCallbacks.add(patternStopCallback);
        } else if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
            eventStreamParentViewable = processor.addConsumer(namedSpec.getFilterExpressions(), this.statementContext.getEpStatementHandle(), this.statementContext.getStatementStopService());
            triggereventTypeName = namedSpec.getWindowName();
        } else {
            throw new ExprValidationException("Unknown stream specification type: " + streamSpec);
        }
        EventType streamEventType = eventStreamParentViewable.getEventType();
        if (this.statementSpec.getOnTriggerDesc() instanceof OnTriggerWindowDesc) {
            String streamName;
            OnTriggerWindowDesc onTriggerDesc = (OnTriggerWindowDesc)this.statementSpec.getOnTriggerDesc();
            NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(onTriggerDesc.getWindowName());
            EventType namedWindowType = processor.getNamedWindowType();
            this.statementContext.getDynamicReferenceEventTypes().add(onTriggerDesc.getWindowName());
            String namedWindowName = onTriggerDesc.getOptionalAsName();
            if (namedWindowName == null) {
                namedWindowName = "stream_0";
            }
            if ((streamName = streamSpec.getOptionalStreamName()) == null) {
                streamName = "stream_1";
            }
            String namedWindowTypeName = onTriggerDesc.getWindowName();
            this.startSubSelect(subSelectStreamDesc, new String[]{namedWindowName, streamSpec.getOptionalStreamName()}, new EventType[]{processor.getNamedWindowType(), streamEventType}, new String[]{namedWindowTypeName, triggereventTypeName}, stopCallbacks, this.statementSpec.getAnnotations());
            StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{namedWindowType, streamEventType}, new String[]{namedWindowName, streamName}, new boolean[]{false, true}, this.services.getEngineURI());
            if (onTriggerDesc instanceof OnTriggerWindowUpdateDesc) {
                OnTriggerWindowUpdateDesc updateDesc = (OnTriggerWindowUpdateDesc)onTriggerDesc;
                for (OnTriggerSetAssignment assignment : updateDesc.getAssignments()) {
                    ExprNode validated = assignment.getExpression().getValidatedSubtree(typeService, this.statementContext.getMethodResolutionService(), null, this.statementContext.getSchedulingService(), this.statementContext.getVariableService(), this.statementContext);
                    assignment.setExpression(validated);
                    EPStatementStartMethod.validateNoAggregations(validated, "Aggregation functions may not be used within an on-update-clause");
                }
            }
            ExprNode validatedJoin = this.validateJoinNamedWindow(this.statementSpec.getFilterRootNode(), namedWindowType, namedWindowName, namedWindowTypeName, streamEventType, streamName, triggereventTypeName);
            EPStatementStartMethod.validateNodes(this.statementSpec, this.statementContext, typeService, null);
            if (this.statementSpec.getSelectClauseSpec().getSelectExprList().size() == 0) {
                this.statementSpec.getSelectClauseSpec().add(new SelectClauseElementWildcard());
            }
            ResultSetProcessor resultSetProcessor = ResultSetProcessorFactory.getProcessor(this.statementSpec, this.statementContext, typeService, null, new boolean[0], true);
            InternalEventRouterImpl routerService = this.statementSpec.getInsertIntoDesc() == null ? null : this.services.getInternalEventRouter();
            onExprView = processor.addOnExpr(onTriggerDesc, validatedJoin, streamEventType, this.statementContext.getStatementStopService(), routerService, resultSetProcessor, this.statementContext.getEpStatementHandle(), this.statementContext.getStatementResultService(), this.statementContext, this.statementSpec.getSelectClauseSpec().isDistinct());
            eventStreamParentViewable.addView(onExprView);
        } else if (this.statementSpec.getOnTriggerDesc() instanceof OnTriggerSetDesc) {
            desc = (OnTriggerSetDesc)this.statementSpec.getOnTriggerDesc();
            StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{streamEventType}, new String[]{streamSpec.getOptionalStreamName()}, new boolean[]{true}, this.services.getEngineURI());
            this.startSubSelect(subSelectStreamDesc, new String[]{streamSpec.getOptionalStreamName()}, new EventType[]{streamEventType}, new String[]{triggereventTypeName}, stopCallbacks, this.statementSpec.getAnnotations());
            for (OnTriggerSetAssignment assignment : ((OnTriggerSetDesc)desc).getAssignments()) {
                ExprNode validated = assignment.getExpression().getValidatedSubtree(typeService, this.statementContext.getMethodResolutionService(), null, this.statementContext.getSchedulingService(), this.statementContext.getVariableService(), this.statementContext);
                assignment.setExpression(validated);
            }
            try {
                onExprView = new OnSetVariableView((OnTriggerSetDesc)desc, this.statementContext.getEventAdapterService(), this.statementContext.getVariableService(), this.statementContext.getStatementResultService(), this.statementContext);
            }
            catch (VariableValueException ex) {
                throw new ExprValidationException("Error in variable assignment: " + ex.getMessage(), ex);
            }
            eventStreamParentViewable.addView(onExprView);
        } else {
            desc = (OnTriggerSplitStreamDesc)this.statementSpec.getOnTriggerDesc();
            String streamName = streamSpec.getOptionalStreamName();
            if (streamName == null) {
                streamName = "stream_0";
            }
            StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{streamEventType}, new String[]{streamName}, new boolean[]{true}, this.services.getEngineURI());
            if (this.statementSpec.getInsertIntoDesc() == null) {
                throw new ExprValidationException("Required insert-into clause is not provided, the clause is required for split-stream syntax");
            }
            if (!this.statementSpec.getGroupByExpressions().isEmpty() || this.statementSpec.getHavingExprRootNode() != null || !this.statementSpec.getOrderByList().isEmpty()) {
                throw new ExprValidationException("A group-by clause, having-clause or order-by clause is not allowed for the split stream syntax");
            }
            this.startSubSelect(subSelectStreamDesc, new String[]{streamSpec.getOptionalStreamName()}, new EventType[]{streamEventType}, new String[]{triggereventTypeName}, stopCallbacks, this.statementSpec.getAnnotations());
            EPStatementStartMethod.validateNodes(this.statementSpec, this.statementContext, typeService, null);
            ResultSetProcessor[] processors = new ResultSetProcessor[((OnTriggerSplitStreamDesc)desc).getSplitStreams().size() + 1];
            ExprNode[] whereClauses = new ExprNode[((OnTriggerSplitStreamDesc)desc).getSplitStreams().size() + 1];
            processors[0] = ResultSetProcessorFactory.getProcessor(this.statementSpec, this.statementContext, typeService, null, new boolean[0], false);
            whereClauses[0] = this.statementSpec.getFilterRootNode();
            int index = 1;
            for (OnTriggerSplitStream splits : ((OnTriggerSplitStreamDesc)desc).getSplitStreams()) {
                StatementSpecCompiled splitSpec = new StatementSpecCompiled();
                splitSpec.setInsertIntoDesc(splits.getInsertInto());
                splitSpec.setSelectClauseSpec(StatementLifecycleSvcImpl.compileSelectAllowSubselect(splits.getSelectClause()));
                splitSpec.setFilterExprRootNode(splits.getWhereClause());
                EPStatementStartMethod.validateNodes(splitSpec, this.statementContext, typeService, null);
                processors[index] = ResultSetProcessorFactory.getProcessor(splitSpec, this.statementContext, typeService, null, new boolean[0], false);
                whereClauses[index] = splitSpec.getFilterRootNode();
                ++index;
            }
            onExprView = new RouteResultView(((OnTriggerSplitStreamDesc)desc).isFirst(), streamEventType, this.statementContext.getEpStatementHandle(), this.services.getInternalEventRouter(), processors, whereClauses, this.statementContext);
            eventStreamParentViewable.addView(onExprView);
        }
        EPStatementStopMethod stopMethod = new EPStatementStopMethod(){

            public void stop() {
                EPStatementStartMethod.this.statementContext.getStatementStopService().fireStatementStopped();
                if (streamSpec instanceof FilterStreamSpecCompiled) {
                    FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
                    EPStatementStartMethod.this.services.getStreamService().dropStream(filterStreamSpec.getFilterSpec(), EPStatementStartMethod.this.statementContext.getFilterService(), false, false, true);
                }
                for (StopCallback stopCallback : stopCallbacks) {
                    stopCallback.stop();
                }
            }
        };
        if (this.statementSpec.getOnTriggerDesc().getOnTriggerType() == OnTriggerType.ON_DELETE || this.statementSpec.getOnTriggerDesc().getOnTriggerType() == OnTriggerType.ON_SET || this.statementSpec.getOnTriggerDesc().getOnTriggerType() == OnTriggerType.ON_UPDATE) {
            StatementSpecCompiled defaultSelectAllSpec = new StatementSpecCompiled();
            defaultSelectAllSpec.getSelectClauseSpec().add(new SelectClauseElementWildcard());
            StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(new EventType[]{onExprView.getEventType()}, new String[]{"trigger_stream"}, new boolean[]{true}, this.services.getEngineURI());
            ResultSetProcessor outputResultSetProcessor = ResultSetProcessorFactory.getProcessor(defaultSelectAllSpec, this.statementContext, streamTypeService, null, new boolean[0], true);
            OutputProcessView outputView = OutputProcessViewFactory.makeView(outputResultSetProcessor, defaultSelectAllSpec, this.statementContext, this.services.getInternalEventRouter());
            onExprView.addView(outputView);
            onExprView = outputView;
        }
        log.debug(".start Statement start completed");
        return new EPStatementStartResult(onExprView, stopMethod);
    }

    private EPStatementStartResult startUpdate() throws ExprValidationException, ViewProcessingException {
        String triggereventTypeName;
        final LinkedList<StopCallback> stopCallbacks = new LinkedList<StopCallback>();
        SubSelectStreamCollection subSelectStreamDesc = this.createSubSelectStreams(false);
        StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs().get(0);
        final UpdateDesc desc = this.statementSpec.getUpdateSpec();
        if (streamSpec instanceof FilterStreamSpecCompiled) {
            FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
            triggereventTypeName = filterStreamSpec.getFilterSpec().getFilterForEventTypeName();
        } else if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            triggereventTypeName = namedSpec.getWindowName();
        } else {
            throw new ExprValidationException("Unknown stream specification streamEventType: " + streamSpec);
        }
        String streamName = triggereventTypeName;
        if (desc.getOptionalStreamName() != null) {
            streamName = desc.getOptionalStreamName();
        }
        final EventType streamEventType = this.services.getEventAdapterService().getExistsTypeByName(triggereventTypeName);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{streamEventType}, new String[]{streamName}, new boolean[]{true}, this.services.getEngineURI());
        this.statementContext.getStatementResultService().setSelectClause(new Class[]{streamEventType.getUnderlyingType()}, new String[]{"*"});
        this.startSubSelect(subSelectStreamDesc, new String[]{streamName}, new EventType[]{streamEventType}, new String[]{triggereventTypeName}, stopCallbacks, this.statementSpec.getAnnotations());
        for (OnTriggerSetAssignment assignment : desc.getAssignments()) {
            ExprNode validated = assignment.getExpression().getValidatedSubtree(typeService, this.statementContext.getMethodResolutionService(), null, this.statementContext.getSchedulingService(), this.statementContext.getVariableService(), this.statementContext);
            assignment.setExpression(validated);
            EPStatementStartMethod.validateNoAggregations(validated, "Aggregation functions may not be used within an update-clause");
        }
        if (desc.getOptionalWhereClause() != null) {
            ExprNode validated = desc.getOptionalWhereClause().getValidatedSubtree(typeService, this.statementContext.getMethodResolutionService(), null, this.statementContext.getSchedulingService(), this.statementContext.getVariableService(), this.statementContext);
            desc.setOptionalWhereClause(validated);
            EPStatementStartMethod.validateNoAggregations(validated, "Aggregation functions may not be used within an update-clause");
        }
        InternalRoutePreprocessView onExprView = new InternalRoutePreprocessView(streamEventType, this.statementContext.getStatementResultService());
        this.services.getInternalEventRouter().addPreprocessing(streamEventType, desc, this.statementSpec.getAnnotations(), onExprView);
        stopCallbacks.add(new StopCallback(){

            public void stop() {
                EPStatementStartMethod.this.services.getInternalEventRouter().removePreprocessing(streamEventType, desc);
            }
        });
        EPStatementStopMethod stopMethod = new EPStatementStopMethod(){

            public void stop() {
                EPStatementStartMethod.this.statementContext.getStatementStopService().fireStatementStopped();
                for (StopCallback stopCallback : stopCallbacks) {
                    stopCallback.stop();
                }
            }
        };
        return new EPStatementStartResult(onExprView, stopMethod);
    }

    private EPStatementStartResult startCreateWindow(boolean isNewStatement, boolean isRecoveringStatement) throws ExprValidationException, ViewProcessingException {
        final FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)this.statementSpec.getStreamSpecs().get(0);
        String windowName = this.statementSpec.getCreateWindowDesc().getWindowName();
        EventType windowType = filterStreamSpec.getFilterSpec().getFilterForEventType();
        ValueAddEventProcessor optionalRevisionProcessor = this.statementContext.getValueAddEventService().getValueAddProcessor(windowName);
        boolean isPrioritized = this.services.getEngineSettingsService().getEngineSettings().getExecution().isPrioritized();
        this.services.getNamedWindowService().addProcessor(windowName, windowType, this.statementContext.getEpStatementHandle(), this.statementContext.getStatementResultService(), optionalRevisionProcessor, this.statementContext.getExpression(), this.statementContext.getStatementName(), isPrioritized, this.statementContext);
        Pair<EventStream, ManagedLock> streamLockPair = this.services.getStreamService().createStream(this.statementContext.getStatementId(), filterStreamSpec.getFilterSpec(), this.statementContext.getFilterService(), this.statementContext.getEpStatementHandle(), false, false, this.statementContext, true);
        Viewable eventStreamParentViewable = streamLockPair.getFirst();
        if (streamLockPair.getSecond() != null) {
            this.statementContext.getEpStatementHandle().setStatementLock(streamLockPair.getSecond());
        }
        ViewFactoryChain unmaterializedViewChain = this.services.getViewService().createFactories(0, eventStreamParentViewable.getEventType(), filterStreamSpec.getViewSpecs(), filterStreamSpec.getOptions(), this.statementContext);
        NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(this.statementSpec.getCreateWindowDesc().getWindowName());
        NamedWindowRootView rootView = processor.getRootView();
        eventStreamParentViewable.addView(rootView);
        ViewResourceDelegateImpl viewResourceDelegate = new ViewResourceDelegateImpl(new ViewFactoryChain[]{unmaterializedViewChain}, this.statementContext);
        if (!viewResourceDelegate.requestCapability(0, new RemoveStreamViewCapability(false), null)) {
            throw new ExprValidationException("Named windows require one or more child views that are data window views");
        }
        EPStatementStopMethod stopMethod = new EPStatementStopMethod(){

            public void stop() {
                EPStatementStartMethod.this.statementContext.getStatementStopService().fireStatementStopped();
                EPStatementStartMethod.this.services.getStreamService().dropStream(filterStreamSpec.getFilterSpec(), EPStatementStartMethod.this.statementContext.getFilterService(), false, false, true);
                String windowName = EPStatementStartMethod.this.statementSpec.getCreateWindowDesc().getWindowName();
                EPStatementStartMethod.this.services.getNamedWindowService().removeProcessor(windowName);
            }
        };
        Viewable finalView = this.services.getViewService().createViews(rootView, unmaterializedViewChain.getViewFactoryChain(), this.statementContext);
        boolean isBatchView = finalView instanceof BatchingDataWindowView;
        NamedWindowTailView tailView = processor.getTailView();
        tailView.setBatchView(isBatchView);
        processor.getRootView().setBatchView(isBatchView);
        finalView.addView(tailView);
        finalView = tailView;
        this.statementSpec.getSelectClauseSpec().getSelectExprList().clear();
        this.statementSpec.getSelectClauseSpec().add(new SelectClauseElementWildcard());
        this.statementSpec.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{windowType}, new String[]{windowName}, new boolean[]{true}, this.services.getEngineURI());
        ResultSetProcessor resultSetProcessor = ResultSetProcessorFactory.getProcessor(this.statementSpec, this.statementContext, typeService, null, new boolean[0], true);
        OutputProcessView outputView = OutputProcessViewFactory.makeView(resultSetProcessor, this.statementSpec, this.statementContext, this.services.getInternalEventRouter());
        finalView.addView(outputView);
        finalView = outputView;
        if (this.statementSpec.getCreateWindowDesc().isInsert() && !isRecoveringStatement) {
            String insertFromWindow = this.statementSpec.getCreateWindowDesc().getInsertFromWindow();
            NamedWindowProcessor sourceWindow = this.services.getNamedWindowService().getProcessor(insertFromWindow);
            ArrayList<EventBean> events = new ArrayList<EventBean>();
            if (this.statementSpec.getCreateWindowDesc().getInsertFilter() != null) {
                EventBean[] eventsPerStream = new EventBean[1];
                ExprNode filter = this.statementSpec.getCreateWindowDesc().getInsertFilter();
                Iterator<EventBean> it = sourceWindow.getTailView().iterator();
                while (it.hasNext()) {
                    EventBean candidate;
                    eventsPerStream[0] = candidate = it.next();
                    Boolean result = (Boolean)filter.evaluate(eventsPerStream, true, this.statementContext);
                    if (result == null || !result.booleanValue()) continue;
                    events.add(candidate);
                }
            } else {
                Iterator<EventBean> it = sourceWindow.getTailView().iterator();
                while (it.hasNext()) {
                    events.add(it.next());
                }
            }
            if (events.size() > 0) {
                EventType rootViewType = rootView.getEventType();
                EventBean[] convertedEvents = this.services.getEventAdapterService().typeCast(events, rootViewType);
                rootView.update(convertedEvents, null);
            }
        }
        log.debug(".start Statement start completed");
        return new EPStatementStartResult(finalView, stopMethod);
    }

    private EPStatementStartResult startCreateVariable(boolean isNewStatement) throws ExprValidationException, ViewProcessingException {
        final CreateVariableDesc createDesc = this.statementSpec.getCreateVariableDesc();
        Object value = null;
        if (createDesc.getAssignment() != null) {
            StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[0], new String[0], new boolean[0], this.services.getEngineURI());
            ExprNode validated = createDesc.getAssignment().getValidatedSubtree(typeService, this.statementContext.getMethodResolutionService(), null, this.statementContext.getSchedulingService(), this.statementContext.getVariableService(), this.statementContext);
            value = validated.evaluate(null, true, this.statementContext);
        }
        try {
            this.services.getVariableService().createNewVariable(createDesc.getVariableName(), createDesc.getVariableType(), value, this.statementContext.getExtensionServicesContext());
        }
        catch (VariableExistsException ex) {
            if (isNewStatement) {
                throw new ExprValidationException("Cannot create variable: " + ex.getMessage());
            }
        }
        catch (VariableDeclarationException ex) {
            throw new ExprValidationException("Cannot create variable: " + ex.getMessage());
        }
        final CreateVariableView createView = new CreateVariableView(this.services.getEventAdapterService(), this.services.getVariableService(), createDesc.getVariableName(), this.statementContext.getStatementResultService());
        final int variableNum = this.services.getVariableService().getReader(createDesc.getVariableName()).getVariableNumber();
        this.services.getVariableService().registerCallback(variableNum, createView);
        this.statementContext.getStatementStopService().addSubscriber(new StatementStopCallback(){

            public void statementStopped() {
                EPStatementStartMethod.this.services.getVariableService().unregisterCallback(variableNum, createView);
            }
        });
        this.statementSpec.getSelectClauseSpec().getSelectExprList().clear();
        this.statementSpec.getSelectClauseSpec().add(new SelectClauseElementWildcard());
        this.statementSpec.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{createView.getEventType()}, new String[]{"create_variable"}, new boolean[]{true}, this.services.getEngineURI());
        ResultSetProcessor resultSetProcessor = ResultSetProcessorFactory.getProcessor(this.statementSpec, this.statementContext, typeService, null, new boolean[0], true);
        OutputProcessView outputView = OutputProcessViewFactory.makeView(resultSetProcessor, this.statementSpec, this.statementContext, this.services.getInternalEventRouter());
        createView.addView(outputView);
        this.services.getStatementVariableRefService().addReferences(this.statementContext.getStatementName(), Collections.singleton(createDesc.getVariableName()));
        EPStatementDestroyMethod destroyMethod = new EPStatementDestroyMethod(){

            public void destroy() {
                try {
                    EPStatementStartMethod.this.services.getStatementVariableRefService().removeReferencesStatement(EPStatementStartMethod.this.statementContext.getStatementName());
                }
                catch (RuntimeException ex) {
                    log.error("Error removing variable '" + createDesc.getVariableName() + "': " + ex.getMessage());
                }
            }
        };
        EPStatementStopMethod stopMethod = new EPStatementStopMethod(){

            public void stop() {
            }
        };
        return new EPStatementStartResult(outputView, stopMethod, destroyMethod);
    }

    private EPStatementStartResult startSelect(boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        Viewable finalView;
        String[] streamNames = EPStatementStartMethod.determineStreamNames(this.statementSpec.getStreamSpecs());
        final boolean isJoin = this.statementSpec.getStreamSpecs().size() > 1;
        SubSelectStreamCollection subSelectStreamDesc = this.createSubSelectStreams(isJoin);
        int numStreams = streamNames.length;
        final LinkedList<StopCallback> stopCallbacks = new LinkedList<StopCallback>();
        Viewable[] eventStreamParentViewable = new Viewable[numStreams];
        ViewFactoryChain[] unmaterializedViewChain = new ViewFactoryChain[numStreams];
        String[] eventTypeNamees = new String[numStreams];
        boolean[] isNamedWindow = new boolean[numStreams];
        StreamJoinAnalysisResult joinAnalysisResult = this.verifyJoinViews(this.statementSpec.getStreamSpecs());
        for (int i = 0; i < this.statementSpec.getStreamSpecs().size(); ++i) {
            StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs().get(i);
            if (streamSpec instanceof FilterStreamSpecCompiled) {
                FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
                eventTypeNamees[i] = filterStreamSpec.getFilterSpec().getFilterForEventTypeName();
                Pair<EventStream, ManagedLock> streamLockPair = this.services.getStreamService().createStream(this.statementContext.getStatementId(), filterStreamSpec.getFilterSpec(), this.statementContext.getFilterService(), this.statementContext.getEpStatementHandle(), isJoin, false, this.statementContext, false | !this.statementSpec.getOrderByList().isEmpty());
                eventStreamParentViewable[i] = streamLockPair.getFirst();
                if (streamLockPair.getSecond() != null) {
                    this.statementContext.getEpStatementHandle().setStatementLock(streamLockPair.getSecond());
                }
                unmaterializedViewChain[i] = this.services.getViewService().createFactories(i, eventStreamParentViewable[i].getEventType(), streamSpec.getViewSpecs(), streamSpec.getOptions(), this.statementContext);
                continue;
            }
            if (streamSpec instanceof PatternStreamSpecCompiled) {
                PatternStreamSpecCompiled patternStreamSpec = (PatternStreamSpecCompiled)streamSpec;
                boolean usedByChildViews = !streamSpec.getViewSpecs().isEmpty() || this.statementSpec.getInsertIntoDesc() != null;
                final EventType eventType = this.services.getEventAdapterService().createSemiAnonymousMapType(patternStreamSpec.getTaggedEventTypes(), patternStreamSpec.getArrayEventTypes(), usedByChildViews);
                final ZeroDepthStream sourceEventStream = new ZeroDepthStream(eventType);
                eventStreamParentViewable[i] = sourceEventStream;
                unmaterializedViewChain[i] = this.services.getViewService().createFactories(i, sourceEventStream.getEventType(), streamSpec.getViewSpecs(), streamSpec.getOptions(), this.statementContext);
                EvalRootNode rootNode = new EvalRootNode();
                rootNode.addChildNode(patternStreamSpec.getEvalNode());
                PatternMatchCallback callback = new PatternMatchCallback(){

                    @Override
                    public void matchFound(Map<String, Object> matchEvent) {
                        EventBean compositeEvent = EPStatementStartMethod.this.statementContext.getEventAdapterService().adaptorForTypedMap(matchEvent, eventType);
                        sourceEventStream.insert(compositeEvent);
                    }
                };
                PatternContext patternContext = this.statementContext.getPatternContextFactory().createContext(this.statementContext, i, rootNode, !patternStreamSpec.getArrayEventTypes().isEmpty());
                PatternStopCallback patternStopCallback = rootNode.start(callback, patternContext);
                stopCallbacks.add(patternStopCallback);
                continue;
            }
            if (streamSpec instanceof DBStatementStreamSpec) {
                if (!streamSpec.getViewSpecs().isEmpty()) {
                    throw new ExprValidationException("Historical data joins do not allow views onto the data, view '" + streamSpec.getViewSpecs().get(0).getObjectNamespace() + ':' + streamSpec.getViewSpecs().get(0).getObjectName() + "' is not valid in this context");
                }
                DBStatementStreamSpec sqlStreamSpec = (DBStatementStreamSpec)streamSpec;
                SQLColumnTypeConversion typeConversionHook = (SQLColumnTypeConversion)JavaClassHelper.getAnnotationHook(this.statementSpec.getAnnotations(), HookType.SQLCOL, SQLColumnTypeConversion.class, this.statementContext.getMethodResolutionService());
                SQLOutputRowConversion outputRowConversionHook = (SQLOutputRowConversion)JavaClassHelper.getAnnotationHook(this.statementSpec.getAnnotations(), HookType.SQLROW, SQLOutputRowConversion.class, this.statementContext.getMethodResolutionService());
                HistoricalEventViewable historicalEventViewable = DatabasePollingViewableFactory.createDBStatementView(i, sqlStreamSpec, this.services.getDatabaseRefService(), this.services.getEventAdapterService(), this.statementContext.getEpStatementHandle(), typeConversionHook, outputRowConversionHook);
                unmaterializedViewChain[i] = new ViewFactoryChain(historicalEventViewable.getEventType(), new LinkedList<ViewFactory>());
                eventStreamParentViewable[i] = historicalEventViewable;
                stopCallbacks.add(historicalEventViewable);
                continue;
            }
            if (streamSpec instanceof MethodStreamSpec) {
                if (!streamSpec.getViewSpecs().isEmpty()) {
                    throw new ExprValidationException("Method data joins do not allow views onto the data, view '" + streamSpec.getViewSpecs().get(0).getObjectNamespace() + ':' + streamSpec.getViewSpecs().get(0).getObjectName() + "' is not valid in this context");
                }
                MethodStreamSpec methodStreamSpec = (MethodStreamSpec)streamSpec;
                HistoricalEventViewable historicalEventViewable = MethodPollingViewableFactory.createPollMethodView(i, methodStreamSpec, this.services.getEventAdapterService(), this.statementContext.getEpStatementHandle(), this.statementContext.getMethodResolutionService(), this.services.getEngineImportService(), this.statementContext.getSchedulingService(), this.statementContext.getScheduleBucket(), this.statementContext);
                unmaterializedViewChain[i] = new ViewFactoryChain(historicalEventViewable.getEventType(), new LinkedList<ViewFactory>());
                eventStreamParentViewable[i] = historicalEventViewable;
                stopCallbacks.add(historicalEventViewable);
                continue;
            }
            if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
                NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
                NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
                NamedWindowConsumerView consumerView = processor.addConsumer(namedSpec.getFilterExpressions(), this.statementContext.getEpStatementHandle(), this.statementContext.getStatementStopService());
                eventStreamParentViewable[i] = consumerView;
                unmaterializedViewChain[i] = this.services.getViewService().createFactories(i, consumerView.getEventType(), namedSpec.getViewSpecs(), namedSpec.getOptions(), this.statementContext);
                joinAnalysisResult.setNamedWindow(i);
                eventTypeNamees[i] = namedSpec.getWindowName();
                isNamedWindow[i] = true;
                ViewResourceDelegateImpl viewResourceDelegate = new ViewResourceDelegateImpl(unmaterializedViewChain, this.statementContext);
                viewResourceDelegate.requestCapability(i, new NotADataWindowViewCapability(), null);
                continue;
            }
            throw new ExprValidationException("Unknown stream specification type: " + streamSpec);
        }
        if (this.statementSpec.getMatchRecognizeSpec() != null) {
            if (isJoin) {
                throw new ExprValidationException("Joins are not allowed when using match recognize");
            }
            boolean isUnbound = unmaterializedViewChain[0].getViewFactoryChain().isEmpty() && !(this.statementSpec.getStreamSpecs().get(0) instanceof NamedWindowConsumerStreamSpec);
            EventRowRegexNFAViewFactory factory = new EventRowRegexNFAViewFactory(unmaterializedViewChain[0], this.statementSpec.getMatchRecognizeSpec(), this.statementContext, isUnbound, this.statementSpec.getAnnotations());
            unmaterializedViewChain[0].getViewFactoryChain().add(factory);
        }
        EventType[] streamEventTypes = new EventType[this.statementSpec.getStreamSpecs().size()];
        for (int i = 0; i < unmaterializedViewChain.length; ++i) {
            streamEventTypes[i] = unmaterializedViewChain[i].getEventType();
        }
        this.startSubSelect(subSelectStreamDesc, streamNames, streamEventTypes, eventTypeNamees, stopCallbacks, this.statementSpec.getAnnotations());
        final ArrayList<StreamSpecCompiled> statementStreamSpecs = new ArrayList<StreamSpecCompiled>();
        statementStreamSpecs.addAll(this.statementSpec.getStreamSpecs());
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(streamEventTypes, streamNames, this.getHasIStreamOnly(isNamedWindow, unmaterializedViewChain), this.services.getEngineURI());
        ViewResourceDelegateImpl viewResourceDelegate = new ViewResourceDelegateImpl(unmaterializedViewChain, this.statementContext);
        for (int i = 0; i < unmaterializedViewChain.length; ++i) {
            if (unmaterializedViewChain[i].getDataWindowViewFactoryCount() <= 1 || viewResourceDelegate.requestCapability(i, new RemoveStreamViewCapability(true), null)) continue;
            log.warn("Combination of multiple data window expiry policies with views that do not support remove streams is not allowed");
        }
        EPStatementStopMethod stopMethod = new EPStatementStopMethod(){

            public void stop() {
                EPStatementStartMethod.this.statementContext.getStatementStopService().fireStatementStopped();
                for (StreamSpecCompiled streamSpec : statementStreamSpecs) {
                    if (!(streamSpec instanceof FilterStreamSpecCompiled)) continue;
                    FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
                    EPStatementStartMethod.this.services.getStreamService().dropStream(filterStreamSpec.getFilterSpec(), EPStatementStartMethod.this.statementContext.getFilterService(), isJoin, false, false | !EPStatementStartMethod.this.statementSpec.getOrderByList().isEmpty());
                }
                for (StopCallback stopCallback : stopCallbacks) {
                    stopCallback.stop();
                }
                for (ExprSubselectNode subselect : EPStatementStartMethod.this.statementSpec.getSubSelectExpressions()) {
                    StreamSpecCompiled subqueryStreamSpec = subselect.getStatementSpecCompiled().getStreamSpecs().get(0);
                    if (!(subqueryStreamSpec instanceof FilterStreamSpecCompiled)) continue;
                    FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)subselect.getStatementSpecCompiled().getStreamSpecs().get(0);
                    EPStatementStartMethod.this.services.getStreamService().dropStream(filterStreamSpec.getFilterSpec(), EPStatementStartMethod.this.statementContext.getFilterService(), isJoin, true, false);
                }
            }
        };
        for (int stream = 0; stream < eventStreamParentViewable.length; ++stream) {
            HistoricalEventViewable historicalView;
            Viewable viewable = eventStreamParentViewable[stream];
            if (viewable instanceof ValidatedView) {
                ValidatedView validatedView = (ValidatedView)((Object)viewable);
                validatedView.validate(typeService, this.statementContext.getMethodResolutionService(), this.statementContext.getSchedulingService(), this.statementContext.getVariableService(), this.statementContext);
            }
            if (!(viewable instanceof HistoricalEventViewable) || !(historicalView = (HistoricalEventViewable)viewable).getRequiredStreams().contains(stream)) continue;
            throw new ExprValidationException("Parameters for historical stream " + stream + " indicate that the stream is subordinate to itself as stream parameters originate in the same stream");
        }
        ResultSetProcessor resultSetProcessor = ResultSetProcessorFactory.getProcessor(this.statementSpec, this.statementContext, typeService, viewResourceDelegate, joinAnalysisResult.getUnidirectionalInd(), true);
        EPStatementStartMethod.validateNodes(this.statementSpec, this.statementContext, typeService, viewResourceDelegate);
        Viewable[] streamViews = new Viewable[streamEventTypes.length];
        for (int i = 0; i < streamViews.length; ++i) {
            streamViews[i] = this.services.getViewService().createViews(eventStreamParentViewable[i], unmaterializedViewChain[i].getViewFactoryChain(), this.statementContext);
        }
        JoinPreloadMethod joinPreloadMethod = null;
        if (streamNames.length == 1) {
            finalView = this.handleSimpleSelect(streamViews[0], resultSetProcessor, this.statementContext);
        } else {
            Pair<Viewable, JoinPreloadMethod> pair = this.handleJoin(streamNames, streamEventTypes, streamViews, resultSetProcessor, this.statementSpec.getSelectStreamSelectorEnum(), this.statementContext, stopCallbacks, joinAnalysisResult);
            finalView = pair.getFirst();
            joinPreloadMethod = pair.getSecond();
        }
        boolean hasNamedWindow = false;
        for (int i = 0; i < this.statementSpec.getStreamSpecs().size(); ++i) {
            StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs().get(i);
            if (!(streamSpec instanceof NamedWindowConsumerStreamSpec)) continue;
            hasNamedWindow = true;
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
            NamedWindowTailView consumerView = processor.getTailView();
            NamedWindowConsumerView view = (NamedWindowConsumerView)eventStreamParentViewable[i];
            ArrayList<EventBean> eventsInWindow = new ArrayList<EventBean>();
            if (!consumerView.isParentBatchWindow()) {
                for (EventBean aConsumerView : consumerView) {
                    eventsInWindow.add(aConsumerView);
                }
            }
            if (!eventsInWindow.isEmpty() && !isRecoveringResilient) {
                EventBean[] newEvents = eventsInWindow.toArray(new EventBean[eventsInWindow.size()]);
                view.update(newEvents, null);
            }
            if (joinPreloadMethod != null) {
                joinPreloadMethod.preloadFromBuffer(i);
                continue;
            }
            if (this.statementContext.getEpStatementHandle().getOptionalDispatchable() == null) continue;
            this.statementContext.getEpStatementHandle().getOptionalDispatchable().execute(this.statementContext);
        }
        if (hasNamedWindow && joinPreloadMethod != null && !isRecoveringResilient) {
            joinPreloadMethod.preloadAggregation(resultSetProcessor);
        }
        log.debug(".start Statement start completed");
        return new EPStatementStartResult(finalView, stopMethod);
    }

    private boolean[] getHasIStreamOnly(boolean[] isNamedWindow, ViewFactoryChain[] unmaterializedViewChain) {
        boolean[] result = new boolean[unmaterializedViewChain.length];
        for (int i = 0; i < unmaterializedViewChain.length; ++i) {
            if (isNamedWindow[i]) continue;
            result[i] = unmaterializedViewChain[i].getDataWindowViewFactoryCount() == 0;
        }
        return result;
    }

    private StreamJoinAnalysisResult verifyJoinViews(List<StreamSpecCompiled> streamSpecs) throws ExprValidationException {
        StreamJoinAnalysisResult analysisResult = new StreamJoinAnalysisResult(streamSpecs.size());
        if (streamSpecs.size() < 2) {
            return analysisResult;
        }
        int unidirectionalStreamNumber = -1;
        for (int i = 0; i < this.statementSpec.getStreamSpecs().size(); ++i) {
            StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs().get(i);
            if (streamSpec.getOptions().isUnidirectional()) {
                analysisResult.setUnidirectionalInd(i);
                if (unidirectionalStreamNumber != -1) {
                    throw new ExprValidationException("The unidirectional keyword can only apply to one stream in a join");
                }
                unidirectionalStreamNumber = i;
            }
            if (!streamSpec.getViewSpecs().isEmpty()) {
                analysisResult.setHasChildViews(i);
            }
            if (!(streamSpec instanceof NamedWindowConsumerStreamSpec)) continue;
            analysisResult.setNamedWindow(i);
        }
        if (unidirectionalStreamNumber != -1 && analysisResult.getHasChildViews()[unidirectionalStreamNumber]) {
            throw new ExprValidationException("The unidirectional keyword requires that no views are declared onto the stream");
        }
        analysisResult.setUnidirectionalStreamNumber(unidirectionalStreamNumber);
        int countProviderNonpolling = 0;
        for (int i = 0; i < this.statementSpec.getStreamSpecs().size(); ++i) {
            StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs().get(i);
            if (streamSpec instanceof MethodStreamSpec || streamSpec instanceof DBStatementStreamSpec) continue;
            ++countProviderNonpolling;
        }
        if (countProviderNonpolling == 1) {
            return analysisResult;
        }
        FilterSpecCompiled unidirectionalFilterSpec = null;
        FilterSpecCompiled lastFilterSpec = null;
        boolean pureSelfJoin = true;
        for (StreamSpecCompiled streamSpec : this.statementSpec.getStreamSpecs()) {
            if (!(streamSpec instanceof FilterStreamSpecCompiled)) {
                pureSelfJoin = false;
                continue;
            }
            FilterSpecCompiled filterSpec = ((FilterStreamSpecCompiled)streamSpec).getFilterSpec();
            if (lastFilterSpec != null && !lastFilterSpec.equalsTypeAndFilter(filterSpec)) {
                pureSelfJoin = false;
            }
            if (!streamSpec.getViewSpecs().isEmpty()) {
                pureSelfJoin = false;
            }
            lastFilterSpec = filterSpec;
            if (!streamSpec.getOptions().isUnidirectional()) continue;
            unidirectionalFilterSpec = filterSpec;
        }
        if (pureSelfJoin && unidirectionalFilterSpec == null) {
            analysisResult.setPureSelfJoin(true);
            return analysisResult;
        }
        for (int i = 0; i < this.statementSpec.getStreamSpecs().size(); ++i) {
            StreamSpecCompiled streamSpec;
            streamSpec = this.statementSpec.getStreamSpecs().get(i);
            if (!streamSpec.getViewSpecs().isEmpty()) continue;
            String name = streamSpec.getOptionalStreamName();
            if (name == null && streamSpec instanceof FilterStreamSpecCompiled) {
                name = ((FilterStreamSpecCompiled)streamSpec).getFilterSpec().getFilterForEventTypeName();
            }
            if (name == null && streamSpec instanceof PatternStreamSpecCompiled) {
                name = "pattern event stream";
            }
            if (streamSpec.getOptions().isUnidirectional()) continue;
            if (unidirectionalFilterSpec != null && streamSpec instanceof FilterStreamSpecCompiled && ((FilterStreamSpecCompiled)streamSpec).getFilterSpec().equalsTypeAndFilter(unidirectionalFilterSpec)) {
                analysisResult.setUnidirectionalNonDriving(i);
                continue;
            }
            if (!(streamSpec instanceof FilterStreamSpecCompiled) && !(streamSpec instanceof PatternStreamSpecCompiled)) continue;
            throw new ExprValidationException("Joins require that at least one view is specified for each stream, no view was specified for " + name);
        }
        return analysisResult;
    }

    private Pair<Viewable, JoinPreloadMethod> handleJoin(String[] streamNames, EventType[] streamTypes, Viewable[] streamViews, ResultSetProcessor resultSetProcessor, SelectClauseStreamSelectorEnum selectStreamSelectorEnum, StatementContext statementContext, List<StopCallback> stopCallbacks, StreamJoinAnalysisResult joinAnalysisResult) throws ExprValidationException {
        final JoinSetComposer composer = statementContext.getJoinSetComposerFactory().makeComposer(this.statementSpec.getOuterJoinDescList(), this.statementSpec.getFilterRootNode(), streamTypes, streamNames, streamViews, selectStreamSelectorEnum, joinAnalysisResult, statementContext);
        stopCallbacks.add(new StopCallback(){

            public void stop() {
                composer.destroy();
            }
        });
        JoinSetFilter filter = new JoinSetFilter(this.statementSpec.getFilterRootNode());
        OutputProcessView indicatorView = OutputProcessViewFactory.makeView(resultSetProcessor, this.statementSpec, statementContext, this.services.getInternalEventRouter());
        JoinExecutionStrategyImpl execution = new JoinExecutionStrategyImpl(composer, filter, indicatorView, statementContext);
        indicatorView.setJoinExecutionStrategy(execution);
        JoinExecStrategyDispatchable joinStatementDispatch = new JoinExecStrategyDispatchable(execution, this.statementSpec.getStreamSpecs().size());
        statementContext.getEpStatementHandle().setOptionalDispatchable(joinStatementDispatch);
        JoinPreloadMethod preloadMethod = joinAnalysisResult.getUnidirectionalStreamNumber() >= 0 ? new JoinPreloadMethodNull() : new JoinPreloadMethodImpl(streamNames.length, composer);
        for (int i = 0; i < this.statementSpec.getStreamSpecs().size(); ++i) {
            BufferView buffer = new BufferView(i);
            streamViews[i].addView(buffer);
            buffer.setObserver(joinStatementDispatch);
            preloadMethod.setBuffer(buffer, i);
        }
        return new Pair<Viewable, JoinPreloadMethod>(indicatorView, preloadMethod);
    }

    protected static String[] determineStreamNames(List<StreamSpecCompiled> streams) {
        String[] streamNames = new String[streams.size()];
        for (int i = 0; i < streams.size(); ++i) {
            streamNames[i] = streams.get(i).getOptionalStreamName();
            if (streamNames[i] != null) continue;
            streamNames[i] = "stream_" + i;
        }
        return streamNames;
    }

    protected static void validateNodes(StatementSpecCompiled statementSpec, StatementContext statementContext, StreamTypeService typeService, ViewResourceDelegate viewResourceDelegate) {
        MethodResolutionService methodResolutionService = statementContext.getMethodResolutionService();
        if (statementSpec.getFilterRootNode() != null) {
            ExprNode optionalFilterNode = statementSpec.getFilterRootNode();
            try {
                optionalFilterNode = optionalFilterNode.getValidatedSubtree(typeService, methodResolutionService, viewResourceDelegate, statementContext.getSchedulingService(), statementContext.getVariableService(), statementContext);
                statementSpec.setFilterExprRootNode(optionalFilterNode);
                LinkedList<ExprAggregateNode> aggregateNodes = new LinkedList<ExprAggregateNode>();
                ExprAggregateNode.getAggregatesBottomUp(optionalFilterNode, aggregateNodes);
                if (!aggregateNodes.isEmpty()) {
                    throw new ExprValidationException("An aggregate function may not appear in a WHERE clause (use the HAVING clause)");
                }
            }
            catch (ExprValidationException ex) {
                log.debug(".validateNodes Validation exception for filter=" + optionalFilterNode.toExpressionString(), ex);
                throw new EPStatementException("Error validating expression: " + ex.getMessage(), statementContext.getExpression());
            }
        }
        if (statementSpec.getOutputLimitSpec() != null && statementSpec.getOutputLimitSpec().getWhenExpressionNode() != null) {
            ExprNode outputLimitWhenNode = statementSpec.getOutputLimitSpec().getWhenExpressionNode();
            try {
                EventType outputLimitType = OutputConditionExpression.getBuiltInEventType(statementContext.getEventAdapterService());
                StreamTypeServiceImpl typeServiceOutputWhen = new StreamTypeServiceImpl(new EventType[]{outputLimitType}, new String[]{null}, new boolean[]{true}, statementContext.getEngineURI());
                outputLimitWhenNode = outputLimitWhenNode.getValidatedSubtree(typeServiceOutputWhen, methodResolutionService, null, statementContext.getSchedulingService(), statementContext.getVariableService(), statementContext);
                statementSpec.getOutputLimitSpec().setWhenExpressionNode(outputLimitWhenNode);
                if (JavaClassHelper.getBoxedType(outputLimitWhenNode.getType()) != Boolean.class) {
                    throw new ExprValidationException("The when-trigger expression in the OUTPUT WHEN clause must return a boolean-type value");
                }
                EPStatementStartMethod.validateNoAggregations(outputLimitWhenNode, "An aggregate function may not appear in a OUTPUT LIMIT clause");
                if (statementSpec.getOutputLimitSpec().getThenExpressions() != null) {
                    for (OnTriggerSetAssignment assign : statementSpec.getOutputLimitSpec().getThenExpressions()) {
                        ExprNode node = assign.getExpression().getValidatedSubtree(typeServiceOutputWhen, methodResolutionService, null, statementContext.getSchedulingService(), statementContext.getVariableService(), statementContext);
                        assign.setExpression(node);
                        EPStatementStartMethod.validateNoAggregations(node, "An aggregate function may not appear in a OUTPUT LIMIT clause");
                    }
                }
            }
            catch (ExprValidationException ex) {
                throw new EPStatementException("Error validating expression: " + ex.getMessage(), statementContext.getExpression());
            }
        }
        for (int outerJoinCount = 0; outerJoinCount < statementSpec.getOuterJoinDescList().size(); ++outerJoinCount) {
            OuterJoinDesc outerJoinDesc = statementSpec.getOuterJoinDescList().get(outerJoinCount);
            UniformPair<Integer> streamIdPair = EPStatementStartMethod.validateOuterJoinPropertyPair(statementContext, outerJoinDesc.getLeftNode(), outerJoinDesc.getRightNode(), outerJoinCount, typeService, viewResourceDelegate);
            if (outerJoinDesc.getAdditionalLeftNodes() == null) continue;
            HashSet<Integer> streamSet = new HashSet<Integer>();
            streamSet.add(streamIdPair.getFirst());
            streamSet.add(streamIdPair.getSecond());
            for (int i = 0; i < outerJoinDesc.getAdditionalLeftNodes().length; ++i) {
                UniformPair<Integer> streamIdPairAdd = EPStatementStartMethod.validateOuterJoinPropertyPair(statementContext, outerJoinDesc.getAdditionalLeftNodes()[i], outerJoinDesc.getAdditionalRightNodes()[i], outerJoinCount, typeService, viewResourceDelegate);
                if (streamSet.contains(streamIdPairAdd.getFirst()) && streamSet.contains(streamIdPairAdd.getSecond())) continue;
                String message = "Outer join ON-clause columns must refer to properties of the same joined streams when using multiple columns in the on-clause";
                throw new EPStatementException("Error validating expression: " + message, statementContext.getExpression());
            }
        }
    }

    private static void validateNoAggregations(ExprNode exprNode, String errorMsg) throws ExprValidationException {
        LinkedList<ExprAggregateNode> aggregateNodes = new LinkedList<ExprAggregateNode>();
        ExprAggregateNode.getAggregatesBottomUp(exprNode, aggregateNodes);
        if (!aggregateNodes.isEmpty()) {
            throw new ExprValidationException(errorMsg);
        }
    }

    private static UniformPair<Integer> validateOuterJoinPropertyPair(StatementContext statementContext, ExprIdentNode leftNode, ExprIdentNode rightNode, int outerJoinCount, StreamTypeService typeService, ViewResourceDelegate viewResourceDelegate) {
        ExprNode equalsNode = new ExprEqualsNode(false);
        equalsNode.addChildNode(leftNode);
        equalsNode.addChildNode(rightNode);
        try {
            equalsNode = equalsNode.getValidatedSubtree(typeService, statementContext.getMethodResolutionService(), viewResourceDelegate, statementContext.getSchedulingService(), statementContext.getVariableService(), statementContext);
        }
        catch (ExprValidationException ex) {
            log.debug("Validation exception for outer join node=" + ((ExprNode)equalsNode).toExpressionString(), ex);
            throw new EPStatementException("Error validating expression: " + ex.getMessage(), statementContext.getExpression());
        }
        int streamIdLeft = leftNode.getStreamId();
        int streamIdRight = rightNode.getStreamId();
        if (streamIdLeft == streamIdRight) {
            String message = "Outer join ON-clause cannot refer to properties of the same stream";
            throw new EPStatementException("Error validating expression: " + message, statementContext.getExpression());
        }
        int expectedStreamJoined = outerJoinCount + 1;
        if (streamIdLeft != expectedStreamJoined && streamIdRight != expectedStreamJoined) {
            String message = "Outer join ON-clause must refer to at least one property of the joined stream for stream " + expectedStreamJoined;
            throw new EPStatementException("Error validating expression: " + message, statementContext.getExpression());
        }
        String badPropertyName = null;
        if (streamIdLeft > outerJoinCount + 1) {
            badPropertyName = leftNode.getResolvedPropertyName();
        }
        if (streamIdRight > outerJoinCount + 1) {
            badPropertyName = rightNode.getResolvedPropertyName();
        }
        if (badPropertyName != null) {
            String message = "Outer join ON-clause invalid scope for property '" + badPropertyName + "', expecting the current or a prior stream scope";
            throw new EPStatementException("Error validating expression: " + message, statementContext.getExpression());
        }
        return new UniformPair<Integer>(streamIdLeft, streamIdRight);
    }

    private Viewable handleSimpleSelect(Viewable view, ResultSetProcessor resultSetProcessor, StatementContext statementContext) throws ExprValidationException {
        Viewable finalView = view;
        if (this.statementSpec.getFilterRootNode() != null) {
            FilterExprView filterView = new FilterExprView(this.statementSpec.getFilterRootNode(), statementContext);
            finalView.addView(filterView);
            finalView = filterView;
        }
        if (!this.statementSpec.getOrderByList().isEmpty() && this.statementSpec.getOutputLimitSpec() == null) {
            SingleStreamDispatchView bf = new SingleStreamDispatchView();
            statementContext.getEpStatementHandle().setOptionalDispatchable(bf);
            finalView.addView(bf);
            finalView = bf;
        }
        OutputProcessView selectView = OutputProcessViewFactory.makeView(resultSetProcessor, this.statementSpec, statementContext, this.services.getInternalEventRouter());
        finalView.addView(selectView);
        finalView = selectView;
        return finalView;
    }

    private SubSelectStreamCollection createSubSelectStreams(boolean isJoin) throws ExprValidationException, ViewProcessingException {
        SubSelectStreamCollection subSelectStreamDesc = new SubSelectStreamCollection();
        int subselectStreamNumber = 1024;
        for (ExprSubselectNode subselect : this.statementSpec.getSubSelectExpressions()) {
            ViewFactoryChain viewFactoryChain;
            StatementSpecCompiled statementSpec = subselect.getStatementSpecCompiled();
            if (statementSpec.getStreamSpecs().get(0) instanceof FilterStreamSpecCompiled) {
                FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)statementSpec.getStreamSpecs().get(0);
                if (filterStreamSpec.getViewSpecs().size() == 0) {
                    throw new ExprValidationException("Subqueries require one or more views to limit the stream, consider declaring a length or time window");
                }
                Pair<EventStream, ManagedLock> streamLockPair = this.services.getStreamService().createStream(this.statementContext.getStatementId(), filterStreamSpec.getFilterSpec(), this.statementContext.getFilterService(), this.statementContext.getEpStatementHandle(), isJoin, true, this.statementContext, false);
                Viewable viewable = streamLockPair.getFirst();
                viewFactoryChain = this.services.getViewService().createFactories(++subselectStreamNumber, viewable.getEventType(), filterStreamSpec.getViewSpecs(), filterStreamSpec.getOptions(), this.statementContext);
                subselect.setRawEventType(viewFactoryChain.getEventType());
                subSelectStreamDesc.add(subselect, subselectStreamNumber, viewable, viewFactoryChain);
                continue;
            }
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)statementSpec.getStreamSpecs().get(0);
            NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
            NamedWindowConsumerView consumerView = processor.addConsumer(namedSpec.getFilterExpressions(), this.statementContext.getEpStatementHandle(), this.statementContext.getStatementStopService());
            viewFactoryChain = this.services.getViewService().createFactories(0, consumerView.getEventType(), namedSpec.getViewSpecs(), namedSpec.getOptions(), this.statementContext);
            subselect.setRawEventType(viewFactoryChain.getEventType());
            subSelectStreamDesc.add(subselect, subselectStreamNumber, consumerView, viewFactoryChain);
        }
        return subSelectStreamDesc;
    }

    private void startSubSelect(SubSelectStreamCollection subSelectStreamDesc, String[] outerStreamNames, EventType[] outerEventTypesSelect, String[] outerEventTypeNamees, List<StopCallback> stopCallbacks, Annotation[] annotations) throws ExprValidationException {
        for (ExprSubselectNode subselect : this.statementSpec.getSubSelectExpressions()) {
            EventTable eventIndex;
            ExprNode filterExpr;
            SelectClauseElementCompiled element;
            EventType[] outerEventTypes;
            StreamTypeService subselectTypeService;
            StatementSpecCompiled statementSpec = subselect.getStatementSpecCompiled();
            StreamSpecCompiled filterStreamSpec = statementSpec.getStreamSpecs().get(0);
            String subselecteventTypeName = null;
            if (filterStreamSpec instanceof FilterStreamSpecCompiled) {
                subselecteventTypeName = ((FilterStreamSpecCompiled)filterStreamSpec).getFilterSpec().getFilterForEventTypeName();
            } else if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec) {
                subselecteventTypeName = ((NamedWindowConsumerStreamSpec)filterStreamSpec).getWindowName();
            }
            ViewFactoryChain viewFactoryChain = subSelectStreamDesc.getViewFactoryChain(subselect);
            EventType eventType = viewFactoryChain.getEventType();
            String subexpressionStreamName = filterStreamSpec.getOptionalStreamName();
            int subselectStreamNumber = subSelectStreamDesc.getStreamNumber(subselect);
            if (subexpressionStreamName == null) {
                subexpressionStreamName = "$subselect_" + subselectStreamNumber;
            }
            if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec) {
                ViewResourceDelegateImpl viewResourceDelegate = new ViewResourceDelegateImpl(new ViewFactoryChain[]{viewFactoryChain}, this.statementContext);
                viewResourceDelegate.requestCapability(0, new NotADataWindowViewCapability(), null);
            }
            if (subselect.getFilterSubqueryStreamTypes() != null) {
                subselectTypeService = subselect.getFilterSubqueryStreamTypes();
                outerEventTypes = new EventType[subselectTypeService.getEventTypes().length - 1];
                System.arraycopy(subselectTypeService.getEventTypes(), 1, outerEventTypes, 0, subselectTypeService.getEventTypes().length - 1);
            } else {
                LinkedHashMap<String, Pair<EventType, String>> namesAndTypes = new LinkedHashMap<String, Pair<EventType, String>>();
                namesAndTypes.put(subexpressionStreamName, new Pair<EventType, String>(eventType, subselecteventTypeName));
                for (int i = 0; i < outerEventTypesSelect.length; ++i) {
                    Pair<EventType, String> pair = new Pair<EventType, String>(outerEventTypesSelect[i], outerEventTypeNamees[i]);
                    namesAndTypes.put(outerStreamNames[i], pair);
                }
                subselectTypeService = new StreamTypeServiceImpl(namesAndTypes, this.services.getEngineURI(), true, true);
                outerEventTypes = outerEventTypesSelect;
            }
            ViewResourceDelegateImpl viewResourceDelegateSubselect = new ViewResourceDelegateImpl(new ViewFactoryChain[]{viewFactoryChain}, this.statementContext);
            SelectClauseSpecCompiled selectClauseSpec = subselect.getStatementSpecCompiled().getSelectClauseSpec();
            AggregationService aggregationService = null;
            if (selectClauseSpec.getSelectExprList().size() > 0 && (element = selectClauseSpec.getSelectExprList().get(0)) instanceof SelectClauseExprCompiledSpec) {
                SelectClauseExprCompiledSpec compiled = (SelectClauseExprCompiledSpec)element;
                ExprNode selectExpression = compiled.getSelectExpression();
                selectExpression = selectExpression.getValidatedSubtree(subselectTypeService, this.statementContext.getMethodResolutionService(), viewResourceDelegateSubselect, this.statementContext.getSchedulingService(), this.statementContext.getVariableService(), this.statementContext);
                subselect.setSelectClause(selectExpression);
                subselect.setSelectAsName(compiled.getAssignedName());
                LinkedList<ExprAggregateNode> aggExprNodes = new LinkedList<ExprAggregateNode>();
                ExprAggregateNode.getAggregatesBottomUp(selectExpression, aggExprNodes);
                if (aggExprNodes.size() > 0) {
                    List<ExprAggregateNode> havingAgg = Collections.emptyList();
                    List<ExprAggregateNode> orderByAgg = Collections.emptyList();
                    aggregationService = AggregationServiceFactory.getService(aggExprNodes, havingAgg, orderByAgg, false, null, this.statementContext, annotations, this.statementContext.getVariableService(), this.statementContext.getStatementStopService());
                    for (ExprAggregateNode aggNode : aggExprNodes) {
                        List<Pair<Integer, String>> propertiesNodesAggregated = EPStatementStartMethod.getExpressionProperties(aggNode, true);
                        for (Pair<Integer, String> pair : propertiesNodesAggregated) {
                            if (pair.getFirst() == 0) continue;
                            throw new ExprValidationException("Subselect aggregation function cannot aggregate across correlated properties");
                        }
                    }
                    List<Pair<Integer, String>> propertiesNotAggregated = EPStatementStartMethod.getExpressionProperties(selectExpression, false);
                    for (Pair<Integer, String> pair : propertiesNotAggregated) {
                        if (pair.getFirst() != 0) continue;
                        throw new ExprValidationException("Subselect properties must all be within aggregation functions");
                    }
                }
            }
            if (statementSpec.getFilterRootNode() != null) {
                LinkedList<ExprAggregateNode> aggExprNodesFilter = new LinkedList<ExprAggregateNode>();
                ExprAggregateNode.getAggregatesBottomUp(statementSpec.getFilterRootNode(), aggExprNodesFilter);
                if (aggExprNodesFilter.size() > 0) {
                    throw new ExprValidationException("Aggregation functions are not supported within subquery filters, consider using insert-into instead");
                }
            }
            if ((filterExpr = statementSpec.getFilterRootNode()) != null) {
                if (JavaClassHelper.getBoxedType((filterExpr = filterExpr.getValidatedSubtree(subselectTypeService, this.statementContext.getMethodResolutionService(), viewResourceDelegateSubselect, this.statementContext.getSchedulingService(), this.statementContext.getVariableService(), this.statementContext)).getType()) != Boolean.class) {
                    throw new ExprValidationException("Subselect filter expression must return a boolean value");
                }
                ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
                filterExpr.accept(visitor);
                List<Pair<Integer, String>> propertiesNodes = visitor.getExprProperties();
                for (Pair<Integer, String> pair : propertiesNodes) {
                    if (pair.getFirst() == 0 || aggregationService == null) continue;
                    throw new ExprValidationException("Subselect filter expression cannot be a correlated expression when aggregating properties via aggregation function");
                }
            }
            Viewable viewableRoot = subSelectStreamDesc.getRootViewable(subselect);
            Viewable subselectView = this.services.getViewService().createViews(viewableRoot, viewFactoryChain.getViewFactoryChain(), this.statementContext);
            if (aggregationService != null) {
                SubselectAggregatorView aggregatorView = new SubselectAggregatorView(aggregationService, filterExpr, this.statementContext);
                subselectView.addView(aggregatorView);
                subselectView = aggregatorView;
                eventIndex = null;
                subselect.setStrategy(new TableLookupStrategyNullRow());
                subselect.setFilterExpr(null);
            } else {
                Pair<EventTable, TableLookupStrategy> indexPair = this.determineSubqueryIndex(filterExpr, eventType, outerEventTypes, subselectTypeService);
                subselect.setStrategy(indexPair.getSecond());
                subselect.setFilterExpr(filterExpr);
                eventIndex = indexPair.getFirst();
            }
            stopCallbacks.add(new SubqueryStopCallback(eventIndex));
            if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec) {
                NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)filterStreamSpec;
                NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
                NamedWindowTailView consumerView = processor.getTailView();
                ArrayList<EventBean> eventsInWindow = new ArrayList<EventBean>();
                Iterator<EventBean> it = consumerView.iterator();
                while (it.hasNext()) {
                    eventsInWindow.add(it.next());
                }
                EventBean[] newEvents = eventsInWindow.toArray(new EventBean[eventsInWindow.size()]);
                ((View)viewableRoot).update(newEvents, null);
                if (eventIndex != null) {
                    eventIndex.add(newEvents);
                }
            } else {
                Iterator<EventBean> it = subselectView.iterator();
                if (it != null && it.hasNext()) {
                    ArrayList<EventBean> preloadEvents = new ArrayList<EventBean>();
                    while (it.hasNext()) {
                        preloadEvents.add(it.next());
                    }
                    if (eventIndex != null) {
                        eventIndex.add(preloadEvents.toArray(new EventBean[preloadEvents.size()]));
                    }
                }
            }
            BufferView bufferView = new BufferView(subselectStreamNumber);
            bufferView.setObserver(new SubselectBufferObserver(eventIndex));
            subselectView.addView(bufferView);
        }
    }

    private Pair<EventTable, TableLookupStrategy> determineSubqueryIndex(ExprNode filterExpr, EventType viewableEventType, EventType[] outerEventTypes, StreamTypeService subselectTypeService) throws ExprValidationException {
        if (filterExpr == null) {
            UnindexedEventTable table = new UnindexedEventTable(0);
            FullTableScanLookupStrategy strategy = new FullTableScanLookupStrategy(table);
            return new Pair<EventTable, TableLookupStrategy>(table, strategy);
        }
        QueryGraph queryGraph = new QueryGraph(outerEventTypes.length + 1);
        FilterExprAnalyzer.analyze(filterExpr, queryGraph);
        LinkedHashMap<String, JoinedPropDesc> joinProps = new LinkedHashMap<String, JoinedPropDesc>();
        boolean mustCoerce = false;
        for (int stream = 0; stream < outerEventTypes.length; ++stream) {
            int lookupStream = stream + 1;
            String[] keyPropertiesJoin = queryGraph.getKeyProperties(lookupStream, 0);
            String[] indexPropertiesJoin = queryGraph.getIndexProperties(lookupStream, 0);
            if (keyPropertiesJoin == null || keyPropertiesJoin.length == 0) continue;
            if (keyPropertiesJoin.length != indexPropertiesJoin.length) {
                throw new IllegalStateException("Invalid query key and index property collection for stream " + stream);
            }
            for (int i = 0; i < keyPropertiesJoin.length; ++i) {
                Class indexedPropType;
                Class keyPropType = JavaClassHelper.getBoxedType(subselectTypeService.getEventTypes()[lookupStream].getPropertyType(keyPropertiesJoin[i]));
                Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(subselectTypeService.getEventTypes()[0].getPropertyType(indexPropertiesJoin[i]));
                if (keyPropType != indexedPropType) {
                    coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, keyPropType);
                    mustCoerce = true;
                }
                JoinedPropDesc desc = new JoinedPropDesc(indexPropertiesJoin[i], coercionType, keyPropertiesJoin[i], stream);
                joinProps.put(indexPropertiesJoin[i], desc);
            }
        }
        if (joinProps.size() != 0) {
            IndexedTableLookupStrategy strategy;
            String[] indexedProps = joinProps.keySet().toArray(new String[joinProps.keySet().size()]);
            int[] keyStreamNums = JoinedPropDesc.getKeyStreamNums(joinProps.values());
            String[] keyProps = JoinedPropDesc.getKeyProperties(joinProps.values());
            Class[] coercionTypes = JoinedPropDesc.getCoercionTypes(joinProps.values());
            if (!mustCoerce) {
                PropertyIndexedEventTable table = new PropertyIndexedEventTable(0, viewableEventType, indexedProps, coercionTypes);
                strategy = new IndexedTableLookupStrategy(outerEventTypes, keyStreamNums, keyProps, table);
                return new Pair<EventTable, TableLookupStrategy>(table, strategy);
            }
            PropertyIndTableCoerceAdd table = new PropertyIndTableCoerceAdd(0, viewableEventType, indexedProps, coercionTypes);
            strategy = new IndexedTableLookupStrategyCoercing(outerEventTypes, keyStreamNums, keyProps, table, coercionTypes);
            return new Pair<EventTable, TableLookupStrategy>(table, strategy);
        }
        UnindexedEventTable table = new UnindexedEventTable(0);
        return new Pair<EventTable, TableLookupStrategy>(table, new FullTableScanLookupStrategy(table));
    }

    private ExprNode validateJoinNamedWindow(ExprNode deleteJoinExpr, EventType namedWindowType, String namedWindowStreamName, String namedWindowName, EventType filteredType, String filterStreamName, String filteredTypeName) throws ExprValidationException {
        if (deleteJoinExpr == null) {
            return null;
        }
        LinkedHashMap<String, Pair<EventType, String>> namesAndTypes = new LinkedHashMap<String, Pair<EventType, String>>();
        namesAndTypes.put(namedWindowStreamName, new Pair<EventType, String>(namedWindowType, namedWindowName));
        namesAndTypes.put(filterStreamName, new Pair<EventType, String>(filteredType, filteredTypeName));
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(namesAndTypes, this.services.getEngineURI(), false, false);
        return deleteJoinExpr.getValidatedSubtree(typeService, this.statementContext.getMethodResolutionService(), null, this.statementContext.getSchedulingService(), this.statementContext.getVariableService(), this.statementContext);
    }

    public static List<Pair<Integer, String>> getExpressionProperties(ExprNode exprNode, boolean visitAggregateNodes) {
        ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(visitAggregateNodes);
        exprNode.accept(visitor);
        return visitor.getExprProperties();
    }

    private String getNull(Object value) {
        if (value == null) {
            return "-";
        }
        return value.toString();
    }
}

