/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.core.InsertIntoLatchSpin;
import com.espertech.esper.core.InsertIntoLatchWait;
import com.espertech.esper.timer.TimeSourceService;

public class InsertIntoLatchFactory {
    private final boolean useSpin;
    private final TimeSourceService timeSourceService;
    private InsertIntoLatchSpin currentLatchSpin;
    private InsertIntoLatchWait currentLatchWait;
    private long msecWait;

    public InsertIntoLatchFactory(String name, long msecWait, ConfigurationEngineDefaults.Threading.Locking locking, TimeSourceService timeSourceService) {
        this.msecWait = msecWait;
        this.timeSourceService = timeSourceService;
        boolean bl = this.useSpin = locking == ConfigurationEngineDefaults.Threading.Locking.SPIN;
        if (this.useSpin) {
            this.currentLatchSpin = new InsertIntoLatchSpin(timeSourceService);
        } else {
            this.currentLatchWait = new InsertIntoLatchWait();
        }
    }

    public Object newLatch(Object payload) {
        if (this.useSpin) {
            InsertIntoLatchSpin nextLatch;
            this.currentLatchSpin = nextLatch = new InsertIntoLatchSpin(this.currentLatchSpin, this.msecWait, payload, this.timeSourceService);
            return nextLatch;
        }
        InsertIntoLatchWait nextLatch = new InsertIntoLatchWait(this.currentLatchWait, this.msecWait, payload);
        this.currentLatchWait.setLater(nextLatch);
        this.currentLatchWait = nextLatch;
        return nextLatch;
    }
}

