/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.ResultDeliveryStrategy;
import com.espertech.esper.core.ResultDeliveryStrategyImpl;
import com.espertech.esper.event.NaturalEventBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultDeliveryStrategyObjectArr
implements ResultDeliveryStrategy {
    private static Log log = LogFactory.getLog(ResultDeliveryStrategyImpl.class);
    private final Object subscriber;
    private final FastMethod fastMethod;

    public ResultDeliveryStrategyObjectArr(Object subscriber, Method method) {
        this.subscriber = subscriber;
        FastClass fastClass = FastClass.create(Thread.currentThread().getContextClassLoader(), subscriber.getClass());
        this.fastMethod = fastClass.getMethod(method);
    }

    @Override
    public void execute(UniformPair<EventBean[]> result) {
        Object[][] newData = this.convert(result.getFirst());
        Object[][] oldData = this.convert(result.getSecond());
        Object[] params = new Object[]{newData, oldData};
        try {
            this.fastMethod.invoke(this.subscriber, params);
        }
        catch (InvocationTargetException e) {
            ResultDeliveryStrategyImpl.handle(log, e, params, this.subscriber, this.fastMethod);
        }
    }

    private Object[][] convert(EventBean[] events) {
        if (events == null || events.length == 0) {
            return null;
        }
        Object[][] result = new Object[events.length][];
        int length = 0;
        for (int i = 0; i < result.length; ++i) {
            if (!(events[i] instanceof NaturalEventBean)) continue;
            NaturalEventBean natural = (NaturalEventBean)events[i];
            result[length] = natural.getNatural();
            ++length;
        }
        if (length == 0) {
            return null;
        }
        if (length != events.length) {
            Object[][] reduced = new Object[length][];
            System.arraycopy(result, 0, reduced, 0, length);
            result = reduced;
        }
        return result;
    }
}

