/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EPServiceProviderIsolated;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.core.EPIsolationUnitServices;
import com.espertech.esper.core.EPServiceProviderIsolatedImpl;
import com.espertech.esper.core.EPServicesContext;
import com.espertech.esper.core.StatementIsolationService;
import com.espertech.esper.filter.FilterServiceProvider;
import com.espertech.esper.filter.FilterServiceSPI;
import com.espertech.esper.schedule.SchedulingServiceImpl;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatementIsolationServiceImpl
implements StatementIsolationService {
    private static final Log log = LogFactory.getLog(StatementIsolationServiceImpl.class);
    private final Map<String, EPServiceProviderIsolatedImpl> isolatedProviders = new ConcurrentHashMap<String, EPServiceProviderIsolatedImpl>();
    private EPServicesContext epServicesContext;
    private volatile int currentUnitId = 0;

    public void setEpServicesContext(EPServicesContext epServicesContext) {
        this.epServicesContext = epServicesContext;
    }

    public EPServiceProviderIsolated getIsolationUnit(String name, Integer optionalUnitId) {
        EPServiceProviderIsolatedImpl serviceProviderIsolated = this.isolatedProviders.get(name);
        if (serviceProviderIsolated != null) {
            return serviceProviderIsolated;
        }
        FilterServiceSPI filterService = FilterServiceProvider.newService();
        SchedulingServiceImpl scheduleService = new SchedulingServiceImpl(this.epServicesContext.getTimeSource());
        EPIsolationUnitServices services = new EPIsolationUnitServices(name, this.currentUnitId, filterService, scheduleService);
        serviceProviderIsolated = new EPServiceProviderIsolatedImpl(name, services, this.epServicesContext, this.isolatedProviders);
        this.isolatedProviders.put(name, serviceProviderIsolated);
        return serviceProviderIsolated;
    }

    public void destroy() {
        this.isolatedProviders.clear();
    }

    public String[] getIsolationUnitNames() {
        Set<String> keyset = this.isolatedProviders.keySet();
        return keyset.toArray(new String[keyset.size()]);
    }

    public void beginIsolatingStatements(String name, int unitId, EPStatement[] stmt) {
        if (log.isInfoEnabled()) {
            log.info("Begin isolating statements " + this.print(stmt) + " unit " + name + " id " + unitId);
        }
    }

    public void commitIsolatingStatements(String name, int unitId, EPStatement[] stmt) {
        if (log.isInfoEnabled()) {
            log.info("Completed isolating statements " + this.print(stmt) + " unit " + name + " id " + unitId);
        }
    }

    public void rollbackIsolatingStatements(String name, int unitId, EPStatement[] stmt) {
        if (log.isInfoEnabled()) {
            log.info("Failed isolating statements " + this.print(stmt) + " unit " + name + " id " + unitId);
        }
    }

    public void beginUnisolatingStatements(String name, int unitId, EPStatement[] stmt) {
        if (log.isInfoEnabled()) {
            log.info("Begin un-isolating statements " + this.print(stmt) + " unit " + name + " id " + unitId);
        }
    }

    public void commitUnisolatingStatements(String name, int unitId, EPStatement[] stmt) {
        if (log.isInfoEnabled()) {
            log.info("Completed un-isolating statements " + this.print(stmt) + " unit " + name + " id " + unitId);
        }
    }

    public void rollbackUnisolatingStatements(String name, int unitId, EPStatement[] stmt) {
        if (log.isInfoEnabled()) {
            log.info("Failed un-isolating statements " + this.print(stmt) + " unit " + name + " id " + unitId);
        }
    }

    public void newStatement(String stmtId, String stmtName, EPIsolationUnitServices isolatedServices) {
        log.info("New statement '" + stmtName + "' unit " + isolatedServices.getName());
    }

    private String print(EPStatement[] stmts) {
        StringBuilder buf = new StringBuilder();
        String delimiter = "";
        for (EPStatement stmt : stmts) {
            buf.append(delimiter);
            buf.append(stmt.getName());
            delimiter = ", ";
        }
        return buf.toString();
    }
}

