/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EPStatementException;
import com.espertech.esper.client.EPStatementState;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.Name;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.EPIsolationUnitServices;
import com.espertech.esper.core.EPServiceProviderSPI;
import com.espertech.esper.core.EPServicesContext;
import com.espertech.esper.core.EPStatementDestroyMethod;
import com.espertech.esper.core.EPStatementHandle;
import com.espertech.esper.core.EPStatementImpl;
import com.espertech.esper.core.EPStatementListenerSet;
import com.espertech.esper.core.EPStatementSPI;
import com.espertech.esper.core.EPStatementStartMethod;
import com.espertech.esper.core.EPStatementStartResult;
import com.espertech.esper.core.EPStatementStopMethod;
import com.espertech.esper.core.InsertIntoLatchFactory;
import com.espertech.esper.core.NamedWindowSelectedProps;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.core.StatementLifecycleEvent;
import com.espertech.esper.core.StatementLifecycleObserver;
import com.espertech.esper.core.StatementLifecycleSvc;
import com.espertech.esper.core.StatementMetadata;
import com.espertech.esper.core.StatementType;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.epl.expression.ExprNodeSubselectVisitor;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprNodeViewResourceVisitor;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.AnnotationDesc;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.FilterStreamSpecRaw;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.OnTriggerSetDesc;
import com.espertech.esper.epl.spec.OnTriggerSplitStream;
import com.espertech.esper.epl.spec.OnTriggerSplitStreamDesc;
import com.espertech.esper.epl.spec.OnTriggerType;
import com.espertech.esper.epl.spec.OnTriggerWindowUpdateDesc;
import com.espertech.esper.epl.spec.PatternStreamSpecCompiled;
import com.espertech.esper.epl.spec.PatternStreamSpecRaw;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementRaw;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseExprRawSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecCompiled;
import com.espertech.esper.epl.spec.SelectClauseSpecRaw;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamRawSpec;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.NativeEventType;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.pattern.EvalFilterNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNodeAnalysisResult;
import com.espertech.esper.util.ManagedReadWriteLock;
import com.espertech.esper.util.MetaDefItem;
import com.espertech.esper.util.UuidGenerator;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementLifecycleSvcImpl
implements StatementLifecycleSvc {
    private static Log log = LogFactory.getLog(StatementLifecycleSvcImpl.class);
    protected final EPServicesContext services;
    protected final Map<String, EPStatementDesc> stmtIdToDescMap;
    protected final Map<String, EPStatement> stmtNameToStmtMap;
    private final EPServiceProviderSPI epServiceProvider;
    private final ManagedReadWriteLock eventProcessingRWLock;
    private final Map<String, String> stmtNameToIdMap;
    private final Set<StatementLifecycleObserver> observers;

    public StatementLifecycleSvcImpl(EPServiceProvider epServiceProvider, EPServicesContext services) {
        this.services = services;
        this.epServiceProvider = (EPServiceProviderSPI)epServiceProvider;
        this.eventProcessingRWLock = services.getEventProcessingRWLock();
        this.stmtIdToDescMap = new HashMap<String, EPStatementDesc>();
        this.stmtNameToStmtMap = new HashMap<String, EPStatement>();
        this.stmtNameToIdMap = new LinkedHashMap<String, String>();
        this.observers = new CopyOnWriteArraySet<StatementLifecycleObserver>();
    }

    @Override
    public void addObserver(StatementLifecycleObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(StatementLifecycleObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void destroy() {
        this.destroyAllStatements();
    }

    @Override
    public void init() {
    }

    @Override
    public synchronized EPStatement createAndStart(StatementSpecRaw statementSpec, String expression, boolean isPattern, String optStatementName, Object userObject, EPIsolationUnitServices isolationUnitServices) {
        String statementId = UuidGenerator.generate();
        return this.createAndStart(statementSpec, expression, isPattern, optStatementName, statementId, null, userObject, isolationUnitServices);
    }

    protected synchronized EPStatement createAndStart(StatementSpecRaw statementSpec, String expression, boolean isPattern, String optStatementName, String statementId, Map<String, Object> optAdditionalContext, Object userObject, EPIsolationUnitServices isolationUnitServices) {
        boolean nameProvided = false;
        String statementName = statementId;
        if (optStatementName == null && statementSpec.getAnnotations() != null && !statementSpec.getAnnotations().isEmpty()) {
            for (AnnotationDesc desc : statementSpec.getAnnotations()) {
                if (!desc.getName().equals(Name.class.getSimpleName()) && !desc.getName().equals(Name.class.getName()) || desc.getAttributes().get(0) == null) continue;
                optStatementName = desc.getAttributes().get(0).getSecond().toString();
            }
        }
        if (optStatementName != null) {
            statementName = this.getUniqueStatementName(optStatementName, statementId);
            nameProvided = true;
        }
        EPStatementDesc desc = this.createStopped(statementSpec, expression, isPattern, statementName, nameProvided, statementId, optAdditionalContext, userObject, isolationUnitServices, false);
        this.start(statementId, desc, true, false, false);
        return desc.getEpStatement();
    }

    protected synchronized EPStatementDesc createStopped(StatementSpecRaw statementSpec, String expression, boolean isPattern, String statementName, boolean nameProvided, String statementId, Map<String, Object> optAdditionalContext, Object userObject, EPIsolationUnitServices isolationUnitServices, boolean isFailed) {
        EPStatementDesc statementDesc;
        StatementSpecCompiled compiledSpec;
        Annotation[] annotations = AnnotationUtil.compileAnnotations(statementSpec.getAnnotations(), this.services.getEngineImportService(), expression);
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof Hint)) continue;
                statementSpec.setHasVariables(true);
            }
        }
        StatementContext statementContext = this.services.getStatementContextFactory().makeContext(statementId, statementName, expression, statementSpec.isHasVariables(), this.services, optAdditionalContext, statementSpec.getOnTriggerDesc(), statementSpec.getCreateWindowDesc(), false, annotations, isolationUnitServices);
        try {
            compiledSpec = StatementLifecycleSvcImpl.compile(statementSpec, expression, statementContext, false, annotations);
        }
        catch (EPStatementException ex) {
            this.stmtNameToIdMap.remove(statementName);
            throw ex;
        }
        if (statementSpec.getInsertIntoDesc() != null) {
            String insertIntoStreamName = statementSpec.getInsertIntoDesc().getEventTypeName();
            String latchFactoryName = "insert_stream_" + insertIntoStreamName + "_" + statementId;
            long msecTimeout = this.services.getEngineSettingsService().getEngineSettings().getThreading().getInsertIntoDispatchTimeout();
            ConfigurationEngineDefaults.Threading.Locking locking = this.services.getEngineSettingsService().getEngineSettings().getThreading().getInsertIntoDispatchLocking();
            InsertIntoLatchFactory latchFactory = new InsertIntoLatchFactory(latchFactoryName, msecTimeout, locking, this.services.getTimeSource());
            statementContext.getEpStatementHandle().setInsertIntoLatchFactory(latchFactory);
        }
        boolean canSelfJoin = this.isPotentialSelfJoin(compiledSpec);
        statementContext.getEpStatementHandle().setCanSelfJoin(canSelfJoin);
        this.services.getStatementEventTypeRefService().addReferences(statementName, compiledSpec.getEventTypeReferences());
        this.services.getStatementVariableRefService().addReferences(statementName, compiledSpec.getVariableReferences());
        StatementType statementType = null;
        if (statementSpec.getCreateVariableDesc() != null) {
            statementType = StatementType.CREATE_VARIABLE;
        } else if (statementSpec.getCreateWindowDesc() != null) {
            statementType = StatementType.CREATE_WINDOW;
        } else if (statementSpec.getOnTriggerDesc() != null) {
            if (statementSpec.getOnTriggerDesc().getOnTriggerType() == OnTriggerType.ON_DELETE) {
                statementType = StatementType.ON_DELETE;
            } else if (statementSpec.getOnTriggerDesc().getOnTriggerType() == OnTriggerType.ON_UPDATE) {
                statementType = StatementType.ON_UPDATE;
            } else if (statementSpec.getOnTriggerDesc().getOnTriggerType() == OnTriggerType.ON_SELECT) {
                statementType = statementSpec.getInsertIntoDesc() != null ? StatementType.ON_INSERT : StatementType.ON_SELECT;
            } else if (statementSpec.getOnTriggerDesc().getOnTriggerType() == OnTriggerType.ON_SET) {
                statementType = StatementType.ON_SET;
            }
        } else if (statementSpec.getInsertIntoDesc() != null) {
            statementType = StatementType.INSERT_INTO;
        } else if (isPattern) {
            statementType = StatementType.PATTERN;
        }
        if (statementType == null) {
            statementType = StatementType.SELECT;
        }
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            boolean preserveDispatchOrder = this.services.getEngineSettingsService().getEngineSettings().getThreading().isListenerDispatchPreserveOrder();
            boolean isSpinLocks = this.services.getEngineSettingsService().getEngineSettings().getThreading().getListenerDispatchLocking() == ConfigurationEngineDefaults.Threading.Locking.SPIN;
            long blockingTimeout = this.services.getEngineSettingsService().getEngineSettings().getThreading().getListenerDispatchTimeout();
            long timeLastStateChange = this.services.getSchedulingService().getTime();
            EPStatementImpl statement = new EPStatementImpl(statementId, statementName, expression, statementSpec.getExpressionNoAnnotations(), isPattern, this.services.getDispatchService(), this, timeLastStateChange, preserveDispatchOrder, isSpinLocks, blockingTimeout, this.services.getTimeSource(), new StatementMetadata(statementType), userObject, compiledSpec.getAnnotations(), statementContext, isFailed, nameProvided);
            boolean isInsertInto = statementSpec.getInsertIntoDesc() != null;
            boolean isDistinct = statementSpec.getSelectClauseSpec().isDistinct();
            statementContext.getStatementResultService().setContext(statement, this.epServiceProvider, isInsertInto, isPattern, isDistinct, statementContext.getEpStatementHandle().getMetricsHandle());
            EPStatementStartMethod startMethod = new EPStatementStartMethod(compiledSpec, this.services, statementContext);
            String insertIntoStreamName = null;
            if (statementSpec.getInsertIntoDesc() != null) {
                insertIntoStreamName = statementSpec.getInsertIntoDesc().getEventTypeName();
            }
            statementDesc = new EPStatementDesc(statement, startMethod, null, null, insertIntoStreamName, statementContext.getEpStatementHandle(), statementContext);
            this.stmtIdToDescMap.put(statementId, statementDesc);
            this.stmtNameToStmtMap.put(statementName, statement);
            this.stmtNameToIdMap.put(statementName, statementId);
            this.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(statement, StatementLifecycleEvent.LifecycleEventType.CREATE, new Object[0]));
        }
        catch (RuntimeException ex) {
            this.stmtIdToDescMap.remove(statementId);
            this.stmtNameToIdMap.remove(statementName);
            this.stmtNameToStmtMap.remove(statementName);
            throw ex;
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
        return statementDesc;
    }

    private boolean isPotentialSelfJoin(StatementSpecCompiled spec) {
        int i;
        if (!spec.getOrderByList().isEmpty()) {
            return true;
        }
        for (StreamSpecCompiled streamSpec : spec.getStreamSpecs()) {
            if (!(streamSpec instanceof PatternStreamSpecCompiled)) continue;
            return true;
        }
        if (spec.getStreamSpecs().size() <= 1 && spec.getSubSelectExpressions().isEmpty()) {
            return false;
        }
        ArrayList<EventType> filteredTypes = new ArrayList<EventType>();
        Set<EventType> optSubselectTypes = this.populateSubqueryTypes(spec.getSubSelectExpressions());
        boolean hasFilterStream = false;
        for (StreamSpecCompiled streamSpec : spec.getStreamSpecs()) {
            if (!(streamSpec instanceof FilterStreamSpecCompiled)) continue;
            EventType type = ((FilterStreamSpecCompiled)streamSpec).getFilterSpec().getFilterForEventType();
            filteredTypes.add(type);
            hasFilterStream = true;
        }
        if (filteredTypes.size() == 1 && optSubselectTypes.isEmpty()) {
            return false;
        }
        if (!hasFilterStream) {
            return false;
        }
        for (i = 0; i < filteredTypes.size(); ++i) {
            for (int j = i + 1; j < filteredTypes.size(); ++j) {
                EventType typeTwo;
                EventType typeOne = (EventType)filteredTypes.get(i);
                if (typeOne == (typeTwo = (EventType)filteredTypes.get(j))) {
                    return true;
                }
                if (typeOne.getSuperTypes() != null) {
                    for (EventType typeOneSuper : typeOne.getSuperTypes()) {
                        if (typeOneSuper != typeTwo) continue;
                        return true;
                    }
                }
                if (typeTwo.getSuperTypes() == null) continue;
                for (EventType typeTwoSuper : typeTwo.getSuperTypes()) {
                    if (typeOne != typeTwoSuper) continue;
                    return true;
                }
            }
        }
        if (!optSubselectTypes.isEmpty()) {
            for (i = 0; i < filteredTypes.size(); ++i) {
                EventType typeOne = (EventType)filteredTypes.get(i);
                if (optSubselectTypes.contains(typeOne)) {
                    return true;
                }
                if (typeOne.getSuperTypes() == null) continue;
                for (EventType typeOneSuper : typeOne.getSuperTypes()) {
                    if (!optSubselectTypes.contains(typeOneSuper)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Set<EventType> populateSubqueryTypes(List<ExprSubselectNode> subSelectExpressions) {
        HashSet<EventType> set = null;
        for (ExprSubselectNode subselect : subSelectExpressions) {
            for (StreamSpecCompiled streamSpec : subselect.getStatementSpecCompiled().getStreamSpecs()) {
                if (streamSpec instanceof FilterStreamSpecCompiled) {
                    EventType type = ((FilterStreamSpecCompiled)streamSpec).getFilterSpec().getFilterForEventType();
                    if (set == null) {
                        set = new HashSet<EventType>();
                    }
                    set.add(type);
                    continue;
                }
                if (!(streamSpec instanceof PatternStreamSpecCompiled)) continue;
                EvalNodeAnalysisResult evalNodeAnalysisResult = EvalNode.recursiveAnalyzeChildNodes(((PatternStreamSpecCompiled)streamSpec).getEvalNode());
                List<EvalFilterNode> filterNodes = evalNodeAnalysisResult.getFilterNodes();
                for (EvalFilterNode filterNode : filterNodes) {
                    if (set == null) {
                        set = new HashSet();
                    }
                    set.add(filterNode.getFilterSpec().getFilterForEventType());
                }
            }
        }
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start(String statementId) {
        if (log.isDebugEnabled()) {
            log.debug(".start Starting statement " + statementId);
        }
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            EPStatementDesc desc = this.stmtIdToDescMap.get(statementId);
            if (desc == null) {
                throw new IllegalStateException("Cannot start statement, statement is in destroyed state");
            }
            this.startInternal(statementId, desc, false, false, false);
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String statementId, EPStatementDesc desc, boolean isNewStatement, boolean isRecoveringStatement, boolean isResilient) {
        if (log.isDebugEnabled()) {
            log.debug(".start Starting statement " + statementId + " from desc=" + desc);
        }
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            this.startInternal(statementId, desc, isNewStatement, isRecoveringStatement, isResilient);
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
    }

    private void startInternal(String statementId, EPStatementDesc desc, boolean isNewStatement, boolean isRecoveringStatement, boolean isResilient) {
        EPStatementStartResult startResult;
        if (log.isDebugEnabled()) {
            log.debug(".startInternal Starting statement " + statementId + " from desc=" + desc);
        }
        if (desc.getStartMethod() == null) {
            throw new IllegalStateException("Statement start method not found for id " + statementId);
        }
        EPStatementSPI statement = desc.getEpStatement();
        if (statement.getState() == EPStatementState.STARTED) {
            log.debug(".startInternal - Statement already started");
            return;
        }
        try {
            startResult = desc.getStartMethod().start(isNewStatement, isRecoveringStatement, isResilient);
        }
        catch (EPStatementException ex) {
            this.stmtIdToDescMap.remove(statementId);
            this.stmtNameToIdMap.remove(statement.getName());
            this.stmtNameToStmtMap.remove(statement.getName());
            log.debug(".start Error starting statement", ex);
            throw ex;
        }
        catch (ExprValidationException ex) {
            this.stmtIdToDescMap.remove(statementId);
            this.stmtNameToIdMap.remove(statement.getName());
            this.stmtNameToStmtMap.remove(statement.getName());
            log.debug(".start Error starting statement", ex);
            throw new EPStatementException("Error starting statement: " + ex.getMessage(), statement.getText());
        }
        catch (ViewProcessingException ex) {
            this.stmtIdToDescMap.remove(statementId);
            this.stmtNameToIdMap.remove(statement.getName());
            this.stmtNameToStmtMap.remove(statement.getName());
            log.debug(".start Error starting statement", ex);
            throw new EPStatementException("Error starting statement: " + ex.getMessage(), statement.getText());
        }
        this.services.getStatementEventTypeRefService().addReferences(desc.getEpStatement().getName(), desc.getStatementContext().getDynamicReferenceEventTypes());
        Viewable parentView = startResult.getViewable();
        desc.setStopMethod(startResult.getStopMethod());
        desc.setDestroyMethod(startResult.getDestroyMethod());
        statement.setParentView(parentView);
        long timeLastStateChange = this.services.getSchedulingService().getTime();
        statement.setCurrentState(EPStatementState.STARTED, timeLastStateChange);
        this.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(statement, StatementLifecycleEvent.LifecycleEventType.STATECHANGE, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop(String statementId) {
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            EPStatementDesc desc = this.stmtIdToDescMap.get(statementId);
            if (desc == null) {
                throw new IllegalStateException("Cannot stop statement, statement is in destroyed state");
            }
            EPStatementSPI statement = desc.getEpStatement();
            EPStatementStopMethod stopMethod = desc.getStopMethod();
            if (stopMethod == null) {
                throw new IllegalStateException("Stop method not found for statement " + statementId);
            }
            if (statement.getState() == EPStatementState.STOPPED) {
                log.debug(".startInternal - Statement already stopped");
                return;
            }
            stopMethod.stop();
            statement.setParentView(null);
            desc.setStopMethod(null);
            long timeLastStateChange = this.services.getSchedulingService().getTime();
            statement.setCurrentState(EPStatementState.STOPPED, timeLastStateChange);
            this.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(statement, StatementLifecycleEvent.LifecycleEventType.STATECHANGE, new Object[0]));
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy(String statementId) {
        this.eventProcessingRWLock.acquireWriteLock();
        try {
            EPStatementDesc desc = this.stmtIdToDescMap.get(statementId);
            if (desc == null) {
                log.debug(".startInternal - Statement already destroyed");
                return;
            }
            this.services.getStatementEventTypeRefService().removeReferencesStatement(desc.getEpStatement().getName());
            this.services.getStatementVariableRefService().removeReferencesStatement(desc.getEpStatement().getName());
            EPStatementSPI statement = desc.getEpStatement();
            if (statement.getState() == EPStatementState.STARTED) {
                EPStatementStopMethod stopMethod = desc.getStopMethod();
                statement.setParentView(null);
                stopMethod.stop();
            }
            if (desc.getDestroyMethod() != null) {
                desc.getDestroyMethod().destroy();
            }
            long timeLastStateChange = this.services.getSchedulingService().getTime();
            statement.setCurrentState(EPStatementState.DESTROYED, timeLastStateChange);
            this.stmtNameToStmtMap.remove(statement.getName());
            this.stmtNameToIdMap.remove(statement.getName());
            this.stmtIdToDescMap.remove(statementId);
            this.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(statement, StatementLifecycleEvent.LifecycleEventType.STATECHANGE, new Object[0]));
        }
        finally {
            this.eventProcessingRWLock.releaseWriteLock();
        }
    }

    @Override
    public synchronized EPStatement getStatementByName(String name) {
        return this.stmtNameToStmtMap.get(name);
    }

    public EPStatementSPI getStatementById(String id) {
        EPStatementDesc statementDesc = this.stmtIdToDescMap.get(id);
        if (statementDesc == null) {
            log.warn("Could not locate statement descriptor for statement id '" + id + "'");
            return null;
        }
        return statementDesc.getEpStatement();
    }

    @Override
    public synchronized String[] getStatementNames() {
        String[] statements = new String[this.stmtNameToStmtMap.size()];
        int count = 0;
        for (String key : this.stmtNameToStmtMap.keySet()) {
            statements[count++] = key;
        }
        return statements;
    }

    @Override
    public synchronized void startAllStatements() throws EPException {
        String[] statementIds = this.getStatementIds();
        for (int i = 0; i < statementIds.length; ++i) {
            EPStatementSPI statement = this.stmtIdToDescMap.get(statementIds[i]).getEpStatement();
            if (statement.getState() != EPStatementState.STOPPED) continue;
            this.start(statementIds[i]);
        }
    }

    @Override
    public synchronized void stopAllStatements() throws EPException {
        String[] statementIds = this.getStatementIds();
        for (int i = 0; i < statementIds.length; ++i) {
            EPStatementSPI statement = this.stmtIdToDescMap.get(statementIds[i]).getEpStatement();
            if (statement.getState() != EPStatementState.STARTED) continue;
            this.stop(statementIds[i]);
        }
    }

    @Override
    public synchronized void destroyAllStatements() throws EPException {
        String[] statementIds = this.getStatementIds();
        for (int i = 0; i < statementIds.length; ++i) {
            try {
                this.destroy(statementIds[i]);
                continue;
            }
            catch (Exception ex) {
                log.warn("Error destroying statement:" + ex.getMessage());
            }
        }
    }

    private String[] getStatementIds() {
        String[] statementIds = new String[this.stmtNameToIdMap.size()];
        int count = 0;
        for (String id : this.stmtNameToIdMap.values()) {
            statementIds[count++] = id;
        }
        return statementIds;
    }

    private String getUniqueStatementName(String statementName, String statementId) {
        String finalStatementName;
        if (this.stmtNameToIdMap.containsKey(statementName)) {
            int count = 0;
            while (this.stmtNameToIdMap.containsKey(finalStatementName = statementName + "--" + count)) {
                if (count > 0x7FFFFFFD) {
                    throw new EPException("Failed to establish a unique statement name");
                }
                ++count;
            }
        } else {
            finalStatementName = statementName;
        }
        this.stmtNameToIdMap.put(finalStatementName, statementId);
        return finalStatementName;
    }

    @Override
    public void updatedListeners(EPStatement statement, EPStatementListenerSet listeners) {
        log.debug(".updatedListeners No action for base implementation");
    }

    protected static StatementSpecCompiled compile(StatementSpecRaw spec, String eplStatement, StatementContext statementContext, boolean isSubquery, Annotation[] annotations) throws EPStatementException {
        ArrayList<StreamSpecCompiled> compiledStreams;
        MetaDefItem raw;
        HashSet<String> eventTypeReferences = new HashSet<String>();
        if (spec.getStreamSpecs().size() == 1 && spec.getStreamSpecs().get(0) instanceof FilterStreamSpecRaw && spec.getStreamSpecs().get(0).getViewSpecs().isEmpty() && spec.getFilterRootNode() != null && spec.getOnTriggerDesc() == null && !isSubquery) {
            boolean disqualified;
            ExprNode whereClause = spec.getFilterRootNode();
            ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
            whereClause.accept(visitor);
            boolean bl = disqualified = visitor.getSubselects().size() > 0;
            if (!disqualified) {
                ExprNodeViewResourceVisitor viewResourceVisitor = new ExprNodeViewResourceVisitor();
                whereClause.accept(viewResourceVisitor);
                boolean bl2 = disqualified = viewResourceVisitor.getExprNodes().size() > 0;
            }
            if (!disqualified) {
                String alias = spec.getStreamSpecs().get(0).getOptionalStreamName();
                if (alias != null) {
                    ExprNodeIdentifierCollectVisitor v = new ExprNodeIdentifierCollectVisitor();
                    whereClause.accept(v);
                    for (ExprIdentNode node : v.getExprProperties()) {
                        if (node.getStreamOrPropertyName() == null || !node.getStreamOrPropertyName().equals(alias)) continue;
                        node.setStreamOrPropertyName(null);
                    }
                }
                spec.setFilterRootNode(null);
                FilterStreamSpecRaw streamSpec = (FilterStreamSpecRaw)spec.getStreamSpecs().get(0);
                streamSpec.getRawFilterSpec().getFilterExpressions().add(whereClause);
            }
        }
        ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
        ArrayList<SelectClauseElementCompiled> selectElements = new ArrayList<SelectClauseElementCompiled>();
        SelectClauseSpecCompiled selectClauseCompiled = new SelectClauseSpecCompiled(selectElements, spec.getSelectClauseSpec().isDistinct());
        for (SelectClauseElementRaw raw2 : spec.getSelectClauseSpec().getSelectExprList()) {
            SelectClauseElementRaw rawExpr;
            if (raw2 instanceof SelectClauseExprRawSpec) {
                rawExpr = (SelectClauseExprRawSpec)raw2;
                ((SelectClauseExprRawSpec)rawExpr).getSelectExpression().accept(visitor);
                selectElements.add(new SelectClauseExprCompiledSpec(((SelectClauseExprRawSpec)rawExpr).getSelectExpression(), ((SelectClauseExprRawSpec)rawExpr).getOptionalAsName()));
                continue;
            }
            if (raw2 instanceof SelectClauseStreamRawSpec) {
                rawExpr = (SelectClauseStreamRawSpec)raw2;
                selectElements.add(new SelectClauseStreamCompiledSpec(((SelectClauseStreamRawSpec)rawExpr).getStreamName(), ((SelectClauseStreamRawSpec)rawExpr).getOptionalAsName()));
                continue;
            }
            if (raw2 instanceof SelectClauseElementWildcard) {
                SelectClauseElementWildcard wildcard = (SelectClauseElementWildcard)raw2;
                selectElements.add(wildcard);
                continue;
            }
            throw new IllegalStateException("Unexpected select clause element class : " + raw2.getClass().getName());
        }
        if (spec.getFilterRootNode() != null) {
            spec.getFilterRootNode().accept(visitor);
        }
        if (spec.getUpdateDesc() != null) {
            if (spec.getUpdateDesc().getOptionalWhereClause() != null) {
                spec.getUpdateDesc().getOptionalWhereClause().accept(visitor);
            }
            for (OnTriggerSetAssignment assignment : spec.getUpdateDesc().getAssignments()) {
                assignment.getExpression().accept(visitor);
            }
        }
        if (spec.getOnTriggerDesc() != null) {
            if (spec.getOnTriggerDesc() instanceof OnTriggerWindowUpdateDesc) {
                OnTriggerWindowUpdateDesc updates = (OnTriggerWindowUpdateDesc)spec.getOnTriggerDesc();
                for (OnTriggerSetAssignment assignment : updates.getAssignments()) {
                    assignment.getExpression().accept(visitor);
                }
            } else if (spec.getOnTriggerDesc() instanceof OnTriggerSetDesc) {
                OnTriggerSetDesc sets = (OnTriggerSetDesc)spec.getOnTriggerDesc();
                for (OnTriggerSetAssignment assignment : sets.getAssignments()) {
                    assignment.getExpression().accept(visitor);
                }
            } else if (spec.getOnTriggerDesc() instanceof OnTriggerSplitStreamDesc) {
                OnTriggerSplitStreamDesc splits = (OnTriggerSplitStreamDesc)spec.getOnTriggerDesc();
                for (OnTriggerSplitStream split : splits.getSplitStreams()) {
                    if (split.getWhereClause() != null) {
                        split.getWhereClause().accept(visitor);
                    }
                    if (split.getSelectClause().getSelectExprList() == null) continue;
                    for (SelectClauseElementRaw element : split.getSelectClause().getSelectExprList()) {
                        if (!(element instanceof SelectClauseExprRawSpec)) continue;
                        SelectClauseExprRawSpec selectExpr = (SelectClauseExprRawSpec)element;
                        selectExpr.getSelectExpression().accept(visitor);
                    }
                }
            }
        }
        for (StreamSpecRaw streamSpecRaw : spec.getStreamSpecs()) {
            if (!(streamSpecRaw instanceof PatternStreamSpecRaw)) continue;
            PatternStreamSpecRaw patternStreamSpecRaw = (PatternStreamSpecRaw)streamSpecRaw;
            EvalNodeAnalysisResult analysisResult = EvalNode.recursiveAnalyzeChildNodes(patternStreamSpecRaw.getEvalNode());
            for (EvalFilterNode filterNode : analysisResult.getFilterNodes()) {
                for (ExprNode filterExpr : filterNode.getRawFilterSpec().getFilterExpressions()) {
                    filterExpr.accept(visitor);
                }
            }
        }
        for (StreamSpecRaw rawSpec : spec.getStreamSpecs()) {
            if (!(rawSpec instanceof FilterStreamSpecRaw)) continue;
            raw = (FilterStreamSpecRaw)rawSpec;
            for (ExprNode filterExpr : raw.getRawFilterSpec().getFilterExpressions()) {
                filterExpr.accept(visitor);
            }
        }
        for (ExprSubselectNode subselect : visitor.getSubselects()) {
            raw = subselect.getStatementSpecRaw();
            StatementSpecCompiled compiled = StatementLifecycleSvcImpl.compile((StatementSpecRaw)raw, eplStatement, statementContext, true, new Annotation[0]);
            subselect.setStatementSpecCompiled(compiled);
        }
        try {
            compiledStreams = new ArrayList<StreamSpecCompiled>();
            for (StreamSpecRaw rawSpec : spec.getStreamSpecs()) {
                StreamSpecCompiled compiled = rawSpec.compile(statementContext, eventTypeReferences, spec.getInsertIntoDesc() != null);
                compiledStreams.add(compiled);
            }
        }
        catch (ExprValidationException ex) {
            log.info("Failed to compile statement: " + ex.getMessage(), ex);
            if (ex.getMessage() == null) {
                throw new EPStatementException("Unexpected exception compiling statement, please consult the log file and report the exception", eplStatement);
            }
            throw new EPStatementException(ex.getMessage(), eplStatement);
        }
        catch (RuntimeException ex) {
            String text = "Unexpected error compiling statement";
            log.error(text, ex);
            throw new EPStatementException(text + ": " + ex.getClass().getName() + ":" + ex.getMessage(), eplStatement);
        }
        if (spec.getCreateWindowDesc() != null) {
            try {
                String selectFromTypeName;
                EventType selectFromType;
                StreamSpecCompiled createWindowTypeSpec = (StreamSpecCompiled)compiledStreams.get(0);
                if (createWindowTypeSpec instanceof FilterStreamSpecCompiled) {
                    FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)createWindowTypeSpec;
                    selectFromType = filterStreamSpec.getFilterSpec().getFilterForEventType();
                    selectFromTypeName = filterStreamSpec.getFilterSpec().getFilterForEventTypeName();
                    if (spec.getCreateWindowDesc().getInsertFilter() != null) {
                        throw new EPStatementException("A named window by name '" + selectFromTypeName + "' could not be located, use the insert-keyword with an existing named window", eplStatement);
                    }
                } else {
                    NamedWindowConsumerStreamSpec consumerStreamSpec = (NamedWindowConsumerStreamSpec)createWindowTypeSpec;
                    selectFromType = statementContext.getEventAdapterService().getExistsTypeByName(consumerStreamSpec.getWindowName());
                    selectFromTypeName = consumerStreamSpec.getWindowName();
                    if (spec.getCreateWindowDesc().getInsertFilter() != null) {
                        ExprNode insertIntoFilter = spec.getCreateWindowDesc().getInsertFilter();
                        String checkMinimal = ExprNodeUtility.isMinimalExpression(insertIntoFilter);
                        if (checkMinimal != null) {
                            throw new ExprValidationException("Create window where-clause may not have " + checkMinimal);
                        }
                        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(selectFromType, selectFromTypeName, true, statementContext.getEngineURI());
                        ExprNode insertFilter = spec.getCreateWindowDesc().getInsertFilter().getValidatedSubtree(streamTypeService, statementContext.getMethodResolutionService(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), statementContext);
                        spec.getCreateWindowDesc().setInsertFilter(insertFilter);
                    }
                    spec.getCreateWindowDesc().setInsertFromWindow(consumerStreamSpec.getWindowName());
                }
                Pair<FilterSpecCompiled, SelectClauseSpecRaw> newFilter = StatementLifecycleSvcImpl.handleCreateWindow(selectFromType, selectFromTypeName, spec, eplStatement, statementContext);
                eventTypeReferences.add(((EventTypeSPI)newFilter.getFirst().getFilterForEventType()).getMetadata().getPrimaryName());
                if (spec.getCreateWindowDesc().getViewSpecs().isEmpty()) {
                    throw new ExprValidationException("Named windows require one or more child views that are data window views");
                }
                compiledStreams.clear();
                ArrayList<ViewSpec> views = new ArrayList<ViewSpec>(spec.getCreateWindowDesc().getViewSpecs());
                compiledStreams.add(new FilterStreamSpecCompiled(newFilter.getFirst(), views, null, spec.getCreateWindowDesc().getStreamSpecOptions()));
                spec.setSelectClauseSpec(newFilter.getSecond());
            }
            catch (ExprValidationException e) {
                throw new EPStatementException(e.getMessage(), eplStatement);
            }
        }
        return new StatementSpecCompiled(spec.getOnTriggerDesc(), spec.getCreateWindowDesc(), spec.getCreateIndexDesc(), spec.getCreateVariableDesc(), spec.getInsertIntoDesc(), spec.getSelectStreamSelectorEnum(), selectClauseCompiled, compiledStreams, spec.getOuterJoinDescList(), spec.getFilterRootNode(), spec.getGroupByExpressions(), spec.getHavingExprRootNode(), spec.getOutputLimitSpec(), spec.getOrderByList(), visitor.getSubselects(), spec.getReferencedVariables(), spec.getRowLimitSpec(), eventTypeReferences, annotations, spec.getUpdateDesc(), spec.getMatchRecognizeSpec());
    }

    public static SelectClauseSpecCompiled compileSelectAllowSubselect(SelectClauseSpecRaw spec) throws ExprValidationException {
        ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
        ArrayList<SelectClauseElementCompiled> selectElements = new ArrayList<SelectClauseElementCompiled>();
        SelectClauseSpecCompiled selectClauseCompiled = new SelectClauseSpecCompiled(selectElements, spec.isDistinct());
        for (SelectClauseElementRaw raw : spec.getSelectExprList()) {
            SelectClauseElementRaw rawExpr;
            if (raw instanceof SelectClauseExprRawSpec) {
                rawExpr = (SelectClauseExprRawSpec)raw;
                ((SelectClauseExprRawSpec)rawExpr).getSelectExpression().accept(visitor);
                selectElements.add(new SelectClauseExprCompiledSpec(((SelectClauseExprRawSpec)rawExpr).getSelectExpression(), ((SelectClauseExprRawSpec)rawExpr).getOptionalAsName()));
                continue;
            }
            if (raw instanceof SelectClauseStreamRawSpec) {
                rawExpr = (SelectClauseStreamRawSpec)raw;
                selectElements.add(new SelectClauseStreamCompiledSpec(((SelectClauseStreamRawSpec)rawExpr).getStreamName(), ((SelectClauseStreamRawSpec)rawExpr).getOptionalAsName()));
                continue;
            }
            if (raw instanceof SelectClauseElementWildcard) {
                SelectClauseElementWildcard wildcard = (SelectClauseElementWildcard)raw;
                selectElements.add(wildcard);
                continue;
            }
            throw new IllegalStateException("Unexpected select clause element class : " + raw.getClass().getName());
        }
        return selectClauseCompiled;
    }

    private static Pair<FilterSpecCompiled, SelectClauseSpecRaw> handleCreateWindow(EventType selectFromType, String selectFromTypeName, StatementSpecRaw spec, String eplStatement, StatementContext statementContext) throws ExprValidationException {
        EventType targetType;
        String typeName = spec.getCreateWindowDesc().getWindowName();
        List<NamedWindowSelectedProps> select = StatementLifecycleSvcImpl.compileLimitedSelect(spec.getSelectClauseSpec(), eplStatement, selectFromType, selectFromTypeName, statementContext.getEngineURI(), statementContext);
        SelectClauseSpecRaw newSelectClauseSpecRaw = new SelectClauseSpecRaw();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (NamedWindowSelectedProps selectElement : select) {
            if (selectElement.getFragmentType() != null) {
                properties.put(selectElement.getAssignedName(), selectElement.getFragmentType());
            } else {
                properties.put(selectElement.getAssignedName(), selectElement.getSelectExpressionType());
            }
            newSelectClauseSpecRaw.add(new SelectClauseExprRawSpec(new ExprIdentNode(selectElement.getAssignedName()), null));
        }
        boolean isWildcard = spec.getSelectClauseSpec().isUsingWildcard();
        if (statementContext.getValueAddEventService().isRevisionTypeName(selectFromTypeName)) {
            targetType = statementContext.getValueAddEventService().createRevisionType(typeName, selectFromTypeName, statementContext.getStatementStopService(), statementContext.getEventAdapterService());
        } else if (isWildcard) {
            targetType = statementContext.getEventAdapterService().addWrapperType(typeName, selectFromType, properties, true, false);
        } else if (spec.getSelectClauseSpec().getSelectExprList().size() > 0) {
            targetType = statementContext.getEventAdapterService().addNestableMapType(typeName, properties, null, false, true, false);
        } else if (selectFromType instanceof MapEventType) {
            MapEventType mapType = (MapEventType)selectFromType;
            targetType = statementContext.getEventAdapterService().addNestableMapType(typeName, mapType.getTypes(), null, false, true, false);
        } else {
            HashMap<String, Object> addOnTypes = new HashMap<String, Object>();
            targetType = statementContext.getEventAdapterService().addWrapperType(typeName, selectFromType, addOnTypes, true, false);
        }
        FilterSpecCompiled filter = new FilterSpecCompiled(targetType, typeName, new ArrayList<FilterSpecParam>(), null);
        return new Pair<FilterSpecCompiled, SelectClauseSpecRaw>(filter, newSelectClauseSpecRaw);
    }

    private static List<NamedWindowSelectedProps> compileLimitedSelect(SelectClauseSpecRaw spec, String eplStatement, EventType singleType, String selectFromTypeName, String engineURI, ExprEvaluatorContext exprEvaluatorContext) {
        LinkedList<NamedWindowSelectedProps> selectProps = new LinkedList<NamedWindowSelectedProps>();
        StreamTypeServiceImpl streams = new StreamTypeServiceImpl(new EventType[]{singleType}, new String[]{"stream_0"}, new boolean[]{false}, engineURI);
        for (SelectClauseElementRaw raw : spec.getSelectExprList()) {
            ExprIdentNode identNode;
            FragmentEventType fragmentEventType;
            ExprNode validatedExpression;
            if (!(raw instanceof SelectClauseExprRawSpec)) continue;
            SelectClauseExprRawSpec exprSpec = (SelectClauseExprRawSpec)raw;
            try {
                validatedExpression = exprSpec.getSelectExpression().getValidatedSubtree(streams, null, null, null, null, exprEvaluatorContext);
            }
            catch (ExprValidationException e) {
                throw new EPStatementException(e.getMessage(), eplStatement);
            }
            String asName = exprSpec.getOptionalAsName();
            if (asName == null) {
                asName = validatedExpression.toExpressionString();
            }
            EventType fragmentType = null;
            if (validatedExpression instanceof ExprIdentNode && !(singleType instanceof NativeEventType) && (fragmentEventType = singleType.getFragmentType((identNode = (ExprIdentNode)validatedExpression).getFullUnresolvedName())) != null && !fragmentEventType.isNative()) {
                fragmentType = fragmentEventType.getFragmentType();
            }
            NamedWindowSelectedProps validatedElement = new NamedWindowSelectedProps(validatedExpression.getType(), asName, fragmentType);
            selectProps.add(validatedElement);
        }
        return selectProps;
    }

    @Override
    public void dispatchStatementLifecycleEvent(StatementLifecycleEvent event) {
        for (StatementLifecycleObserver observer : this.observers) {
            observer.observe(event);
        }
    }

    public static class EPStatementDesc {
        private EPStatementSPI epStatement;
        private EPStatementStartMethod startMethod;
        private EPStatementStopMethod stopMethod;
        private EPStatementDestroyMethod destroyMethod;
        private String optInsertIntoStream;
        private EPStatementHandle statementHandle;
        private StatementContext statementContext;

        public EPStatementDesc(EPStatementSPI epStatement, EPStatementStartMethod startMethod, EPStatementStopMethod stopMethod, EPStatementDestroyMethod destroyMethod, String optInsertIntoStream, EPStatementHandle statementHandle, StatementContext statementContext) {
            this.epStatement = epStatement;
            this.startMethod = startMethod;
            this.stopMethod = stopMethod;
            this.destroyMethod = destroyMethod;
            this.optInsertIntoStream = optInsertIntoStream;
            this.statementHandle = statementHandle;
            this.statementContext = statementContext;
        }

        public EPStatementSPI getEpStatement() {
            return this.epStatement;
        }

        public EPStatementStartMethod getStartMethod() {
            return this.startMethod;
        }

        public EPStatementStopMethod getStopMethod() {
            return this.stopMethod;
        }

        public String getOptInsertIntoStream() {
            return this.optInsertIntoStream;
        }

        public void setStopMethod(EPStatementStopMethod stopMethod) {
            this.stopMethod = stopMethod;
        }

        public EPStatementHandle getStatementHandle() {
            return this.statementHandle;
        }

        public StatementContext getStatementContext() {
            return this.statementContext;
        }

        public void setDestroyMethod(EPStatementDestroyMethod destroyMethod) {
            this.destroyMethod = destroyMethod;
        }

        public EPStatementDestroyMethod getDestroyMethod() {
            return this.destroyMethod;
        }
    }
}

