/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.StatementAwareUpdateListener;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.EPServiceProviderSPI;
import com.espertech.esper.core.EPStatementListenerSet;
import com.espertech.esper.core.EPStatementSPI;
import com.espertech.esper.core.ResultDeliveryStrategy;
import com.espertech.esper.core.ResultDeliveryStrategyFactory;
import com.espertech.esper.core.StatementLifecycleSvc;
import com.espertech.esper.core.StatementResultListener;
import com.espertech.esper.core.StatementResultService;
import com.espertech.esper.core.thread.OutboundUnitRunnable;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.epl.metric.MetricReportingPath;
import com.espertech.esper.epl.metric.MetricReportingService;
import com.espertech.esper.epl.metric.MetricReportingServiceSPI;
import com.espertech.esper.epl.metric.StatementMetricHandle;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.ViewSupport;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementResultServiceImpl
implements StatementResultService {
    private static Log log = LogFactory.getLog(StatementResultServiceImpl.class);
    private final StatementLifecycleSvc statementLifecycleSvc;
    private final MetricReportingService metricReportingService;
    private final ThreadingService threadingService;
    private EPStatementSPI epStatement;
    private EPServiceProviderSPI epServiceProvider;
    private boolean isInsertInto;
    private boolean isPattern;
    private boolean isDistinct;
    private StatementMetricHandle statementMetricHandle;
    private Class[] selectClauseTypes;
    private String[] selectClauseColumnNames;
    private EPStatementListenerSet statementListenerSet;
    private boolean isMakeNatural;
    private boolean isMakeSynthetic;
    private ResultDeliveryStrategy statementResultNaturalStrategy;
    private EventBean lastIterableEvent;
    private Set<StatementResultListener> statementOutputHooks;
    protected ThreadLocal<ArrayDequeJDK6Backport<UniformPair<EventBean[]>>> lastResults = new ThreadLocal<ArrayDequeJDK6Backport<UniformPair<EventBean[]>>>(){

        @Override
        protected synchronized ArrayDequeJDK6Backport<UniformPair<EventBean[]>> initialValue() {
            return new ArrayDequeJDK6Backport<UniformPair<EventBean[]>>();
        }
    };

    public StatementResultServiceImpl(StatementLifecycleSvc statementLifecycleSvc, MetricReportingServiceSPI metricReportingService, ThreadingService threadingService) {
        log.debug(".ctor");
        this.statementLifecycleSvc = statementLifecycleSvc;
        this.metricReportingService = metricReportingService;
        this.statementOutputHooks = metricReportingService != null ? metricReportingService.getStatementOutputHooks() : Collections.EMPTY_SET;
        this.threadingService = threadingService;
    }

    @Override
    public void setContext(EPStatementSPI epStatement, EPServiceProviderSPI epServiceProvider, boolean isInsertInto, boolean isPattern, boolean isDistinct, StatementMetricHandle statementMetricHandle) {
        this.epStatement = epStatement;
        this.epServiceProvider = epServiceProvider;
        this.isInsertInto = isInsertInto;
        this.isPattern = isPattern;
        this.isDistinct = isDistinct;
        this.isMakeSynthetic = isInsertInto || isPattern || isDistinct;
        this.statementMetricHandle = statementMetricHandle;
    }

    @Override
    public void setSelectClause(Class[] selectClauseTypes, String[] selectClauseColumnNames) {
        if (selectClauseTypes == null || selectClauseTypes.length == 0) {
            throw new IllegalArgumentException("Invalid null or zero-element list of select clause expression types");
        }
        if (selectClauseColumnNames == null || selectClauseColumnNames.length == 0) {
            throw new IllegalArgumentException("Invalid null or zero-element list of select clause column names");
        }
        this.selectClauseTypes = selectClauseTypes;
        this.selectClauseColumnNames = selectClauseColumnNames;
    }

    @Override
    public boolean isMakeSynthetic() {
        return this.isMakeSynthetic;
    }

    @Override
    public boolean isMakeNatural() {
        return this.isMakeNatural;
    }

    @Override
    public EventBean getLastIterableEvent() {
        return this.lastIterableEvent;
    }

    @Override
    public void setUpdateListeners(EPStatementListenerSet statementListenerSet) {
        if (this.epStatement != null) {
            this.statementLifecycleSvc.updatedListeners(this.epStatement, statementListenerSet);
        }
        this.statementListenerSet = statementListenerSet;
        this.isMakeNatural = statementListenerSet.getSubscriber() != null;
        boolean bl = this.isMakeSynthetic = !statementListenerSet.getListeners().isEmpty() || !statementListenerSet.getStmtAwareListeners().isEmpty() || this.isPattern || this.isInsertInto || this.isDistinct;
        if (statementListenerSet.getSubscriber() == null) {
            this.statementResultNaturalStrategy = null;
            this.isMakeNatural = false;
            return;
        }
        this.statementResultNaturalStrategy = ResultDeliveryStrategyFactory.create(statementListenerSet.getSubscriber(), this.selectClauseTypes, this.selectClauseColumnNames);
        this.isMakeNatural = true;
    }

    @Override
    public void indicate(UniformPair<EventBean[]> results) {
        if (results != null) {
            if (MetricReportingPath.isMetricsEnabled && this.statementMetricHandle.isEnabled()) {
                int numIStream = results.getFirst() != null ? results.getFirst().length : 0;
                int numRStream = results.getSecond() != null ? results.getSecond().length : 0;
                this.metricReportingService.accountOutput(this.statementMetricHandle, numIStream, numRStream);
            }
            if (results.getFirst() != null && results.getFirst().length != 0) {
                this.lastResults.get().add(results);
                this.lastIterableEvent = results.getFirst()[0];
            } else if (results.getSecond() != null && results.getSecond().length != 0) {
                this.lastResults.get().add(results);
            }
        }
    }

    @Override
    public void execute() {
        ArrayDequeJDK6Backport<UniformPair<EventBean[]>> dispatches = this.lastResults.get();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".execute dispatches: " + dispatches.size());
        }
        UniformPair<EventBean[]> events = EventBeanUtility.flattenList(dispatches);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            ViewSupport.dumpUpdateParams(".execute", events);
        }
        if (ThreadingOption.isThreadingEnabled && this.threadingService.isOutboundThreading()) {
            this.threadingService.submitOutbound(new OutboundUnitRunnable(events, this));
        } else {
            this.processDispatch(events);
        }
        dispatches.clear();
    }

    public void processDispatch(UniformPair<EventBean[]> events) {
        String message;
        if (this.statementResultNaturalStrategy != null) {
            this.statementResultNaturalStrategy.execute(events);
        }
        EventBean[] newEventArr = events != null ? events.getFirst() : null;
        EventBean[] oldEventArr = events != null ? events.getSecond() : null;
        for (UpdateListener updateListener : this.statementListenerSet.listeners) {
            try {
                updateListener.update(newEventArr, oldEventArr);
            }
            catch (Throwable t) {
                message = "Unexpected exception invoking listener update method on listener class '" + updateListener.getClass().getSimpleName() + "' : " + t.getClass().getSimpleName() + " : " + t.getMessage();
                log.error(message, t);
            }
        }
        if (!this.statementListenerSet.stmtAwareListeners.isEmpty()) {
            for (StatementAwareUpdateListener statementAwareUpdateListener : this.statementListenerSet.getStmtAwareListeners()) {
                try {
                    statementAwareUpdateListener.update(newEventArr, oldEventArr, this.epStatement, this.epServiceProvider);
                }
                catch (Throwable t) {
                    message = "Unexpected exception invoking listener update method on listener class '" + statementAwareUpdateListener.getClass().getSimpleName() + "' : " + t.getClass().getSimpleName() + " : " + t.getMessage();
                    log.error(message, t);
                }
            }
        }
        if (AuditPath.isAuditEnabled && !this.statementOutputHooks.isEmpty()) {
            for (StatementResultListener statementResultListener : this.statementOutputHooks) {
                statementResultListener.update(newEventArr, oldEventArr, this.epStatement.getName(), this.epStatement, this.epServiceProvider);
            }
        }
    }

    @Override
    public void dispatchOnStop() {
        this.lastIterableEvent = null;
        ArrayDequeJDK6Backport<UniformPair<EventBean[]>> dispatches = this.lastResults.get();
        if (dispatches.isEmpty()) {
            return;
        }
        this.execute();
    }
}

